/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.utils;

import com.agilemind.utils.LafUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.AbstractBorder;

public class ShadowBorder
extends AbstractBorder {
    private static final Color COLOR_1 = new Color(225, 225, 225);
    private static final Color COLOR_2 = new Color(212, 212, 212);
    private static final Color COLOR_3 = new Color(206, 206, 206);
    private static final Color COLOR_4 = new Color(229, 229, 229);
    private static final Color COLOR_5 = new Color(217, 217, 217);
    private final boolean outside;
    public static ShadowBorder DOWN = new ShadowBorder(false);
    public static ShadowBorder OUTSIDE = new ShadowBorder(true);

    private ShadowBorder(boolean outside) {
        this.outside = outside;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        int onePixel = LafUtils.scalingInt(1);
        int twoPixels = onePixel * 2;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        if (this.outside) {
            g.setColor(COLOR_1);
            g.fillRect(0, 0, onePixel, height);
            g.fillRect(width - onePixel, 0, onePixel, height);
            g.fillRect(0, height - onePixel, width, onePixel);
            g.setColor(COLOR_2);
            g.fillRect(onePixel, height - twoPixels - onePixel, width - twoPixels, twoPixels);
            g.setColor(COLOR_3);
            g.fillRect(twoPixels, height - twoPixels - onePixel, width - twoPixels * 2, onePixel);
            g.setColor(COLOR_4);
            g.fillRect(0, height - onePixel, onePixel, onePixel);
            g.fillRect(width - onePixel, height - onePixel, onePixel, onePixel);
            g.setColor(COLOR_5);
            g.fillRect(onePixel, height - twoPixels, onePixel, onePixel);
            g.fillRect(width - twoPixels, height - twoPixels, onePixel, onePixel);
        } else {
            g.setColor(COLOR_2);
            g.fillRect(0, height - onePixel, width, onePixel);
            g.setColor(COLOR_3);
            g.fillRect(0, height - twoPixels, width, onePixel);
            g.setColor(COLOR_5);
            g.fillRect(0, height - twoPixels, onePixel, onePixel);
            g.fillRect(width - onePixel, height - twoPixels, onePixel, onePixel);
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int onePixel = LafUtils.scalingInt(1);
        int leftRight = this.outside ? onePixel : 0;
        return new Insets(0, leftRight, onePixel * (this.outside ? 3 : 2), leftRight);
    }
}

