/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.utils;

import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.LafUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import sun.awt.image.ToolkitImage;

final class ShadowPopupBorder
extends AbstractBorder {
    private static final int SHADOW_SIZE = LafUtils.scalingInt(5);
    private static ShadowPopupBorder instance = new ShadowPopupBorder();
    private static Image shadow = Toolkit.getDefaultToolkit().createImage(PureLookAndFeel.class.getClassLoader().getResource("icons/shadow.png"));

    ShadowPopupBorder() {
    }

    public static ShadowPopupBorder getInstance() {
        return instance;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Image vShadowBg;
        JComponent popup = (JComponent)c;
        Image hShadowBg = (Image)popup.getClientProperty("jgoodies.hShadowBg");
        int fivePixels = LafUtils.scalingInt(5);
        if (hShadowBg != null) {
            g.drawImage(hShadowBg, x, y + height - fivePixels, c);
        }
        if ((vShadowBg = (Image)popup.getClientProperty("jgoodies.vShadowBg")) != null) {
            g.drawImage(vShadowBg, x + width - fivePixels, y, c);
        }
        int tenPixels = LafUtils.scalingInt(10);
        int sixPixels = LafUtils.scalingInt(6);
        int elevenPixels = LafUtils.scalingInt(11);
        g.drawImage(shadow, x + fivePixels, y + height - fivePixels, x + tenPixels, y + height, 0, sixPixels, fivePixels, elevenPixels, null, c);
        g.drawImage(shadow, x + tenPixels, y + height - fivePixels, x + width - fivePixels, y + height, fivePixels, sixPixels, sixPixels, elevenPixels, null, c);
        g.drawImage(shadow, x + width - fivePixels, y + fivePixels, x + width, y + tenPixels, sixPixels, 0, elevenPixels, fivePixels, null, c);
        g.drawImage(shadow, x + width - fivePixels, y + tenPixels, x + width, y + height - fivePixels, sixPixels, fivePixels, elevenPixels, sixPixels, null, c);
        g.drawImage(shadow, x + width - fivePixels, y + height - fivePixels, x + width, y + height, sixPixels, sixPixels, elevenPixels, elevenPixels, null, c);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(0, 0, SHADOW_SIZE, SHADOW_SIZE);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 0;
        insets.left = 0;
        insets.right = insets.bottom = SHADOW_SIZE;
        return insets;
    }

    static {
        if (LafUtils.needScale()) {
            shadow = shadow.getScaledInstance(LafUtils.scalingInt(((ToolkitImage)shadow).getWidth()), LafUtils.scalingInt(((ToolkitImage)shadow).getHeight()), 1);
        }
    }
}

