/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.utils;

import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.plaf.RadioButtonMenuItemIcon;
import com.agilemind.utils.LafUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import sun.swing.ImageIconUIResource;

public class StyleConstants {
    public static final int DEFAULT_5PX = 5;
    public static final int DEFAULT_10PX = 10;
    public static final int DEFAULT_15PX = 15;
    public static final int DEFAULT_20PX = 20;
    public static final int DEFAULT_40PX = 40;
    private static final Map<Color, Map<ArrowDirection, ImageIconUIResource>> arrowIcons = new HashMap<Color, Map<ArrowDirection, ImageIconUIResource>>();
    private static final Map<String, ImageIconUIResource> circlesIcons = new HashMap<String, ImageIconUIResource>();
    private static Icon radioButtonMenuItemIcon;
    private static Icon checkBoxMenuItemIcon;
    private static boolean useCustomFont;
    private static Font customFont;
    public static final Color TRANSPARENT_COLOR;
    public static final Color DARK_BACKGROUND;
    public static final Color DARK_BACKGROUND2;
    public static final Color TEXT_COLOR;
    public static final Color TEXT_DESCRIPTION_COLOR;
    public static final Color TABBED_PANE_HEADER_UNSELECTED_COLOR;
    public static final Color TEXT_ROLLOVER_COLOR;
    public static final Color TEXT_SELECTED_COLOR;
    public static final Color GREEN_TEXT_ON_WHITE;
    public static final Color MENU_BAR_BACKGROUND;
    public static final Color MENU_ACCELERATOR_FOREGROUND;
    public static final Color MENU_ACCELERATOR_SELECTED_FOREGROUND;
    public static final Color MENU_SEPARATOR_BACKGROUND;
    public static final Color DARK_MENU_BACKGROUND;
    public static final Color DARK_MENU_FOREGROUND;
    public static final Color DARK_MENU_SELECTED_FOREGROUND;
    public static final Color DARK_MENU_SELECTED_BACKGROUND;
    public static final Color DARK_MENU_DISABLED_FOREGROUND;
    public static final Color DARK_MENU_ACCELERATOR_FOREGROUND;
    public static final Color DARK_MENU_ACCELERATOR_SELECTED_FOREGROUND;
    public static final Color DARK_MENU_SEPARATOR_BACKGROUND;
    public static final Color POPUP_BACKGROUND;
    private static final int DOTS_COUNT = 3;

    public static void updateArrows() {
        arrowIcons.clear();
    }

    public static ImageIconUIResource horizontalSplitter(Color color) {
        return StyleConstants.dividerIcon(1, color);
    }

    public static ImageIconUIResource verticalSplitter(Color color) {
        return StyleConstants.dividerIcon(0, color);
    }

    private static ImageIconUIResource dividerIcon(int orientation, Color color) {
        int GAP = LafUtils.scalingInt(6);
        int DOT_SIZE = LafUtils.scalingInt(4);
        int width = orientation == 1 ? DOT_SIZE : 3 * (GAP + DOT_SIZE);
        int height = orientation == 1 ? 3 * (GAP + DOT_SIZE) : DOT_SIZE;
        BufferedImage image = new BufferedImage(width, height, 6);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.setColor(color);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (orientation == 1) {
            int y = 0;
            for (int i = 0; i < 3; ++i) {
                g2d.fillOval(0, y, DOT_SIZE, DOT_SIZE);
                y += GAP;
            }
        } else {
            int x = 0;
            for (int i = 0; i < 3; ++i) {
                g2d.fillOval(x, 0, DOT_SIZE, DOT_SIZE);
                x += GAP;
            }
        }
        return new ImageIconUIResource(image);
    }

    public static ImageIconUIResource arrowRight() {
        return StyleConstants.arrowRight(Color.BLACK);
    }

    public static ImageIconUIResource arrowRight(Color color) {
        return StyleConstants.arrow(color, ArrowDirection.RIGHT);
    }

    public static ImageIconUIResource arrowLeft() {
        return StyleConstants.arrowLeft(Color.BLACK);
    }

    public static ImageIconUIResource arrowLeft(Color color) {
        return StyleConstants.arrow(color, ArrowDirection.LEFT);
    }

    public static ImageIconUIResource arrowUp() {
        return StyleConstants.arrowUp(Color.BLACK);
    }

    public static ImageIconUIResource arrowUp(Color color) {
        return StyleConstants.arrow(color, ArrowDirection.UP);
    }

    public static ImageIconUIResource arrowDown() {
        return StyleConstants.arrowDown(Color.BLACK);
    }

    public static ImageIconUIResource arrowDown(Color color) {
        return StyleConstants.arrow(color, ArrowDirection.DOWN);
    }

    private static ImageIconUIResource arrow(Color color, ArrowDirection direction) {
        return arrowIcons.computeIfAbsent(color, color1 -> new EnumMap(ArrowDirection.class)).computeIfAbsent(direction, arrowDirection -> StyleConstants.crateArrowImage(StyleConstants.arrowSize(), color, direction));
    }

    private static int arrowSize() {
        int size = LafUtils.scalingInt(5);
        if (size % 2 == 0) {
            ++size;
        }
        return size;
    }

    public static ImageIconUIResource getCircleIcon(int size, Color color, int borderWidth, Color borderColor) {
        String id = String.valueOf(size) + color + borderWidth + borderColor;
        return circlesIcons.computeIfAbsent(id, key -> StyleConstants.createCircle(size, color, borderWidth, borderColor));
    }

    private static ImageIconUIResource createCircle(int size, Color color, int borderWidth, Color borderColor) {
        BufferedImage image = new BufferedImage(size, size, 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics.setPaint(color);
        graphics.fillOval(0, 0, size, size);
        if (borderWidth > 0) {
            graphics.setPaint(borderColor);
            graphics.setStroke(new BasicStroke(borderWidth));
            graphics.drawOval(0, 0, size, size);
        }
        return new ImageIconUIResource(image);
    }

    private static ImageIconUIResource crateArrowImage(int size, Color color, ArrowDirection direction) {
        BufferedImage image;
        int steps = size / 2;
        int end = size - 1;
        switch (direction) {
            case RIGHT: {
                image = new BufferedImage(steps + 1, size, 6);
                Graphics2D g = (Graphics2D)image.getGraphics();
                g.setPaint(color);
                for (int i = 0; i < steps; ++i) {
                    g.drawLine(i, i, i, end);
                    --end;
                }
                g.drawLine(steps, steps, steps, steps);
                break;
            }
            case LEFT: {
                image = new BufferedImage(steps + 1, size, 6);
                Graphics2D g = (Graphics2D)image.getGraphics();
                g.setPaint(color);
                for (int i = 0; i < steps; ++i) {
                    g.drawLine(steps - i, i, steps - i, end);
                    --end;
                }
                g.drawLine(0, steps, 0, steps);
                break;
            }
            case UP: {
                image = new BufferedImage(size, steps + 1, 6);
                Graphics2D g = (Graphics2D)image.getGraphics();
                g.setPaint(color);
                for (int i = 0; i < steps; ++i) {
                    g.drawLine(i, steps - i, end, steps - i);
                    --end;
                }
                g.drawLine(steps, 0, steps, 0);
                break;
            }
            case DOWN: {
                image = new BufferedImage(size, steps + 1, 6);
                Graphics2D g = (Graphics2D)image.getGraphics();
                g.setPaint(color);
                for (int i = 0; i < steps; ++i) {
                    g.drawLine(i, i, end, i);
                    --end;
                }
                g.drawLine(steps, steps, steps, steps);
                break;
            }
            default: {
                System.err.println("Unsupported arrow direction");
                image = new BufferedImage(size, steps + 1, 6);
            }
        }
        return new ImageIconUIResource(image);
    }

    private StyleConstants() {
    }

    public static GradientPaint createButtonGradientNormal(float y1, float y2) {
        return new GradientPaint(0.0f, y1, PureLookAndFeel.getCurrentTheme().getGradientLightColor(), 0.0f, y2, PureLookAndFeel.getCurrentTheme().getGradientDarkColor());
    }

    public static GradientPaint createButtonGradientHover(float y1, float y2) {
        return new GradientPaint(0.0f, y1, PureLookAndFeel.getCurrentTheme().getGradientLightColor(), 0.0f, y2, PureLookAndFeel.getCurrentTheme().getGradientLessLightColor());
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static FontUIResource getControlTextFont(UIDefaults table, String uiId) {
        if (table.contains(uiId)) {
            return StyleConstants.getFont(table.getFont(uiId), 0, 12);
        }
        return StyleConstants.getFont(LafUtils.createScaledFont("Default", 0, 12), 0, 12);
    }

    public static FontUIResource getSmallControlTextFont(Font uiId) {
        return StyleConstants.getFont(uiId, 0, 11);
    }

    public static FontUIResource getButtonTextFont(Font uiId) {
        return StyleConstants.getFont(uiId, 1, 12);
    }

    public static FontUIResource getToolbarButtonTextFont(Font uiId) {
        return StyleConstants.getFont(uiId, 0, 11);
    }

    private static FontUIResource getFont(Font oldFont, int style, int size) {
        Font newFont = null;
        if (useCustomFont) {
            if (customFont == null) {
                String customFontName = System.getProperty("customFont");
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                for (Font font : graphicsEnvironment.getAllFonts()) {
                    if (!font.getName().equalsIgnoreCase(customFontName)) continue;
                    customFont = font;
                    System.err.println("Set custom font " + customFont.getName());
                    break;
                }
                useCustomFont = customFont != null;
            }
            newFont = customFont;
        }
        if (newFont == null) {
            newFont = oldFont;
        }
        return new FontUIResource(newFont.getName(), style, LafUtils.scalingInt(size));
    }

    static {
        useCustomFont = System.getProperty("customFont") != null;
        customFont = null;
        TRANSPARENT_COLOR = new ColorUIResource(new Color(255, 255, 255, 0));
        DARK_BACKGROUND = new ColorUIResource(62, 62, 62);
        DARK_BACKGROUND2 = new ColorUIResource(43, 43, 43);
        TEXT_COLOR = new ColorUIResource(162, 162, 162);
        TEXT_DESCRIPTION_COLOR = new ColorUIResource(125, 125, 125);
        TABBED_PANE_HEADER_UNSELECTED_COLOR = new ColorUIResource(196, 196, 196);
        TEXT_ROLLOVER_COLOR = new ColorUIResource(210, 210, 210);
        TEXT_SELECTED_COLOR = new ColorUIResource(100, 165, 49);
        GREEN_TEXT_ON_WHITE = new Color(5348380);
        MENU_BAR_BACKGROUND = DARK_BACKGROUND;
        MENU_ACCELERATOR_FOREGROUND = new ColorUIResource(158, 158, 158);
        MENU_ACCELERATOR_SELECTED_FOREGROUND = new ColorUIResource(144, 176, 219);
        MENU_SEPARATOR_BACKGROUND = new ColorUIResource(213, 213, 213);
        DARK_MENU_BACKGROUND = new ColorUIResource(73, 73, 73);
        DARK_MENU_FOREGROUND = new ColorUIResource(196, 196, 196);
        DARK_MENU_SELECTED_FOREGROUND = new ColorUIResource(Color.WHITE);
        DARK_MENU_SELECTED_BACKGROUND = DARK_BACKGROUND2;
        DARK_MENU_DISABLED_FOREGROUND = TEXT_DESCRIPTION_COLOR;
        DARK_MENU_ACCELERATOR_FOREGROUND = DARK_MENU_FOREGROUND;
        DARK_MENU_ACCELERATOR_SELECTED_FOREGROUND = DARK_MENU_SELECTED_FOREGROUND;
        DARK_MENU_SEPARATOR_BACKGROUND = new ColorUIResource(59, 59, 59);
        POPUP_BACKGROUND = new ColorUIResource(251, 251, 251);
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = 12;

        private CheckBoxMenuItemIcon() {
        }

        @Override
        public int getIconWidth() {
            return LafUtils.scalingInt(12);
        }

        @Override
        public int getIconHeight() {
            return LafUtils.scalingInt(12);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            if (b.isSelected()) {
                CheckBoxMenuItemIcon.drawCheck(g, x, y + 1);
            }
        }

        private static void drawCheck(Graphics g, int x, int y) {
            g.translate(x, y);
            g.drawLine(3, 5, 3, 5);
            g.fillRect(3, 6, 2, 2);
            g.drawLine(4, 8, 9, 3);
            g.drawLine(5, 8, 9, 4);
            g.drawLine(5, 9, 9, 5);
            g.translate(-x, -y);
        }
    }

    private static enum ArrowDirection {
        RIGHT,
        LEFT,
        UP,
        DOWN;

    }
}

