/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.sshtools.publickey.PEM;
import com.sshtools.ssh.components.SshCipher;
import com.sshtools.ssh.components.jce.AES128Cbc;
import com.sshtools.ssh.components.jce.AbstractJCECipher;
import com.sshtools.ssh.components.jce.TripleDesCbc;
import com.sshtools.util.Base64;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PEMReader
extends PEM {
    private LineNumberReader reader;
    private String type;
    private Hashtable<String, String> header;
    private byte[] payload;

    public PEMReader(Reader r) throws IOException {
        this.reader = new LineNumberReader(r);
        this.read();
    }

    private void read() throws IOException {
        int colon;
        String line;
        while ((line = this.reader.readLine()) != null) {
            if (!line.startsWith("-----") || !line.endsWith("-----")) continue;
            if (line.startsWith("-----BEGIN ")) {
                this.type = line.substring("-----BEGIN ".length(), line.length() - "-----".length());
                break;
            }
            throw new IOException("Invalid PEM boundary at line " + this.reader.getLineNumber() + ": " + line);
        }
        this.header = new Hashtable();
        block1: while ((line = this.reader.readLine()) != null && (colon = line.indexOf(58)) != -1) {
            String key = line.substring(0, colon).trim();
            if (line.endsWith("\\")) {
                String v = line.substring(colon + 1, line.length() - 1).trim();
                StringBuffer value = new StringBuffer(v);
                while ((line = this.reader.readLine()) != null) {
                    if (line.endsWith("\\")) {
                        value.append(" ").append(line.substring(0, line.length() - 1).trim());
                        continue;
                    }
                    value.append(" ").append(line.trim());
                    continue block1;
                }
                continue;
            }
            String value = line.substring(colon + 1).trim();
            this.header.put(key, value);
        }
        if (line == null) {
            throw new IOException("The key format is invalid! OpenSSH formatted keys must begin with -----BEGIN RSA or -----BEGIN DSA");
        }
        StringBuffer body = new StringBuffer(line);
        while ((line = this.reader.readLine()) != null) {
            if (line.startsWith("-----") && line.endsWith("-----")) {
                if (line.startsWith("-----END " + this.type)) break;
                throw new IOException("Invalid PEM end boundary at line " + this.reader.getLineNumber() + ": " + line);
            }
            body.append(line);
        }
        this.payload = Base64.decode(body.toString());
    }

    public Hashtable<String, String> getHeader() {
        return this.header;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String getType() {
        return this.type;
    }

    public byte[] decryptPayload(String passphrase) throws IOException {
        String dekInfo = this.header.get("DEK-Info");
        if (dekInfo != null) {
            int comma = dekInfo.indexOf(44);
            String keyAlgorithm = dekInfo.substring(0, comma);
            if (!"DES-EDE3-CBC".equalsIgnoreCase(keyAlgorithm) && !"AES-128-CBC".equalsIgnoreCase(keyAlgorithm)) {
                throw new IOException("Unsupported passphrase algorithm: " + keyAlgorithm);
            }
            String ivString = dekInfo.substring(comma + 1);
            byte[] iv = new byte[ivString.length() / 2];
            for (int i = 0; i < ivString.length(); i += 2) {
                iv[i / 2] = (byte)Integer.parseInt(ivString.substring(i, i + 2), 16);
            }
            byte[] keydata = null;
            AbstractJCECipher cipher = null;
            if ("DES-EDE3-CBC".equalsIgnoreCase(keyAlgorithm)) {
                keydata = PEMReader.getKeyFromPassphrase(passphrase, iv, 24);
                cipher = new TripleDesCbc();
            } else if ("AES-128-CBC".equalsIgnoreCase(keyAlgorithm)) {
                keydata = PEMReader.getKeyFromPassphrase(passphrase, iv, 16);
                cipher = new AES128Cbc();
            }
            ((SshCipher)cipher).init(1, iv, keydata);
            byte[] plain = new byte[this.payload.length];
            ((SshCipher)cipher).transform(this.payload, 0, plain, 0, plain.length);
            return plain;
        }
        return this.payload;
    }
}

