/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.sshtools.publickey.OpenSSHPublicKeyFile;
import com.sshtools.publickey.SECSHPublicKeyFile;
import com.sshtools.publickey.SshPublicKeyFile;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshIOException;
import com.sshtools.ssh.components.ComponentManager;
import com.sshtools.ssh.components.SshPublicKey;
import com.sshtools.util.ByteArrayReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SshPublicKeyFileFactory {
    public static final int OPENSSH_FORMAT = 0;
    public static final int SECSH_FORMAT = 1;
    public static final int SSH1_FORMAT = 2;

    public static SshPublicKey decodeSSH2PublicKey(byte[] encoded) throws IOException {
        ByteArrayReader bar = new ByteArrayReader(encoded);
        try {
            String algorithm = bar.readString();
            try {
                SshPublicKey publickey = (SshPublicKey)ComponentManager.getInstance().supportedPublicKeys().getInstance(algorithm);
                publickey.init(encoded, 0, encoded.length);
                SshPublicKey sshPublicKey = publickey;
                return sshPublicKey;
            }
            catch (SshException ex) {
                try {
                    throw new SshIOException(ex);
                }
                catch (OutOfMemoryError ex2) {
                    throw new IOException("An error occurred parsing a public key file! Is the file corrupt?");
                }
            }
        }
        finally {
            try {
                bar.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static SshPublicKey decodeSSH2PublicKey(String algorithm, byte[] encoded) throws IOException {
        try {
            SshPublicKey publickey = (SshPublicKey)ComponentManager.getInstance().supportedPublicKeys().getInstance(algorithm);
            publickey.init(encoded, 0, encoded.length);
            return publickey;
        }
        catch (SshException ex) {
            throw new SshIOException(ex);
        }
    }

    public static SshPublicKeyFile parse(byte[] formattedkey) throws IOException {
        try {
            try {
                return new OpenSSHPublicKeyFile(formattedkey);
            }
            catch (IOException ex) {
                try {
                    return new SECSHPublicKeyFile(formattedkey);
                }
                catch (IOException ex2) {
                    throw new IOException("Unable to parse key, format could not be identified");
                }
            }
        }
        catch (OutOfMemoryError ex1) {
            throw new IOException("An error occurred parsing a public key file! Is the file corrupt?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SshPublicKeyFile parse(InputStream in) throws IOException {
        try {
            int read;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((read = in.read()) > -1) {
                out.write(read);
            }
            SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFileFactory.parse(out.toByteArray());
            return sshPublicKeyFile;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static SshPublicKeyFile create(SshPublicKey key, String comment, int format) throws IOException {
        switch (format) {
            case 0: {
                return new OpenSSHPublicKeyFile(key, comment);
            }
            case 1: {
                return new SECSHPublicKeyFile(key, comment);
            }
        }
        throw new IOException("Invalid format type specified!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(SshPublicKey key, String comment, int format, File toFile) throws IOException {
        SshPublicKeyFile pub = SshPublicKeyFileFactory.create(key, comment, format);
        FileOutputStream out = new FileOutputStream(toFile);
        try {
            out.write(pub.getFormattedKey());
            out.flush();
        }
        finally {
            out.close();
        }
    }

    public static void convertFile(File keyFile, int toFormat, File toFile) throws IOException {
        SshPublicKeyFile pub = SshPublicKeyFileFactory.parse(new FileInputStream(keyFile));
        SshPublicKeyFileFactory.createFile(pub.toPublicKey(), pub.getComment(), toFormat, toFile);
    }
}

