/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sftp;

import com.sshtools.sftp.RegularExpressionMatching;
import com.sshtools.sftp.SftpFile;
import com.sshtools.sftp.SftpStatusException;
import com.sshtools.ssh.SshException;
import java.io.File;
import java.util.Vector;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;

public class GlobRegExpMatching
implements RegularExpressionMatching {
    public String[] matchFileNamesWithPattern(File[] files, String fileNameRegExp) throws SshException {
        Pattern mpattern = null;
        GlobCompiler aGCompiler = new GlobCompiler();
        Perl5Matcher aPerl5Matcher = new Perl5Matcher();
        try {
            mpattern = aGCompiler.compile(fileNameRegExp);
        }
        catch (MalformedPatternException e) {
            throw new SshException("Invalid regular expression:" + e.getMessage(), 4);
        }
        Vector<String> matchedNames = new Vector<String>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().equals(".") || files[i].getName().equals("..") || !aPerl5Matcher.matches(files[i].getName(), mpattern)) continue;
            matchedNames.addElement(files[i].getAbsolutePath());
        }
        Object[] matchedNamesStrings = new String[matchedNames.size()];
        matchedNames.copyInto(matchedNamesStrings);
        return matchedNamesStrings;
    }

    public SftpFile[] matchFilesWithPattern(SftpFile[] files, String fileNameRegExp) throws SftpStatusException, SshException {
        Pattern mpattern = null;
        GlobCompiler aGCompiler = new GlobCompiler();
        Perl5Matcher aPerl5Matcher = new Perl5Matcher();
        try {
            mpattern = aGCompiler.compile(fileNameRegExp);
        }
        catch (MalformedPatternException e) {
            throw new SshException("Invalid regular expression:" + e.getMessage(), 4);
        }
        Vector<SftpFile> matchedNames = new Vector<SftpFile>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getFilename().equals(".") || files[i].getFilename().equals("..") || files[i].isDirectory() || !aPerl5Matcher.matches(files[i].getFilename(), mpattern)) continue;
            matchedNames.addElement(files[i]);
        }
        Object[] matchedNamesSftpFiles = new SftpFile[matchedNames.size()];
        matchedNames.copyInto(matchedNamesSftpFiles);
        return matchedNamesSftpFiles;
    }
}

