/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sftp;

import com.sshtools.sftp.SftpFile;
import com.sshtools.sftp.SftpMessage;
import com.sshtools.sftp.SftpStatusException;
import com.sshtools.sftp.SftpSubsystemChannel;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshIOException;
import com.sshtools.util.UnsignedInteger32;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class SftpFileInputStream
extends InputStream {
    SftpFile file;
    SftpSubsystemChannel sftp;
    long position;
    Vector<UnsignedInteger32> outstandingRequests = new Vector();
    SftpMessage currentMessage;
    int currentMessageRemaining;
    boolean isEOF = false;

    public SftpFileInputStream(SftpFile file) throws SftpStatusException, SshException {
        this(file, 0L);
    }

    public SftpFileInputStream(SftpFile file, long position) throws SftpStatusException, SshException {
        if (file.getHandle() == null) {
            throw new SftpStatusException(100, "The file does not have a valid handle!");
        }
        if (file.getSFTPChannel() == null) {
            throw new SshException("The file is not attached to an SFTP subsystem!", 4);
        }
        this.file = file;
        this.position = position;
        this.sftp = file.getSFTPChannel();
        try {
            this.bufferNextMessage();
        }
        catch (IOException e) {
            throw new SshException(e);
        }
    }

    public int read(byte[] buffer, int offset, int len) throws IOException {
        try {
            if (this.isEOF && this.currentMessageRemaining == 0) {
                return -1;
            }
            int read = 0;
            int wantsLength = len;
            while (read < wantsLength && !this.isEOF) {
                if (this.currentMessage == null || this.currentMessageRemaining == 0) {
                    this.bufferNextMessage();
                    if (this.isEOF && read == 0) {
                        return -1;
                    }
                }
                if (this.currentMessage == null) {
                    throw new IOException("Failed to obtain file data or status from the SFTP server!");
                }
                int count = Math.min(this.currentMessageRemaining, len);
                System.arraycopy(this.currentMessage.array(), this.currentMessage.getPosition(), buffer, offset, count);
                this.currentMessageRemaining -= count;
                this.currentMessage.skip(count);
                if (this.currentMessageRemaining == 0) {
                    this.bufferNextMessage();
                }
                read += count;
                len -= count;
                offset += count;
            }
            return read;
        }
        catch (SshException ex) {
            throw new SshIOException(ex);
        }
        catch (SftpStatusException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private void bufferNextMessage() throws SshException, IOException, SftpStatusException {
        this.bufferMoreData();
        UnsignedInteger32 requestid = this.outstandingRequests.elementAt(0);
        this.currentMessage = this.sftp.getResponse(requestid);
        this.outstandingRequests.removeElementAt(0);
        if (this.currentMessage.getType() != 103) {
            if (this.currentMessage.getType() == 101) {
                int status = (int)this.currentMessage.readInt();
                if (status == 1) {
                    this.isEOF = true;
                    return;
                }
                if (this.sftp.getVersion() >= 3) {
                    String desc = this.currentMessage.readString().trim();
                    throw new IOException(desc);
                }
                throw new IOException("Unexpected status " + status);
            }
            this.close();
            throw new IOException("The server responded with an unexpected SFTP protocol message! type=" + this.currentMessage.getType());
        }
        this.currentMessageRemaining = (int)this.currentMessage.readInt();
    }

    private void bufferMoreData() throws SftpStatusException, SshException {
        while (this.outstandingRequests.size() < 100) {
            this.outstandingRequests.addElement(this.sftp.postReadRequest(this.file.getHandle(), this.position, 32768));
            this.position += 32768L;
        }
    }

    public int available() {
        return this.currentMessageRemaining;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b) == 1) {
            int val = b[0] & 0xFF;
            return val;
        }
        return -1;
    }

    public void close() throws IOException {
        try {
            this.file.close();
            while (this.outstandingRequests.size() > 0) {
                UnsignedInteger32 requestid = this.outstandingRequests.elementAt(0);
                this.outstandingRequests.removeElementAt(0);
                this.sftp.getResponse(requestid);
            }
        }
        catch (SshException ex) {
            throw new SshIOException(ex);
        }
        catch (SftpStatusException ex) {
            throw new IOException(ex.getMessage());
        }
    }
}

