/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh;

import com.sshtools.events.EventListener;
import com.sshtools.events.EventServiceImplementation;
import com.sshtools.logging.Log;
import com.sshtools.ssh.SocketTimeoutSupport;
import com.sshtools.ssh.SshClient;
import com.sshtools.ssh.SshContext;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshTransport;
import com.sshtools.ssh2.Ssh2Client;
import com.sshtools.ssh2.Ssh2Context;
import java.io.IOException;
import java.io.InputStream;

public final class SshConnector {
    String softwareComments = "SOFTWARE_VERSION_COMMENTS";
    String originalSoftwareComments = "SOFTWARE_VERSION_COMMENTS";
    Ssh2Context ssh2Context = new Ssh2Context();
    String product = "J2SSH";
    public static Throwable initException = null;
    boolean fipsEnabled = false;

    SshConnector() throws SshException {
    }

    public static SshConnector createInstance() throws SshException {
        return new SshConnector();
    }

    public static void addEventListener(EventListener listener) {
        EventServiceImplementation.getInstance().addListener("", listener);
    }

    public static void addEventListener(String threadPrefix, EventListener listener) {
        EventServiceImplementation.getInstance().addListener(threadPrefix, listener);
    }

    public static void removeEventListener(String threadPrefix) {
        EventServiceImplementation.getInstance().removeListener(threadPrefix);
    }

    public final void enableFIPSMode() throws SshException {
        this.ssh2Context.enableFIPSMode();
        this.fipsEnabled = true;
    }

    public Ssh2Context getContext() throws SshException {
        return this.ssh2Context;
    }

    public Ssh2Client connect(SshTransport transport, String username) throws SshException {
        return this.connect(transport, username, false, null);
    }

    public SshClient connect(SshTransport transport, String username, boolean buffered) throws SshException {
        return this.connect(transport, username, buffered, null);
    }

    public SshClient connect(SshTransport transport, String username, SshContext context) throws SshException {
        return this.connect(transport, username, false, context);
    }

    public void setSoftwareVersionComments(String softwareComments) {
        this.softwareComments = softwareComments;
    }

    public Ssh2Client connect(SshTransport transport, String username, boolean buffered, SshContext context) throws SshException {
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Connecting " + username + "@" + transport.getHost() + ":" + transport.getPort() + " [buffered=" + buffered + "]");
        }
        String localIdentification = null;
        String remoteIdentification = null;
        localIdentification = "SSH-2.0-" + this.softwareComments.replace(' ', '_');
        if (localIdentification.length() > 253) {
            localIdentification = localIdentification.substring(0, 253);
        }
        localIdentification = localIdentification + "\r\n";
        Ssh2Context ctx = (Ssh2Context)(context != null ? context : this.ssh2Context);
        if (ctx.getSocketTimeout() > 0 && transport instanceof SocketTimeoutSupport) {
            try {
                ((SocketTimeoutSupport)((Object)transport)).setSoTimeout(ctx.getSocketTimeout());
            }
            catch (IOException e) {
                throw new SshException(10, (Throwable)e);
            }
        } else if (ctx.getSocketTimeout() > 0) {
            Log.info(this, "Socket timeout is set on SshContext but SshTransport does not support socket timeouts");
        }
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Attempting to determine remote version");
        }
        remoteIdentification = this.getRemoteIdentification(transport);
        try {
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Attempting SSH2 connection");
            }
            transport.getOutputStream().write(localIdentification.getBytes());
            Ssh2Client client = new Ssh2Client();
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Remote identification: " + remoteIdentification);
                Log.debug(this, "Local identification: " + localIdentification.trim() + " [" + this.originalSoftwareComments + "]");
            }
            client.connect(transport, this.ssh2Context == null ? context : this.ssh2Context, this, username, localIdentification.trim(), remoteIdentification, buffered);
            return client;
        }
        catch (Throwable t) {
            throw new SshException(t.getMessage() != null ? t.getMessage() : t.getClass().getName(), 10, t);
        }
    }

    String getRemoteIdentification(SshTransport transport) throws SshException {
        try {
            String remoteIdentification = "";
            InputStream in = transport.getInputStream();
            int MAX_BUFFER_LENGTH = 255;
            while (!remoteIdentification.startsWith("SSH-")) {
                int ch;
                StringBuffer lineBuffer = new StringBuffer(MAX_BUFFER_LENGTH);
                while ((ch = in.read()) != 10 && lineBuffer.length() < MAX_BUFFER_LENGTH && ch > -1) {
                    if (ch == 13) continue;
                    lineBuffer.append((char)ch);
                }
                if (ch == -1) {
                    throw new SshException("Failed to read remote identification " + lineBuffer.toString(), 10);
                }
                remoteIdentification = lineBuffer.toString();
            }
            return remoteIdentification;
        }
        catch (Throwable ex) {
            throw new SshException(ex, 10);
        }
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }
}

