/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh;

public class SshException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final int UNEXPECTED_TERMINATION = 1;
    public static final int REMOTE_HOST_DISCONNECTED = 2;
    public static final int PROTOCOL_VIOLATION = 3;
    public static final int BAD_API_USAGE = 4;
    public static final int INTERNAL_ERROR = 5;
    public static final int CHANNEL_FAILURE = 6;
    public static final int UNSUPPORTED_ALGORITHM = 7;
    public static final int CANCELLED_CONNECTION = 8;
    public static final int KEY_EXCHANGE_FAILED = 9;
    public static final int CONNECT_FAILED = 10;
    public static final int LICENSE_ERROR = 11;
    public static final int CONNECTION_CLOSED = 12;
    public static final int AGENT_ERROR = 13;
    public static final int FORWARDING_ERROR = 14;
    public static final int PSEUDO_TTY_ERROR = 15;
    public static final int SHELL_ERROR = 15;
    public static final int SESSION_STREAM_ERROR = 15;
    public static final int JCE_ERROR = 16;
    public static final int POSSIBLE_CORRUPT_FILE = 17;
    public static final int SCP_TRANSFER_CANCELLED = 18;
    public static final int SOCKET_TIMEOUT = 19;
    public static final int PROMPT_TIMEOUT = 20;
    public static final int MESSAGE_TIMEOUT = 21;
    int reason;
    Throwable cause;

    public SshException(String msg, int reason) {
        this(msg, reason, null);
    }

    public SshException(int reason, Throwable cause) {
        this(null, reason, cause);
    }

    public SshException(Throwable cause, int reason) {
        this(null, reason, cause);
    }

    public SshException(String msg, Throwable cause) {
        this(msg, 5, cause);
    }

    public SshException(Throwable cause) {
        this("An unexpected exception was caught: " + cause.getMessage(), cause);
    }

    public SshException(String msg, int reason, Throwable cause) {
        super(msg == null ? (cause == null ? "Unknown cause" : cause.getClass().getName()) : msg + " [" + (cause == null ? "Unknown cause" : cause.getClass().getName()) + "]");
        this.cause = cause;
        this.reason = reason;
    }

    public int getReason() {
        return this.reason;
    }

    public Throwable getCause() {
        return this.cause;
    }
}

