/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components;

import com.sshtools.ssh.SshException;
import com.sshtools.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentFactory
implements Cloneable {
    protected Hashtable<String, Class<?>> supported = new Hashtable();
    protected Vector<Object> order = new Vector();
    Class<?> type;
    private boolean locked;

    public synchronized String changePositionofAlgorithm(String name, int position) throws SshException {
        int currentLocation;
        if (position < 0) {
            throw new SshException("index out of bounds", 4);
        }
        if (position >= this.order.size()) {
            position = this.order.size();
        }
        if ((currentLocation = this.order.indexOf(name)) < position) {
            this.order.insertElementAt(name, position);
            this.order.removeElementAt(currentLocation);
        } else {
            this.order.removeElementAt(currentLocation);
            this.order.insertElementAt(name, position);
        }
        return (String)this.order.elementAt(0);
    }

    public synchronized String createNewOrdering(int[] ordering) throws SshException {
        int i;
        if (ordering.length > this.order.size()) {
            throw new SshException("too many indicies", 4);
        }
        for (i = 0; i < ordering.length; ++i) {
            if (ordering[i] < 0 || ordering[i] >= this.order.size()) {
                throw new SshException("index out of bounds", 4);
            }
            this.order.insertElementAt(this.order.elementAt(ordering[i]), this.order.size());
        }
        Arrays.sort(ordering);
        for (i = ordering.length - 1; i >= 0; --i) {
            this.order.removeElementAt(ordering[i]);
        }
        for (i = 0; i < ordering.length; ++i) {
            Object element = this.order.elementAt(this.order.size() - 1);
            this.order.removeElementAt(this.order.size() - 1);
            this.order.insertElementAt(element, 0);
        }
        return (String)this.order.elementAt(0);
    }

    public ComponentFactory(Class<?> type) {
        this.type = type;
    }

    public boolean contains(String name) {
        return this.supported.containsKey(name);
    }

    public synchronized String list(String preferred) {
        return this.createDelimitedList(preferred);
    }

    public synchronized void add(String name, Class<?> cls) {
        if (this.locked) {
            throw new IllegalStateException("Component factory is locked. Components cannot be added");
        }
        this.supported.put(name, cls);
        if (!this.order.contains(name)) {
            this.order.addElement(name);
        }
    }

    public Object getInstance(String name) throws SshException {
        if (this.supported.containsKey(name)) {
            try {
                return this.createInstance(name, this.supported.get(name));
            }
            catch (Throwable t) {
                throw new SshException(t.getMessage(), 5);
            }
        }
        throw new SshException(name + " is not supported", 7);
    }

    protected Object createInstance(String name, Class<?> cls) throws Throwable {
        return cls.newInstance();
    }

    private synchronized String createDelimitedList(String preferred) {
        StringBuffer listBuf = new StringBuffer();
        int prefIndex = this.order.indexOf(preferred);
        if (prefIndex != -1) {
            listBuf.append(preferred);
        }
        for (int i = 0; i < this.order.size(); ++i) {
            if (prefIndex == i) continue;
            listBuf.append("," + (String)this.order.elementAt(i));
        }
        if (prefIndex == -1 && listBuf.length() > 0) {
            return listBuf.toString().substring(1);
        }
        return listBuf.toString();
    }

    public synchronized void remove(String name) {
        this.supported.remove(name);
        this.order.removeElement(name);
    }

    public synchronized void clear() {
        if (this.locked) {
            throw new IllegalStateException("Component factory is locked. Removing all components renders it unusable");
        }
        this.supported.clear();
        this.order.removeAllElements();
    }

    public Object clone() {
        ComponentFactory clone = new ComponentFactory(this.type);
        clone.order = (Vector)this.order.clone();
        clone.supported = (Hashtable)this.supported.clone();
        clone.locked = this.locked;
        return clone;
    }

    public String[] toArray() {
        return this.order.toArray(new String[this.order.size()]);
    }

    public void lockComponents() {
        this.locked = true;
    }
}

