/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components.jce;

import com.sshtools.ssh.components.Digest;
import com.sshtools.ssh.components.jce.JCEProvider;
import com.sshtools.util.ByteArrayWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AbstractDigest
implements Digest {
    MessageDigest digest;
    String jceAlgorithm;

    public AbstractDigest(String jceAlgorithm) throws NoSuchAlgorithmException {
        this.digest = JCEProvider.getProviderForAlgorithm(jceAlgorithm) == null ? MessageDigest.getInstance(jceAlgorithm) : MessageDigest.getInstance(jceAlgorithm, JCEProvider.getProviderForAlgorithm(jceAlgorithm));
    }

    public byte[] doFinal() {
        return this.digest.digest();
    }

    public void putBigInteger(BigInteger bi) {
        byte[] data = bi.toByteArray();
        this.putInt(data.length);
        this.putBytes(data);
    }

    public void putByte(byte b) {
        this.digest.update(b);
    }

    public void putBytes(byte[] data) {
        this.digest.update(data, 0, data.length);
    }

    public void putBytes(byte[] data, int offset, int len) {
        this.digest.update(data, offset, len);
    }

    public void putInt(int i) {
        this.putBytes(ByteArrayWriter.encodeInt(i));
    }

    public void putString(String str) {
        this.putInt(str.length());
        this.putBytes(str.getBytes());
    }

    public void reset() {
        this.digest.reset();
    }

    public String getProvider() {
        return this.digest.getProvider().getName();
    }
}

