/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components.jce;

import com.sshtools.ssh.SshException;
import com.sshtools.ssh.components.SshHmac;
import com.sshtools.ssh.components.jce.JCEProvider;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractHmac
implements SshHmac {
    protected Mac mac;
    protected int macSize;
    protected int macLength;
    protected String jceAlgorithm;

    public AbstractHmac(String jceAlgorithm, int macLength) {
        this(jceAlgorithm, macLength, macLength);
    }

    public AbstractHmac(String jceAlgorithm, int macSize, int outputLength) {
        this.jceAlgorithm = jceAlgorithm;
        this.macSize = macSize;
        this.macLength = outputLength;
    }

    public void generate(long sequenceNo, byte[] data, int offset, int len, byte[] output, int start) {
        byte[] sequenceBytes = new byte[]{(byte)(sequenceNo >> 24), (byte)(sequenceNo >> 16), (byte)(sequenceNo >> 8), (byte)(sequenceNo >> 0)};
        this.mac.update(sequenceBytes);
        this.mac.update(data, offset, len);
        byte[] tmp = this.mac.doFinal();
        System.arraycopy(tmp, 0, output, start, this.macLength);
    }

    public void update(byte[] b) {
        this.mac.update(b);
    }

    public byte[] doFinal() {
        return this.mac.doFinal();
    }

    public abstract String getAlgorithm();

    public String getProvider() {
        return this.mac.getProvider().getName();
    }

    public int getMacLength() {
        return this.macLength;
    }

    public void init(byte[] keydata) throws SshException {
        try {
            this.mac = JCEProvider.getProviderForAlgorithm(this.jceAlgorithm) == null ? Mac.getInstance(this.jceAlgorithm) : Mac.getInstance(this.jceAlgorithm, JCEProvider.getProviderForAlgorithm(this.jceAlgorithm));
            byte[] key = new byte[this.macSize];
            System.arraycopy(keydata, 0, key, 0, key.length);
            SecretKeySpec keyspec = new SecretKeySpec(key, this.jceAlgorithm);
            this.mac.init(keyspec);
        }
        catch (Throwable t) {
            throw new SshException(t);
        }
    }

    public boolean verify(long sequenceNo, byte[] data, int start, int len, byte[] mac, int offset) {
        int length = this.getMacLength();
        byte[] generated = new byte[length];
        this.generate(sequenceNo, data, start, len, generated, 0);
        for (int i = 0; i < generated.length; ++i) {
            if (mac[i + offset] == generated[i]) continue;
            return false;
        }
        return true;
    }
}

