/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components.jce;

import com.sshtools.ssh.components.SshCipher;
import com.sshtools.ssh.components.jce.JCEProvider;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AbstractJCECipher
extends SshCipher {
    Cipher cipher;
    String spec;
    String keyspec;
    int keylength;

    public AbstractJCECipher(String spec, String keyspec, int keylength, String algorithm) throws IOException {
        super(algorithm);
        this.spec = spec;
        this.keylength = keylength;
        this.keyspec = keyspec;
        try {
            this.cipher = JCEProvider.getProviderForAlgorithm(spec) == null ? Cipher.getInstance(spec) : Cipher.getInstance(spec, JCEProvider.getProviderForAlgorithm(spec));
        }
        catch (NoSuchPaddingException nspe) {
            throw new IOException("Padding type not supported");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IOException("Algorithm not supported:" + spec);
        }
        if (this.cipher == null) {
            throw new IOException("Failed to create cipher engine for " + spec);
        }
    }

    public void transform(byte[] buf, int start, byte[] output, int off, int len) throws IOException {
        if (len > 0) {
            byte[] tmp = this.cipher.update(buf, start, len);
            System.arraycopy(tmp, 0, output, off, len);
        }
    }

    public String getProvider() {
        return this.cipher.getProvider().getName();
    }

    public void init(int mode, byte[] iv, byte[] keydata) throws IOException {
        try {
            byte[] actualKey = new byte[this.keylength];
            System.arraycopy(keydata, 0, actualKey, 0, actualKey.length);
            SecretKeySpec kspec = new SecretKeySpec(actualKey, this.keyspec);
            this.cipher.init(mode == 0 ? 1 : 2, (Key)kspec, new IvParameterSpec(iv, 0, this.getBlockSize()));
        }
        catch (InvalidKeyException ike) {
            throw new IOException("Invalid encryption key");
        }
        catch (InvalidAlgorithmParameterException ape) {
            throw new IOException("Invalid algorithm parameter");
        }
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }
}

