/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components.jce;

import com.sshtools.ssh.SshException;
import com.sshtools.ssh.components.ComponentManager;
import com.sshtools.ssh.components.DiffieHellmanGroups;
import com.sshtools.ssh.components.Digest;
import com.sshtools.ssh.components.SshKeyExchangeClient;
import com.sshtools.ssh.components.jce.AbstractKeyExchange;
import com.sshtools.ssh.components.jce.JCEProvider;
import com.sshtools.util.ByteArrayReader;
import com.sshtools.util.ByteArrayWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DiffieHellmanGroup1Sha1
extends SshKeyExchangeClient
implements AbstractKeyExchange {
    public static final String DIFFIE_HELLMAN_GROUP1_SHA1 = "diffie-hellman-group1-sha1";
    static final int SSH_MSG_KEXDH_INIT = 30;
    static final int SSH_MSG_KEXDH_REPLY = 31;
    static final BigInteger ONE = BigInteger.valueOf(1L);
    static final BigInteger TWO;
    static final BigInteger g;
    static final BigInteger p;
    BigInteger e = null;
    BigInteger f = null;
    BigInteger y = null;
    String clientId;
    String serverId;
    byte[] clientKexInit;
    byte[] serverKexInit;
    KeyPairGenerator dhKeyPairGen;
    KeyAgreement dhKeyAgreement;
    KeyFactory dhKeyFactory;

    public DiffieHellmanGroup1Sha1() {
        super("SHA-1");
    }

    public String getAlgorithm() {
        return DIFFIE_HELLMAN_GROUP1_SHA1;
    }

    public String getProvider() {
        if (this.dhKeyAgreement != null) {
            return this.dhKeyAgreement.getProvider().getName();
        }
        return "";
    }

    public void performClientExchange(String clientIdentification, String serverIdentification, byte[] clientKexInit, byte[] serverKexInit) throws SshException {
        this.clientId = clientIdentification;
        this.serverId = serverIdentification;
        this.clientKexInit = clientKexInit;
        this.serverKexInit = serverKexInit;
        try {
            this.dhKeyFactory = JCEProvider.getProviderForAlgorithm("DH") == null ? KeyFactory.getInstance("DH") : KeyFactory.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH"));
            this.dhKeyAgreement = JCEProvider.getProviderForAlgorithm("DH") == null ? KeyAgreement.getInstance("DH") : KeyAgreement.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH"));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SshException("JCE does not support Diffie Hellman key exchange", 16);
        }
        KeyPair dhKeyPair = null;
        int retry = 3;
        do {
            if (retry == 0) {
                this.transport.disconnect(3, "Failed to generate key exchange value");
                throw new SshException("Key exchange failed to generate e value", 5);
            }
            --retry;
            try {
                this.dhKeyPairGen = JCEProvider.getProviderForAlgorithm("DH") == null ? KeyPairGenerator.getInstance("DH") : KeyPairGenerator.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH"));
                DHParameterSpec dhSkipParamSpec = new DHParameterSpec(p, g);
                this.dhKeyPairGen.initialize(dhSkipParamSpec);
                dhKeyPair = this.dhKeyPairGen.generateKeyPair();
                this.e = ((DHPublicKey)dhKeyPair.getPublic()).getY();
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new SshException("Failed to generate DH value", 16);
            }
            catch (NoSuchAlgorithmException e1) {
                throw new SshException("JCE does not support Diffie Hellman key exchange", 16);
            }
        } while (this.e.compareTo(ONE) < 0 || this.e.compareTo(p.subtract(ONE)) > 0);
        ByteArrayWriter msg = new ByteArrayWriter();
        try {
            this.dhKeyAgreement.init(dhKeyPair.getPrivate());
            msg.write(30);
            msg.writeBigInteger(this.e);
            this.transport.sendMessage(msg.toByteArray(), true);
        }
        catch (IOException ex) {
            throw new SshException("Failed to write SSH_MSG_KEXDH_INIT to message buffer", 5);
        }
        catch (InvalidKeyException e1) {
            throw new SshException("JCE reported Diffie Hellman invalid key", 16);
        }
        finally {
            try {
                msg.close();
            }
            catch (IOException iOException) {}
        }
        byte[] tmp = this.transport.nextMessage();
        if (tmp[0] != 31) {
            this.transport.disconnect(3, "Key exchange failed [id=" + tmp[0] + "]");
            throw new SshException("Key exchange failed [id=" + tmp[0] + "]", 5);
        }
        ByteArrayReader bar = new ByteArrayReader(tmp, 1, tmp.length - 1);
        try {
            this.hostKey = bar.readBinaryString();
            this.f = bar.readBigInteger();
            this.signature = bar.readBinaryString();
            DHPublicKeySpec spec = new DHPublicKeySpec(this.f, p, g);
            this.dhKeyAgreement.doPhase(this.dhKeyFactory.generatePublic(spec), true);
            tmp = this.dhKeyAgreement.generateSecret();
            if ((tmp[0] & 0x80) == 128) {
                byte[] tmp2 = new byte[tmp.length + 1];
                System.arraycopy(tmp, 0, tmp2, 1, tmp.length);
                tmp = tmp2;
            }
            this.secret = new BigInteger(tmp);
            this.calculateExchangeHash();
        }
        catch (Exception ex) {
            throw new SshException("Failed to read SSH_MSG_KEXDH_REPLY from message buffer", 5, ex);
        }
        finally {
            try {
                bar.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void calculateExchangeHash() throws SshException {
        Digest hash = (Digest)ComponentManager.getInstance().supportedDigests().getInstance("SHA-1");
        hash.putString(this.clientId);
        hash.putString(this.serverId);
        hash.putInt(this.clientKexInit.length);
        hash.putBytes(this.clientKexInit);
        hash.putInt(this.serverKexInit.length);
        hash.putBytes(this.serverKexInit);
        hash.putInt(this.hostKey.length);
        hash.putBytes(this.hostKey);
        hash.putBigInteger(this.e);
        hash.putBigInteger(this.f);
        hash.putBigInteger(this.secret);
        this.exchangeHash = hash.doFinal();
    }

    public boolean isKeyExchangeMessage(int messageid) {
        switch (messageid) {
            case 30: 
            case 31: {
                return true;
            }
        }
        return false;
    }

    static {
        g = TWO = BigInteger.valueOf(2L);
        p = DiffieHellmanGroups.group1;
    }
}

