/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components.jce;

import com.sshtools.ssh.SshException;
import com.sshtools.ssh.components.SshDsaPrivateKey;
import com.sshtools.ssh.components.SshDsaPublicKey;
import com.sshtools.ssh.components.jce.JCEProvider;
import com.sshtools.ssh.components.jce.Ssh2DsaPublicKey;
import com.sshtools.util.SimpleASNReader;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;

public class Ssh2DsaPrivateKey
implements SshDsaPrivateKey {
    protected DSAPrivateKey prv;
    private Ssh2DsaPublicKey pub;

    public Ssh2DsaPrivateKey(DSAPrivateKey prv, DSAPublicKey pub) {
        this.prv = prv;
        this.pub = new Ssh2DsaPublicKey(pub);
    }

    public Ssh2DsaPrivateKey(BigInteger p, BigInteger q, BigInteger g, BigInteger x, BigInteger y) throws SshException {
        try {
            KeyFactory kf = JCEProvider.getProviderForAlgorithm("DSA") == null ? KeyFactory.getInstance("DSA") : KeyFactory.getInstance("DSA", JCEProvider.getProviderForAlgorithm("DSA"));
            DSAPrivateKeySpec spec = new DSAPrivateKeySpec(x, p, q, g);
            this.prv = (DSAPrivateKey)kf.generatePrivate(spec);
            this.pub = new Ssh2DsaPublicKey(p, q, g, y);
        }
        catch (Throwable e) {
            throw new SshException(e);
        }
    }

    public byte[] sign(byte[] data) throws IOException {
        try {
            Signature l_sig = JCEProvider.getProviderForAlgorithm("SHA1WithDSA") == null ? Signature.getInstance("SHA1WithDSA") : Signature.getInstance("SHA1WithDSA", JCEProvider.getProviderForAlgorithm("SHA1WithDSA"));
            l_sig.initSign(this.prv);
            l_sig.update(data);
            byte[] signature = l_sig.sign();
            SimpleASNReader asn = new SimpleASNReader(signature);
            asn.getByte();
            asn.getLength();
            asn.getByte();
            byte[] r = asn.getData();
            asn.getByte();
            byte[] s = asn.getData();
            byte[] decoded = null;
            int numSize = 32;
            if (r.length < numSize && r.length < (numSize = 28)) {
                numSize = 20;
            }
            decoded = new byte[numSize * 2];
            if (r.length >= numSize) {
                System.arraycopy(r, r.length - numSize, decoded, 0, numSize);
            } else {
                System.arraycopy(r, 0, decoded, numSize - r.length, r.length);
            }
            if (s.length >= numSize) {
                System.arraycopy(s, s.length - numSize, decoded, numSize, numSize);
            } else {
                System.arraycopy(s, 0, decoded, numSize + (numSize - s.length), s.length);
            }
            return decoded;
        }
        catch (Exception e) {
            throw new IOException("Failed to sign data! " + e.getMessage());
        }
    }

    public String getAlgorithm() {
        return "ssh-dss";
    }

    public SshDsaPublicKey getPublicKey() {
        return this.pub;
    }

    public BigInteger getX() {
        return this.prv.getX();
    }
}

