/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components.jce;

import com.sshtools.ssh.components.SshRsaPrivateKey;
import com.sshtools.ssh.components.jce.JCEProvider;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;

public class Ssh2RsaPrivateKey
implements SshRsaPrivateKey {
    protected RSAPrivateKey prv;

    public Ssh2RsaPrivateKey(RSAPrivateKey prv) {
        this.prv = prv;
    }

    public Ssh2RsaPrivateKey(BigInteger modulus, BigInteger privateExponent) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = JCEProvider.getProviderForAlgorithm("RSA") == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
        RSAPrivateKeySpec spec = new RSAPrivateKeySpec(modulus, privateExponent);
        this.prv = (RSAPrivateKey)keyFactory.generatePrivate(spec);
    }

    public byte[] sign(byte[] data) throws IOException {
        try {
            Signature l_sig = JCEProvider.getProviderForAlgorithm("SHA1WithRSA") == null ? Signature.getInstance("SHA1WithRSA") : Signature.getInstance("SHA1WithRSA", JCEProvider.getProviderForAlgorithm("SHA1WithRSA"));
            l_sig.initSign(this.prv);
            l_sig.update(data);
            return l_sig.sign();
        }
        catch (Exception e) {
            IOException ex = new IOException("Failed to sign data! " + e.getMessage());
            try {
                Method m = IOException.class.getMethod("initCause", Throwable.class);
                m.invoke((Object)ex, e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw ex;
        }
    }

    public String getAlgorithm() {
        return "ssh-rsa";
    }

    public BigInteger getModulus() {
        return this.prv.getModulus();
    }

    public BigInteger getPrivateExponent() {
        return this.prv.getPrivateExponent();
    }
}

