/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.message;

import com.sshtools.logging.Log;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshIOException;
import com.sshtools.ssh.message.Message;
import com.sshtools.ssh.message.MessageHolder;
import com.sshtools.ssh.message.MessageObserver;
import com.sshtools.ssh.message.SshAbstractChannel;
import com.sshtools.ssh.message.SshChannelMessage;
import com.sshtools.ssh.message.SshMessage;
import com.sshtools.ssh.message.SshMessageReader;
import com.sshtools.ssh.message.SshMessageStore;
import com.sshtools.ssh.message.ThreadSynchronizer;
import java.util.Vector;

public abstract class SshMessageRouter {
    private SshAbstractChannel[] channels;
    SshMessageReader reader;
    SshMessageStore global;
    ThreadSynchronizer sync;
    private int count = 0;
    boolean buffered;
    MessagePump messagePump;
    boolean isClosing = false;
    Vector<SshAbstractChannel> activeChannels = new Vector();
    Vector<Runnable> shutdownHooks = new Vector();
    boolean verbose = Boolean.valueOf(System.getProperty("maverick.verbose", "false"));

    public SshMessageRouter(SshMessageReader reader, int maxChannels, boolean buffered) {
        this.reader = reader;
        this.buffered = buffered;
        this.channels = new SshAbstractChannel[maxChannels];
        this.global = new SshMessageStore(this, null, new MessageObserver(){

            public boolean wantsNotification(Message msg) {
                return false;
            }
        });
        this.sync = new ThreadSynchronizer(buffered);
        if (buffered) {
            this.messagePump = new MessagePump();
            this.sync.blockingThread = this.messagePump;
        }
    }

    public void start() {
        if (Log.isDebugEnabled() && this.verbose) {
            Log.debug(this, "starting message pump");
        }
        if (this.messagePump != null && !this.messagePump.isRunning()) {
            String prefix = "";
            String sourceThread = Thread.currentThread().getName();
            if (sourceThread.indexOf(45) > -1) {
                prefix = sourceThread.substring(0, 1 + sourceThread.indexOf(45));
            }
            this.messagePump.setName(prefix + "MessagePump_" + this.messagePump.getName());
            this.messagePump.start();
            if (Log.isDebugEnabled() && this.verbose) {
                Log.debug(this, "message pump started thread name:" + this.messagePump.getName());
            }
        }
    }

    public void addShutdownHook(Runnable r) {
        if (r != null) {
            this.shutdownHooks.addElement(r);
        }
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void stop() {
        this.signalClosingState();
        if (this.messagePump != null) {
            this.messagePump.stopThread();
        }
        if (this.shutdownHooks != null) {
            for (int i = 0; i < this.shutdownHooks.size(); ++i) {
                try {
                    this.shutdownHooks.elementAt(i).run();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalClosingState() {
        if (this.buffered && this.messagePump != null) {
            MessagePump messagePump = this.messagePump;
            synchronized (messagePump) {
                this.isClosing = true;
            }
        }
    }

    protected SshMessageStore getGlobalMessages() {
        return this.global;
    }

    public int getMaxChannels() {
        return this.channels.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int allocateChannel(SshAbstractChannel channel) {
        SshAbstractChannel[] sshAbstractChannelArray = this.channels;
        synchronized (this.channels) {
            for (int i = 0; i < this.channels.length; ++i) {
                if (this.channels[i] != null) continue;
                this.channels[i] = channel;
                this.activeChannels.addElement(channel);
                ++this.count;
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Allocated channel " + i);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeChannel(SshAbstractChannel channel) {
        SshAbstractChannel[] sshAbstractChannelArray = this.channels;
        synchronized (this.channels) {
            if (this.channels[channel.getChannelId()] != null && channel.equals(this.channels[channel.getChannelId()])) {
                this.channels[channel.getChannelId()] = null;
                this.activeChannels.removeElement(channel);
                --this.count;
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Freed channel " + channel.getChannelId());
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected SshAbstractChannel[] getActiveChannels() {
        return this.activeChannels.toArray(new SshAbstractChannel[0]);
    }

    protected int maximumChannels() {
        return this.channels.length;
    }

    public int getChannelCount() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SshMessage nextMessage(SshAbstractChannel channel, MessageObserver observer, long timeout) throws SshException, InterruptedException {
        SshMessageStore store;
        long startTime = System.currentTimeMillis();
        SshMessageStore sshMessageStore = store = channel == null ? this.global : channel.getMessageStore();
        if (Log.isDebugEnabled() && this.verbose) {
            Log.debug(this, "using " + (channel == null ? "global store" : "channel store"));
        }
        MessageHolder holder = new MessageHolder();
        while (holder.msg == null && (timeout == 0L || System.currentTimeMillis() - startTime < timeout)) {
            if (this.buffered && this.messagePump != null) {
                if (Log.isDebugEnabled() && this.verbose) {
                    Log.debug(this, "waiting for messagePump lock");
                }
                MessagePump messagePump = this.messagePump;
                synchronized (messagePump) {
                    if (!this.isClosing && this.messagePump.lastError != null) {
                        Throwable tmpEx = this.messagePump.lastError;
                        this.messagePump.lastError = null;
                        if (tmpEx instanceof SshException) {
                            if (Log.isDebugEnabled()) {
                                Log.debug(this, "messagePump has SshException this will be caught by customer code");
                            }
                            throw (SshException)tmpEx;
                        }
                        if (tmpEx instanceof SshIOException) {
                            if (Log.isDebugEnabled()) {
                                Log.debug(this, "messagePump has SshIOException this will be caught by customer code");
                            }
                            throw ((SshIOException)tmpEx).getRealException();
                        }
                        if (Log.isDebugEnabled()) {
                            Log.debug(this, "messagePump has some other exception this will be caught by customer code");
                        }
                        throw new SshException(tmpEx);
                    }
                }
            }
            if (!this.sync.requestBlock(store, observer, holder)) continue;
            try {
                if (Log.isDebugEnabled() && this.verbose) {
                    Log.debug(this, "block for message");
                }
                this.blockForMessage();
            }
            finally {
                this.sync.releaseBlock();
            }
        }
        if (holder.msg == null) {
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Mesage timeout reached timeout=" + timeout);
            }
            throw new SshException("The message was not received before the specified timeout period timeout=" + timeout, 21);
        }
        return (SshMessage)holder.msg;
    }

    public boolean isBlockingThread(Thread thread) {
        return this.sync.isBlockOwner(thread);
    }

    private void blockForMessage() throws SshException {
        boolean processed;
        SshMessage message = this.createMessage(this.reader.nextMessage());
        if (Log.isDebugEnabled() && this.verbose) {
            Log.debug(this, "read next message");
        }
        SshAbstractChannel destination = null;
        if (message instanceof SshChannelMessage) {
            destination = this.channels[((SshChannelMessage)message).getChannelId()];
        }
        boolean bl = processed = destination == null ? this.processGlobalMessage(message) : destination.processChannelMessage((SshChannelMessage)message);
        if (!processed) {
            SshMessageStore ms = destination == null ? this.global : destination.getMessageStore();
            ms.addMessage(message);
        }
    }

    protected abstract void onThreadExit();

    protected abstract SshMessage createMessage(byte[] var1) throws SshException;

    protected abstract boolean processGlobalMessage(SshMessage var1) throws SshException;

    class MessagePump
    extends Thread {
        Throwable lastError;
        boolean running = false;

        MessagePump() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.running = true;
                while (this.running) {
                    try {
                        SshMessageRouter.this.blockForMessage();
                        SshMessageRouter.this.sync.releaseWaiting();
                    }
                    catch (Throwable t) {
                        MessagePump messagePump = this;
                        synchronized (messagePump) {
                            if (!SshMessageRouter.this.isClosing) {
                                Log.info(this, "Message pump caught exception: " + t.getMessage());
                                this.lastError = t;
                            }
                            this.stopThread();
                        }
                    }
                }
                SshMessageRouter.this.sync.releaseBlock();
            }
            finally {
                SshMessageRouter.this.onThreadExit();
            }
        }

        public void stopThread() {
            this.running = false;
            if (!Thread.currentThread().equals(this)) {
                this.interrupt();
            }
        }

        public boolean isRunning() {
            return this.running;
        }
    }
}

