/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh2;

import com.sshtools.logging.Log;
import com.sshtools.ssh.ChannelEventListener;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshIOException;
import com.sshtools.ssh.message.Message;
import com.sshtools.ssh.message.MessageObserver;
import com.sshtools.ssh.message.SshAbstractChannel;
import com.sshtools.ssh.message.SshChannelMessage;
import com.sshtools.ssh.message.SshMessageStore;
import com.sshtools.ssh2.ConnectionProtocol;
import com.sshtools.util.ByteArrayReader;
import com.sshtools.util.ByteArrayWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class Ssh2Channel
extends SshAbstractChannel {
    public static final String SESSION_CHANNEL = "session";
    ConnectionProtocol connection;
    int remoteid;
    String name;
    Vector<ChannelEventListener> listeners = new Vector();
    static final int SSH_MSG_CHANNEL_CLOSE = 97;
    static final int SSH_MSG_CHANNEL_EOF = 96;
    static final int SSH_MSG_CHANNEL_REQUEST = 98;
    static final int SSH_MSG_CHANNEL_SUCCESS = 99;
    static final int SSH_MSG_CHANNEL_FAILURE = 100;
    static final int SSH_MSG_WINDOW_ADJUST = 93;
    static final int SSH_MSG_CHANNEL_DATA = 94;
    static final int SSH_MSG_CHANNEL_EXTENDED_DATA = 95;
    boolean autoConsumeInput = false;
    boolean sendKeepAliveOnIdle = false;
    boolean isRemoteEOF = false;
    boolean isLocalEOF = false;
    final MessageObserver WINDOW_ADJUST_MESSAGES = new MessageObserver(){

        public boolean wantsNotification(Message msg) {
            switch (msg.getMessageId()) {
                case 93: 
                case 97: {
                    return true;
                }
            }
            return false;
        }
    };
    final MessageObserver CHANNEL_DATA_MESSAGES = new MessageObserver(){

        public boolean wantsNotification(Message msg) {
            switch (msg.getMessageId()) {
                case 94: 
                case 96: 
                case 97: {
                    return true;
                }
            }
            return false;
        }
    };
    final MessageObserver EXTENDED_DATA_MESSAGES = new MessageObserver(){

        public boolean wantsNotification(Message msg) {
            switch (msg.getMessageId()) {
                case 95: 
                case 96: 
                case 97: {
                    return true;
                }
            }
            return false;
        }
    };
    final MessageObserver CHANNEL_REQUEST_MESSAGES = new MessageObserver(){

        public boolean wantsNotification(Message msg) {
            switch (msg.getMessageId()) {
                case 97: 
                case 99: 
                case 100: {
                    return true;
                }
            }
            return false;
        }
    };
    final MessageObserver CHANNEL_CLOSE_MESSAGES = new MessageObserver(){

        public boolean wantsNotification(Message msg) {
            switch (msg.getMessageId()) {
                case 97: {
                    return true;
                }
            }
            return false;
        }
    };
    static final MessageObserver STICKY_MESSAGES = new MessageObserver(){

        public boolean wantsNotification(Message msg) {
            switch (msg.getMessageId()) {
                case 96: 
                case 97: {
                    return true;
                }
            }
            return false;
        }
    };
    ChannelInputStream in;
    ChannelOutputStream out;
    DataWindow localwindow;
    DataWindow remotewindow;
    boolean closing = false;
    boolean free = false;
    boolean isBlocking = false;

    public Ssh2Channel(String name, int windowsize, int packetsize) {
        this.name = name;
        this.localwindow = new DataWindow(windowsize, packetsize);
        this.in = new ChannelInputStream(this.CHANNEL_DATA_MESSAGES);
        this.out = new ChannelOutputStream();
    }

    protected MessageObserver getStickyMessageIds() {
        return STICKY_MESSAGES;
    }

    public void setAutoConsumeInput(boolean autoConsumeInput) {
        this.autoConsumeInput = autoConsumeInput;
    }

    long getWindowSize() {
        return this.localwindow.available();
    }

    int getPacketSize() {
        return this.localwindow.getPacketSize();
    }

    protected SshMessageStore getMessageStore() throws SshException {
        return super.getMessageStore();
    }

    public String getName() {
        return this.name;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChannelEventListener(ChannelEventListener listener) {
        Vector<ChannelEventListener> vector = this.listeners;
        synchronized (vector) {
            if (listener != null) {
                this.listeners.addElement(listener);
            }
        }
    }

    public boolean isSendKeepAliveOnIdle() {
        return this.sendKeepAliveOnIdle;
    }

    public void setSendKeepAliveOnIdle(boolean sendKeepAliveOnIdle) {
        this.sendKeepAliveOnIdle = sendKeepAliveOnIdle;
    }

    public void idle() {
        if (this.sendKeepAliveOnIdle) {
            try {
                this.sendRequest("keep-alive@sshtools.com", false, null, false);
            }
            catch (SshException sshException) {
                // empty catch block
            }
        }
    }

    void init(ConnectionProtocol connection, int channelid) {
        this.connection = connection;
        super.init(connection, channelid);
    }

    protected byte[] create() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open(int remoteid, long remotewindow, int remotepacket) throws IOException {
        this.remoteid = remoteid;
        this.remotewindow = new DataWindow(remotewindow, remotepacket);
        this.state = 2;
        Vector<ChannelEventListener> vector = this.listeners;
        synchronized (vector) {
            Enumeration<ChannelEventListener> e = this.listeners.elements();
            while (e.hasMoreElements()) {
                e.nextElement().channelOpened(this);
            }
        }
    }

    protected void open(int remoteid, long remotewindow, int remotepacket, byte[] responsedata) throws IOException {
        this.open(remoteid, remotewindow, remotepacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processChannelMessage(SshChannelMessage msg) throws SshException {
        try {
            switch (msg.getMessageId()) {
                case 98: {
                    String requesttype = msg.readString();
                    boolean wantreply = msg.read() != 0;
                    byte[] requestdata = new byte[msg.available()];
                    msg.read(requestdata);
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Received SSH_MSG_CHANNEL_REQUEST id=" + this.channelid + " rid=" + this.remoteid + " request=" + requesttype + " wantreply=" + wantreply);
                    }
                    this.channelRequest(requesttype, wantreply, requestdata);
                    return true;
                }
                case 93: {
                    if (Log.isDebugEnabled()) {
                        msg.mark(4);
                        int len = (int)msg.readInt();
                        Log.debug(this, "Received SSH_MSG_WINDOW_ADJUST id=" + this.channelid + " rid=" + this.remoteid + " window=" + this.remotewindow.available() + " adjust=" + len);
                        msg.reset();
                    }
                    return false;
                }
                case 94: {
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Received SSH_MSG_CHANNEL_DATA id=" + this.channelid + " rid=" + this.remoteid + " len=" + (msg.available() - 4) + " window=" + this.localwindow.available());
                    }
                    if (this.autoConsumeInput) {
                        this.localwindow.consume(msg.available() - 4);
                        if (this.localwindow.available() <= this.localwindow.getInitialSize() / 2L) {
                            this.adjustWindow(this.localwindow.getInitialSize() - this.localwindow.available());
                        }
                    }
                    Enumeration<ChannelEventListener> e = this.listeners.elements();
                    while (e.hasMoreElements()) {
                        e.nextElement().dataReceived(this, msg.array(), msg.getPosition() + 4, msg.available() - 4);
                    }
                    return this.autoConsumeInput;
                }
                case 95: {
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Received SSH_MSG_CHANNEL_EXTENDED_DATA id=" + this.channelid + " rid=" + this.remoteid + " len=" + (msg.available() - 4) + " window=" + this.localwindow.available());
                    }
                    int type = (int)ByteArrayReader.readInt(msg.array(), msg.getPosition());
                    if (this.autoConsumeInput) {
                        this.localwindow.consume(msg.available() - 8);
                        if (this.localwindow.available() <= this.localwindow.getInitialSize() / 2L) {
                            this.adjustWindow(this.localwindow.getInitialSize() - this.localwindow.available());
                        }
                    }
                    Enumeration<ChannelEventListener> e = this.listeners.elements();
                    while (e.hasMoreElements()) {
                        e.nextElement().extendedDataReceived(this, msg.array(), msg.getPosition() + 8, msg.available() - 8, type);
                    }
                    return this.autoConsumeInput;
                }
                case 97: {
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Received SSH_MSG_CHANNEL_CLOSE id=" + this.channelid + " rid=" + this.remoteid);
                    }
                    Ssh2Channel e = this;
                    synchronized (e) {
                        if (!this.closing) {
                            SshMessageStore sshMessageStore = this.ms;
                            synchronized (sshMessageStore) {
                                if (!this.ms.isClosed()) {
                                    this.ms.close();
                                }
                            }
                        }
                    }
                    this.checkCloseStatus(true);
                    return false;
                }
                case 96: {
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Received SSH_MSG_CHANNEL_EOF id=" + this.channelid + " rid=" + this.remoteid);
                    }
                    this.isRemoteEOF = true;
                    Enumeration<ChannelEventListener> e = this.listeners.elements();
                    while (e.hasMoreElements()) {
                        e.nextElement().channelEOF(this);
                    }
                    this.channelEOF();
                    if (this.isLocalEOF) {
                        this.close();
                    }
                    return false;
                }
            }
            return false;
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
    }

    SshChannelMessage processMessages(MessageObserver messagefilter) throws SshException, EOFException {
        SshChannelMessage msg = (SshChannelMessage)this.ms.nextMessage(messagefilter, 0L);
        switch (msg.getMessageId()) {
            case 93: {
                try {
                    this.remotewindow.adjust(msg.readInt());
                    if (!Log.isDebugEnabled()) break;
                    Log.debug(this, "Applied window adjust window=" + this.remotewindow.available());
                    break;
                }
                catch (IOException ex) {
                    throw new SshException(5, (Throwable)ex);
                }
            }
            case 94: {
                try {
                    int length = (int)msg.readInt();
                    this.processStandardData(length, msg);
                    break;
                }
                catch (IOException e) {
                    throw new SshException(5, (Throwable)e);
                }
            }
            case 95: {
                try {
                    int type = (int)msg.readInt();
                    int length = (int)msg.readInt();
                    this.processExtendedData(type, length, msg);
                    break;
                }
                catch (IOException ex) {
                    throw new SshException(5, (Throwable)ex);
                }
            }
            case 97: {
                this.checkCloseStatus(true);
                throw new EOFException("The channel is closed");
            }
            case 96: {
                throw new EOFException("The channel is EOF");
            }
        }
        return msg;
    }

    protected void processStandardData(int length, SshChannelMessage msg) throws SshException {
        this.in.addMessage(length, msg);
    }

    protected void processStandardData(byte[] buf, int off, int len) throws SshException {
        this.in.addMessage(len, new SshChannelMessage(94, buf, off, len));
    }

    protected void processExtendedData(int typecode, int length, SshChannelMessage msg) throws SshException {
    }

    protected ChannelInputStream createExtendedDataStream() {
        return new ChannelInputStream(this.EXTENDED_DATA_MESSAGES);
    }

    void sendChannelData(byte[] buf, int offset, int len) throws SshException {
        ByteArrayWriter msg = new ByteArrayWriter(len + 9);
        try {
            if (this.state != 2) {
                throw new SshException("The channel is closed", 6);
            }
            if (len > 0) {
                msg.write(94);
                msg.writeInt(this.remoteid);
                msg.writeBinaryString(buf, offset, len);
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Sending SSH_MSG_CHANNEL_DATA id=" + this.channelid + " rid=" + this.remoteid + " len=" + len + " window=" + this.remotewindow.available());
                }
                this.connection.sendMessage(msg.toByteArray(), true);
            }
            Enumeration<ChannelEventListener> e = this.listeners.elements();
            while (e.hasMoreElements()) {
                e.nextElement().dataSent(this, buf, offset, len);
            }
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                msg.close();
            }
            catch (IOException iOException) {}
        }
    }

    void sendExtendedChannelData(byte[] buf, int offset, int len, int type) throws SshException {
        ByteArrayWriter msg = new ByteArrayWriter(len + 9);
        try {
            if (this.state != 2) {
                throw new SshException("The channel is closed", 6);
            }
            if (len > 0) {
                msg.write(95);
                msg.writeInt(this.remoteid);
                msg.writeInt(type);
                msg.writeBinaryString(buf, offset, len);
                this.connection.sendMessage(msg.toByteArray(), true);
            }
            if (this.listeners != null) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.listeners.elementAt(i).extendedDataReceived(this, buf, offset, len, type);
                }
            }
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                msg.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void adjustWindow(long increment) throws SshException {
        ByteArrayWriter msg = new ByteArrayWriter(9);
        try {
            if (this.closing || this.isClosed()) {
                return;
            }
            msg.write(93);
            msg.writeInt(this.remoteid);
            msg.writeInt(increment);
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Sending SSH_MSG_WINDOW_ADJUST id=" + this.channelid + " rid=" + this.remoteid + " window=" + this.localwindow.available() + " adjust=" + increment);
            }
            this.localwindow.adjust(increment);
            this.connection.sendMessage(msg.toByteArray(), true);
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                msg.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean sendRequest(String requesttype, boolean wantreply, byte[] requestdata) throws SshException {
        return this.sendRequest(requesttype, wantreply, requestdata, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendRequest(String requesttype, boolean wantreply, byte[] requestdata, boolean isActivity) throws SshException {
        Ssh2Channel ssh2Channel = this;
        synchronized (ssh2Channel) {
            boolean bl;
            ByteArrayWriter msg;
            block18: {
                boolean bl2;
                block17: {
                    msg = new ByteArrayWriter();
                    try {
                        msg.write(98);
                        msg.writeInt(this.remoteid);
                        msg.writeString(requesttype);
                        msg.writeBoolean(wantreply);
                        if (requestdata != null) {
                            msg.write(requestdata);
                        }
                        if (Log.isDebugEnabled()) {
                            Log.debug(this, "Sending SSH_MSG_CHANNEL_REQUEST id=" + this.channelid + " rid=" + this.remoteid + " request=" + requesttype + " wantreply=" + wantreply);
                        }
                        this.connection.sendMessage(msg.toByteArray(), true);
                        boolean result = false;
                        if (wantreply) {
                            SshChannelMessage reply = this.processMessages(this.CHANNEL_REQUEST_MESSAGES);
                            bl2 = reply.getMessageId() == 99;
                            break block17;
                        }
                        bl = result;
                        break block18;
                    }
                    catch (IOException ex) {
                        throw new SshException(ex, 5);
                    }
                }
                return bl2;
            }
            return bl;
            finally {
                try {
                    msg.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean performClose = false;
        Object object = this;
        synchronized (object) {
            if (!this.closing && this.state == 2) {
                this.closing = true;
                performClose = true;
            }
        }
        if (performClose) {
            object = this.listeners;
            synchronized (object) {
                Enumeration<ChannelEventListener> e = this.listeners.elements();
                while (e.hasMoreElements()) {
                    e.nextElement().channelClosing(this);
                }
            }
            try {
                this.out.close(!this.isLocalEOF);
                ByteArrayWriter msg = new ByteArrayWriter(5);
                msg.write(97);
                msg.writeInt(this.remoteid);
                try {
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Sending SSH_MSG_CHANNEL_CLOSE id=" + this.channelid + " rid=" + this.remoteid);
                    }
                    this.connection.sendMessage(msg.toByteArray(), true);
                }
                catch (SshException ex1) {
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Exception attempting to send SSH_MSG_CHANNEL_CLOSE id=" + this.channelid + " rid=" + this.remoteid, ex1);
                    }
                }
                finally {
                    msg.close();
                }
                this.state = 3;
            }
            catch (EOFException msg) {
            }
            catch (SshIOException ex) {
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "SSH Exception during close reason=" + ex.getRealException().getReason() + " id=" + this.channelid + " rid=" + this.remoteid, ex.getRealException());
                }
                this.connection.transport.disconnect(10, "IOException during channel close: " + ex.getMessage());
            }
            catch (IOException ex) {
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Exception during close id=" + this.channelid + " rid=" + this.remoteid, ex);
                }
                this.connection.transport.disconnect(10, "IOException during channel close: " + ex.getMessage());
            }
            finally {
                this.checkCloseStatus(this.ms.isClosed());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCloseStatus(boolean remoteClosed) {
        if (this.state != 3) {
            this.close();
            if (!remoteClosed) {
                boolean bl = remoteClosed = this.ms.hasMessage(this.CHANNEL_CLOSE_MESSAGES) != null;
            }
        }
        if (remoteClosed) {
            Ssh2Channel ssh2Channel = this;
            synchronized (ssh2Channel) {
                if (!this.free) {
                    Vector<ChannelEventListener> vector = this.listeners;
                    synchronized (vector) {
                        Enumeration<ChannelEventListener> e = this.listeners.elements();
                        while (e.hasMoreElements()) {
                            e.nextElement().channelClosed(this);
                        }
                    }
                    this.connection.closeChannel(this);
                    this.free = true;
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Ssh2Channel) {
            return ((Ssh2Channel)obj).getChannelId() == this.channelid;
        }
        return false;
    }

    protected void channelRequest(String requesttype, boolean wantreply, byte[] requestdata) throws SshException {
        if (wantreply) {
            ByteArrayWriter msg = new ByteArrayWriter();
            try {
                msg.write(100);
                msg.writeInt(this.remoteid);
                this.connection.sendMessage(msg.toByteArray(), true);
            }
            catch (IOException e) {
                throw new SshException(e, 5);
            }
            finally {
                try {
                    msg.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void channelEOF() {
    }

    static class DataWindow {
        long windowsize;
        long initialSize;
        int packetsize;

        DataWindow(long windowsize, int packetsize) {
            this.initialSize = windowsize;
            this.windowsize = windowsize;
            this.packetsize = packetsize;
        }

        int getPacketSize() {
            return this.packetsize;
        }

        long getInitialSize() {
            return this.initialSize;
        }

        void adjust(long count) {
            this.windowsize += count;
        }

        void consume(int count) {
            this.windowsize -= (long)count;
        }

        long available() {
            return this.windowsize;
        }
    }

    class ChannelInputStream
    extends InputStream {
        int unread = 0;
        MessageObserver messagefilter;
        long transfered = 0L;
        SshChannelMessage currentMessage = null;

        ChannelInputStream(MessageObserver messagefilter) {
            this.messagefilter = messagefilter;
        }

        void addMessage(int length, SshChannelMessage msg) {
            this.unread = length;
            this.currentMessage = msg;
        }

        public synchronized int available() throws IOException {
            try {
                if (this.unread == 0 && Ssh2Channel.this.getMessageStore().hasMessage(this.messagefilter) != null) {
                    Ssh2Channel.this.processMessages(this.messagefilter);
                }
                return this.unread;
            }
            catch (EOFException ex) {
                return -1;
            }
            catch (SshException ex) {
                throw new SshIOException(ex);
            }
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            int ret = this.read(b, 0, 1);
            if (ret > 0) {
                return b[0] & 0xFF;
            }
            return -1;
        }

        public synchronized int read(byte[] buf, int offset, int len) throws IOException {
            try {
                int count;
                if (this.available() == -1) {
                    return -1;
                }
                while (this.unread <= 0 && !Ssh2Channel.this.isClosed()) {
                    Ssh2Channel.this.processMessages(this.messagefilter);
                }
                int n = count = this.unread < len ? this.unread : len;
                if (count == 0 && Ssh2Channel.this.isClosed()) {
                    return -1;
                }
                this.currentMessage.read(buf, offset, count);
                Ssh2Channel.this.localwindow.consume(count);
                this.unread -= count;
                if (System.getProperty("maverick.windowAdjustTest", "false").equals("true") || (long)this.unread + Ssh2Channel.this.localwindow.available() < Ssh2Channel.this.localwindow.getInitialSize() / 2L && !Ssh2Channel.this.isClosed() && !Ssh2Channel.this.closing) {
                    Ssh2Channel.this.adjustWindow(Ssh2Channel.this.localwindow.getInitialSize() - Ssh2Channel.this.localwindow.available() - (long)this.unread);
                }
                this.transfered += (long)count;
                return count;
            }
            catch (SshException ex) {
                throw new SshIOException(ex);
            }
            catch (EOFException ex) {
                return -1;
            }
        }
    }

    class ChannelOutputStream
    extends OutputStream {
        ChannelOutputStream() {
        }

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] buf, int offset, int len) throws IOException {
            try {
                do {
                    if (Ssh2Channel.this.remotewindow.available() <= 0L) {
                        Ssh2Channel.this.processMessages(Ssh2Channel.this.WINDOW_ADJUST_MESSAGES);
                    }
                    Ssh2Channel ssh2Channel = Ssh2Channel.this;
                    synchronized (ssh2Channel) {
                        long write;
                        if (Ssh2Channel.this.isLocalEOF) {
                            throw new EOFException("The channel is EOF");
                        }
                        if (Ssh2Channel.this.isClosed() || Ssh2Channel.this.closing) {
                            throw new EOFException("The channel is closed");
                        }
                        long l = Ssh2Channel.this.remotewindow.available() < (long)Ssh2Channel.this.remotewindow.getPacketSize() ? (Ssh2Channel.this.remotewindow.available() < (long)len ? Ssh2Channel.this.remotewindow.available() : (long)len) : (write = (long)(Ssh2Channel.this.remotewindow.getPacketSize() < len ? Ssh2Channel.this.remotewindow.getPacketSize() : len));
                        if (write > 0L) {
                            Ssh2Channel.this.sendChannelData(buf, offset, (int)write);
                            Ssh2Channel.this.remotewindow.consume((int)write);
                            len = (int)((long)len - write);
                            offset = (int)((long)offset + write);
                        }
                    }
                } while (len > 0);
            }
            catch (SshException ex) {
                throw new SshIOException(ex);
            }
        }

        public void close() throws IOException {
            this.close(!Ssh2Channel.this.isClosed() && !Ssh2Channel.this.isLocalEOF && !Ssh2Channel.this.closing);
        }

        public void close(boolean sendEOF) throws IOException {
            if (sendEOF) {
                ByteArrayWriter msg = new ByteArrayWriter(5);
                msg.write(96);
                msg.writeInt(Ssh2Channel.this.remoteid);
                try {
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Sending SSH_MSG_CHANNEL_EOF id=" + Ssh2Channel.this.getChannelId() + " rid=" + Ssh2Channel.this.remoteid);
                    }
                    Ssh2Channel.this.connection.sendMessage(msg.toByteArray(), true);
                }
                catch (SshException ex) {
                    throw new SshIOException(ex);
                }
                finally {
                    msg.close();
                }
            }
            Ssh2Channel.this.isLocalEOF = true;
            if (Ssh2Channel.this.isRemoteEOF) {
                Ssh2Channel.this.close();
            }
        }
    }
}

