/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh2;

import com.sshtools.logging.Log;
import com.sshtools.ssh.ChannelEventListener;
import com.sshtools.ssh.ChannelOpenException;
import com.sshtools.ssh.ForwardingRequestListener;
import com.sshtools.ssh.PasswordAuthentication;
import com.sshtools.ssh.PublicKeyAuthentication;
import com.sshtools.ssh.SshAuthentication;
import com.sshtools.ssh.SshClient;
import com.sshtools.ssh.SshConnector;
import com.sshtools.ssh.SshContext;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshSession;
import com.sshtools.ssh.SshTransport;
import com.sshtools.ssh.SshTunnel;
import com.sshtools.ssh.components.SshKeyExchangeClient;
import com.sshtools.ssh.message.SshAbstractChannel;
import com.sshtools.ssh2.AuthenticationClient;
import com.sshtools.ssh2.AuthenticationProtocol;
import com.sshtools.ssh2.ChannelFactory;
import com.sshtools.ssh2.ConnectionProtocol;
import com.sshtools.ssh2.GlobalRequest;
import com.sshtools.ssh2.GlobalRequestHandler;
import com.sshtools.ssh2.KBIAuthentication;
import com.sshtools.ssh2.KBIPrompt;
import com.sshtools.ssh2.KBIRequestHandler;
import com.sshtools.ssh2.Ssh2Channel;
import com.sshtools.ssh2.Ssh2Context;
import com.sshtools.ssh2.Ssh2ForwardingChannel;
import com.sshtools.ssh2.Ssh2PasswordAuthentication;
import com.sshtools.ssh2.Ssh2PublicKeyAuthentication;
import com.sshtools.ssh2.Ssh2Session;
import com.sshtools.ssh2.TransportProtocol;
import com.sshtools.util.ByteArrayReader;
import com.sshtools.util.ByteArrayWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class Ssh2Client
implements SshClient {
    TransportProtocol transport;
    SshTransport io;
    AuthenticationProtocol authentication;
    ConnectionProtocol connection;
    String localIdentification;
    String remoteIdentification;
    String[] authenticationMethods;
    String username;
    Hashtable<String, ForwardingRequestListener> forwardingListeners = new Hashtable();
    Hashtable<String, String> forwardingDestinations = new Hashtable();
    ForwardingRequestChannelFactory requestFactory = new ForwardingRequestChannelFactory();
    SshAuthentication auth;
    SshConnector connector;
    boolean isXForwarding = false;
    boolean buffered;

    public void connect(SshTransport io, SshContext context, SshConnector connector, String username, String localIdentification, String remoteIdentification, boolean buffered) throws SshException {
        this.io = io;
        this.localIdentification = localIdentification;
        this.remoteIdentification = remoteIdentification;
        this.username = username;
        this.buffered = buffered;
        this.connector = connector;
        if (username == null) {
            block10: {
                try {
                    io.close();
                }
                catch (IOException ex) {
                    if (!Log.isDebugEnabled()) break block10;
                    Log.debug(this, "RECIEVED IOException IN Ssh2Client.connect:" + ex.getMessage());
                }
            }
            throw new SshException("You must supply a valid username!", 4);
        }
        if (!(context instanceof Ssh2Context)) {
            block11: {
                try {
                    io.close();
                }
                catch (IOException ex) {
                    if (!Log.isDebugEnabled()) break block11;
                    Log.debug(this, "RECIEVED IOException IN Ssh2Client.connect:" + ex.getMessage());
                }
            }
            throw new SshException("Ssh2Context required!", 4);
        }
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Connecting " + username + "@" + io.getHost() + ":" + io.getPort());
            Log.debug(this, "Remote identification is " + remoteIdentification);
        }
        this.transport = new TransportProtocol();
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Starting transport protocol");
        }
        this.transport.startTransportProtocol(io, (Ssh2Context)context, localIdentification, remoteIdentification, this);
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Starting authentication protocol");
        }
        this.authentication = new AuthenticationProtocol(this.transport);
        this.authentication.setBannerDisplay(((Ssh2Context)context).getBannerDisplay());
        this.connection = new ConnectionProtocol(this.transport, context, buffered);
        this.connection.addChannelFactory(this.requestFactory);
        this.getAuthenticationMethods(username);
        if (Log.isDebugEnabled()) {
            Log.debug(this, "SSH connection established");
        }
    }

    public String[] getAuthenticationMethods(String username) throws SshException {
        this.verifyConnection(false);
        if (this.authenticationMethods == null) {
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Requesting authentication methods");
            }
            String methods = this.authentication.getAuthenticationMethods(username, "ssh-connection");
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Available authentications are " + methods);
            }
            Vector<String> tmp = new Vector<String>();
            while (methods != null) {
                int idx = methods.indexOf(44);
                if (idx > -1) {
                    tmp.addElement(methods.substring(0, idx));
                    methods = methods.substring(idx + 1);
                    continue;
                }
                tmp.addElement(methods);
                methods = null;
            }
            this.authenticationMethods = new String[tmp.size()];
            tmp.copyInto(this.authenticationMethods);
            if (this.isAuthenticated()) {
                this.connection.start();
            }
        }
        return this.authenticationMethods;
    }

    private SshAuthentication checkForPasswordOverKBI(SshAuthentication auth) {
        boolean kbiAuthenticationPossible = false;
        for (int i = 0; i < this.authenticationMethods.length; ++i) {
            if (this.authenticationMethods[i].equals("password")) {
                return auth;
            }
            if (!this.authenticationMethods[i].equals("keyboard-interactive")) continue;
            kbiAuthenticationPossible = true;
        }
        if (kbiAuthenticationPossible) {
            KBIAuthentication kbi = new KBIAuthentication();
            kbi.setUsername(((PasswordAuthentication)auth).getUsername());
            kbi.setKBIRequestHandler(new KBIRequestHandlerWhenUserUsingPasswordAuthentication((PasswordAuthentication)auth));
            return kbi;
        }
        return auth;
    }

    public int authenticate(SshAuthentication auth) throws SshException {
        int result;
        this.verifyConnection(false);
        if (this.isAuthenticated()) {
            throw new SshException("User is already authenticated! Did you check isAuthenticated?", 4);
        }
        if (auth.getUsername() == null) {
            auth.setUsername(this.username);
        }
        if (auth instanceof PasswordAuthentication || auth instanceof Ssh2PasswordAuthentication) {
            auth = this.checkForPasswordOverKBI(auth);
        }
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Authenticating with " + auth.getMethod());
        }
        if (auth instanceof PasswordAuthentication && !(auth instanceof Ssh2PasswordAuthentication)) {
            Ssh2PasswordAuthentication pwd = new Ssh2PasswordAuthentication();
            pwd.setUsername(((PasswordAuthentication)auth).getUsername());
            pwd.setPassword(((PasswordAuthentication)auth).getPassword());
            result = this.authentication.authenticate(pwd, "ssh-connection");
            if (pwd.requiresPasswordChange()) {
                this.disconnect();
                throw new SshException("Password change required!", 8);
            }
        } else if (auth instanceof PublicKeyAuthentication && !(auth instanceof Ssh2PublicKeyAuthentication)) {
            Ssh2PublicKeyAuthentication pk = new Ssh2PublicKeyAuthentication();
            pk.setUsername(((PublicKeyAuthentication)auth).getUsername());
            pk.setPublicKey(((PublicKeyAuthentication)auth).getPublicKey());
            pk.setPrivateKey(((PublicKeyAuthentication)auth).getPrivateKey());
            result = this.authentication.authenticate(pk, "ssh-connection");
        } else if (auth instanceof AuthenticationClient) {
            result = this.authentication.authenticate((AuthenticationClient)auth, "ssh-connection");
        } else {
            throw new SshException("Invalid authentication client", 4);
        }
        if (result == 1) {
            this.auth = auth;
            this.connection.start();
        }
        if (Log.isDebugEnabled()) {
            switch (result) {
                case 1: {
                    Log.debug(this, "Authentication complete");
                    break;
                }
                case 2: {
                    Log.debug(this, "Authentication failed");
                    break;
                }
                case 3: {
                    Log.debug(this, "Authentication successful but further authentication required");
                    break;
                }
                case 4: {
                    Log.debug(this, "Authentication cancelled");
                    break;
                }
                case 5: {
                    Log.debug(this, "Server accepts the public key provided");
                    break;
                }
                default: {
                    Log.debug(this, "Unknown authentication result " + result);
                }
            }
        }
        return result;
    }

    public boolean isAuthenticated() {
        return this.authentication.isAuthenticated();
    }

    public void disconnect() {
        try {
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Disconnecting");
            }
            this.connection.signalClosingState();
            this.connection.stop();
            this.transport.disconnect(11, "The user disconnected the application");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Disconnected");
        }
    }

    public void exit() {
        try {
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Disconnecting");
            }
            this.connection.signalClosingState();
            this.transport.disconnect(11, "The user disconnected the application");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Disconnected");
        }
    }

    public boolean isConnected() {
        return this.transport.isConnected();
    }

    public void forceKeyExchange() throws SshException {
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Forcing key exchange");
        }
        this.transport.sendKeyExchangeInit(false);
    }

    public SshSession openSessionChannel() throws SshException, ChannelOpenException {
        return this.openSessionChannel(32768, 32768, null);
    }

    public SshSession openSessionChannel(long timeout) throws SshException, ChannelOpenException {
        return this.openSessionChannel(32768, 32768, null, timeout);
    }

    public SshSession openSessionChannel(ChannelEventListener listener, long timeout) throws SshException, ChannelOpenException {
        return this.openSessionChannel(32768, 32768, listener, timeout);
    }

    public SshSession openSessionChannel(ChannelEventListener listener) throws SshException, ChannelOpenException {
        return this.openSessionChannel(32768, 32768, listener);
    }

    public Ssh2Session openSessionChannel(int windowspace, int packetsize, ChannelEventListener listener) throws ChannelOpenException, SshException {
        return this.openSessionChannel(windowspace, packetsize, listener, 0L);
    }

    public Ssh2Session openSessionChannel(int windowspace, int packetsize, ChannelEventListener listener, long timeout) throws ChannelOpenException, SshException {
        this.verifyConnection(true);
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Opening session channel windowspace=" + windowspace + " packetsize=" + packetsize);
        }
        Ssh2Session channel = new Ssh2Session(windowspace, packetsize, this);
        if (listener != null) {
            channel.addChannelEventListener(listener);
        }
        this.connection.openChannel(channel, null, timeout);
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Channel has been opened channelid=" + channel.getChannelId());
        }
        if (this.connection.getContext().getX11Display() != null) {
            String display = this.connection.getContext().getX11Display();
            int idx = display.indexOf(58);
            int screen = 0;
            if (idx != -1) {
                display = display.substring(idx + 1);
            }
            if ((idx = display.indexOf(46)) > -1) {
                screen = Integer.parseInt(display.substring(idx + 1));
            }
            byte[] x11FakeCookie = this.connection.getContext().getX11AuthenticationCookie();
            StringBuffer cookieBuf = new StringBuffer();
            for (int i = 0; i < 16; ++i) {
                String b = Integer.toHexString(x11FakeCookie[i] & 0xFF);
                if (b.length() == 1) {
                    b = "0" + b;
                }
                cookieBuf.append(b);
            }
            if (channel.requestX11Forwarding(false, "MIT-MAGIC-COOKIE-1", cookieBuf.toString(), screen)) {
                this.isXForwarding = true;
            }
        }
        return channel;
    }

    public SshClient openRemoteClient(String hostname, int port, String username, SshConnector con) throws SshException, ChannelOpenException {
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Opening a remote SSH client from " + this.io.getHost() + " to " + username + "@" + hostname + ":" + port);
        }
        SshTunnel tunnel = this.openForwardingChannel(hostname, port, "127.0.0.1", 22, "127.0.0.1", 22, null, null);
        return con.connect((SshTransport)tunnel, username, this.buffered);
    }

    public SshClient openRemoteClient(String hostname, int port, String username) throws SshException, ChannelOpenException {
        return this.openRemoteClient(hostname, port, username, this.connector);
    }

    public SshTunnel openForwardingChannel(String hostname, int port, String listeningAddress, int listeningPort, String originatingHost, int originatingPort, SshTransport transport, ChannelEventListener listener) throws SshException, ChannelOpenException {
        ByteArrayWriter request = new ByteArrayWriter();
        try {
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Opening forwarding channel from " + listeningAddress + ":" + listeningPort + " to " + hostname + ":" + port);
            }
            Ssh2ForwardingChannel tunnel = new Ssh2ForwardingChannel("direct-tcpip", 32768, 0x200000, hostname, port, listeningAddress, listeningPort, originatingHost, originatingPort, transport);
            request.writeString(hostname);
            request.writeInt(port);
            request.writeString(originatingHost);
            request.writeInt(originatingPort);
            tunnel.addChannelEventListener(listener);
            this.openChannel(tunnel, request.toByteArray());
            Ssh2ForwardingChannel ssh2ForwardingChannel = tunnel;
            return ssh2ForwardingChannel;
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean requestRemoteForwarding(String bindAddress, int bindPort, String hostToConnect, int portToConnect, ForwardingRequestListener listener) throws SshException {
        ByteArrayWriter baw = new ByteArrayWriter();
        try {
            if (listener == null) {
                throw new SshException("You must specify a listener to receive connection requests", 4);
            }
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Requesting remote forwarding from " + bindAddress + ":" + bindPort + " to " + hostToConnect + ":" + portToConnect);
            }
            baw.writeString(bindAddress);
            baw.writeInt(bindPort);
            GlobalRequest request = new GlobalRequest("tcpip-forward", baw.toByteArray());
            if (this.sendGlobalRequest(request, true)) {
                this.forwardingListeners.put(bindAddress + ":" + String.valueOf(bindPort), listener);
                this.forwardingDestinations.put(bindAddress + ":" + String.valueOf(bindPort), hostToConnect + ":" + String.valueOf(portToConnect));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                baw.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean cancelRemoteForwarding(String bindAddress, int bindPort) throws SshException {
        ByteArrayWriter baw = new ByteArrayWriter();
        try {
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Cancelling remote forwarding from " + bindAddress + ":" + bindPort);
            }
            baw.writeString(bindAddress);
            baw.writeInt(bindPort);
            GlobalRequest request = new GlobalRequest("cancel-tcpip-forward", baw.toByteArray());
            if (this.sendGlobalRequest(request, true)) {
                this.forwardingListeners.remove(bindAddress + ":" + String.valueOf(bindPort));
                this.forwardingDestinations.remove(bindAddress + ":" + String.valueOf(bindPort));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                baw.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void openChannel(Ssh2Channel channel, byte[] requestdata) throws SshException, ChannelOpenException {
        this.verifyConnection(true);
        this.connection.openChannel(channel, requestdata);
    }

    public void openChannel(SshAbstractChannel channel) throws SshException, ChannelOpenException {
        this.verifyConnection(true);
        if (!(channel instanceof Ssh2Channel)) {
            throw new SshException("The channel is not an SSH2 channel!", 4);
        }
        this.connection.openChannel((Ssh2Channel)channel, null);
    }

    public void addChannelFactory(ChannelFactory factory) throws SshException {
        this.connection.addChannelFactory(factory);
    }

    public SshContext getContext() {
        return this.transport.transportContext;
    }

    public void addRequestHandler(GlobalRequestHandler handler) throws SshException {
        if (Log.isDebugEnabled()) {
            String requests = "";
            for (int i = 0; i < handler.supportedRequests().length; ++i) {
                requests = requests + handler.supportedRequests()[i] + " ";
            }
            Log.debug(this, "Installing global request handler for " + requests.trim());
        }
        this.connection.addRequestHandler(handler);
    }

    public boolean sendGlobalRequest(GlobalRequest request, boolean wantreply) throws SshException {
        this.verifyConnection(true);
        return this.connection.sendGlobalRequest(request, wantreply);
    }

    public String getRemoteIdentification() {
        return this.remoteIdentification;
    }

    void verifyConnection(boolean requireAuthentication) throws SshException {
        if (this.authentication == null || this.transport == null || this.connection == null) {
            throw new SshException("Not connected!", 4);
        }
        if (!this.transport.isConnected()) {
            throw new SshException("The connection has been terminated!", 2);
        }
        if (!this.authentication.isAuthenticated() && requireAuthentication) {
            throw new SshException("The connection is not authenticated!", 4);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public SshClient duplicate() throws SshException {
        if (this.username == null || this.auth == null) {
            throw new SshException("Cannot duplicate! The existing connection does not have a set of credentials", 4);
        }
        try {
            Ssh2Client duplicate;
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Duplicating SSH client");
            }
            if ((duplicate = this.connector.connect(this.io.duplicate(), this.username, this.buffered, this.transport.transportContext)).authenticate(this.auth) != 1) {
                duplicate.disconnect();
                throw new SshException("Duplication attempt failed to authenicate user!", 5);
            }
            return duplicate;
        }
        catch (IOException ex) {
            throw new SshException(ex, 10);
        }
    }

    public int getChannelCount() {
        return this.connection.getChannelCount();
    }

    public int getVersion() {
        return 2;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public String getKeyExchangeInUse() {
        return this.transport.keyExchange == null ? "none" : this.transport.keyExchange.getAlgorithm();
    }

    public SshKeyExchangeClient getKeyExchangeInstanceInUse() {
        return this.transport.keyExchange;
    }

    public String getHostKeyInUse() {
        return this.transport.hostkey == null ? "none" : this.transport.hostkey.getAlgorithm();
    }

    public String getCipherInUseCS() {
        return this.transport.encryption == null ? "none" : this.transport.encryption.getAlgorithm();
    }

    public String getCipherInUseSC() {
        return this.transport.decryption == null ? "none" : this.transport.decryption.getAlgorithm();
    }

    public String getMacInUseCS() {
        return this.transport.outgoingMac == null ? "none" : this.transport.outgoingMac.getAlgorithm();
    }

    public String getMacInUseSC() {
        return this.transport.incomingMac == null ? "none" : this.transport.incomingMac.getAlgorithm();
    }

    public String getCompressionInUseCS() {
        return this.transport.outgoingCompression == null ? "none" : this.transport.outgoingCompression.getAlgorithm();
    }

    public String getCompressionInUseSC() {
        return this.transport.incomingCompression == null ? "none" : this.transport.incomingCompression.getAlgorithm();
    }

    public String toString() {
        return "SSH2 " + this.io.getHost() + ":" + this.io.getPort() + " [kex=" + (this.transport.keyExchange == null ? "none" : this.transport.keyExchange.getAlgorithm()) + " hostkey=" + (this.transport.hostkey == null ? "none" : this.transport.hostkey.getAlgorithm()) + " client->server=" + (this.transport.encryption == null ? "none" : this.transport.encryption.getAlgorithm()) + "," + (this.transport.outgoingMac == null ? "none" : this.transport.outgoingMac.getAlgorithm()) + "," + (this.transport.outgoingCompression == null ? "none" : this.transport.outgoingCompression.getAlgorithm()) + " server->client=" + (this.transport.decryption == null ? "none" : this.transport.decryption.getAlgorithm()) + "," + (this.transport.incomingMac == null ? "none" : this.transport.incomingMac.getAlgorithm()) + "," + (this.transport.incomingCompression == null ? "none" : this.transport.incomingCompression.getAlgorithm()) + "]";
    }

    class ForwardingRequestChannelFactory
    implements ChannelFactory {
        String[] types = new String[]{"forwarded-tcpip", "x11"};

        ForwardingRequestChannelFactory() {
        }

        public String[] supportedChannelTypes() {
            return this.types;
        }

        public Ssh2Channel createChannel(String channeltype, byte[] requestdata) throws SshException, ChannelOpenException {
            if (channeltype.equals("forwarded-tcpip")) {
                ByteArrayReader bar = new ByteArrayReader(requestdata);
                try {
                    String address = bar.readString();
                    int port = (int)bar.readInt();
                    String originatorIP = bar.readString();
                    int originatorPort = (int)bar.readInt();
                    String key = address + ":" + String.valueOf(port);
                    if (Ssh2Client.this.forwardingListeners.containsKey(key)) {
                        ForwardingRequestListener listener = Ssh2Client.this.forwardingListeners.get(key);
                        String destination = Ssh2Client.this.forwardingDestinations.get(key);
                        String hostToConnect = destination.substring(0, destination.indexOf(58));
                        int portToConnect = Integer.parseInt(destination.substring(destination.indexOf(58) + 1));
                        if (Log.isDebugEnabled()) {
                            Log.debug(this, "Creating remote forwarding channel from " + address + ":" + port + " to " + hostToConnect + ":" + portToConnect);
                        }
                        Ssh2ForwardingChannel channel = new Ssh2ForwardingChannel("forwarded-tcpip", 32768, 0x200000, hostToConnect, portToConnect, address, port, originatorIP, originatorPort, listener.createConnection(hostToConnect, portToConnect));
                        listener.initializeTunnel(channel);
                        Ssh2ForwardingChannel ssh2ForwardingChannel = channel;
                        return ssh2ForwardingChannel;
                    }
                    try {
                        throw new ChannelOpenException("Forwarding had not previously been requested", 1);
                    }
                    catch (IOException ex) {
                        throw new ChannelOpenException(ex.getMessage(), 4);
                    }
                    catch (SshException ex) {
                        throw new ChannelOpenException(ex.getMessage(), 2);
                    }
                }
                finally {
                    try {
                        bar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (channeltype.equals("x11")) {
                if (!Ssh2Client.this.isXForwarding) {
                    throw new ChannelOpenException("X Forwarding had not previously been requested", 1);
                }
                ByteArrayReader bar = new ByteArrayReader(requestdata);
                try {
                    int targetPort;
                    String targetAddr;
                    String originatorIP = bar.readString();
                    int originatorPort = (int)bar.readInt();
                    String display = Ssh2Client.this.connection.getContext().getX11Display();
                    int i = display.indexOf(":");
                    int num = 0;
                    int screen = 0;
                    if (i != -1) {
                        targetAddr = display.substring(0, i);
                        if ((i = (display = display.substring(i + 1)).indexOf(46)) > -1) {
                            num = Integer.parseInt(display.substring(0, i));
                            screen = Integer.parseInt(display.substring(i + 1));
                        } else {
                            num = Integer.parseInt(display);
                        }
                        targetPort = num;
                    } else {
                        targetAddr = display;
                        targetPort = 6000;
                    }
                    if (targetPort <= 10) {
                        targetPort += 6000;
                    }
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Creating X11 forwarding channel for display " + targetAddr + ":" + screen);
                    }
                    ForwardingRequestListener listener = Ssh2Client.this.connection.getContext().getX11RequestListener();
                    Ssh2ForwardingChannel channel = new Ssh2ForwardingChannel("x11", 32768, 32768, targetAddr, targetPort, targetAddr, screen, originatorIP, originatorPort, listener.createConnection(targetAddr, targetPort));
                    listener.initializeTunnel(channel);
                    Ssh2ForwardingChannel ssh2ForwardingChannel = channel;
                    return ssh2ForwardingChannel;
                }
                catch (Throwable ex) {
                    throw new ChannelOpenException(ex.getMessage(), 2);
                }
                finally {
                    try {
                        bar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            throw new ChannelOpenException(channeltype + " is not supported", 3);
        }
    }

    private static class KBIRequestHandlerWhenUserUsingPasswordAuthentication
    implements KBIRequestHandler {
        private String password;

        public KBIRequestHandlerWhenUserUsingPasswordAuthentication(PasswordAuthentication pwdAuth) {
            this.password = pwdAuth.getPassword();
        }

        public boolean showPrompts(String name, String instruction, KBIPrompt[] prompts) {
            for (int i = 0; i < prompts.length; ++i) {
                prompts[i].setResponse(this.password);
            }
            return true;
        }
    }
}

