/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh2;

import com.sshtools.logging.Log;
import com.sshtools.ssh.ForwardingRequestListener;
import com.sshtools.ssh.HostKeyVerification;
import com.sshtools.ssh.SshConnector;
import com.sshtools.ssh.SshContext;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.components.ComponentFactory;
import com.sshtools.ssh.components.ComponentManager;
import com.sshtools.ssh2.BannerDisplay;
import com.sshtools.ssh2.MaverickCallbackHandler;
import java.util.Vector;

public final class Ssh2Context
implements SshContext {
    ComponentFactory compressionsCS;
    ComponentFactory compressionsSC;
    ComponentFactory ciphersCS;
    ComponentFactory ciphersSC;
    ComponentFactory keyExchanges;
    ComponentFactory macCS;
    ComponentFactory macSC;
    ComponentFactory publicKeys;
    public static final String CIPHER_TRIPLEDES_CBC = "3des-cbc";
    public static final String CIPHER_TRIPLEDES_CTR = "3des-ctr";
    public static final String CIPHER_BLOWFISH_CBC = "blowfish-cbc";
    public static final String CIPHER_AES128_CBC = "aes128-cbc";
    public static final String CIPHER_AES192_CBC = "aes192-cbc";
    public static final String CIPHER_AES256_CBC = "aes256-cbc";
    public static final String CIPHER_AES128_CTR = "aes128-ctr";
    public static final String CIPHER_AES192_CTR = "aes192-ctr";
    public static final String CIPHER_AES256_CTR = "aes256-ctr";
    public static final String CIPHER_ARCFOUR = "arcfour";
    public static final String CIPHER_ARCFOUR_128 = "arcfour128";
    public static final String CIPHER_ARCFOUR_256 = "arcfour256";
    public static final String HMAC_SHA1 = "hmac-sha1";
    public static final String HMAC_SHA1_96 = "hmac-sha1-96";
    public static final String HMAC_MD5 = "hmac-md5";
    public static final String HMAC_MD5_96 = "hmac-md5-96";
    public static final String HMAC_SHA256 = "hmac-sha256";
    public static final String COMPRESSION_NONE = "none";
    public static final String COMPRESSION_ZLIB = "zlib";
    public static final String KEX_DIFFIE_HELLMAN_GROUP1_SHA1 = "diffie-hellman-group1-sha1";
    public static final String KEX_DIFFIE_HELLMAN_GROUP14_SHA1 = "diffie-hellman-group14-sha1";
    public static final String KEX_DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1 = "diffie-hellman-group-exchange-sha1";
    public static final String KEX_DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA256 = "diffie-hellman-group-exchange-sha256";
    public static final String KEX_DIFFIE_HELLMAN_ECDH_NISTP_256 = "ecdh-sha2-nistp256";
    public static final String KEX_DIFFIE_HELLMAN_ECDH_NISTP_384 = "ecdh-sha2-nistp384";
    public static final String KEX_DIFFIE_HELLMAN_ECDH_NISTP_521 = "ecdh-sha2-nistp521";
    public static final String PUBLIC_KEY_SSHDSS = "ssh-dss";
    public static final String PUBLIC_KEY_SSHRSA = "ssh-rsa";
    public static final String PUBLIC_KEY_ECDSA_256 = "ecdsa-sha2-nistp256";
    public static final String PUBLIC_KEY_ECDSA_384 = "ecdsa-sha2-nistp384";
    public static final String PUBLIC_KEY_ECDSA_521 = "ecdsa-sha2-nistp521";
    String prefCipherCS = "aes128-ctr";
    String prefCipherSC = "aes128-ctr";
    String prefMacCS = "hmac-sha1";
    String prefMacSC = "hmac-sha1";
    String prefCompressionCS = "none";
    String prefCompressionSC = "none";
    String prefKeyExchange = "ecdh-sha2-nistp256";
    String prefPublicKey = "ecdsa-sha2-nistp256";
    String sftpProvider = "/usr/libexec/sftp-server";
    int maxChannels = 100;
    BannerDisplay bannerdisplay;
    HostKeyVerification verify;
    String xDisplay = null;
    byte[] x11FakeCookie = null;
    byte[] x11RealCookie = null;
    ForwardingRequestListener x11Listener = null;
    String jceProvider = "";
    int maxPacketLength = 131072;
    boolean keyReExchangeDisabled = false;
    int partialMessageTimeout = 30000;
    int keepAliveMaxDataLength = 128;
    int idleConnectionTimeoutSeconds = 0;
    boolean sendIgnorePacketOnIdle = false;
    int dhGroupExchangeKeySize = 1024;
    boolean dhGroupExchangeBackwardCompatible = false;
    int socketTimeout = 0;
    SshConnector con;
    MaverickCallbackHandler gsscall = null;

    public Ssh2Context() throws SshException {
        try {
            this.ciphersCS = ComponentManager.getInstance().supportedSsh2CiphersCS();
            this.ciphersSC = ComponentManager.getInstance().supportedSsh2CiphersSC();
            this.keyExchanges = ComponentManager.getInstance().supportedKeyExchanges();
            this.macCS = ComponentManager.getInstance().supportedHMacsCS();
            this.macSC = ComponentManager.getInstance().supportedHMacsSC();
            this.publicKeys = ComponentManager.getInstance().supportedPublicKeys();
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Creating compression factory");
            }
            this.compressionsSC = new ComponentFactory(Class.forName("com.sshtools.ssh.compression.SshCompression"));
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Adding None Compression");
            }
            this.compressionsSC.add(COMPRESSION_NONE, Class.forName("java.lang.Object"));
            try {
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Adding ZLib Compression");
                }
                this.compressionsSC.add(COMPRESSION_ZLIB, Class.forName("com.sshtools.zlib.ZLibCompression"));
                this.compressionsSC.add("zlib@openssh.com", Class.forName("com.sshtools.zlib.OpenSSHZLibCompression"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.compressionsCS = new ComponentFactory(Class.forName("com.sshtools.ssh.compression.SshCompression"));
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Adding None Compression");
            }
            this.compressionsCS.add(COMPRESSION_NONE, Class.forName("java.lang.Object"));
            try {
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Adding ZLib Compression");
                }
                this.compressionsCS.add(COMPRESSION_ZLIB, Class.forName("com.sshtools.zlib.ZLibCompression"));
                this.compressionsCS.add("zlib@openssh.com", Class.forName("com.sshtools.zlib.OpenSSHZLibCompression"));
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new SshException(t.getMessage() != null ? t.getMessage() : t.getClass().getName(), 5);
        }
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Completed Ssh2Context creation");
        }
    }

    public int getMaximumPacketLength() {
        return this.maxPacketLength;
    }

    public void setGssCallback(MaverickCallbackHandler gsscall) {
        this.gsscall = gsscall;
    }

    public MaverickCallbackHandler getGssCallback() {
        return this.gsscall;
    }

    public void setMaximumPacketLength(int maxPacketLength) {
        if (maxPacketLength < 35000) {
            throw new IllegalArgumentException("The minimum packet length supported must be 35,000 bytes or greater!");
        }
        this.maxPacketLength = maxPacketLength;
    }

    public void setChannelLimit(int maxChannels) {
        this.maxChannels = maxChannels;
    }

    public int getChannelLimit() {
        return this.maxChannels;
    }

    public void setX11Display(String xDisplay) {
        this.xDisplay = xDisplay;
    }

    public String getX11Display() {
        return this.xDisplay;
    }

    public byte[] getX11AuthenticationCookie() throws SshException {
        if (this.x11FakeCookie == null) {
            this.x11FakeCookie = new byte[16];
            ComponentManager.getInstance().getRND().nextBytes(this.x11FakeCookie);
        }
        return this.x11FakeCookie;
    }

    public void setX11AuthenticationCookie(byte[] x11FakeCookie) {
        this.x11FakeCookie = x11FakeCookie;
    }

    public void setX11RealCookie(byte[] x11RealCookie) {
        this.x11RealCookie = x11RealCookie;
    }

    public byte[] getX11RealCookie() throws SshException {
        if (this.x11RealCookie == null) {
            this.x11RealCookie = this.getX11AuthenticationCookie();
        }
        return this.x11RealCookie;
    }

    public void setX11RequestListener(ForwardingRequestListener x11Listener) {
        this.x11Listener = x11Listener;
    }

    public ForwardingRequestListener getX11RequestListener() {
        return this.x11Listener;
    }

    public BannerDisplay getBannerDisplay() {
        return this.bannerdisplay;
    }

    public void setBannerDisplay(BannerDisplay bannerdisplay) {
        this.bannerdisplay = bannerdisplay;
    }

    public ComponentFactory supportedCiphersSC() {
        return this.ciphersSC;
    }

    public ComponentFactory supportedCiphersCS() {
        return this.ciphersCS;
    }

    public String getPreferredCipherCS() {
        return this.prefCipherCS;
    }

    public void setPreferredCipherCS(String name) throws SshException {
        if (name == null) {
            return;
        }
        if (!this.ciphersCS.contains(name)) {
            throw new SshException(name + " is not supported", 7);
        }
        this.prefCipherCS = name;
        this.setCipherPreferredPositionCS(name, 0);
    }

    public String getPreferredCipherSC() {
        return this.prefCipherSC;
    }

    public String getCiphersCS() {
        return this.ciphersCS.list(this.prefCipherCS);
    }

    public String getCiphersSC() {
        return this.ciphersSC.list(this.prefCipherSC);
    }

    public String getMacsCS() {
        return this.macCS.list(this.prefMacCS);
    }

    public String getMacsSC() {
        return this.macSC.list(this.prefMacSC);
    }

    public String getPublicKeys() {
        return this.publicKeys.list(this.prefPublicKey);
    }

    public String getKeyExchanges() {
        return this.keyExchanges.list(this.prefKeyExchange);
    }

    public void setPreferredCipherSC(int[] order) throws SshException {
        this.prefCipherSC = this.ciphersSC.createNewOrdering(order);
    }

    public void setPreferredCipherCS(int[] order) throws SshException {
        this.prefCipherCS = this.ciphersCS.createNewOrdering(order);
    }

    public void setCipherPreferredPositionCS(String name, int position) throws SshException {
        this.prefCipherCS = this.ciphersCS.changePositionofAlgorithm(name, position);
    }

    public void setCipherPreferredPositionSC(String name, int position) throws SshException {
        this.prefCipherSC = this.ciphersSC.changePositionofAlgorithm(name, position);
    }

    public void setMacPreferredPositionSC(String name, int position) throws SshException {
        this.prefMacSC = this.macSC.changePositionofAlgorithm(name, position);
    }

    public void setMacPreferredPositionCS(String name, int position) throws SshException {
        this.prefMacCS = this.macCS.changePositionofAlgorithm(name, position);
    }

    public void setPreferredMacSC(int[] order) throws SshException {
        this.prefCipherSC = this.macSC.createNewOrdering(order);
    }

    public void setPreferredMacCS(int[] order) throws SshException {
        this.prefCipherSC = this.macCS.createNewOrdering(order);
    }

    public void setPreferredCipherSC(String name) throws SshException {
        if (name == null) {
            return;
        }
        if (!this.ciphersSC.contains(name)) {
            throw new SshException(name + " is not supported", 7);
        }
        this.prefCipherSC = name;
        this.setCipherPreferredPositionSC(name, 0);
    }

    public ComponentFactory supportedMacsSC() {
        return this.macSC;
    }

    public ComponentFactory supportedMacsCS() {
        return this.macCS;
    }

    public String getPreferredMacCS() {
        return this.prefMacCS;
    }

    public void setPreferredMacCS(String name) throws SshException {
        if (name == null) {
            return;
        }
        if (!this.macCS.contains(name)) {
            throw new SshException(name + " is not supported", 7);
        }
        this.prefMacCS = name;
        this.setMacPreferredPositionCS(name, 0);
    }

    public String getPreferredMacSC() {
        return this.prefMacSC;
    }

    public void setPreferredMacSC(String name) throws SshException {
        if (name == null) {
            return;
        }
        if (!this.macSC.contains(name)) {
            throw new SshException(name + " is not supported", 7);
        }
        this.prefMacSC = name;
        this.setMacPreferredPositionSC(name, 0);
    }

    public ComponentFactory supportedCompressionsSC() {
        return this.compressionsSC;
    }

    public ComponentFactory supportedCompressionsCS() {
        return this.compressionsCS;
    }

    public String getPreferredCompressionCS() {
        return this.prefCompressionCS;
    }

    public void setPreferredCompressionCS(String name) throws SshException {
        if (name == null) {
            return;
        }
        if (!this.compressionsCS.contains(name)) {
            throw new SshException(name + " is not supported", 7);
        }
        this.prefCompressionCS = name;
    }

    public String getPreferredCompressionSC() {
        return this.prefCompressionSC;
    }

    public void setPreferredCompressionSC(String name) throws SshException {
        if (name == null) {
            return;
        }
        if (!this.compressionsSC.contains(name)) {
            throw new SshException(name + " is not supported", 7);
        }
        this.prefCompressionSC = name;
    }

    public void enableCompression() throws SshException {
        this.supportedCompressionsCS().changePositionofAlgorithm(COMPRESSION_ZLIB, 0);
        this.supportedCompressionsCS().changePositionofAlgorithm("zlib@openssh.com", 1);
        this.prefCompressionCS = this.supportedCompressionsCS().changePositionofAlgorithm(COMPRESSION_NONE, 2);
        this.supportedCompressionsSC().changePositionofAlgorithm(COMPRESSION_ZLIB, 0);
        this.supportedCompressionsSC().changePositionofAlgorithm("zlib@openssh.com", 1);
        this.prefCompressionSC = this.supportedCompressionsSC().changePositionofAlgorithm(COMPRESSION_NONE, 2);
    }

    public void disableCompression() throws SshException {
        this.supportedCompressionsCS().changePositionofAlgorithm(COMPRESSION_NONE, 0);
        this.supportedCompressionsCS().changePositionofAlgorithm(COMPRESSION_ZLIB, 1);
        this.prefCompressionCS = this.supportedCompressionsCS().changePositionofAlgorithm("zlib@openssh.com", 2);
        this.supportedCompressionsSC().changePositionofAlgorithm(COMPRESSION_NONE, 0);
        this.supportedCompressionsSC().changePositionofAlgorithm(COMPRESSION_ZLIB, 1);
        this.prefCompressionSC = this.supportedCompressionsSC().changePositionofAlgorithm("zlib@openssh.com", 2);
    }

    public ComponentFactory supportedKeyExchanges() {
        return this.keyExchanges;
    }

    public String getPreferredKeyExchange() {
        return this.prefKeyExchange;
    }

    public void setPreferredKeyExchange(String name) throws SshException {
        if (name == null) {
            return;
        }
        if (!this.keyExchanges.contains(name)) {
            throw new SshException(name + " is not supported", 7);
        }
        this.prefKeyExchange = name;
        this.setKeyExchangePreferredPosition(name, 0);
    }

    public ComponentFactory supportedPublicKeys() {
        return this.publicKeys;
    }

    public String getPreferredPublicKey() {
        return this.prefPublicKey;
    }

    public void setPreferredPublicKey(String name) throws SshException {
        if (name == null) {
            return;
        }
        if (!this.publicKeys.contains(name)) {
            throw new SshException(name + " is not supported", 7);
        }
        this.prefPublicKey = name;
        this.setPublicKeyPreferredPosition(name, 0);
    }

    public void setHostKeyVerification(HostKeyVerification verify) {
        this.verify = verify;
    }

    public HostKeyVerification getHostKeyVerification() {
        return this.verify;
    }

    public void setSFTPProvider(String sftpProvider) {
        this.sftpProvider = sftpProvider;
    }

    public String getSFTPProvider() {
        return this.sftpProvider;
    }

    public void setPartialMessageTimeout(int partialMessageTimeout) {
        this.partialMessageTimeout = partialMessageTimeout;
    }

    public int getPartialMessageTimeout() {
        return this.partialMessageTimeout;
    }

    public boolean isKeyReExchangeDisabled() {
        return this.keyReExchangeDisabled;
    }

    public void setKeyReExchangeDisabled(boolean keyReExchangeDisabled) {
        this.keyReExchangeDisabled = keyReExchangeDisabled;
    }

    public void setPublicKeyPreferredPosition(String name, int position) throws SshException {
        this.prefPublicKey = this.publicKeys.changePositionofAlgorithm(name, position);
    }

    public void setKeyExchangePreferredPosition(String name, int position) throws SshException {
        this.prefKeyExchange = this.keyExchanges.changePositionofAlgorithm(name, position);
    }

    public int getIdleConnectionTimeoutSeconds() {
        return this.idleConnectionTimeoutSeconds;
    }

    public void setIdleConnectionTimeoutSeconds(int idleConnectionTimeoutSeconds) {
        this.idleConnectionTimeoutSeconds = idleConnectionTimeoutSeconds;
    }

    public boolean isDHGroupExchangeBackwardsCompatible() {
        return this.dhGroupExchangeBackwardCompatible;
    }

    public int getDHGroupExchangeKeySize() {
        return this.dhGroupExchangeKeySize;
    }

    public void setDHGroupExchangeKeySize(int dhGroupExchangeKeySize) {
        if (dhGroupExchangeKeySize < 1024 || dhGroupExchangeKeySize > 8192) {
            throw new IllegalArgumentException("DH group exchange key size must be between 1024 and 8192");
        }
        this.dhGroupExchangeKeySize = dhGroupExchangeKeySize;
    }

    public void setDHGroupExchangeBackwardsCompatible(boolean dhGroupExchangeBackwardCompatible) {
        this.dhGroupExchangeBackwardCompatible = dhGroupExchangeBackwardCompatible;
    }

    public boolean isSendIgnorePacketOnIdle() {
        return this.sendIgnorePacketOnIdle;
    }

    public void setSendIgnorePacketOnIdle(boolean sendIgnorePacketOnIdle) {
        this.sendIgnorePacketOnIdle = sendIgnorePacketOnIdle;
    }

    public int getKeepAliveMaxDataLength() {
        return this.keepAliveMaxDataLength;
    }

    public void setKeepAliveMaxDataLength(int keepAliveMaxDataLength) {
        if (keepAliveMaxDataLength < 8) {
            throw new IllegalArgumentException("There must be at least 8 bytes of random data");
        }
        this.keepAliveMaxDataLength = keepAliveMaxDataLength;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void enableFIPSMode() throws SshException {
        int i;
        Log.info(this, "Enabling FIPS mode");
        if (!this.keyExchanges.contains(KEX_DIFFIE_HELLMAN_GROUP14_SHA1)) {
            throw new SshException("Cannot enable FIPS mode because diffie-hellman-group14-sha1 keyexchange was not supported by this configuration. Install a JCE Provider that supports a prime size of 2048 bits (for example BouncyCastle provider)", 4);
        }
        if (this.dhGroupExchangeKeySize < 2048) {
            this.dhGroupExchangeKeySize = 2048;
        }
        Vector<String> allowed = new Vector<String>();
        allowed.addElement(KEX_DIFFIE_HELLMAN_GROUP14_SHA1);
        allowed.addElement(KEX_DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1);
        allowed.addElement(KEX_DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA256);
        String[] names = this.keyExchanges.toArray();
        for (i = 0; i < names.length; ++i) {
            if (allowed.contains(names[i])) continue;
            Log.info(this, "Removing key exchange " + names[i]);
            this.keyExchanges.remove(names[i]);
        }
        this.keyExchanges.lockComponents();
        allowed.clear();
        allowed.addElement(CIPHER_AES128_CBC);
        allowed.addElement(CIPHER_AES192_CBC);
        allowed.addElement(CIPHER_AES256_CBC);
        allowed.addElement(CIPHER_TRIPLEDES_CBC);
        names = this.ciphersCS.toArray();
        for (i = 0; i < names.length; ++i) {
            if (allowed.contains(names[i])) continue;
            Log.info(this, "Removing cipher client->server " + names[i]);
            this.ciphersCS.remove(names[i]);
        }
        this.ciphersCS.lockComponents();
        names = this.ciphersSC.toArray();
        for (i = 0; i < names.length; ++i) {
            if (allowed.contains(names[i])) continue;
            Log.info(this, "Removing cipher server->client " + names[i]);
            this.ciphersSC.remove(names[i]);
        }
        this.ciphersSC.lockComponents();
        allowed.clear();
        allowed.addElement(PUBLIC_KEY_SSHRSA);
        names = this.publicKeys.toArray();
        for (i = 0; i < names.length; ++i) {
            if (allowed.contains(names[i])) continue;
            Log.info(this, "Removing public key " + names[i]);
            this.publicKeys.remove(names[i]);
        }
        this.publicKeys.lockComponents();
        allowed.clear();
        allowed.addElement(HMAC_SHA1);
        allowed.addElement(HMAC_SHA256);
        allowed.addElement("hmac-sha256@ssh.com");
        names = this.macCS.toArray();
        for (i = 0; i < names.length; ++i) {
            if (allowed.contains(names[i])) continue;
            Log.info(this, "Removing mac client->server " + names[i]);
            this.macCS.remove(names[i]);
        }
        this.macCS.lockComponents();
        names = this.macSC.toArray();
        for (i = 0; i < names.length; ++i) {
            if (allowed.contains(names[i])) continue;
            Log.info(this, "Removing mac server->client " + names[i]);
            this.macSC.remove(names[i]);
        }
        this.macCS.lockComponents();
    }
}

