/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh2;

import com.sshtools.events.Event;
import com.sshtools.events.EventServiceImplementation;
import com.sshtools.logging.Log;
import com.sshtools.ssh.SocketTimeoutSupport;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshIOException;
import com.sshtools.ssh.SshTransport;
import com.sshtools.ssh.components.ComponentManager;
import com.sshtools.ssh.components.Digest;
import com.sshtools.ssh.components.SshCipher;
import com.sshtools.ssh.components.SshHmac;
import com.sshtools.ssh.components.SshKeyExchangeClient;
import com.sshtools.ssh.components.SshPublicKey;
import com.sshtools.ssh.compression.SshCompression;
import com.sshtools.ssh.message.SshMessageReader;
import com.sshtools.ssh2.Ssh2Client;
import com.sshtools.ssh2.Ssh2Context;
import com.sshtools.ssh2.TransportProtocolListener;
import com.sshtools.util.ByteArrayReader;
import com.sshtools.util.ByteArrayWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class TransportProtocol
implements SshMessageReader {
    public static String CHARSET_ENCODING = "UTF8";
    DataInputStream transportIn;
    OutputStream transportOut;
    SshTransport provider;
    Ssh2Context transportContext;
    Ssh2Client client;
    String localIdentification;
    String remoteIdentification;
    byte[] localkex;
    byte[] remotekex;
    byte[] sessionIdentifier;
    static final int SSH_MSG_DISCONNECT = 1;
    static final int SSH_MSG_IGNORE = 2;
    static final int SSH_MSG_UNIMPLEMENTED = 3;
    static final int SSH_MSG_DEBUG = 4;
    static final int SSH_MSG_SERVICE_REQUEST = 5;
    static final int SSH_MSG_SERVICE_ACCEPT = 6;
    static final int SSH_MSG_KEX_INIT = 20;
    static final int SSH_MSG_NEWKEYS = 21;
    public static final int NEGOTIATING_PROTOCOL = 1;
    public static final int PERFORMING_KEYEXCHANGE = 2;
    public static final int CONNECTED = 3;
    public static final int DISCONNECTED = 4;
    int currentState;
    Throwable lastError;
    String disconnectReason;
    SshKeyExchangeClient keyExchange;
    SshKeyExchangeClient guessedKeyExchange;
    SshCipher encryption;
    SshCipher decryption;
    SshHmac outgoingMac;
    SshHmac incomingMac;
    SshCompression outgoingCompression;
    SshCompression incomingCompression;
    SshPublicKey hostkey;
    boolean isIncomingCompressing = false;
    boolean isOutgoingCompressing = false;
    int outgoingCipherLength = 8;
    int outgoingMacLength = 0;
    boolean ignoreHostKeyifEmpty = false;
    byte[] incomingMessage;
    ByteArrayWriter outgoingMessage;
    int incomingCipherLength = 8;
    int incomingMacLength = 0;
    long outgoingSequence = 0L;
    long incomingSequence = 0L;
    static final int MAX_NUM_PACKETS_BEFORE_REKEY = Integer.MAX_VALUE;
    static final int MAX_NUM_BYTES_BEFORE_REKEY = 0x40000000;
    int numIncomingBytesSinceKEX;
    int numIncomingPacketsSinceKEX;
    int numOutgoingBytesSinceKEX;
    int numOutgoingPacketsSinceKEX;
    long outgoingBytes = 0L;
    long incomingBytes = 0L;
    Vector<byte[]> kexqueue = new Vector();
    Vector<Runnable> shutdownHooks = new Vector();
    Vector<TransportProtocolListener> listeners = new Vector();
    long lastActivity = System.currentTimeMillis();
    public static final int HOST_NOT_ALLOWED = 1;
    public static final int PROTOCOL_ERROR = 2;
    public static final int KEY_EXCHANGE_FAILED = 3;
    public static final int RESERVED = 4;
    public static final int MAC_ERROR = 5;
    public static final int COMPRESSION_ERROR = 6;
    public static final int SERVICE_NOT_AVAILABLE = 7;
    public static final int PROTOCOL_VERSION_NOT_SUPPORTED = 8;
    public static final int HOST_KEY_NOT_VERIFIABLE = 9;
    public static final int CONNECTION_LOST = 10;
    public static final int BY_APPLICATION = 11;
    public static final int TOO_MANY_CONNECTIONS = 12;
    public static final int AUTH_CANCELLED_BY_USER = 13;
    public static final int NO_MORE_AUTH_METHODS_AVAILABLE = 14;
    public static final int ILLEGAL_USER_NAME = 15;
    boolean verbose = Boolean.valueOf(System.getProperty("maverick.verbose", "false"));

    public SshTransport getProvider() {
        return this.provider;
    }

    public void addListener(TransportProtocolListener listener) {
        this.listeners.addElement(listener);
    }

    public Ssh2Client getClient() {
        return this.client;
    }

    public boolean isConnected() {
        return this.currentState == 3 || this.currentState == 2;
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public Ssh2Context getContext() {
        return this.transportContext;
    }

    public boolean getIgnoreHostKeyifEmpty() {
        return this.ignoreHostKeyifEmpty;
    }

    public void setIgnoreHostKeyifEmpty(boolean ignoreHostKeyifEmpty) {
        this.ignoreHostKeyifEmpty = ignoreHostKeyifEmpty;
    }

    public void startTransportProtocol(SshTransport provider, Ssh2Context context, String localIdentification, String remoteIdentification, Ssh2Client client) throws SshException {
        try {
            this.transportIn = new DataInputStream(provider.getInputStream());
            this.transportOut = provider.getOutputStream();
            this.provider = provider;
            this.localIdentification = localIdentification;
            this.remoteIdentification = remoteIdentification;
            this.transportContext = context;
            this.incomingMessage = new byte[this.transportContext.getMaximumPacketLength()];
            this.outgoingMessage = new ByteArrayWriter(this.transportContext.getMaximumPacketLength());
            this.client = client;
            this.currentState = 1;
            this.sendKeyExchangeInit(false);
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Waiting for transport protocol to complete initialization");
            }
            while (this.processMessage(this.readMessage()) && this.currentState != 3) {
            }
        }
        catch (IOException ex) {
            throw new SshException(ex, 10);
        }
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Transport protocol initialized");
        }
    }

    public String getRemoteIdentification() {
        return this.remoteIdentification;
    }

    public byte[] getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(int reason, String disconnectReason) {
        ByteArrayWriter baw = new ByteArrayWriter();
        try {
            this.disconnectReason = disconnectReason;
            baw.write(1);
            baw.writeInt(reason);
            baw.writeString(disconnectReason);
            baw.writeString("");
            Log.info(this, "Sending SSH_MSG_DISCONNECT [" + disconnectReason + "]");
            this.sendMessage(baw.toByteArray(), true);
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                baw.close();
            }
            catch (IOException iOException) {}
            this.internalDisconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(byte[] msgdata, boolean isActivity) throws SshException {
        Vector<byte[]> vector = this.kexqueue;
        synchronized (vector) {
            if (this.currentState == 2 && !this.isTransportMessage(msgdata[0])) {
                this.kexqueue.addElement(msgdata);
                return;
            }
            if (Log.isDebugEnabled() && this.verbose) {
                Log.debug(this, "Sending transport protocol message");
            }
            try {
                this.outgoingMessage.reset();
                int padding = 4;
                if (this.outgoingCompression != null && this.isOutgoingCompressing) {
                    msgdata = this.outgoingCompression.compress(msgdata, 0, msgdata.length);
                }
                padding += (this.outgoingCipherLength - (msgdata.length + 5 + padding) % this.outgoingCipherLength) % this.outgoingCipherLength;
                this.outgoingMessage.writeInt(msgdata.length + 1 + padding);
                this.outgoingMessage.write(padding);
                this.outgoingMessage.write(msgdata, 0, msgdata.length);
                ComponentManager.getInstance().getRND().nextBytes(this.outgoingMessage.array(), this.outgoingMessage.size(), padding);
                this.outgoingMessage.move(padding);
                if (this.outgoingMac != null) {
                    this.outgoingMac.generate(this.outgoingSequence, this.outgoingMessage.array(), 0, this.outgoingMessage.size(), this.outgoingMessage.array(), this.outgoingMessage.size());
                }
                if (this.encryption != null) {
                    this.encryption.transform(this.outgoingMessage.array(), 0, this.outgoingMessage.array(), 0, this.outgoingMessage.size());
                }
                this.outgoingMessage.move(this.outgoingMacLength);
                this.outgoingBytes += (long)this.outgoingMessage.size();
                this.transportOut.write(this.outgoingMessage.array(), 0, this.outgoingMessage.size());
                this.transportOut.flush();
                if (isActivity) {
                    this.lastActivity = System.currentTimeMillis();
                }
                if (Log.isDebugEnabled() && this.verbose) {
                    Log.debug(this, "Sent " + this.outgoingMessage.size() + " bytes of transport data outgoingSequence=" + this.outgoingSequence + " totalBytesSinceKEX=" + this.numOutgoingBytesSinceKEX);
                }
                ++this.outgoingSequence;
                this.numOutgoingBytesSinceKEX += msgdata.length;
                ++this.numOutgoingPacketsSinceKEX;
                if (this.outgoingSequence >= 0x100000000L) {
                    this.outgoingSequence = 0L;
                }
                if (!(this.transportContext.isKeyReExchangeDisabled() || this.numOutgoingBytesSinceKEX < 0x40000000 && this.numOutgoingPacketsSinceKEX < Integer.MAX_VALUE)) {
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Requesting key re-exchange");
                    }
                    this.sendKeyExchangeInit(false);
                }
            }
            catch (IOException ex) {
                this.internalDisconnect();
                throw new SshException("Unexpected termination: " + ex.getMessage(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] nextMessage() throws SshException {
        if (Log.isDebugEnabled() && this.verbose) {
            Log.debug(this, "transport next message");
        }
        DataInputStream dataInputStream = this.transportIn;
        synchronized (dataInputStream) {
            byte[] msg;
            while (this.processMessage(msg = this.readMessage())) {
            }
            return msg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readWithTimeout(byte[] buf, int off, int len, int timeoutMillis, boolean isPartialMessage) throws SshException {
        int count = 0;
        int timeout = 0;
        if (isPartialMessage) {
            timeout = this.configureSocketTimeout(this.transportContext.getPartialMessageTimeout());
        }
        try {
            do {
                try {
                    int read = this.transportIn.read(buf, off + count, len - count);
                    if (read == -1) {
                        throw new SshException("EOF received from remote side", 1);
                    }
                    count += read;
                }
                catch (InterruptedIOException ex) {
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Socket timed out during read!  isPartialMessage=" + isPartialMessage + " bytesTransfered=" + ex.bytesTransferred);
                    }
                    if (isPartialMessage && ex.bytesTransferred > 0) {
                        count += ex.bytesTransferred;
                        continue;
                    }
                    if (isPartialMessage) {
                        this.internalDisconnect();
                        throw new SshException("Remote host failed to respond during message receive!", 19);
                    }
                    if (this.getContext().getIdleConnectionTimeoutSeconds() > 0 && System.currentTimeMillis() - this.lastActivity > (long)(this.getContext().getIdleConnectionTimeoutSeconds() * 1000)) {
                        if (Log.isDebugEnabled()) {
                            Log.debug(this, "Connection is idle, disconnecting idleMax=" + this.getContext().getIdleConnectionTimeoutSeconds());
                        }
                        this.disconnect(11, "Idle connection");
                        throw new SshException("Connection has been dropped as it reached max idle time of " + this.getContext().getIdleConnectionTimeoutSeconds() + " seconds.", 12);
                    }
                    if (this.getContext().isSendIgnorePacketOnIdle()) {
                        ByteArrayWriter baw = new ByteArrayWriter();
                        try {
                            if (Log.isDebugEnabled()) {
                                Log.debug(this, "Sending SSH_MSG_IGNORE");
                            }
                            baw.write(2);
                            int tmplen = (int)(Math.random() * (double)this.getContext().getKeepAliveMaxDataLength() + 1.0);
                            byte[] tmp = new byte[tmplen];
                            ComponentManager.getInstance().getRND().nextBytes(tmp);
                            baw.writeBinaryString(tmp);
                            this.sendMessage(baw.toByteArray(), false);
                        }
                        catch (IOException e) {
                            this.internalDisconnect("Connection failed during SSH_MSG_IGNORE packet", 10);
                        }
                        finally {
                            try {
                                baw.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    if (this.getContext().getSocketTimeout() > 0) {
                        Enumeration<TransportProtocolListener> e = this.listeners.elements();
                        while (e.hasMoreElements()) {
                            TransportProtocolListener l = e.nextElement();
                            try {
                                l.onIdle(this.lastActivity);
                            }
                            catch (Throwable throwable) {}
                        }
                        continue;
                    }
                    throw new SshException("Socket connection timed out.", 19);
                }
                catch (IOException ex) {
                    throw new SshException("IO error received from remote" + ex.getMessage(), 1, ex);
                }
            } while (count < len);
        }
        finally {
            if (isPartialMessage) {
                this.configureSocketTimeout(timeout);
            }
        }
    }

    private int configureSocketTimeout(int timeout) {
        if (this.provider instanceof SocketTimeoutSupport) {
            try {
                SocketTimeoutSupport sock = (SocketTimeoutSupport)((Object)this.provider);
                int ret = sock.getSoTimeout();
                sock.setSoTimeout(timeout);
                return ret;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    byte[] readMessage() throws SshException {
        if (Log.isDebugEnabled() && this.verbose) {
            Log.debug(this, "transport read message");
        }
        DataInputStream dataInputStream = this.transportIn;
        synchronized (dataInputStream) {
            try {
                int msglen;
                if (Log.isDebugEnabled() && this.verbose) {
                    Log.debug(this, "Waiting for transport message");
                }
                this.readWithTimeout(this.incomingMessage, 0, this.incomingCipherLength, this.transportContext.getPartialMessageTimeout(), false);
                if (this.decryption != null) {
                    this.decryption.transform(this.incomingMessage, 0, this.incomingMessage, 0, this.incomingCipherLength);
                }
                if ((msglen = (int)ByteArrayReader.readInt(this.incomingMessage, 0)) <= 0) {
                    throw new SshException("Server sent invalid message length of " + msglen + "!", 3);
                }
                int padlen = this.incomingMessage[4] & 0xFF;
                int remaining = msglen - (this.incomingCipherLength - 4);
                if (Log.isDebugEnabled() && this.verbose) {
                    Log.debug(this, "Incoming transport message msglen=" + msglen + " padlen=" + padlen);
                }
                if (remaining < 0) {
                    this.internalDisconnect();
                    throw new SshException("EOF whilst reading message data block", 1);
                }
                if (remaining > this.incomingMessage.length - this.incomingCipherLength) {
                    if (remaining + this.incomingCipherLength + this.incomingMacLength > this.transportContext.getMaximumPacketLength()) {
                        this.internalDisconnect();
                        throw new SshException("Incoming packet length violates SSH protocol [" + remaining + this.incomingCipherLength + " bytes]", 1);
                    }
                    byte[] tmp = new byte[remaining + this.incomingCipherLength + this.incomingMacLength];
                    System.arraycopy(this.incomingMessage, 0, tmp, 0, this.incomingCipherLength);
                    this.incomingMessage = tmp;
                }
                if (remaining > 0) {
                    this.readWithTimeout(this.incomingMessage, this.incomingCipherLength, remaining, this.transportContext.getPartialMessageTimeout(), true);
                    if (this.decryption != null) {
                        this.decryption.transform(this.incomingMessage, this.incomingCipherLength, this.incomingMessage, this.incomingCipherLength, remaining);
                    }
                }
                if (this.incomingMac != null) {
                    this.readWithTimeout(this.incomingMessage, this.incomingCipherLength + remaining, this.incomingMacLength, this.transportContext.getPartialMessageTimeout(), true);
                    if (!this.incomingMac.verify(this.incomingSequence, this.incomingMessage, 0, this.incomingCipherLength + remaining, this.incomingMessage, this.incomingCipherLength + remaining)) {
                        this.disconnect(5, "Corrupt Mac on input");
                        throw new SshException("Corrupt Mac on input", 3);
                    }
                }
                if (++this.incomingSequence >= 0x100000000L) {
                    this.incomingSequence = 0L;
                }
                this.incomingBytes += (long)(this.incomingCipherLength + remaining + this.incomingMacLength);
                byte[] payload = new byte[msglen + 4 - padlen - 5];
                System.arraycopy(this.incomingMessage, 5, payload, 0, payload.length);
                if (this.incomingCompression != null && this.isIncomingCompressing) {
                    return this.incomingCompression.uncompress(payload, 0, payload.length);
                }
                this.numIncomingBytesSinceKEX += payload.length;
                ++this.numIncomingPacketsSinceKEX;
                if (!(this.transportContext.isKeyReExchangeDisabled() || this.numIncomingBytesSinceKEX < 0x40000000 && this.numIncomingPacketsSinceKEX < Integer.MAX_VALUE)) {
                    this.sendKeyExchangeInit(false);
                }
                if (Log.isDebugEnabled() && this.verbose) {
                    Log.debug(this, "Completed incoming transport message");
                }
                return payload;
            }
            catch (InterruptedIOException ex) {
                throw new SshException("Interrupted IO; possible socket timeout detected?", 19);
            }
            catch (IOException ex) {
                this.internalDisconnect();
                throw new SshException("Unexpected terminaton: " + (ex.getMessage() != null ? ex.getMessage() : ex.getClass().getName()) + " sequenceNo = " + this.incomingSequence + " bytesIn = " + this.incomingBytes + " bytesOut = " + this.outgoingBytes, 1, ex);
            }
        }
    }

    public SshKeyExchangeClient getKeyExchange() {
        return this.keyExchange;
    }

    public static boolean Arrayequals(byte[] a, byte[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performKeyExchange(byte[] msg) throws SshException {
        ByteArrayReader bar = new ByteArrayReader(msg, 0, msg.length);
        try {
            Vector<byte[]> vector = this.kexqueue;
            synchronized (vector) {
                if (this.localkex == null) {
                    this.sendKeyExchangeInit(false);
                }
                this.currentState = 2;
                this.remotekex = msg;
                bar.skip(17L);
                String remoteKeyExchanges = this.checkValidString("key exchange", bar.readString());
                String remotePublicKeys = this.checkValidString("public key", bar.readString());
                String remoteCiphersCS = this.checkValidString("client->server cipher", bar.readString());
                String remoteCiphersSC = this.checkValidString("server->client cipher", bar.readString());
                String serverCSMacs = this.checkValidString("client->server mac", bar.readString());
                String serverSCMacs = this.checkValidString("server->client mac", bar.readString());
                String serverCSCompressions = this.checkValidString("client->server comp", bar.readString());
                String serverSCCompressions = this.checkValidString("server->client comp", bar.readString());
                String lang1 = bar.readString();
                String lang2 = bar.readString();
                boolean guessed = bar.readBoolean();
                EventServiceImplementation.getInstance().fireEvent(new Event(this, 3, true).addAttribute("REMOTE_KEY_EXCHANGES", remoteKeyExchanges).addAttribute("LOCAL_KEY_EXCHANGES", this.transportContext.supportedKeyExchanges().list(this.transportContext.getPreferredKeyExchange())).addAttribute("REMOTE_PUBLICKEYS", remotePublicKeys).addAttribute("LOCAL_PUBLICKEYS", this.transportContext.supportedPublicKeys().list(this.transportContext.getPreferredPublicKey())).addAttribute("REMOTE_CIPHERS_CS", remoteCiphersCS).addAttribute("LOCAL_CIPHERS_CS", this.transportContext.supportedCiphersCS().list(this.transportContext.getPreferredCipherCS())).addAttribute("REMOTE_CIPHERS_SC", remoteCiphersSC).addAttribute("LOCAL_CIPHERS_SC", this.transportContext.supportedCiphersSC().list(this.transportContext.getPreferredCipherSC())).addAttribute("REMOTE_CS_MACS", serverCSMacs).addAttribute("LOCAL_CS_MACS", this.transportContext.supportedMacsCS().list(this.transportContext.getPreferredMacCS())).addAttribute("REMOTE_SC_MACS", serverSCMacs).addAttribute("LOCAL_SC_MACS", this.transportContext.supportedMacsSC().list(this.transportContext.getPreferredMacSC())).addAttribute("REMOTE_CS_COMPRESSIONS", serverCSCompressions).addAttribute("LOCAL_CS_COMPRESSIONS", this.transportContext.supportedCompressionsCS().list(this.transportContext.getPreferredCompressionCS())).addAttribute("REMOTE_SC_COMPRESSIONS", serverSCCompressions).addAttribute("LOCAL_SC_COMPRESSIONS", this.transportContext.supportedCompressionsSC().list(this.transportContext.getPreferredCompressionSC())));
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Remote computer supports key exchanges: " + remoteKeyExchanges);
                }
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Remote computer supports public keys: " + remotePublicKeys);
                }
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Remote computer supports client->server ciphers: " + remoteCiphersCS);
                }
                String cipherCS = this.selectNegotiatedComponent(this.transportContext.supportedCiphersCS().list(this.transportContext.getPreferredCipherCS()), remoteCiphersCS);
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Negotiated client->server cipher: " + cipherCS);
                }
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Remote computer supports client->server ciphers: " + remoteCiphersCS);
                }
                String cipherSC = this.selectNegotiatedComponent(this.transportContext.supportedCiphersSC().list(this.transportContext.getPreferredCipherSC()), remoteCiphersSC);
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Negotiated server->client cipher: " + cipherSC);
                }
                SshCipher encryption = (SshCipher)this.transportContext.supportedCiphersCS().getInstance(cipherCS);
                SshCipher decryption = (SshCipher)this.transportContext.supportedCiphersSC().getInstance(cipherSC);
                String macCS = this.selectNegotiatedComponent(this.transportContext.supportedMacsCS().list(this.transportContext.getPreferredMacCS()), this.checkValidString("client->server hmac", serverCSMacs));
                String macSC = this.selectNegotiatedComponent(this.transportContext.supportedMacsSC().list(this.transportContext.getPreferredMacSC()), this.checkValidString("server->client hmac", serverSCMacs));
                SshHmac outgoingMac = (SshHmac)this.transportContext.supportedMacsCS().getInstance(macCS);
                SshHmac incomingMac = (SshHmac)this.transportContext.supportedMacsSC().getInstance(macSC);
                String compressionCS = this.selectNegotiatedComponent(this.transportContext.supportedCompressionsCS().list(this.transportContext.getPreferredCompressionCS()), this.checkValidString("client->server compression", serverCSCompressions));
                String compressionSC = this.selectNegotiatedComponent(this.transportContext.supportedCompressionsSC().list(this.transportContext.getPreferredCompressionSC()), this.checkValidString("server->client compression", serverSCCompressions));
                SshCompression outgoingCompression = null;
                if (!compressionCS.equals("none")) {
                    outgoingCompression = (SshCompression)this.transportContext.supportedCompressionsCS().getInstance(compressionCS);
                    outgoingCompression.init(1, 6);
                }
                SshCompression incomingCompression = null;
                if (!compressionSC.equals("none")) {
                    incomingCompression = (SshCompression)this.transportContext.supportedCompressionsSC().getInstance(compressionSC);
                    incomingCompression.init(0, 6);
                }
                boolean ignoreFirstPacket = false;
                String keyExchangeAlg = this.selectNegotiatedComponent(this.transportContext.supportedKeyExchanges().list(this.transportContext.getPreferredKeyExchange()), remoteKeyExchanges);
                if (this.guessedKeyExchange == null || !keyExchangeAlg.equals(this.guessedKeyExchange.getAlgorithm())) {
                    this.keyExchange = (SshKeyExchangeClient)this.transportContext.supportedKeyExchanges().getInstance(keyExchangeAlg);
                }
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Negotiated key exchange: " + this.keyExchange.getAlgorithm());
                }
                if (guessed) {
                    if (!keyExchangeAlg.equals(this.transportContext.getPreferredKeyExchange())) {
                        ignoreFirstPacket = true;
                    }
                    String hostkey = this.selectNegotiatedComponent(this.transportContext.supportedPublicKeys().list(this.transportContext.getPreferredPublicKey()), remotePublicKeys);
                    if (!ignoreFirstPacket && !hostkey.equals(this.transportContext.getPreferredPublicKey())) {
                        ignoreFirstPacket = true;
                    }
                }
                this.keyExchange.init(this, ignoreFirstPacket);
                this.keyExchange.performClientExchange(this.localIdentification, this.remoteIdentification, this.localkex, this.remotekex);
                String hostKeyAlg = this.selectNegotiatedComponent(this.transportContext.supportedPublicKeys().list(this.transportContext.getPreferredPublicKey()), remotePublicKeys);
                this.hostkey = (SshPublicKey)this.transportContext.supportedPublicKeys().getInstance(hostKeyAlg);
                if (!this.ignoreHostKeyifEmpty || !TransportProtocol.Arrayequals(this.keyExchange.getHostKey(), "".getBytes())) {
                    EventServiceImplementation.getInstance().fireEvent(new Event(this, 0, true).addAttribute("HOST_KEY", new String(this.keyExchange.getHostKey())));
                    this.hostkey.init(this.keyExchange.getHostKey(), 0, this.keyExchange.getHostKey().length);
                    if (this.transportContext.getHostKeyVerification() != null) {
                        if (!this.transportContext.getHostKeyVerification().verifyHost(this.provider.getHost(), this.hostkey)) {
                            EventServiceImplementation.getInstance().fireEvent(new Event(this, 1, false));
                            this.disconnect(9, "Host key not accepted");
                            throw new SshException("The host key was not accepted", 8);
                        }
                        if (!this.hostkey.verifySignature(this.keyExchange.getSignature(), this.keyExchange.getExchangeHash())) {
                            EventServiceImplementation.getInstance().fireEvent(new Event(this, 1, false));
                            this.disconnect(9, "Invalid host key signature");
                            throw new SshException("The host key signature is invalid", 3);
                        }
                        EventServiceImplementation.getInstance().fireEvent(new Event(this, 2, true));
                    }
                }
                if (this.sessionIdentifier == null) {
                    this.sessionIdentifier = this.keyExchange.getExchangeHash();
                }
                this.sendMessage(new byte[]{21}, true);
                encryption.init(0, this.makeSshKey('A'), this.makeSshKey('C'));
                this.outgoingCipherLength = encryption.getBlockSize();
                outgoingMac.init(this.makeSshKey('E'));
                this.outgoingMacLength = outgoingMac.getMacLength();
                this.encryption = encryption;
                this.outgoingMac = outgoingMac;
                this.outgoingCompression = outgoingCompression;
                do {
                    if (this.processMessage(msg = this.readMessage())) continue;
                    EventServiceImplementation.getInstance().fireEvent(new Event(this, 4, true));
                    this.disconnect(2, "Invalid message received");
                    throw new SshException("Invalid message received during key exchange", 3);
                } while (msg[0] != 21);
                EventServiceImplementation.getInstance().fireEvent(new Event(this, 5, true).addAttribute("USING_PUBLICKEY", hostKeyAlg).addAttribute("USING_KEY_EXCHANGE", keyExchangeAlg).addAttribute("USING_CS_CIPHER", cipherCS).addAttribute("USING_SC_CIPHERC", cipherSC).addAttribute("USING_CS_MAC", macCS).addAttribute("USING_SC_MAC", macSC).addAttribute("USING_CS_COMPRESSION", compressionCS).addAttribute("USING_SC_COMPRESSION", compressionSC));
                decryption.init(1, this.makeSshKey('B'), this.makeSshKey('D'));
                this.incomingCipherLength = decryption.getBlockSize();
                incomingMac.init(this.makeSshKey('F'));
                this.incomingMacLength = incomingMac.getMacLength();
                this.decryption = decryption;
                this.incomingMac = incomingMac;
                this.incomingCompression = incomingCompression;
                if (incomingCompression != null && !incomingCompression.getAlgorithm().equals("zlib@openssh.com")) {
                    this.isIncomingCompressing = true;
                }
                if (outgoingCompression != null && !outgoingCompression.getAlgorithm().equals("zlib@openssh.com")) {
                    this.isOutgoingCompressing = true;
                }
                this.currentState = 3;
                Enumeration<byte[]> e = this.kexqueue.elements();
                while (e.hasMoreElements()) {
                    this.sendMessage(e.nextElement(), true);
                }
                this.kexqueue.removeAllElements();
                this.localkex = null;
                this.remotekex = null;
            }
        }
        catch (IOException ex) {
            EventServiceImplementation.getInstance().fireEvent(new Event(this, 4, true));
            throw new SshException(ex, 5);
        }
        catch (SshException sshe) {
            EventServiceImplementation.getInstance().fireEvent(new Event(this, 4, true));
            throw sshe;
        }
        finally {
            try {
                bar.close();
            }
            catch (IOException iOException) {}
        }
    }

    void completedAuthentication() {
        if (this.incomingCompression != null && this.incomingCompression.getAlgorithm().equals("zlib@openssh.com")) {
            this.isIncomingCompressing = true;
        }
        if (this.outgoingCompression != null && this.outgoingCompression.getAlgorithm().equals("zlib@openssh.com")) {
            this.isOutgoingCompressing = true;
        }
    }

    public void startService(String servicename) throws SshException {
        ByteArrayWriter baw = new ByteArrayWriter();
        try {
            byte[] msg;
            baw.write(5);
            baw.writeString(servicename);
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Sending SSH_MSG_SERVICE_REQUEST");
            }
            this.sendMessage(baw.toByteArray(), true);
            while (this.processMessage(msg = this.readMessage()) || msg[0] != 6) {
            }
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Received SSH_MSG_SERVICE_ACCEPT");
            }
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                baw.close();
            }
            catch (IOException iOException) {}
        }
    }

    void internalDisconnect(String msg, int reason) {
        this.currentState = 4;
        try {
            this.provider.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Enumeration<TransportProtocolListener> e = this.listeners.elements();
        while (e.hasMoreElements()) {
            TransportProtocolListener l = e.nextElement();
            try {
                l.onDisconnect(msg, reason);
            }
            catch (Throwable throwable) {}
        }
        for (int i = 0; i < this.shutdownHooks.size(); ++i) {
            try {
                this.shutdownHooks.elementAt(i).run();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void internalDisconnect() {
        this.currentState = 4;
        try {
            this.provider.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (int i = 0; i < this.shutdownHooks.size(); ++i) {
            try {
                this.shutdownHooks.elementAt(i).run();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void addShutdownHook(Runnable r) {
        if (r != null) {
            this.shutdownHooks.addElement(r);
        }
    }

    public boolean processMessage(byte[] msg) throws SshException {
        try {
            if (msg.length < 1) {
                this.disconnect(2, "Invalid message received");
                throw new SshException("Invalid transport protocol message", 5);
            }
            switch (msg[0]) {
                case 1: {
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Received SSH_MSG_DISCONNECT");
                    }
                    this.internalDisconnect();
                    ByteArrayReader bar = new ByteArrayReader(msg, 5, msg.length - 5);
                    try {
                        EventServiceImplementation.getInstance().fireEvent(new Event(this, 21, true));
                        throw new SshException(bar.readString(), 2);
                    }
                    catch (Throwable throwable) {
                        bar.close();
                        throw throwable;
                    }
                }
                case 2: {
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Received SSH_MSG_IGNORE");
                    }
                    return true;
                }
                case 4: {
                    this.lastActivity = System.currentTimeMillis();
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Received SSH_MSG_DEBUG");
                    }
                    return true;
                }
                case 21: {
                    this.lastActivity = System.currentTimeMillis();
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Received SSH_MSG_NEWKEYS");
                    }
                    return true;
                }
                case 20: {
                    this.lastActivity = System.currentTimeMillis();
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Received SSH_MSG_KEX_INIT");
                    }
                    if (this.remotekex != null) {
                        this.disconnect(2, "Key exchange already in progress!");
                        throw new SshException("Key exchange already in progress!", 3);
                    }
                    this.performKeyExchange(msg);
                    return true;
                }
            }
            this.lastActivity = System.currentTimeMillis();
            return false;
        }
        catch (IOException ex1) {
            throw new SshException(ex1.getMessage(), 5);
        }
    }

    boolean isTransportMessage(int messageid) {
        switch (messageid) {
            case 1: 
            case 2: 
            case 4: 
            case 20: 
            case 21: {
                return true;
            }
        }
        if (this.keyExchange != null) {
            return this.keyExchange.isKeyExchangeMessage(messageid);
        }
        return false;
    }

    String selectNegotiatedComponent(String locallist, String remotelist) throws SshException {
        int idx;
        String list = remotelist;
        String llist = locallist;
        Vector<String> r = new Vector<String>();
        while ((idx = list.indexOf(",")) > -1) {
            r.addElement(list.substring(0, idx).trim());
            list = list.substring(idx + 1).trim();
        }
        r.addElement(list.trim());
        while ((idx = llist.indexOf(",")) > -1) {
            String name = llist.substring(0, idx).trim();
            if (r.contains(name)) {
                return name;
            }
            llist = llist.substring(idx + 1).trim();
        }
        if (r.contains(llist)) {
            return llist;
        }
        EventServiceImplementation.getInstance().fireEvent(new Event(this, 32, true).addAttribute("LOCAL_COMPONENT_LIST", locallist).addAttribute("REMOTE_COMPONENT_LIST", remotelist));
        throw new SshException("Failed to negotiate a transport component [" + locallist + "] [" + remotelist + "]", 9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendKeyExchangeInit(boolean guess) throws SshException {
        ByteArrayWriter msg = new ByteArrayWriter();
        try {
            Vector<byte[]> vector = this.kexqueue;
            synchronized (vector) {
                this.numIncomingBytesSinceKEX = 0;
                this.numIncomingPacketsSinceKEX = 0;
                this.numOutgoingBytesSinceKEX = 0;
                this.numOutgoingPacketsSinceKEX = 0;
                this.currentState = 2;
                byte[] cookie = new byte[16];
                ComponentManager.getInstance().getRND().nextBytes(cookie);
                msg.write(20);
                msg.write(cookie);
                msg.writeString(this.transportContext.supportedKeyExchanges().list(this.transportContext.getPreferredKeyExchange()));
                msg.writeString(this.transportContext.supportedPublicKeys().list(this.transportContext.getPreferredPublicKey()));
                msg.writeString(this.transportContext.supportedCiphersCS().list(this.transportContext.getPreferredCipherCS()));
                msg.writeString(this.transportContext.supportedCiphersSC().list(this.transportContext.getPreferredCipherSC()));
                msg.writeString(this.transportContext.supportedMacsCS().list(this.transportContext.getPreferredMacCS()));
                msg.writeString(this.transportContext.supportedMacsSC().list(this.transportContext.getPreferredMacSC()));
                msg.writeString(this.transportContext.supportedCompressionsCS().list(this.transportContext.getPreferredCompressionCS()));
                msg.writeString(this.transportContext.supportedCompressionsSC().list(this.transportContext.getPreferredCompressionSC()));
                msg.writeString("");
                msg.writeString("");
                msg.writeBoolean(guess);
                msg.writeInt(0);
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Sending SSH_MSG_KEX_INIT");
                }
                this.localkex = msg.toByteArray();
                this.sendMessage(this.localkex, true);
            }
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                msg.close();
            }
            catch (IOException iOException) {}
        }
    }

    byte[] makeSshKey(char chr) throws IOException {
        ByteArrayWriter keydata = new ByteArrayWriter();
        try {
            byte[] data = new byte[20];
            Digest hash = (Digest)ComponentManager.getInstance().supportedDigests().getInstance(this.keyExchange.getHashAlgorithm());
            hash.putBigInteger(this.keyExchange.getSecret());
            hash.putBytes(this.keyExchange.getExchangeHash());
            hash.putByte((byte)chr);
            hash.putBytes(this.sessionIdentifier);
            data = hash.doFinal();
            keydata.write(data);
            hash.reset();
            hash.putBigInteger(this.keyExchange.getSecret());
            hash.putBytes(this.keyExchange.getExchangeHash());
            hash.putBytes(data);
            data = hash.doFinal();
            keydata.write(data);
            byte[] byArray = keydata.toByteArray();
            return byArray;
        }
        catch (SshException e) {
            throw new SshIOException(e);
        }
        finally {
            keydata.close();
        }
    }

    private String checkValidString(String id, String str) throws IOException {
        if (str.trim().equals("")) {
            throw new IOException("Server sent invalid " + id + " value '" + str + "'");
        }
        StringTokenizer t = new StringTokenizer(str, ",");
        if (!t.hasMoreElements()) {
            throw new IOException("Server sent invalid " + id + " value '" + str + "'");
        }
        return str;
    }
}

