/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.gui;

import com.agilemind.commons.gui.util.ColorUtil;
import com.agilemind.commons.gui.util.ScalingUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class BottomLineBorder
extends AbstractBorder {
    protected Color lineColor;
    protected boolean halfDarker = true;

    public BottomLineBorder() {
        this(null);
    }

    public BottomLineBorder(Color color) {
        this.lineColor = color;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = n4;
        int n7 = n5;
        graphics.translate(n2, n3);
        graphics.setColor(this.getShadowColor(component));
        int n8 = ScalingUtil.int_SC(1);
        graphics.drawLine(0, n7 - n8, n6, n7 - n8);
        graphics.translate(-n2, -n3);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return ScalingUtil.insets_SC(0, 0, 1, 0);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = 0;
        insets.left = 0;
        insets.bottom = ScalingUtil.int_SC(1);
        insets.right = 0;
        return insets;
    }

    public Color getShadowColor(Component component) {
        return this.lineColor != null ? this.lineColor : this.getDarker(component.getBackground());
    }

    public Color getDarker(Color color) {
        return this.halfDarker ? ColorUtil.getColor(color.darker(), color, 0.5) : color.darker();
    }

    public Color getShadowColor() {
        return this.lineColor;
    }
}

