/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.gui;

import com.agilemind.commons.gui.StateSelectBox;
import com.agilemind.commons.util.StringUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public class GraphicsUtilities {
    private static final String[] a;

    private GraphicsUtilities() {
    }

    private static GraphicsConfiguration a() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static boolean b() {
        return GraphicsEnvironment.isHeadless();
    }

    public static BufferedImage convertToBufferedImage(Image image) {
        BufferedImage bufferedImage = GraphicsUtilities.createCompatibleTranslucentImage(image.getWidth(null), image.getHeight(null));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.drawImage(image, 0, 0, null);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    public static BufferedImage createColorModelCompatibleImage(BufferedImage bufferedImage) {
        ColorModel colorModel = bufferedImage.getColorModel();
        return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), colorModel.isAlphaPremultiplied(), null);
    }

    public static BufferedImage createCompatibleImage(BufferedImage bufferedImage) {
        return GraphicsUtilities.createCompatibleImage(bufferedImage, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public static BufferedImage createCompatibleImage(BufferedImage bufferedImage, int n2, int n3) {
        BufferedImage bufferedImage2 = GraphicsUtilities.b() ? new BufferedImage(n2, n3, bufferedImage.getType()) : GraphicsUtilities.a().createCompatibleImage(n2, n3, bufferedImage.getTransparency());
        return bufferedImage2;
    }

    public static BufferedImage createCompatibleImage(int n2, int n3) {
        BufferedImage bufferedImage = GraphicsUtilities.b() ? new BufferedImage(n2, n3, 1) : GraphicsUtilities.a().createCompatibleImage(n2, n3);
        return bufferedImage;
    }

    public static BufferedImage createCompatibleTranslucentImage(int n2, int n3) {
        BufferedImage bufferedImage = GraphicsUtilities.b() ? new BufferedImage(n2, n3, 2) : GraphicsUtilities.a().createCompatibleImage(n2, n3, 3);
        return bufferedImage;
    }

    public static BufferedImage loadCompatibleImage(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        if (bufferedImage == null) {
            return null;
        }
        return GraphicsUtilities.toCompatibleImage(bufferedImage);
    }

    public static BufferedImage loadCompatibleImage(URL uRL) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(uRL);
        return GraphicsUtilities.toCompatibleImage(bufferedImage);
    }

    public static BufferedImage toCompatibleImage(BufferedImage bufferedImage) {
        if (GraphicsUtilities.b()) {
            return bufferedImage;
        }
        if (bufferedImage.getColorModel().equals(GraphicsUtilities.a().getColorModel())) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = GraphicsUtilities.a().createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getTransparency());
        Graphics graphics = bufferedImage2.getGraphics();
        try {
            graphics.drawImage(bufferedImage, 0, 0, null);
        }
        finally {
            graphics.dispose();
        }
        return bufferedImage2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage createThumbnailFast(BufferedImage bufferedImage, int n2) {
        int n3;
        int n4;
        block17: {
            float f2;
            block16: {
                n4 = bufferedImage.getWidth();
                if (n4 <= (n3 = bufferedImage.getHeight())) break block16;
                if (n2 >= n4) {
                    throw new IllegalArgumentException(a[10]);
                }
                if (n2 <= 0) {
                    throw new IllegalArgumentException(a[7]);
                }
                f2 = (float)n4 / (float)n3;
                n4 = n2;
                n3 = (int)((float)n2 / f2);
                if (StateSelectBox.State.c == 0) break block17;
            }
            if (n2 >= n3) {
                throw new IllegalArgumentException(a[9]);
            }
            if (n2 <= 0) {
                throw new IllegalArgumentException(a[8]);
            }
            f2 = (float)n3 / (float)n4;
            n3 = n2;
            n4 = (int)((float)n2 / f2);
        }
        BufferedImage bufferedImage2 = GraphicsUtilities.createCompatibleImage(bufferedImage, n4, n3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(bufferedImage, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), null);
            return bufferedImage2;
        }
        finally {
            graphics2D.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage createThumbnailFast(BufferedImage bufferedImage, int n2, int n3) {
        if (n2 >= bufferedImage.getWidth()) throw new IllegalArgumentException(a[1]);
        if (n3 >= bufferedImage.getHeight()) {
            throw new IllegalArgumentException(a[1]);
        }
        if (n2 <= 0) throw new IllegalArgumentException(a[0]);
        if (n3 <= 0) {
            throw new IllegalArgumentException(a[0]);
        }
        BufferedImage bufferedImage2 = GraphicsUtilities.createCompatibleImage(bufferedImage, n2, n3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(bufferedImage, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), null);
            return bufferedImage2;
        }
        finally {
            graphics2D.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage createThumbnail(BufferedImage bufferedImage, int n2) {
        boolean bl;
        int n3 = StateSelectBox.State.c;
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        boolean bl2 = bufferedImage.getTransparency() != 1;
        boolean bl3 = bl = n4 > n5;
        if (bl) {
            if (n2 >= n4) {
                throw new IllegalArgumentException(a[4]);
            }
        } else if (n2 >= n5) {
            throw new IllegalArgumentException(a[2]);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException(a[3]);
        }
        float f2 = (float)n4 / (float)n5;
        float f3 = (float)n5 / (float)n4;
        BufferedImage bufferedImage2 = bufferedImage;
        BufferedImage bufferedImage3 = null;
        Graphics graphics = null;
        try {
            int n6 = n4;
            int n7 = n5;
            do {
                block37: {
                    block36: {
                        if (!bl) break block36;
                        if ((n4 /= 2) < n2) {
                            n4 = n2;
                        }
                        n5 = (int)((float)n4 / f2);
                        if (n3 == 0) break block37;
                    }
                    if ((n5 /= 2) < n2) {
                        n5 = n2;
                    }
                    n4 = (int)((float)n5 / f3);
                }
                if (bufferedImage3 == null || bl2) {
                    if (graphics != null) {
                        graphics.dispose();
                    }
                    bufferedImage3 = GraphicsUtilities.createCompatibleImage(bufferedImage, n4, n5);
                    graphics = bufferedImage3.createGraphics();
                    ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                graphics.drawImage(bufferedImage2, 0, 0, n4, n5, 0, 0, n6, n7, null);
                n6 = n4;
                n7 = n5;
                bufferedImage2 = bufferedImage3;
            } while (n2 != (bl ? n4 : n5));
        }
        finally {
            graphics.dispose();
        }
        if (n4 != bufferedImage2.getWidth() || n5 != bufferedImage2.getHeight()) {
            bufferedImage3 = GraphicsUtilities.createCompatibleImage(bufferedImage, n4, n5);
            graphics = bufferedImage3.createGraphics();
            try {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics.drawImage(bufferedImage2, 0, 0, n4, n5, 0, 0, n4, n5, null);
            }
            finally {
                graphics.dispose();
            }
            bufferedImage2 = bufferedImage3;
        }
        if (!StringUtil.f) return bufferedImage2;
        StateSelectBox.State.c = ++n3;
        return bufferedImage2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage createThumbnail(BufferedImage bufferedImage, int n2, int n3) {
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        boolean bl = bufferedImage.getTransparency() != 1;
        if (n2 >= n4) throw new IllegalArgumentException(a[5]);
        if (n3 >= n5) {
            throw new IllegalArgumentException(a[5]);
        }
        if (n2 <= 0) throw new IllegalArgumentException(a[6]);
        if (n3 <= 0) {
            throw new IllegalArgumentException(a[6]);
        }
        BufferedImage bufferedImage2 = bufferedImage;
        BufferedImage bufferedImage3 = null;
        Graphics graphics = null;
        try {
            int n6 = n4;
            int n7 = n5;
            do {
                if (n4 > n2 && (n4 /= 2) < n2) {
                    n4 = n2;
                }
                if (n5 > n3 && (n5 /= 2) < n3) {
                    n5 = n3;
                }
                if (bufferedImage3 == null || bl) {
                    if (graphics != null) {
                        graphics.dispose();
                    }
                    bufferedImage3 = GraphicsUtilities.createCompatibleImage(bufferedImage, n4, n5);
                    graphics = bufferedImage3.createGraphics();
                    ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                }
                graphics.drawImage(bufferedImage2, 0, 0, n4, n5, 0, 0, n6, n7, null);
                n6 = n4;
                n7 = n5;
                bufferedImage2 = bufferedImage3;
            } while (n4 != n2 || n5 != n3);
        }
        finally {
            graphics.dispose();
        }
        if (n4 == bufferedImage2.getWidth()) {
            if (n5 == bufferedImage2.getHeight()) return bufferedImage2;
        }
        bufferedImage3 = GraphicsUtilities.createCompatibleImage(bufferedImage, n4, n5);
        graphics = bufferedImage3.createGraphics();
        try {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics.drawImage(bufferedImage2, 0, 0, n4, n5, 0, 0, n4, n5, null);
            return bufferedImage3;
        }
        finally {
            graphics.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] getPixels(BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int[] nArray) {
        int n6;
        block12: {
            block11: {
                if (n4 == 0 || n5 == 0) {
                    return new int[0];
                }
                if (nArray != null) break block11;
                nArray = new int[n4 * n5];
                if (StateSelectBox.State.c == 0) break block12;
            }
            if (nArray.length < n4 * n5) {
                throw new IllegalArgumentException(a[11]);
            }
        }
        if ((n6 = bufferedImage.getType()) != 2 && n6 != 1) {
            return bufferedImage.getRGB(n2, n3, n4, n5, nArray, 0, n4);
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        return (int[])writableRaster.getDataElements(n2, n3, n4, n5, nArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setPixels(BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int[] nArray) {
        if (nArray == null) return;
        if (n4 == 0) return;
        if (n5 == 0) {
            return;
        }
        if (nArray.length < n4 * n5) {
            throw new IllegalArgumentException(a[12]);
        }
        int n6 = bufferedImage.getType();
        if (n6 == 2 || n6 == 1) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            writableRaster.setDataElements(n2, n3, n4, n5, nArray);
            if (StateSelectBox.State.c == 0) return;
        }
        bufferedImage.setRGB(n2, n3, n4, n5, nArray, 0, n4);
    }

    public static Shape mergeClip(Graphics graphics, Shape shape) {
        Shape shape2 = graphics.getClip();
        if (shape2 == null) {
            graphics.setClip(shape);
            return null;
        }
        Area area = new Area(shape2);
        area.intersect(new Area(shape));
        graphics.setClip(area);
        return shape2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[13];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\rg\u0005|]\u0007v\u001a\u000bU\rfREQ\u0014J\u0017BS\u000bvRFA\u0010vRIQCe\u0000NU\u0017g\u0000\u000b@\u000bc\u001c\u000b\u0004";
        int n3 = -1;
        block20: while (true) {
            char[] cArray;
            block25: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block24: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block24;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block25;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 99;
                                break;
                            }
                            case 1: {
                                n9 = 2;
                                break;
                            }
                            case 2: {
                                n9 = 114;
                                break;
                            }
                            case 3: {
                                n9 = 43;
                                break;
                            }
                            default: {
                                n9 = 52;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\rg\u0005|]\u0007v\u001a\u000bU\rfREQ\u0014J\u0017BS\u000bvRHU\rl\u001d_\u0014\u0001gRLF\u0006c\u0006NFCv\u001aJZCv\u001aN\u0014\no\u0013LQCf\u001bFQ\rq\u001bDZ\u0010";
                    n3 = 0;
                    continue block20;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\rg\u0005x]\u0019gRFA\u0010vRIQCn\u001d\\Q\u0011\"\u0006CU\r\"\u0006CQCk\u001fJS\u0006\"\u001aN]\u0004j\u0006";
                    n3 = 1;
                    continue block20;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\rg\u0005x]\u0019gRFA\u0010vRIQCe\u0000NU\u0017g\u0000\u000b@\u000bc\u001c\u000b\u0004";
                    n3 = 2;
                    continue block20;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\rg\u0005x]\u0019gRFA\u0010vRIQCn\u001d\\Q\u0011\"\u0006CU\r\"\u0006CQCk\u001fJS\u0006\"\u0005BP\u0017j";
                    n3 = 3;
                    continue block20;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\rg\u0005|]\u0007v\u001a\u000bU\rfREQ\u0014J\u0017BS\u000bvRHU\rl\u001d_\u0014\u0001gRLF\u0006c\u0006NFCv\u001aJZCv\u001aN\u0014\no\u0013LQCf\u001bFQ\rq\u001bDZ\u0010";
                    n3 = 4;
                    continue block20;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\rg\u0005|]\u0007v\u001a\u000bU\rfREQ\u0014J\u0017BS\u000bvRFA\u0010vRIQCe\u0000NU\u0017g\u0000\u000b@\u000bc\u001c\u000b\u0004";
                    n3 = 5;
                    continue block20;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\rg\u0005x]\u0019gRFA\u0010vRIQCe\u0000NU\u0017g\u0000\u000b@\u000bc\u001c\u000b\u0004";
                    n3 = 6;
                    continue block20;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\rg\u0005x]\u0019gRFA\u0010vRIQCe\u0000NU\u0017g\u0000\u000b@\u000bc\u001c\u000b\u0004";
                    n3 = 7;
                    continue block20;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\rg\u0005x]\u0019gRFA\u0010vRIQCn\u001d\\Q\u0011\"\u0006CU\r\"\u0006CQCk\u001fJS\u0006\"\u001aN]\u0004j\u0006";
                    n3 = 8;
                    continue block20;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\rg\u0005x]\u0019gRFA\u0010vRIQCn\u001d\\Q\u0011\"\u0006CU\r\"\u0006CQCk\u001fJS\u0006\"\u0005BP\u0017j";
                    n3 = 9;
                    continue block20;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u0013k\nNX\u0010\"\u0013YF\u0002{RFA\u0010vRCU\u0015gRJ\u0014\u000fg\u001cL@\u000b\"L\u0016\u0014\u0014(\u001a";
                    n3 = 10;
                    continue block20;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\u0013k\nNX\u0010\"\u0013YF\u0002{RFA\u0010vRCU\u0015gRJ\u0014\u000fg\u001cL@\u000b\"L\u0016\u0014\u0014(\u001a";
                    n3 = 11;
                    continue block20;
                }
                case 11: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        a = stringArray3;
    }
}

