/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.gui;

import com.agilemind.commons.gui.renderer.ProgressBarTableCellRenderer;
import com.agilemind.commons.util.FormatUtil;

public abstract class Progressable
implements Comparable<Progressable> {
    public abstract void setValues(ProgressBarTableCellRenderer var1);

    public static class DoubleIntProgressable
    extends Progressable {
        private final double a;
        private int b;
        private static final String c;

        public DoubleIntProgressable(double d2, int n2) {
            this.a = d2;
            this.b = n2;
        }

        @Override
        public void setValues(ProgressBarTableCellRenderer progressBarTableCellRenderer) {
            progressBarTableCellRenderer.setValue(this.a, this.b);
        }

        @Override
        public int compareTo(Progressable progressable) {
            int n2 = Double.compare(this.a, ((DoubleIntProgressable)progressable).a);
            if (n2 == 0) {
                return Integer.compare(this.b, ((DoubleIntProgressable)progressable).b);
            }
            return n2;
        }

        public String toString() {
            return DoubleIntProgressable.format(this.a, this.b);
        }

        public static String format(double d2, int n2) {
            String string = FormatUtil.NUMBER_0_0_FORMAT.format(d2) + '%';
            if (n2 != -1) {
                string = string + c + n2 + ')';
            }
            return string;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "\u001d=".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 61;
                                break;
                            }
                            case 1: {
                                n7 = 21;
                                break;
                            }
                            case 2: {
                                n7 = 10;
                                break;
                            }
                            case 3: {
                                n7 = 54;
                                break;
                            }
                            default: {
                                n7 = 120;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            c = new String(cArray).intern();
        }
    }

    public static class DoubleProgressable
    extends Progressable {
        private final double a;

        public DoubleProgressable(double d2) {
            this.a = d2;
        }

        @Override
        public void setValues(ProgressBarTableCellRenderer progressBarTableCellRenderer) {
            progressBarTableCellRenderer.setValue(this.a, -1);
        }

        @Override
        public int compareTo(Progressable progressable) {
            return Double.compare(this.a, ((DoubleProgressable)progressable).a);
        }

        public String toString() {
            return DoubleProgressable.format(this.a);
        }

        public static String format(double d2) {
            return FormatUtil.NUMBER_0_0_FORMAT.format(d2) + '%';
        }
    }
}

