/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.gui;

import com.agilemind.commons.gui.DocumentEditActionListeners;
import com.agilemind.commons.gui.TextComponentToolbar;
import com.agilemind.commons.gui.undoredo.AbstractUndoRedoHandler;
import com.agilemind.commons.util.ClipboardUtil;
import com.agilemind.commons.util.StringUtil;
import java.util.Objects;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public class TextComponentToolBarConfigurator {
    private TextComponentToolBarConfigurator() {
    }

    public static void configureToolbar(JTextComponent jTextComponent, TextComponentToolbar textComponentToolbar, AbstractUndoRedoHandler abstractUndoRedoHandler, DocumentEditActionListeners documentEditActionListeners) {
        Objects.requireNonNull(textComponentToolbar);
        Objects.requireNonNull(jTextComponent);
        Objects.requireNonNull(documentEditActionListeners);
        UndoManager undoManager2 = abstractUndoRedoHandler.getUndoManager();
        abstractUndoRedoHandler.addObserver((observable, undoManager) -> {
            boolean bl = jTextComponent.isEditable() && jTextComponent.isEnabled();
            boolean bl2 = bl && undoManager.canUndo();
            boolean bl3 = bl && undoManager.canRedo();
            textComponentToolbar.getUndoButton().setEnabled(bl2);
            textComponentToolbar.getRedoButton().setEnabled(bl3);
        });
        textComponentToolbar.getUndoButton().addActionListener(documentEditActionListeners.undoListener());
        textComponentToolbar.getRedoButton().addActionListener(documentEditActionListeners.redoListener());
        textComponentToolbar.getCopyButton().addActionListener(documentEditActionListeners.copyListener());
        textComponentToolbar.getCutButton().addActionListener(documentEditActionListeners.cutListener());
        textComponentToolbar.getPasteButton().addActionListener(documentEditActionListeners.pasteListener());
        textComponentToolbar.getToolBar().addHierarchyListener(hierarchyEvent -> {
            boolean bl = jTextComponent.isEditable() && jTextComponent.isEnabled();
            boolean bl2 = bl && !StringUtil.isEmpty(jTextComponent.getSelectedText());
            boolean bl3 = bl && !ClipboardUtil.isClipboardEmpty();
            textComponentToolbar.getCutButton().setEnabled(bl2);
            textComponentToolbar.getCopyButton().setEnabled(bl2);
            textComponentToolbar.getPasteButton().setEnabled(bl3);
        });
        jTextComponent.addCaretListener(caretEvent -> {
            boolean bl = jTextComponent.isEditable() && jTextComponent.isEnabled();
            boolean bl2 = !StringUtil.isEmpty(jTextComponent.getSelectedText());
            boolean bl3 = bl && bl2;
            textComponentToolbar.getCutButton().setEnabled(bl3);
            textComponentToolbar.getCopyButton().setEnabled(bl2);
            boolean bl4 = bl && undoManager2.canUndo();
            boolean bl5 = bl && undoManager2.canRedo();
            textComponentToolbar.getUndoButton().setEnabled(bl4);
            textComponentToolbar.getRedoButton().setEnabled(bl5);
        });
    }
}

