/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.gui.locale.iconset;

import com.agilemind.commons.gui.locale.iconset.ButtonIconSetCustomColorSVG;
import com.agilemind.commons.gui.locale.iconset.IButtonIconSet;
import com.agilemind.commons.gui.util.IconPath;
import com.agilemind.commons.gui.util.IconSize;
import com.agilemind.commons.gui.util.IconType;
import com.agilemind.commons.gui.util.SVGColor;
import com.agilemind.commons.util.Pair;
import com.google.common.collect.Iterables;
import java.util.EnumMap;
import java.util.Map;

public class SVGIconSetBuilder {
    private IconSize a = IconSize._16x16;
    private Map<IconType, SVGColor> b = new EnumMap<IconType, SVGColor>(IconType.class);

    protected SVGIconSetBuilder() {
    }

    public static SVGIconSetBuilder newInstance() {
        return new SVGIconSetBuilder();
    }

    public SVGIconSetBuilder setSize(IconSize iconSize) {
        this.a = iconSize;
        return this;
    }

    public SVGIconSetBuilder setTypeColor(IconType iconType, SVGColor sVGColor) {
        this.b.put(iconType, sVGColor);
        return this;
    }

    public SVGIconSetBuilder clearTypes() {
        this.b.clear();
        return this;
    }

    public IButtonIconSet buildButtonSet(IconPath iconPath) {
        if (this.b.isEmpty()) {
            this.b.put(IconType.NORMAL, SVGColor.LIGHT_GREY);
            this.b.put(IconType.ROLLOVER, SVGColor.DARK_GREY);
        }
        return new ButtonIconSetCustomColorSVG(iconPath, this.a, (Pair[])Iterables.toArray((Iterable)Iterables.transform(this.b.entrySet(), entry -> Pair.create(entry.getKey(), entry.getValue())), Pair.class));
    }

    public IButtonIconSet buildUncoloredButtonSet(IconPath iconPath) {
        return this.buildSingleColorButtonSet(iconPath, SVGColor.UNCOLORED);
    }

    public IButtonIconSet buildSingleColorButtonSet(IconPath iconPath, SVGColor sVGColor) {
        return new ButtonIconSetCustomColorSVG(iconPath, this.a, Pair.create(IconType.NORMAL, sVGColor));
    }

    public SVGIconSetBuilder setToolBarSize() {
        this.a = IconSize._24x24;
        return this;
    }

    public SVGIconSetBuilder addDefaultButtonTypeColor() {
        this.b.put(IconType.NORMAL, SVGColor.LIGHT_GREY);
        this.b.put(IconType.ROLLOVER, SVGColor.DARK_GREY);
        return this;
    }
}

