/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.gui.util;

import com.agilemind.commons.gui.factory.BorderFactory_SC;
import com.agilemind.commons.gui.util.ColorUtil;
import com.agilemind.commons.gui.util.ScalingUtil;
import com.agilemind.commons.gui.util.UiUtil;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.ShadowBorder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;

public final class BorderUtil {
    public static final Border EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    public static final LineBorder LINE_GREY_BORDER_SC = BorderFactory_SC.lineBorder_SC(PureLookAndFeel.getCurrentTheme().getTableHeaderSortedColor());
    public static final LineBorder DARK_LINE_GREY_BORDER_SC = BorderFactory_SC.lineBorder_SC(PureLookAndFeel.getCurrentTheme().getTableHeaderColor());
    private static AbstractBorder a;
    private static AbstractBorder b;
    private static Border c;
    private static Border d;
    private static Border e;
    private static Border f;
    private static Border g;

    private BorderUtil() {
    }

    public static <C extends JComponent> C border(C c2, Border border) {
        c2.setBorder(border);
        return c2;
    }

    public static void setBorder(Component component, Border border) {
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder(border);
        }
    }

    public static Border getLineStrokeBorder_SC() {
        if (f == null) {
            f = BorderFactory_SC.lineBorder_SC(ColorUtil.getPrimaryControl());
        }
        return f;
    }

    public static Border getTableBorder_SC() {
        if (g == null) {
            g = BorderFactory_SC.tableBorder_SC(1, 0, 1, 0);
        }
        return g;
    }

    public static Border getEmptyBorderForTextComponent_SC() {
        if (c == null) {
            c = BorderFactory_SC.emptyBorder_SC(10, 10, 10, 10);
        }
        return c;
    }

    public static Border getEmptyBorderForToolbar_SC() {
        if (e == null) {
            e = BorderFactory_SC.emptyBorder_SC(15);
        }
        return e;
    }

    public static Border getRightLeftDefaultRendererBorder_SC() {
        if (d == null) {
            d = BorderFactory_SC.emptyBorder_SC(0, 10, 0, 10);
        }
        return d;
    }

    public static AbstractBorder shadowBorderOutside() {
        return ShadowBorder.OUTSIDE;
    }

    public static AbstractBorder shadowBorderDown() {
        return ShadowBorder.DOWN;
    }

    public static AbstractBorder toolbarBorder() {
        if (a == null) {
            a = BorderFactory_SC.matteBorder_SC(0, 0, 1, 0, ColorUtil.b);
        }
        return a;
    }

    public static AbstractBorder toolbarShadowBorder() {
        if (b == null) {
            b = BorderFactory.createCompoundBorder(BorderFactory_SC.matteBorder_SC(0, 0, 1, 0, new Color(207, 207, 207)), BorderFactory_SC.matteBorder_SC(0, 0, 1, 0, ColorUtil.TOOLBAR_BORDER_COLOR2));
        }
        return b;
    }

    public static class UnderlineBorder
    implements Border {
        private JComponent a;

        public UnderlineBorder(JComponent jComponent) {
            this.a = jComponent;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            String string;
            Object object;
            Serializable serializable;
            int n6;
            block12: {
                block14: {
                    int n7;
                    block13: {
                        block11: {
                            n7 = ScalingUtil.b;
                            n6 = 0;
                            if (!(this.a instanceof JLabel)) break block11;
                            serializable = (JLabel)this.a;
                            object = ((JLabel)serializable).getIcon();
                            if (object != null) {
                                n6 = object.getIconWidth() + ((JLabel)serializable).getIconTextGap();
                            }
                            string = ((JLabel)serializable).getText();
                            if (n7 == 0) break block12;
                        }
                        if (!(this.a instanceof JTextComponent)) break block13;
                        string = ((JTextComponent)this.a).getText();
                        if (n7 == 0) break block12;
                    }
                    if (!(this.a instanceof AbstractButton)) break block14;
                    serializable = (AbstractButton)this.a;
                    object = ((AbstractButton)serializable).getIcon();
                    if (object != null) {
                        n6 = object.getIconWidth() + ((AbstractButton)serializable).getIconTextGap();
                    }
                    string = ((AbstractButton)serializable).getText();
                    if (n7 == 0) break block12;
                }
                throw new IllegalArgumentException();
            }
            if (!StringUtil.isEmpty(string)) {
                serializable = this.a.getForeground();
                object = this.a.getFont();
                graphics.setColor((Color)serializable);
                FontMetrics fontMetrics = this.a.getFontMetrics((Font)object);
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
                n4 = Math.min((int)rectangle2D.getWidth(), n4);
                int n8 = (int)rectangle2D.getHeight();
                n3 = n3 + n5 - (n5 - n8) / 2 - ScalingUtil.int_SC(1);
                if (graphics instanceof Graphics2D) {
                    ((Graphics2D)graphics).setStroke(UiUtil.createBasicStroke_SC(1));
                }
                graphics.drawLine(n2 + n6, n3, n2 + n4 + n6, n3);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 0);
        }
    }

    public static class UnderlineDashedBorder
    implements Border {
        private int a;

        public UnderlineDashedBorder(int n2) {
            this.a = n2;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = component.getForeground();
            graphics2D.setStroke(new BasicStroke(ScalingUtil.float_SC(2.0f), 0, 2, 0.0f, new float[]{this.a}, 0.0f));
            graphics2D.setColor(color);
            graphics2D.drawLine(0, n5, n4, n5);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return ScalingUtil.insets_SC(0, 0, 1, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

