/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.gui.util;

import com.agilemind.commons.gui.ColorThemeDescriptor;
import com.agilemind.commons.gui.util.ScalingUtil;
import com.agilemind.commons.util.MathUtil;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.plaf.scheme.ColorScheme;
import com.agilemind.utils.StyleConstants;
import java.awt.Color;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColorUtil {
    public static final ColorUIResource WHITE;
    private static final Logger a;
    public static final Color[] PREDEFINED_COLORS;
    public static final Color[] PREDEFINED_SMOOTH_COLORS;
    public static final Color EMAIL_TEMPLATE_COLOR;
    public static final Color LINK_HOVER_COLOR;
    public static final Color PROGRESS_COLOR;
    public static final Color RED_COLOR;
    public static final Color NOTIF_RED_COLOR;
    public static final Color LIGHT_YELLOW_COLOR;
    public static final Color TRANSPARENT_COLOR;
    public static final Color CHART_RANGE_COLOR;
    public static final Color CHART_LABEL_COLOR;
    public static final Color CHART_SELECTED_LABEL_COLOR;
    public static final Color LIGHT_GRAY_COLOR;
    public static final Color MENU_BACKGROUND_COLOR2;
    public static final Color GREEN_TEXT_ON_WHITE;
    public static final Color GREEN_LABEL;
    public static final Color GREEN_HOVER_LABEL;
    public static final Color GREEN_COLOR_ON_DARK;
    public static final Color TEXT_HEADER_COLOR;
    public static final Color DARK_BACKGROUND;
    public static final Color TEXT_COLOR;
    public static final Color TEXT_DESCRIPTION_COLOR;
    public static final Color DARK_SEPARATOR_COLOR;
    public static final Color STATUSBAR_BACKGROUND;
    public static final Color HINT_BACKGROUND;
    public static final Color DND_DRAGGED_BACKGROUND;
    public static final Color TOOLBAR_BORDER_COLOR2;
    public static final Color LIGHT_BORDER_COLOR;
    static final Color b;
    private static final Color c;
    private static final Color d;
    public static int f;
    private static final String[] g;

    private ColorUtil() {
    }

    public static Color getUnSelectedColor() {
        return PureLookAndFeel.getCurrentTheme().getUnSelectedColor();
    }

    public static Color getMenuBarBackground() {
        return PureLookAndFeel.getCurrentTheme().getMenuBarBackground();
    }

    public static Color getMenuForeground() {
        return PureLookAndFeel.getCurrentTheme().getMainMenuColorScheme().getForeground();
    }

    public static Color getPrimaryControl() {
        return PureLookAndFeel.getCurrentTheme().getPrimaryControl();
    }

    public static Color getMainTextColor() {
        return PureLookAndFeel.getCurrentTheme().getAcceleratorForeground();
    }

    public static Color getBackgroundColor() {
        return PureLookAndFeel.getCurrentTheme().getBackgroundColor();
    }

    public static Color getBackgroundColor2() {
        return PureLookAndFeel.getCurrentTheme().getBackgroundColor2();
    }

    public static Color getBackgroundColor3() {
        return PureLookAndFeel.getCurrentTheme().getBackgroundColor3();
    }

    public static Color getBackgroundLightColor() {
        return PureLookAndFeel.getCurrentTheme().getGradientDarkColor();
    }

    public static Color getMainComboBoxBackground() {
        return PureLookAndFeel.getCurrentTheme().getMainComboBoxScheme().getBackground();
    }

    public static Color getInactiveControlTextColor() {
        return PureLookAndFeel.getCurrentTheme().getInactiveControlTextColor();
    }

    public static Color getInactiveTextfieldColor() {
        return PureLookAndFeel.getCurrentTheme().getInactiveTextFieldColor();
    }

    public static Color getFixedColumnTableBackground() {
        return PureLookAndFeel.getCurrentTheme().getFixedColumnTableBackground();
    }

    public static Color getLinkColor() {
        return PureLookAndFeel.getCurrentTheme().getLinkColor();
    }

    public static Color getFocusColor() {
        return PureLookAndFeel.getCurrentTheme().getFocusColor();
    }

    public static Color getNotificationBackground() {
        return c;
    }

    public static Color getNotificationBorder() {
        return d;
    }

    public static Color getDarkBackgroundColor() {
        return PureLookAndFeel.getCurrentTheme().getTableHeaderSortedColor();
    }

    public static Color getControlColor() {
        return PureLookAndFeel.getCurrentTheme().getControl();
    }

    public static String getHEXColorCode(Color color) {
        int n2 = color.getRGB();
        String string = Integer.toHexString(n2);
        return "#" + string.substring(2);
    }

    public static void setDefaultColorScheme() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (!(lookAndFeel instanceof PureLookAndFeel)) {
            a.error(g[2]);
            return;
        }
        PureLookAndFeel.setCurrentTheme((ColorScheme)ColorScheme.DEFAULT);
        try {
            UIManager.setLookAndFeel(g[1]);
        }
        catch (Exception exception) {
            a.error("", (Throwable)exception);
        }
    }

    public static void updateColorScheme(ColorThemeDescriptor colorThemeDescriptor) {
        block7: {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            if (!(lookAndFeel instanceof PureLookAndFeel)) {
                a.error(g[3]);
                return;
            }
            if (colorThemeDescriptor == null || colorThemeDescriptor.getColorScheme() == PureLookAndFeel.getCurrentTheme()) break block7;
            PureLookAndFeel.setCurrentTheme((ColorScheme)colorThemeDescriptor.getColorScheme());
            try {
                UIManager.setLookAndFeel(g[4]);
            }
            catch (Exception exception) {
                a.error("", (Throwable)exception);
            }
        }
    }

    public static Color getGrayScale(Color color) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = (299 * n2 + 587 * n3 + 144 * n4) / 1030;
        return new Color(n5, n5, n5, color.getAlpha());
    }

    public static Color newAlpha(Color color, int n2) {
        assert (n2 >= 0 && n2 <= 255) : g[0] + n2;
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        return new Color(n3, n4, n5, n2);
    }

    public static Color getColor(Color color, Color color2, double d2) {
        int n2 = ColorUtil.a(color.getRed(), color2.getRed(), d2);
        int n3 = ColorUtil.a(color.getGreen(), color2.getGreen(), d2);
        int n4 = ColorUtil.a(color.getBlue(), color2.getBlue(), d2);
        return new Color(n2, n3, n4);
    }

    public static Color getColor(double d2, double d3, Color color, Color color2, double d4) {
        double d5 = MathUtil.getProportion(d2, d3, d4);
        return ColorUtil.getColor(color, color2, d5);
    }

    private static int a(int n2, int n3, double d2) {
        return (int)((double)n2 + (double)(n3 - n2) * d2);
    }

    public static String getRandomColor() {
        return Integer.toHexString(MathUtil.random(0xFFFFFF));
    }

    public static Color getColor(String string) {
        if (string.charAt(0) == '#') {
            string = string.substring(1);
        }
        return new Color(Integer.parseInt(string, 16));
    }

    public static Color getWhiterColor(Color color) {
        return ColorUtil.getBlendColor(color, Color.WHITE, 0.5f);
    }

    public static Color getDarkerColor(Color color) {
        return ColorUtil.getBlendColor(color, Color.BLACK, 0.5f);
    }

    public static Color getBlendColor(Color color, Color color2, float f2) {
        int n2 = ScalingUtil.b;
        float f3 = (float)(1.0 - (double)f2);
        float[] fArray = new float[3];
        color.getColorComponents(fArray);
        float[] fArray2 = new float[3];
        color2.getColorComponents(fArray2);
        float[] fArray3 = new float[]{fArray[0] * f2 + fArray2[0] * f3, fArray[1] * f2 + fArray2[1] * f3, fArray[2] * f2 + fArray2[2] * f3};
        Color color3 = new Color(fArray3[0], fArray3[1], fArray3[2]);
        if (n2 != 0) {
            StringUtil.f = !StringUtil.f;
        }
        return color3;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "7N>?tk";
        int n3 = -1;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block16;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 86;
                                break;
                            }
                            case 1: {
                                n9 = 34;
                                break;
                            }
                            case 2: {
                                n9 = 78;
                                break;
                            }
                            case 3: {
                                n9 = 87;
                                break;
                            }
                            default: {
                                n9 = 21;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "5M#yt1K\"2x?L*ye:C(yE#P+\u001bz9I\u000f9q\u0010G+;";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0006W<2Y9M%\u0016{2d+2yvK=92\"\u0002'9|\"";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0006W<2Y9M%\u0016{2d+2yvK=92\"\u0002'9|\"";
                    n3 = 2;
                    continue block12;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "5M#yt1K\"2x?L*ye:C(yE#P+\u001bz9I\u000f9q\u0010G+;";
                    n3 = 3;
                    continue block12;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        g = stringArray3;
        WHITE = new ColorUIResource(255, 255, 255);
        a = LoggerFactory.getLogger(ColorUtil.class);
        PREDEFINED_COLORS = new Color[]{new Color(5223680), new Color(15418112), new Color(5472740), new Color(16026624), new Color(3381404), new Color(4208623), new Color(9455334), new Color(16108588), new Color(6038025), new Color(33280), new Color(0x4A4A4A), new Color(9878009), new Color(1245311), new Color(4835529), new Color(12845255), new Color(0x7D7D7D), new Color(12575789), new Color(12814445), new Color(7539854), new Color(3156087), new Color(13179470), new Color(4116093), new Color(15835366), new Color(9431530)};
        PREDEFINED_SMOOTH_COLORS = new Color[]{new Color(16169381), new Color(12379040), new Color(12570867), new Color(14333657), new Color(16438179), new Color(16509622), new Color(14599676), new Color(13351604), new Color(11917747), new Color(12170199), new Color(12380640), new Color(15513325), new Color(0xD7D7D7), new Color(12632021), new Color(15645642), new Color(13103321)};
        EMAIL_TEMPLATE_COLOR = new Color(250, 250, 250);
        LINK_HOVER_COLOR = new Color(4490958);
        PROGRESS_COLOR = new Color(7772872);
        RED_COLOR = new Color(16138240);
        NOTIF_RED_COLOR = new Color(222, 88, 57);
        LIGHT_YELLOW_COLOR = new Color(16775915);
        TRANSPARENT_COLOR = new Color(255, 255, 255, 0);
        CHART_RANGE_COLOR = new Color(230, 230, 230);
        CHART_LABEL_COLOR = new Color(172, 172, 172);
        CHART_SELECTED_LABEL_COLOR = new Color(52, 59, 73);
        LIGHT_GRAY_COLOR = new Color(245, 245, 245);
        MENU_BACKGROUND_COLOR2 = new Color(63, 70, 84);
        GREEN_TEXT_ON_WHITE = StyleConstants.GREEN_TEXT_ON_WHITE;
        GREEN_LABEL = new ColorUIResource(100, 165, 49);
        GREEN_HOVER_LABEL = new ColorUIResource(83, 148, 49);
        TEXT_HEADER_COLOR = GREEN_COLOR_ON_DARK = StyleConstants.TEXT_SELECTED_COLOR;
        DARK_BACKGROUND = StyleConstants.DARK_BACKGROUND2;
        TEXT_COLOR = StyleConstants.TEXT_COLOR;
        TEXT_DESCRIPTION_COLOR = StyleConstants.TEXT_DESCRIPTION_COLOR;
        DARK_SEPARATOR_COLOR = StyleConstants.DARK_MENU_SELECTED_BACKGROUND;
        STATUSBAR_BACKGROUND = new Color(31, 37, 48);
        HINT_BACKGROUND = new Color(242, 252, 228);
        DND_DRAGGED_BACKGROUND = new Color(220, 220, 220);
        TOOLBAR_BORDER_COLOR2 = new Color(195, 195, 195);
        LIGHT_BORDER_COLOR = new Color(225, 225, 225);
        b = new Color(215, 215, 215);
        c = new Color(255, 251, 237);
        d = new Color(226, 214, 178);
    }
}

