/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.gui.util;

import com.agilemind.commons.gui.util.BorderUtil;
import com.agilemind.commons.gui.util.ColorUtil;
import com.agilemind.commons.gui.util.ScalingUtil;
import com.agilemind.utils.LafUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public final class FontUtil {
    private static Font a;
    private static Font b;
    private static Font c;
    private static final String[] d;

    private FontUtil() {
    }

    public static Font getWizardHeaderFont() {
        return UIManager.getDefaults().getFont(d[0]).deriveFont(1, ScalingUtil.int_SC(16));
    }

    public static void setUnderline(JComponent jComponent) {
        FontUtil.setUnderline(jComponent, jComponent.getFont());
    }

    public static void setUnderline(JComponent jComponent, Font font) {
        FontUtil.setUnderline(jComponent, font, ColorUtil.getLinkColor());
    }

    public static void setUnderline(JComponent jComponent, Font font, Color color) {
        jComponent.setFont(font);
        jComponent.setForeground(color);
        jComponent.setOpaque(false);
        jComponent.setBorder(new BorderUtil.UnderlineBorder(jComponent));
    }

    public static void setRequired(Component component) {
        FontUtil.setBold(component);
    }

    public static <T extends Component> T bold(T t2) {
        FontUtil.setBold(t2);
        return t2;
    }

    public static void setBold(Component component) {
        FontUtil.setBold(component, true);
    }

    public static void setBold(Component component, boolean bl) {
        FontUtil.deriveFont(component, bl ? 1 : 0);
    }

    public static <T extends Component> T italic(T t2) {
        FontUtil.setItalic(t2, true);
        return t2;
    }

    public static void setItalic(Component component) {
        FontUtil.setItalic(component, true);
    }

    public static void setItalic(Component component, boolean bl) {
        FontUtil.deriveFont(component, bl ? 2 : 0);
    }

    public static void deriveFont(Component component, int n2) {
        component.setFont(component.getFont().deriveFont(n2));
    }

    public static <C extends Component> C fontSize(C c2, float f2) {
        c2.setFont(c2.getFont().deriveFont(f2));
        return c2;
    }

    public static <C extends Component> C multSize(C c2, float f2) {
        Font font = c2.getFont();
        c2.setFont(font.deriveFont(font.getSize2D() * f2));
        return c2;
    }

    public static void setFontSize(Component component, float f2) {
        component.setFont(component.getFont().deriveFont(f2));
    }

    public static int getTextWidth(String string, Font font) {
        AffineTransform affineTransform = new AffineTransform();
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, true, true);
        return (int)font.getStringBounds(string, fontRenderContext).getWidth();
    }

    public static int getTextWidth(String string, Component component) {
        return SwingUtilities.computeStringWidth(component.getFontMetrics(component.getFont()), string);
    }

    @NotNull
    public static List<String> getSuitableFontNames() {
        int n2 = ScalingUtil.b;
        ArrayList<String> arrayList = new ArrayList<String>();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String string : graphicsEnvironment.getAvailableFontFamilyNames()) {
            Font font = new Font(string, 0, 0);
            if (!font.canDisplay('a') || FontUtil.isBold(font) || FontUtil.isItalic(font)) continue;
            arrayList.add(string);
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    public static boolean isBold(Font font) {
        String string = font.getFontName(Locale.ENGLISH).toLowerCase();
        if (string.contains(d[4])) {
            return true;
        }
        String string2 = font.getPSName().toLowerCase();
        return string2.contains(d[5]);
    }

    public static boolean isItalic(Font font) {
        String string = font.getFontName(Locale.ENGLISH).toLowerCase();
        if (string.contains(d[7]) || string.contains(d[6])) {
            return true;
        }
        String string2 = font.getPSName().toLowerCase();
        return string2.contains(d[8]) || string2.contains(d[9]);
    }

    public static Font getNotifyFont() {
        if (a == null) {
            a = ScalingUtil.font_SC(d[2], 1, 14);
        }
        return a;
    }

    public static Font getChartSliderFont() {
        if (b == null) {
            b = ScalingUtil.font_SC(d[3], 0, 10);
        }
        return b;
    }

    public static Font getSubFont() {
        if (c == null) {
            c = ScalingUtil.font_SC(d[1], 0, 9);
        }
        return c;
    }

    public static int getDefaultFontSize() {
        return LafUtils.getDefaultFontSize();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "Qe\"\rK3b/\u0006S";
        int n3 = -1;
        block17: while (true) {
            char[] cArray;
            block22: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block21: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block21;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block22;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 29;
                                break;
                            }
                            case 1: {
                                n9 = 4;
                                break;
                            }
                            case 2: {
                                n9 = 64;
                                break;
                            }
                            case 3: {
                                n9 = 104;
                                break;
                            }
                            default: {
                                n9 = 39;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\\v)\tK";
                    n3 = 0;
                    continue block17;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\\v)\tK";
                    n3 = 1;
                    continue block17;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\\v)\tK";
                    n3 = 2;
                    continue block17;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u007fk,\f";
                    n3 = 3;
                    continue block17;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u007fk,\f";
                    n3 = 4;
                    continue block17;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "rf,\u0001Vha";
                    n3 = 5;
                    continue block17;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "tp!\u0004N~";
                    n3 = 6;
                    continue block17;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "tp!\u0004N~";
                    n3 = 7;
                    continue block17;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "rf,\u0001Vha";
                    n3 = 8;
                    continue block17;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        d = stringArray3;
    }
}

