/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.gui.util;

import com.agilemind.commons.gui.util.ScalingUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;

public final class ImageUtil {
    private ImageUtil() {
    }

    public static BufferedImage toBufferedImage(Image image) {
        Object object;
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        if (n2 <= 0 || n3 <= 0) {
            object = new ImageIcon(image);
            n2 = ((ImageIcon)object).getIconWidth();
            n3 = ((ImageIcon)object).getIconHeight();
        }
        object = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return object;
    }

    public static BufferedImage scaleSmooth(BufferedImage bufferedImage, int n2, int n3) {
        return ImageUtil.toBufferedImage(ImageUtil.a(bufferedImage, n2, n3, 4));
    }

    public static Image scaleIfNeeded(Image image, int n2, int n3) {
        return ImageUtil.a(image, n2, n3, 1);
    }

    private static Image a(Image image, int n2, int n3, int n4) {
        if (image != null) {
            float f2;
            int n5 = image.getWidth(null);
            int n6 = image.getHeight(null);
            if (n5 > n2) {
                f2 = (float)n5 / (float)n2;
                n5 = n2;
                n6 = (int)((float)n6 / f2);
                image = image.getScaledInstance(n5, n6, n4);
            }
            if (n6 > n3) {
                f2 = (float)n6 / (float)n3;
                n6 = n3;
                n5 = (int)((float)n5 / f2);
                image = image.getScaledInstance(n5, n6, n4);
            }
        }
        return image;
    }

    public static BufferedImage cropImage(BufferedImage bufferedImage, int n2, int n3) {
        block5: {
            double d2;
            int n4;
            int n5;
            block4: {
                n5 = bufferedImage.getHeight();
                n4 = bufferedImage.getWidth();
                if (n5 <= n3 && n4 <= n2) {
                    return bufferedImage;
                }
                d2 = (double)n3 / (double)n5;
                double d3 = (double)n2 / (double)n4;
                if (!(d2 >= d3)) break block4;
                n2 = (int)((double)n4 * d3 + 1.0);
                n3 = (int)((double)n5 * d3 + 1.0);
                if (ScalingUtil.b == 0) break block5;
            }
            n2 = (int)((double)n4 * d2 + 1.0);
            n3 = (int)((double)n5 * d2 + 1.0);
        }
        return ImageUtil.a(bufferedImage, n2, n3);
    }

    private static BufferedImage a(Image image, int n2, int n3) {
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2D.drawImage(image, 0, 0, n2, n3, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Image mergeImages(Image image, Image image2, ImageObserver imageObserver) {
        int n2 = image.getWidth(imageObserver);
        int n3 = image.getHeight(imageObserver);
        int n4 = image2.getWidth(imageObserver);
        int n5 = image2.getHeight(imageObserver);
        BufferedImage bufferedImage = new BufferedImage(n2 + n4, Math.max(n3, n5), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, n2, n3, imageObserver);
        graphics2D.drawImage(image2, n2, 0, n4, n5, imageObserver);
        return bufferedImage;
    }

    public static BufferedImage fastScale(Image image, int n2, int n3) {
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        ImageObserver imageObserver = null;
        AffineTransform affineTransform = AffineTransform.getScaleInstance((double)n2 / (double)image.getWidth(imageObserver), (double)n3 / (double)image.getHeight(imageObserver));
        graphics2D.drawImage(image, affineTransform, imageObserver);
        return bufferedImage;
    }
}

