/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io;

import com.agilemind.commons.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;

public class CopyUtils {
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    private CopyUtils() {
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        boolean bl = IOUtils.b;
        byte[] byArray = new byte[4096];
        int n3 = 0;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            n3 += n2;
            if (!bl) continue;
        }
        return n3;
    }

    public static int copyAndClose(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int n2 = CopyUtils.copy(inputStream, outputStream);
            return n2;
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    public static void copyAndClose(String string, OutputStream outputStream) throws IOException {
        try {
            CopyUtils.copy(string, outputStream);
        }
        finally {
            outputStream.close();
        }
    }

    public static int copy(Reader reader, Writer writer) throws IOException {
        int n2;
        boolean bl = IOUtils.b;
        char[] cArray = new char[4096];
        int n3 = 0;
        while ((n2 = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n2);
            n3 += n2;
            if (!bl) continue;
        }
        return n3;
    }

    public static void copy(InputStream inputStream, Writer writer) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        CopyUtils.copy(inputStreamReader, writer);
    }

    public static void copy(InputStream inputStream, Writer writer, String string) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        CopyUtils.copy(inputStreamReader, writer);
    }

    public static void copy(String string, OutputStream outputStream) throws IOException {
        StringReader stringReader = new StringReader(string);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        CopyUtils.copy(stringReader, (Writer)outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static void temporaryCopy(File file, File file2) throws IOException {
        CopyUtils.copy(file, file2);
        file2.deleteOnExit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copy(File file, File file2) throws IOException {
        FileInputStream fileInputStream;
        block30: {
            boolean bl = IOUtils.b;
            fileInputStream = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                Throwable throwable2 = null;
                try {
                    CopyUtils.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    block29: {
                        if (fileOutputStream != null) {
                            if (throwable2 != null) {
                                try {
                                    fileOutputStream.close();
                                    break block29;
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                    if (!bl) break block29;
                                }
                            }
                            fileOutputStream.close();
                        }
                    }
                }
                if (fileInputStream == null) return;
                if (throwable == null) break block30;
            }
            catch (Throwable throwable5) {
                try {
                    throwable = throwable5;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    throw throwable6;
                }
                finally {
                    block31: {
                        if (fileInputStream != null) {
                            if (throwable != null) {
                                try {
                                    fileInputStream.close();
                                    break block31;
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                    if (!bl) break block31;
                                }
                            }
                            fileInputStream.close();
                        }
                    }
                }
            }
            try {
                fileInputStream.close();
                return;
            }
            catch (Throwable throwable8) {
                throwable.addSuppressed(throwable8);
                return;
            }
        }
        fileInputStream.close();
    }

    public static long copySome(InputStream inputStream, OutputStream outputStream, byte[] byArray, long l2) throws IOException {
        int n2;
        boolean bl = IOUtils.b;
        int n3 = Math.min((int)l2, byArray.length);
        long l3 = 0L;
        while (n3 != 0 && (n2 = inputStream.read(byArray, 0, n3)) != -1) {
            outputStream.write(byArray, 0, n2);
            n3 = Math.min((int)(l2 - (l3 += (long)n2)), byArray.length);
            if (!bl) continue;
        }
        return l3;
    }

    public static long copySome(InputStream inputStream, OutputStream outputStream, int n2, long l2) throws IOException {
        return CopyUtils.copySome(inputStream, outputStream, new byte[n2], l2);
    }

    public static long copySome(InputStream inputStream, OutputStream outputStream, long l2) throws IOException {
        return CopyUtils.copySome(inputStream, outputStream, 4096, l2);
    }
}

