/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io;

import com.agilemind.commons.io.CopyUtils;
import com.agilemind.commons.io.ReadContentTimeoutException;
import com.agilemind.commons.io.a;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.Util;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class IOUtils {
    public static final int NO_TIMEOUT = 0;
    public static boolean b;
    private static final String[] c;

    private IOUtils() {
    }

    public static void copyFolder(File file, File file2, boolean bl) throws IOException {
        if (file.exists()) {
            IOUtils.a(file, file2, false, bl, null);
        }
    }

    public static void copyFolder(File file, File file2, boolean bl, FilenameFilter filenameFilter) throws IOException {
        if (file.exists()) {
            IOUtils.a(file, file2, false, bl, filenameFilter);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream;
        block32: {
            boolean bl = b;
            fileInputStream = new FileInputStream(file);
            Throwable throwable = null;
            try {
                block29: {
                    FileOutputStream fileOutputStream;
                    block30: {
                        fileOutputStream = new FileOutputStream(file2);
                        Throwable throwable2 = null;
                        try {
                            int n2;
                            byte[] byArray = new byte[1024];
                            while ((n2 = ((InputStream)fileInputStream).read(byArray)) > 0) {
                                ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                                if (!bl) continue;
                            }
                            if (fileOutputStream == null) break block29;
                            if (throwable2 == null) break block30;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throw throwable4;
                            }
                            finally {
                                block31: {
                                    if (fileOutputStream != null) {
                                        if (throwable2 != null) {
                                            try {
                                                ((OutputStream)fileOutputStream).close();
                                                break block31;
                                            }
                                            catch (Throwable throwable5) {
                                                throwable2.addSuppressed(throwable5);
                                                if (!bl) break block31;
                                            }
                                        }
                                        ((OutputStream)fileOutputStream).close();
                                    }
                                }
                            }
                        }
                        try {
                            ((OutputStream)fileOutputStream).close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                        break block29;
                    }
                    ((OutputStream)fileOutputStream).close();
                }
                if (fileInputStream == null) return true;
                if (throwable == null) break block32;
            }
            catch (Throwable throwable7) {
                try {
                    throwable = throwable7;
                    throw throwable7;
                }
                catch (Throwable throwable8) {
                    throw throwable8;
                }
                finally {
                    block33: {
                        if (fileInputStream != null) {
                            if (throwable != null) {
                                try {
                                    ((InputStream)fileInputStream).close();
                                    break block33;
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                    if (!bl) break block33;
                                }
                            }
                            ((InputStream)fileInputStream).close();
                        }
                    }
                }
            }
            try {
                ((InputStream)fileInputStream).close();
                return true;
            }
            catch (Throwable throwable10) {
                throwable.addSuppressed(throwable10);
                return true;
            }
        }
        ((InputStream)fileInputStream).close();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void a(File file, File file2, boolean bl, boolean bl2, FilenameFilter filenameFilter) throws IOException {
        File[] fileArray;
        boolean bl3 = b;
        if (!file.exists()) return;
        if (!file2.exists()) {
            file2.mkdirs();
            if (bl2) {
                file2.deleteOnExit();
            }
        }
        for (File file3 : fileArray = filenameFilter != null ? file.listFiles(filenameFilter) : file.listFiles()) {
            File file4 = new File(file2, file3.getName());
            if (file3.isDirectory()) {
                file4.mkdir();
                if (bl2) {
                    file4.deleteOnExit();
                }
                IOUtils.a(file3, file4, bl, bl2, filenameFilter);
                if (!bl3) continue;
            }
            if (bl) {
                file3.renameTo(file4);
                if (!bl3) continue;
            }
            if (bl2) {
                CopyUtils.temporaryCopy(file3, file4);
                if (!bl3) continue;
            }
            CopyUtils.copy(file3, file4);
            if (!bl3) continue;
        }
        if (!bl) return;
        file.delete();
    }

    public static boolean recursiveDelete(File file) {
        boolean bl = b;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    IOUtils.recursiveDelete(file2);
                    if (!bl) continue;
                }
                boolean bl2 = file2.delete();
                if (bl2) continue;
                System.err.println(c[1] + file2.getAbsolutePath());
            }
        }
        return file.delete();
    }

    public static boolean copyResourcesRecursively(URL uRL, File file, FilenameFilter filenameFilter, boolean bl) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof JarURLConnection) {
            return IOUtils.a(file, (JarURLConnection)uRLConnection, filenameFilter, bl);
        }
        return IOUtils.a(new File(uRL.getPath()), file, filenameFilter, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean a(File file, JarURLConnection jarURLConnection, FilenameFilter filenameFilter, boolean bl) throws IOException {
        boolean bl2 = b;
        JarFile jarFile = jarURLConnection.getJarFile();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        do {
            if (!enumeration.hasMoreElements()) return true;
            JarEntry jarEntry = enumeration.nextElement();
            if (!jarEntry.getName().startsWith(jarURLConnection.getEntryName())) continue;
            String string = StringUtils.removeStart((String)jarEntry.getName(), (String)jarURLConnection.getEntryName());
            File file2 = new File(file, string);
            if (bl) {
                file2.deleteOnExit();
            }
            if (!jarEntry.isDirectory() && filenameFilter.accept(file2, file2.getName())) {
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                Throwable throwable = null;
                try {
                    if (!IOUtils.a(inputStream, file2)) {
                        boolean bl3 = false;
                        return bl3;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    block29: {
                        if (inputStream != null) {
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                    break block29;
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                    if (!bl2) break block29;
                                }
                            }
                            inputStream.close();
                        }
                    }
                }
                if (!bl2) continue;
            }
            if (file2.exists() || file2.mkdir()) continue;
            return false;
        } while (!bl2);
        return true;
    }

    private static boolean a(File file, File file2, FilenameFilter filenameFilter, boolean bl) throws IOException {
        block22: {
            block23: {
                block21: {
                    block20: {
                        boolean bl2 = b;
                        if (a || file2.isDirectory()) break block20;
                        throw new AssertionError();
                    }
                    if (file.isDirectory()) break block21;
                    if (!filenameFilter.accept(file, file.getName())) break block22;
                    File file3 = new File(file2, file.getName());
                    if (bl) {
                        file3.deleteOnExit();
                    }
                    return IOUtils.copyFile(file, file3);
                }
                if (file2.exists() || file2.mkdir()) break block23;
                return false;
            }
            if (bl) {
                file2.deleteOnExit();
            }
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file4 : fileArray) {
                    if (IOUtils.a(file4, file2, filenameFilter, bl)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean a(InputStream inputStream, File file) throws IOException {
        return IOUtils.a(inputStream, new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean a(InputStream inputStream, OutputStream outputStream) throws IOException {
        boolean bl = b;
        try {
            int n2;
            byte[] byArray = new byte[1024];
            while ((n2 = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n2);
                if (!bl) continue;
                break;
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
        return true;
    }

    public static File createFile(File file, String ... stringArray) {
        for (String string : stringArray) {
            file = new File(file, string);
        }
        return file;
    }

    public static String load(String string) throws IOException {
        return IOUtils.load(new File(string));
    }

    public static String load(File file) throws IOException {
        return IOUtils.load(file, null);
    }

    public static String loadFromUTF8(File file) throws IOException {
        return IOUtils.load(file, c[10]);
    }

    public static String loadFromUTF8(InputStream inputStream) throws IOException {
        return IOUtils.load(inputStream, c[17]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String load(File file, String string) throws IOException {
        String string2;
        if (file.length() > Integer.MAX_VALUE) {
            throw new IOException(c[19]);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            string2 = IOUtils.load(fileInputStream, string);
        }
        catch (Throwable throwable) {
            if (fileInputStream == null) throw throwable;
            fileInputStream.close();
            throw throwable;
        }
        if (fileInputStream == null) return string2;
        fileInputStream.close();
        return string2;
    }

    public static String load(InputStream inputStream) throws IOException {
        return IOUtils.load(inputStream, null);
    }

    public static String load(InputStream inputStream, String string) throws IOException {
        String string2;
        block6: {
            ByteArrayOutputStream byteArrayOutputStream;
            block5: {
                int n2;
                boolean bl = b;
                byteArrayOutputStream = new ByteArrayOutputStream();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                byte[] byArray = new byte[8192];
                while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                    if (!bl) continue;
                    boolean bl2 = StringUtil.f = !StringUtil.f;
                }
                if (!StringUtil.isEmpty(string)) break block5;
                string2 = new String(byteArrayOutputStream.toByteArray());
                if (!bl) break block6;
            }
            string2 = new String(byteArrayOutputStream.toByteArray(), string);
        }
        return string2;
    }

    public static List<String> loadLines(File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        IOUtils.loadLines(file, new a(arrayList));
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadLines(File file, LineAcceptor lineAcceptor) throws IOException {
        BufferedReader bufferedReader;
        block15: {
            boolean bl = b;
            bufferedReader = new BufferedReader(new FileReader(file));
            Throwable throwable = null;
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    lineAcceptor.accept(string);
                    if (!bl) continue;
                }
                if (bufferedReader == null) return;
                if (throwable == null) break block15;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    block16: {
                        if (bufferedReader != null) {
                            if (throwable != null) {
                                try {
                                    bufferedReader.close();
                                    break block16;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    if (!bl) break block16;
                                }
                            }
                            bufferedReader.close();
                        }
                    }
                }
            }
            try {
                bufferedReader.close();
                return;
            }
            catch (Throwable throwable5) {
                throwable.addSuppressed(throwable5);
                return;
            }
        }
        bufferedReader.close();
    }

    public static void save2UTF8(File file, String string) throws IOException {
        IOUtils.save(file, string, c[2]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void save(File file, String string, String string2) throws IOException {
        boolean bl = b;
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists()) {
            file2.mkdirs();
        }
        Writer writer = IOUtils.createWriter(file, string2);
        Throwable throwable = null;
        try {
            writer.write(string);
            return;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            block17: {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                            break block17;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                            if (!bl) break block17;
                        }
                    }
                    writer.close();
                }
            }
        }
    }

    public static Writer createWriter(File file, String string) throws IOException {
        BufferedWriter bufferedWriter;
        block3: {
            block2: {
                if (!StringUtil.isEmpty(string)) break block2;
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                if (!b) break block3;
            }
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string));
        }
        return bufferedWriter;
    }

    public static File createRandomFile(File file, String string) {
        return IOUtils.createRandomFile(file, null, string);
    }

    public static File createRandomFile(File file, String string, String string2) {
        File file2;
        block8: {
            boolean bl;
            block10: {
                block9: {
                    File file3;
                    File file4;
                    boolean bl2 = b;
                    do {
                        File file5;
                        String string3 = StringUtil.createRandomSignature(8);
                        if (!StringUtil.isEmpty(string)) {
                            string3 = string + string3;
                        }
                        File file6 = file5;
                        file3 = file5;
                        File file7 = file;
                        StringBuilder stringBuilder = new StringBuilder().append(string3);
                        String string4 = StringUtil.isEmpty(string2) ? "" : '.' + string2;
                        file6(file7, stringBuilder.append(string4).toString());
                    } while ((file4 = file3).exists());
                    file2 = file4;
                    if (!StringUtil.f) break block8;
                    if (!bl2) break block9;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
            b = bl;
        }
        return file2;
    }

    public static File createRandomFolder(File file) {
        File file2 = IOUtils.createRandomFile(file, null);
        if (!file2.mkdirs()) {
            System.err.println(c[12] + file.getAbsolutePath());
        }
        return file2;
    }

    public static void zipFolder(File file, File file2) throws IOException {
        IOUtils.zipFolder(file, new File[]{file2});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zipFolder(File file, File[] fileArray) throws IOException {
        FileOutputStream fileOutputStream;
        block30: {
            boolean bl = b;
            fileOutputStream = new FileOutputStream(file);
            Throwable throwable = null;
            try {
                block27: {
                    ZipOutputStream zipOutputStream;
                    block28: {
                        zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
                        Throwable throwable2 = null;
                        try {
                            byte[] byArray = new byte[2048];
                            IOUtils.a(fileArray, null, zipOutputStream, byArray);
                            if (zipOutputStream == null) break block27;
                            if (throwable2 == null) break block28;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throw throwable4;
                            }
                            finally {
                                block29: {
                                    if (zipOutputStream != null) {
                                        if (throwable2 != null) {
                                            try {
                                                zipOutputStream.close();
                                                break block29;
                                            }
                                            catch (Throwable throwable5) {
                                                throwable2.addSuppressed(throwable5);
                                                if (!bl) break block29;
                                            }
                                        }
                                        zipOutputStream.close();
                                    }
                                }
                            }
                        }
                        try {
                            zipOutputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                        break block27;
                    }
                    zipOutputStream.close();
                }
                if (fileOutputStream == null) return;
                if (throwable == null) break block30;
            }
            catch (Throwable throwable7) {
                try {
                    throwable = throwable7;
                    throw throwable7;
                }
                catch (Throwable throwable8) {
                    throw throwable8;
                }
                finally {
                    block31: {
                        if (fileOutputStream != null) {
                            if (throwable != null) {
                                try {
                                    fileOutputStream.close();
                                    break block31;
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                    if (!bl) break block31;
                                }
                            }
                            fileOutputStream.close();
                        }
                    }
                }
            }
            try {
                fileOutputStream.close();
                return;
            }
            catch (Throwable throwable10) {
                throwable.addSuppressed(throwable10);
                return;
            }
        }
        fileOutputStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void a(File[] fileArray, File file, ZipOutputStream zipOutputStream, byte[] byArray) throws IOException {
        boolean bl = b;
        if (fileArray == null) return;
        File[] fileArray2 = fileArray;
        int n2 = fileArray2.length;
        int n3 = 0;
        do {
            block34: {
                FileInputStream fileInputStream;
                block35: {
                    File file2;
                    block37: {
                        if (n3 >= n2) return;
                        file2 = fileArray2[n3];
                        if (!file2.isDirectory()) break block37;
                        IOUtils.a(file2.listFiles(), new File(file, file2.getName()), zipOutputStream, byArray);
                        if (!bl) break block34;
                    }
                    fileInputStream = new FileInputStream(file2);
                    Throwable throwable = null;
                    try {
                        block31: {
                            BufferedInputStream bufferedInputStream;
                            block32: {
                                bufferedInputStream = new BufferedInputStream(fileInputStream, 2048);
                                Throwable throwable2 = null;
                                try {
                                    int n4;
                                    ZipEntry zipEntry = new ZipEntry(new File(file, file2.getName()).toString());
                                    zipEntry.setTime(file2.lastModified());
                                    zipOutputStream.putNextEntry(zipEntry);
                                    while ((n4 = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                                        zipOutputStream.write(byArray, 0, n4);
                                        if (!bl) continue;
                                    }
                                    if (bufferedInputStream == null) break block31;
                                    if (throwable2 == null) break block32;
                                }
                                catch (Throwable throwable3) {
                                    try {
                                        throwable2 = throwable3;
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throw throwable4;
                                    }
                                    finally {
                                        block33: {
                                            if (bufferedInputStream != null) {
                                                if (throwable2 != null) {
                                                    try {
                                                        bufferedInputStream.close();
                                                        break block33;
                                                    }
                                                    catch (Throwable throwable5) {
                                                        throwable2.addSuppressed(throwable5);
                                                        if (!bl) break block33;
                                                    }
                                                }
                                                bufferedInputStream.close();
                                            }
                                        }
                                    }
                                }
                                try {
                                    bufferedInputStream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                                break block31;
                            }
                            bufferedInputStream.close();
                        }
                        if (fileInputStream == null) break block34;
                        if (throwable == null) break block35;
                    }
                    catch (Throwable throwable7) {
                        try {
                            throwable = throwable7;
                            throw throwable7;
                        }
                        catch (Throwable throwable8) {
                            throw throwable8;
                        }
                        finally {
                            block36: {
                                if (fileInputStream != null) {
                                    if (throwable != null) {
                                        try {
                                            fileInputStream.close();
                                            break block36;
                                        }
                                        catch (Throwable throwable9) {
                                            throwable.addSuppressed(throwable9);
                                            if (!bl) break block36;
                                        }
                                    }
                                    fileInputStream.close();
                                }
                            }
                        }
                    }
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable10) {
                        throwable.addSuppressed(throwable10);
                    }
                    break block34;
                }
                fileInputStream.close();
            }
            ++n3;
        } while (!bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zipFile(File file, File file2) throws IOException {
        FileOutputStream fileOutputStream;
        block30: {
            boolean bl = b;
            fileOutputStream = new FileOutputStream(file2);
            Throwable throwable = null;
            try {
                ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
                Throwable throwable2 = null;
                try {
                    IOUtils.a(zipOutputStream, file);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    block29: {
                        if (zipOutputStream != null) {
                            if (throwable2 != null) {
                                try {
                                    zipOutputStream.close();
                                    break block29;
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                    if (!bl) break block29;
                                }
                            }
                            zipOutputStream.close();
                        }
                    }
                }
                if (fileOutputStream == null) return;
                if (throwable == null) break block30;
            }
            catch (Throwable throwable5) {
                try {
                    throwable = throwable5;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    throw throwable6;
                }
                finally {
                    block31: {
                        if (fileOutputStream != null) {
                            if (throwable != null) {
                                try {
                                    fileOutputStream.close();
                                    break block31;
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                    if (!bl) break block31;
                                }
                            }
                            fileOutputStream.close();
                        }
                    }
                }
            }
            try {
                fileOutputStream.close();
                return;
            }
            catch (Throwable throwable8) {
                throwable.addSuppressed(throwable8);
                return;
            }
        }
        fileOutputStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void a(ZipOutputStream zipOutputStream, File file) throws IOException {
        FileInputStream fileInputStream;
        block15: {
            boolean bl = b;
            fileInputStream = new FileInputStream(file);
            Throwable throwable = null;
            try {
                int n2;
                ZipEntry zipEntry = new ZipEntry(file.getName());
                zipOutputStream.putNextEntry(zipEntry);
                byte[] byArray = new byte[2048];
                while ((n2 = fileInputStream.read(byArray)) > 0) {
                    zipOutputStream.write(byArray, 0, n2);
                    if (!bl) continue;
                }
                if (fileInputStream == null) return;
                if (throwable == null) break block15;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    block16: {
                        if (fileInputStream != null) {
                            if (throwable != null) {
                                try {
                                    fileInputStream.close();
                                    break block16;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    if (!bl) break block16;
                                }
                            }
                            fileInputStream.close();
                        }
                    }
                }
            }
            try {
                fileInputStream.close();
                return;
            }
            catch (Throwable throwable5) {
                throwable.addSuppressed(throwable5);
                return;
            }
        }
        fileInputStream.close();
    }

    public static void unzip(InputStream inputStream, OutputStream outputStream) throws IOException {
        boolean bl = b;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (zipEntry != null) {
            int n2;
            byte[] byArray = new byte[2048];
            while ((n2 = zipInputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n2);
                if (!bl) continue;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzipFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream;
        block30: {
            boolean bl = b;
            fileInputStream = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                Throwable throwable2 = null;
                try {
                    IOUtils.unzip(fileInputStream, fileOutputStream);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    block29: {
                        if (fileOutputStream != null) {
                            if (throwable2 != null) {
                                try {
                                    fileOutputStream.close();
                                    break block29;
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                    if (!bl) break block29;
                                }
                            }
                            fileOutputStream.close();
                        }
                    }
                }
                if (fileInputStream == null) return;
                if (throwable == null) break block30;
            }
            catch (Throwable throwable5) {
                try {
                    throwable = throwable5;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    throw throwable6;
                }
                finally {
                    block31: {
                        if (fileInputStream != null) {
                            if (throwable != null) {
                                try {
                                    fileInputStream.close();
                                    break block31;
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                    if (!bl) break block31;
                                }
                            }
                            fileInputStream.close();
                        }
                    }
                }
            }
            try {
                fileInputStream.close();
                return;
            }
            catch (Throwable throwable8) {
                throwable.addSuppressed(throwable8);
                return;
            }
        }
        fileInputStream.close();
    }

    public static boolean isZipFile(File file) throws IOException {
        if (file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            throw new IOException(c[18] + file.getAbsolutePath());
        }
        if (file.length() < 4L) {
            return false;
        }
        return IOUtils.isZipStream(new FileInputStream(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isZipStream(InputStream inputStream) throws IOException {
        boolean bl;
        DataInputStream dataInputStream;
        block16: {
            boolean bl2 = b;
            dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            Throwable throwable = null;
            try {
                int n2 = dataInputStream.readInt();
                dataInputStream.close();
                bl = n2 == 1347093252;
                if (dataInputStream == null) return bl;
                if (throwable == null) break block16;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    block17: {
                        if (dataInputStream != null) {
                            if (throwable != null) {
                                try {
                                    dataInputStream.close();
                                    break block17;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    if (!bl2) break block17;
                                }
                            }
                            dataInputStream.close();
                        }
                    }
                }
            }
            try {
                dataInputStream.close();
                return bl;
            }
            catch (Throwable throwable5) {
                throwable.addSuppressed(throwable5);
                if (!bl2) return bl;
            }
        }
        dataInputStream.close();
        return bl;
    }

    public static boolean isGzip(byte[] byArray) {
        boolean bl;
        block8: {
            block7: {
                if (byArray.length < 2) {
                    return false;
                }
                if (byArray[0] != 31 || byArray[1] != -117) break block7;
                bl = true;
                break block8;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String ungzip(String string, String string2) throws IOException, InterruptedException {
        String string3;
        GZIPInputStream gZIPInputStream;
        block15: {
            boolean bl = b;
            gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(string.getBytes(string2)));
            Throwable throwable = null;
            try {
                string3 = IOUtils.readString(gZIPInputStream, string2);
                if (gZIPInputStream == null) return string3;
                if (throwable == null) break block15;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    block16: {
                        if (gZIPInputStream != null) {
                            if (throwable != null) {
                                try {
                                    gZIPInputStream.close();
                                    break block16;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    if (!bl) break block16;
                                }
                            }
                            gZIPInputStream.close();
                        }
                    }
                }
            }
            try {
                gZIPInputStream.close();
                return string3;
            }
            catch (Throwable throwable5) {
                throwable.addSuppressed(throwable5);
                if (!bl) return string3;
            }
        }
        gZIPInputStream.close();
        return string3;
    }

    public static void deleteFolder(File file) throws IOException {
        IOUtils.recursiveDelete(file);
        if (file.exists()) {
            throw new IOException(c[11] + file.getAbsolutePath() + '\"');
        }
    }

    public static IOException throwIOException(Throwable throwable) {
        return new IOException(throwable);
    }

    public static List<File> recursiveListFiles(File file, String ... stringArray) {
        boolean bl = b;
        ArrayList<File> arrayList = new ArrayList<File>();
        block10: for (File file2 : file.listFiles()) {
            block13: {
                if (file2.isDirectory()) {
                    arrayList.addAll(IOUtils.recursiveListFiles(file2, stringArray));
                    if (!bl) continue;
                }
                if (stringArray.length != 0) break block13;
                arrayList.add(file2);
                if (!bl) continue;
            }
            for (String string : stringArray) {
                if (!file2.getName().toLowerCase().endsWith(string.toLowerCase())) continue;
                arrayList.add(file2);
                if (!bl) continue block10;
            }
            if (!bl) continue;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeBytes(File file, byte[] byArray) throws IOException {
        boolean bl = b;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        Throwable throwable = null;
        try {
            fileOutputStream.write(byArray);
            return;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            block14: {
                if (fileOutputStream != null) {
                    if (throwable != null) {
                        try {
                            fileOutputStream.close();
                            break block14;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                            if (!bl) break block14;
                        }
                    }
                    fileOutputStream.close();
                }
            }
        }
    }

    public static byte[] readBytes(File file) throws IOException, InterruptedException {
        FileInputStream fileInputStream = new FileInputStream(file);
        return IOUtils.readBytes(fileInputStream);
    }

    public static byte[] readBytes(InputStream inputStream) throws IOException, InterruptedException {
        return IOUtils.readBytes(inputStream, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytes(InputStream inputStream, int n2) throws IOException, InterruptedException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream;
        block25: {
            boolean bl = b;
            byteArrayOutputStream = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                byte[] byArray2 = new byte[1024];
                try {
                    int n3;
                    long l2 = System.currentTimeMillis();
                    while ((n3 = inputStream.read(byArray2)) != -1) {
                        Util.checkInterrupted();
                        byteArrayOutputStream.write(byArray2, 0, n3);
                        if (n2 == 0 || System.currentTimeMillis() - l2 <= (long)n2) continue;
                        throw new ReadContentTimeoutException();
                    }
                }
                catch (EOFException eOFException) {
                    String string = StringUtil.stackTraceToString(eOFException);
                    if (!string.contains(c[8]) && !string.contains(c[9])) {
                        throw eOFException;
                    }
                }
                finally {
                    inputStream.close();
                }
                byArray = byteArrayOutputStream.toByteArray();
                if (byteArrayOutputStream == null) return byArray;
                if (throwable == null) break block25;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    block26: {
                        if (byteArrayOutputStream != null) {
                            if (throwable != null) {
                                try {
                                    byteArrayOutputStream.close();
                                    break block26;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    if (!bl) break block26;
                                }
                            }
                            byteArrayOutputStream.close();
                        }
                    }
                }
            }
            try {
                byteArrayOutputStream.close();
                return byArray;
            }
            catch (Throwable throwable5) {
                throwable.addSuppressed(throwable5);
                if (!bl) return byArray;
            }
        }
        byteArrayOutputStream.close();
        return byArray;
    }

    public static String readString(File file, String string) throws IOException, InterruptedException {
        return new String(IOUtils.readBytes(file), string);
    }

    public static String readString(InputStream inputStream, String string) throws IOException, InterruptedException {
        return new String(IOUtils.readBytes(inputStream), string);
    }

    public static void append(Writer writer, CharSequence charSequence) throws IOException {
        block5: {
            block4: {
                if (charSequence != null) break block4;
                writer.write(c[16]);
                if (!b) break block5;
            }
            writer.write(charSequence.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String encode(String string) {
        char[] cArray;
        boolean bl = b;
        StringBuilder stringBuilder = new StringBuilder();
        for (char c2 : cArray = string.toCharArray()) {
            if (!Character.isLetterOrDigit(c2) && c2 != ' ' && c2 != '_') {
                String string2 = Integer.toHexString(c2);
                string2 = "#" + StringUtil.createMonoString(4 - string2.length(), '0') + string2;
                stringBuilder.append(string2);
                if (!bl) continue;
            }
            stringBuilder.append(c2);
            if (!bl) continue;
        }
        return stringBuilder.toString();
    }

    public static String buildQueryString(Map<String, Object> map) throws UnsupportedEncodingException {
        Set<Map.Entry<String, Object>> set = map.entrySet();
        return IOUtils.buildQueryString(set);
    }

    public static String buildQueryString(Collection<Map.Entry<String, Object>> collection) throws UnsupportedEncodingException {
        return IOUtils.buildQueryString(collection, c[15]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String buildQueryString(Collection<Map.Entry<String, Object>> collection, String string) throws UnsupportedEncodingException {
        boolean bl = b;
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, Object>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            block11: {
                Object object;
                String string2;
                block10: {
                    Map.Entry<String, Object> entry = iterator.next();
                    string2 = entry.getKey();
                    object = entry.getValue();
                    if (!(object instanceof List)) break block10;
                    Iterator iterator2 = ((List)object).iterator();
                    while (iterator2.hasNext()) {
                        String string3 = (String)iterator2.next();
                        stringBuilder.append(URLEncoder.encode(string2, string));
                        stringBuilder.append('=');
                        stringBuilder.append(URLEncoder.encode(string3, string));
                        if (iterator2.hasNext()) {
                            stringBuilder.append('&');
                        }
                        if (!bl) continue;
                    }
                    if (!bl) break block11;
                }
                stringBuilder.append(URLEncoder.encode(string2, string));
                stringBuilder.append('=');
                stringBuilder.append(URLEncoder.encode(StringUtil.getStringOrEmpty(object), string));
            }
            if (iterator.hasNext()) {
                stringBuilder.append('&');
            }
            if (!bl) continue;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canWrite(File file) {
        if (file.exists() && !file.canWrite()) {
            System.err.println(c[6] + file.getAbsolutePath() + c[5] + file.exists() + c[4] + file.canWrite());
            return false;
        }
        try {
            boolean bl = file.exists();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, c[7]);
            randomAccessFile.close();
            if (bl) return true;
            if (file.delete()) return true;
            System.err.println(c[3] + file.getAbsolutePath());
            return true;
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isGifImage(byte[] var0) {
        var9_1 = IOUtils.b;
        try {
            block26: {
                block24: {
                    block25: {
                        var1_2 = ImageIO.createImageInputStream(new ByteArrayInputStream(var0));
                        var2_4 = null;
                        try {
                            var3_5 = ImageIO.getImageReaders(var1_2);
lbl7:
                            // 2 sources

                            while (var3_5.hasNext()) {
                                var4_8 = var3_5.next();
                                if (var4_8.getFormatName().equalsIgnoreCase(IOUtils.c[0])) {
                                    var5_9 = true;
                                    if (var1_2 == null) return var5_9;
                                    if (var2_4 == null) break block24;
                                    break block25;
                                }
                                ** GOTO lbl-1000
                            }
                            break block26;
                        }
                        catch (Throwable var3_7) {
                            try {
                                var2_4 = var3_7;
                                throw var3_7;
                            }
                            catch (Throwable var7_11) {
                                throw var7_11;
                            }
                            finally {
                                block27: {
                                    if (var1_2 != null) {
                                        if (var2_4 != null) {
                                            try {
                                                var1_2.close();
                                                break block27;
                                            }
                                            catch (Throwable var8_12) {
                                                var2_4.addSuppressed(var8_12);
                                                if (!var9_1) break block27;
                                            }
                                        }
                                        var1_2.close();
                                    }
                                }
                            }
                        }
                    }
                    try {
                        var1_2.close();
                        return var5_9;
                    }
                    catch (Throwable var6_10) {
                        var2_4.addSuppressed(var6_10);
                        if (var9_1 == false) return var5_9;
                    }
                }
                var1_2.close();
                return var5_9;
lbl-1000:
                // 1 sources

                {
                    if (!var9_1) ** GOTO lbl7
                }
            }
            if (var1_2 == null) return false;
            if (var2_4 == null) {
                var1_2.close();
                return false;
            }
            try {
                var1_2.close();
                return false;
            }
            catch (Throwable var3_6) {
                var2_4.addSuppressed(var3_6);
                return false;
            }
        }
        catch (IOException var1_3) {
            var1_3.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] convertToJPG(byte[] byArray) throws IOException {
        Object object;
        ByteArrayInputStream byteArrayInputStream;
        block30: {
            boolean bl = b;
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            Throwable throwable = null;
            try {
                BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                object = ImageIO.createImageOutputStream(byteArrayOutputStream);
                Throwable throwable2 = null;
                try {
                    ImageIO.write((RenderedImage)bufferedImage, c[13], (ImageOutputStream)object);
                    object.flush();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    block29: {
                        if (object != null) {
                            if (throwable2 != null) {
                                try {
                                    object.close();
                                    break block29;
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                    if (!bl) break block29;
                                }
                            }
                            object.close();
                        }
                    }
                }
                object = byteArrayOutputStream.toByteArray();
                if (byteArrayInputStream == null) return object;
                if (throwable == null) break block30;
            }
            catch (Throwable throwable5) {
                try {
                    throwable = throwable5;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    throw throwable6;
                }
                finally {
                    block31: {
                        if (byteArrayInputStream != null) {
                            if (throwable != null) {
                                try {
                                    byteArrayInputStream.close();
                                    break block31;
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                    if (!bl) break block31;
                                }
                            }
                            byteArrayInputStream.close();
                        }
                    }
                }
            }
            try {
                byteArrayInputStream.close();
                return object;
            }
            catch (Throwable throwable8) {
                throwable.addSuppressed(throwable8);
                return object;
            }
        }
        byteArrayInputStream.close();
        return object;
    }

    public static Image createStaticImage(byte[] byArray) {
        if (IOUtils.isGifImage(byArray)) {
            try {
                byArray = IOUtils.convertToJPG(byArray);
            }
            catch (IOException | IndexOutOfBoundsException exception) {
                exception.printStackTrace();
            }
        }
        return new ImageIcon(byArray).getImage();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeAsGZip(File file, String string, String string2) throws IOException {
        FileOutputStream fileOutputStream;
        block47: {
            boolean bl = b;
            fileOutputStream = new FileOutputStream(file.getAbsolutePath() + c[14]);
            Throwable throwable = null;
            try {
                block44: {
                    ByteArrayOutputStream byteArrayOutputStream;
                    block45: {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        Throwable throwable2 = null;
                        try {
                            byteArrayOutputStream.write(string.getBytes(string2));
                            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new BufferedOutputStream(fileOutputStream));
                            Throwable throwable3 = null;
                            try {
                                gZIPOutputStream.write(byteArrayOutputStream.toByteArray());
                            }
                            catch (Throwable throwable4) {
                                throwable3 = throwable4;
                                throw throwable4;
                            }
                            finally {
                                block43: {
                                    if (gZIPOutputStream != null) {
                                        if (throwable3 != null) {
                                            try {
                                                gZIPOutputStream.close();
                                                break block43;
                                            }
                                            catch (Throwable throwable5) {
                                                throwable3.addSuppressed(throwable5);
                                                if (!bl) break block43;
                                            }
                                        }
                                        gZIPOutputStream.close();
                                    }
                                }
                            }
                            if (byteArrayOutputStream == null) break block44;
                            if (throwable2 == null) break block45;
                        }
                        catch (Throwable throwable6) {
                            try {
                                throwable2 = throwable6;
                                throw throwable6;
                            }
                            catch (Throwable throwable7) {
                                throw throwable7;
                            }
                            finally {
                                block46: {
                                    if (byteArrayOutputStream != null) {
                                        if (throwable2 != null) {
                                            try {
                                                byteArrayOutputStream.close();
                                                break block46;
                                            }
                                            catch (Throwable throwable8) {
                                                throwable2.addSuppressed(throwable8);
                                                if (!bl) break block46;
                                            }
                                        }
                                        byteArrayOutputStream.close();
                                    }
                                }
                            }
                        }
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                        break block44;
                    }
                    byteArrayOutputStream.close();
                }
                if (fileOutputStream == null) return;
                if (throwable == null) break block47;
            }
            catch (Throwable throwable10) {
                try {
                    throwable = throwable10;
                    throw throwable10;
                }
                catch (Throwable throwable11) {
                    throw throwable11;
                }
                finally {
                    block48: {
                        if (fileOutputStream != null) {
                            if (throwable != null) {
                                try {
                                    fileOutputStream.close();
                                    break block48;
                                }
                                catch (Throwable throwable12) {
                                    throwable.addSuppressed(throwable12);
                                    if (!bl) break block48;
                                }
                            }
                            fileOutputStream.close();
                        }
                    }
                }
            }
            try {
                fileOutputStream.close();
                return;
            }
            catch (Throwable throwable13) {
                throwable.addSuppressed(throwable13);
                return;
            }
        }
        fileOutputStream.close();
    }

    public static List<File> buildPath(File file) {
        boolean bl = b;
        LinkedList<File> linkedList = new LinkedList<File>();
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            linkedList.addFirst(file2);
            if (!bl) continue;
        }
        return linkedList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeSilently(@Nullable Closeable closeable) {
        if (closeable == null) return;
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        String string;
        String[] stringArray = new String[20];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u0013|y";
        int n3 = -1;
        block28: while (true) {
            char[] cArray;
            block33: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block32: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block32;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block33;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 116;
                                break;
                            }
                            case 1: {
                                n9 = 21;
                                break;
                            }
                            case 2: {
                                n9 = 31;
                                break;
                            }
                            case 3: {
                                n9 = 40;
                                break;
                            }
                            default: {
                                n9 = 85;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "!{~J9\u00115kGu\u0010psM!\u00115";
                    n3 = 0;
                    continue block28;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "!AY\u0005m";
                    n3 = 1;
                    continue block28;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "7tqF:\u00005{M9\u0011az\b!\u0019e?N<\u0018p?";
                    n3 = 2;
                    continue block28;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "X5|I;TbmA!\u0011/?";
                    n3 = 3;
                    continue block28;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "X5?M-\u001dfk\u0012u";
                    n3 = 4;
                    continue block28;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "7tqF:\u00005hZ<\u0000p?A;TspD1\u0011g%\b3\u001dyz\u0012u";
                    n3 = 5;
                    continue block28;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u0006b";
                    n3 = 6;
                    continue block28;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u001etiI{\u0001avD{\u000e|o\u0006\u0012.\\Oa;\u0004`k{!\u0006p~E{\u0006p~L\u0001\u0006tvD0\u0006=";
                    n3 = 7;
                    continue block28;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "!{zP%\u0011vkM1TpqLu\u001bs?r\u0019=W?A;\u0004`k\b&\u0000gzI8";
                    n3 = 8;
                    continue block28;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "!AY\u0005m";
                    n3 = 9;
                    continue block28;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "!{~J9\u00115kGu\u0010psM!\u00115{A'\u0011vkG'\r5wA0\u0006tmK=\r5=";
                    n3 = 10;
                    continue block28;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "7tqF:\u00005|Z0\u0015az\b'\u0015{{G8TspD1\u0011g?";
                    n3 = 11;
                    continue block28;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u001eex";
                    n3 = 12;
                    continue block28;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "Zre";
                    n3 = 13;
                    continue block28;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "!AY\u0005m";
                    n3 = 14;
                    continue block28;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "\u001a`sD";
                    n3 = 15;
                    continue block28;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "!AY\u0005m";
                    n3 = 16;
                    continue block28;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "7tqF:\u00005mM4\u00105yA9\u00115";
                    n3 = 17;
                    continue block28;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = " zp\b7\u001dr?N<\u0018p";
                    n3 = 18;
                    continue block28;
                }
                case 18: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        c = stringArray3;
    }

    public static abstract class LineAcceptor {
        protected abstract void accept(String var1);
    }
}

