/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.ftp;

import com.agilemind.commons.io.ftp.FTPClientPlugin;
import com.agilemind.commons.io.ftp.FtpClientFile;
import com.agilemind.commons.io.ftp.FtpConnection;
import com.agilemind.commons.io.ftp.data.IFtpSettings;
import com.agilemind.commons.io.ftp.util.FTPLogger;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.Util;
import com.sshtools.net.SocketTransport;
import com.sshtools.sftp.SftpClient;
import com.sshtools.sftp.SftpFile;
import com.sshtools.sftp.SftpStatusException;
import com.sshtools.sftp.TransferCancelledException;
import com.sshtools.ssh.ChannelOpenException;
import com.sshtools.ssh.PasswordAuthentication;
import com.sshtools.ssh.SshAuthentication;
import com.sshtools.ssh.SshClient;
import com.sshtools.ssh.SshConnector;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshTransport;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHToolsFTPClientPlugin
extends FTPClientPlugin {
    private static final Logger d = LoggerFactory.getLogger(SSHToolsFTPClientPlugin.class);
    private SshClient e;
    private SftpClient f;
    private SshConnector g;
    private IFtpSettings h;

    SSHToolsFTPClientPlugin(IFtpSettings iFtpSettings) {
        this.h = iFtpSettings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean changeWorkingDirectory(String string) throws IOException {
        if (string == null) return string.equals(this.f.pwd());
        try {
            this.f.cd(string);
            return string.equals(this.f.pwd());
        }
        catch (SftpStatusException | SshException throwable) {
            throw new IOException(throwable);
        }
    }

    @Override
    public boolean sendFile(String string, String string2) throws IOException {
        try {
            this.f.put(new File(string, string2).toString());
        }
        catch (SftpStatusException | TransferCancelledException | SshException throwable) {
            throw new IOException(throwable);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void connection(FTPLogger fTPLogger) throws IOException, InterruptedException {
        boolean bl = FtpConnection.d;
        fTPLogger.log(a.getConnectingMessage());
        SocketTransport socketTransport = new SocketTransport(this.h.getHost(), this.h.getPort());
        socketTransport.setTcpNoDelay(true);
        try {
            if (this.g == null) {
                this.g = SshConnector.createInstance();
            }
            this.e = this.g.connect((SshTransport)socketTransport, this.h.getLogin(), true);
            fTPLogger.log(a.getConnectingMessage());
            Util.checkInterrupted();
            fTPLogger.log(a.getLoginToServerMessage());
            PasswordAuthentication passwordAuthentication = new PasswordAuthentication();
            passwordAuthentication.setPassword(this.h.getPassword());
            int n2 = this.e.authenticate((SshAuthentication)passwordAuthentication);
            if (n2 == 1 && this.e.isAuthenticated()) {
                Util.checkInterrupted();
                fTPLogger.log(a.getDoneStatusMessage());
                this.f = new SftpClient(this.e);
                if (!bl) return;
                StringUtil.f = !StringUtil.f;
            }
            fTPLogger.log(a.getFailedStatusMessage());
            return;
        }
        catch (SftpStatusException | ChannelOpenException | SshException throwable) {
            fTPLogger.log(a.getFailedStatusMessage());
            throw new IOException(a.getLoginFailedMessage());
        }
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    protected void doDisconnecting(FTPLogger fTPLogger) throws InterruptedException {
        try {
            fTPLogger.log(a.getDisconnectingMessage());
            if (this.f != null) {
                this.f.quit();
            }
            this.e.disconnect();
        }
        catch (SshException sshException) {
            fTPLogger.log(a.getFailedStatusMessage());
            d.error("", (Throwable)sshException);
        }
        fTPLogger.log(a.getDoneStatusMessage());
    }

    @Override
    public IFtpSettings getFtpSettings() {
        return this.h;
    }

    @Override
    public String printWorkingDirectory() throws IOException {
        return this.f.pwd();
    }

    @Override
    public boolean makeDirectory(String string) throws IOException {
        try {
            this.f.mkdir(string);
        }
        catch (SftpStatusException | SshException throwable) {
            throw new IOException(throwable);
        }
        return true;
    }

    @Override
    public boolean deleteFile(String string) {
        try {
            this.f.rm(string);
            return true;
        }
        catch (SftpStatusException | SshException throwable) {
            d.error("", throwable);
            return true;
        }
    }

    @Override
    protected FtpClientFile[] listFiles(FtpClientFile ftpClientFile) throws IOException {
        try {
            SftpFile[] sftpFileArray = new SftpFile[]{};
            sftpFileArray = this.f.ls(ftpClientFile.getFullName());
            return this.a(ftpClientFile, sftpFileArray);
        }
        catch (SftpStatusException | SshException throwable) {
            throw new IOException(throwable);
        }
    }

    private FtpClientFile[] a(FtpClientFile ftpClientFile, SftpFile[] sftpFileArray) {
        boolean bl = FtpConnection.d;
        FtpClientFile[] ftpClientFileArray = new FtpClientFile[sftpFileArray.length];
        try {
            for (int i2 = 0; i2 < ftpClientFileArray.length; ++i2) {
                SftpFile sftpFile = sftpFileArray[i2];
                ftpClientFileArray[i2] = new FtpClientFile(ftpClientFile, sftpFile.getFilename(), sftpFile.isDirectory(), this);
                if (!bl) continue;
                break;
            }
        }
        catch (SftpStatusException | SshException throwable) {
            d.error("", throwable);
        }
        return ftpClientFileArray;
    }
}

