/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.gateway;

import com.agilemind.commons.io.gateway.GatewayClient;
import com.agilemind.commons.io.gateway.GatewayPageReader;
import com.agilemind.commons.io.gateway.GatewaySearchEngineManager;
import com.agilemind.commons.io.gateway.GatewayTimeoutException;
import com.agilemind.commons.io.gateway.IGatewayClient;
import com.agilemind.commons.io.gateway.IGatewayRequestInfo;
import com.agilemind.commons.io.gateway.g;
import com.agilemind.commons.io.gateway.h;
import com.agilemind.commons.io.pagereader.PageReader;
import com.agilemind.commons.io.pagereader.PageReaderFactory;
import com.agilemind.commons.io.proxifier.IProxifiedConnectionSettings;
import com.agilemind.commons.io.proxifier.IProxifier;
import com.agilemind.commons.io.proxifier.ServiceType;
import com.agilemind.commons.io.proxifier.cache.api.CacheType;
import com.agilemind.commons.io.searchengine.ParserBrokenException;
import com.agilemind.commons.io.searchengine.ServiceBlockedByCaptchaException;
import com.agilemind.commons.io.searchengine.ServiceBlockedByRecaptchaException;
import com.agilemind.commons.io.searchengine.ServiceBlockedException;
import com.agilemind.commons.io.searchengine.captcha.ICaptchaSettings;
import com.agilemind.commons.io.searchengine.captcha.SearchEngineManager;
import com.agilemind.commons.io.utils.IOLogger;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.retry.RetryHandler;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.concurrent.Semaphore;
import javax.net.ssl.SSLHandshakeException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GatewayProxifier<T>
implements IProxifier<T> {
    private static final Logger a = LoggerFactory.getLogger(GatewayProxifier.class);
    private static final Semaphore b = new Semaphore(10, true);
    private IProxifiedConnectionSettings c;
    private ICaptchaSettings d;
    private SearchEngineManager e;
    private SearchEngineManager f;
    private SearchEngineManager g;
    private ServiceType h;
    private CacheType i;
    private IGatewayClient j;
    private GatewayPageReader k;
    private RetryHandler l;
    public static int n;

    protected GatewayProxifier(IProxifiedConnectionSettings iProxifiedConnectionSettings, ICaptchaSettings iCaptchaSettings, SearchEngineManager searchEngineManager, IGatewayRequestInfo iGatewayRequestInfo, ServiceType serviceType, CacheType cacheType) {
        int n2 = n;
        this.l = new RetryHandler(3, GatewayTimeoutException.class, SSLHandshakeException.class, ConnectException.class, SocketTimeoutException.class, IOException.class);
        this.c = iProxifiedConnectionSettings;
        this.d = iCaptchaSettings;
        this.h = serviceType;
        this.i = cacheType;
        PageReader pageReader = PageReaderFactory.getInstance(iProxifiedConnectionSettings).createPageReaderForNonSearchEngine();
        pageReader.getPageReaderSettings().setReadTimeOut(120000);
        this.j = new GatewayClient(iGatewayRequestInfo, pageReader);
        this.f = searchEngineManager;
        this.e = searchEngineManager.isAutomatic() ? searchEngineManager : new h(searchEngineManager, null);
        this.k = PageReaderFactory.getInstance(iProxifiedConnectionSettings).createGatewayPageReader(this.j, serviceType.getService());
        this.g = new GatewaySearchEngineManager(searchEngineManager, this.j, this.k);
        if (n2 != 0) {
            StringUtil.f = !StringUtil.f;
        }
    }

    @Override
    public T query(IOLogger iOLogger) throws IOException, InterruptedException {
        try {
            IProxifier<T> iProxifier = this.a(this.e);
            return iProxifier.query(iOLogger);
        }
        catch (ServiceBlockedByCaptchaException | ServiceBlockedByRecaptchaException serviceBlockedException) {
            return this.a(iOLogger);
        }
        catch (ServiceBlockedException serviceBlockedException) {
            return this.a(serviceBlockedException);
        }
    }

    @NotNull
    private IProxifier<T> a(SearchEngineManager searchEngineManager) {
        return new g(this, this.c, this.d, searchEngineManager, this.h, this.i);
    }

    private T a(IOLogger iOLogger) throws InterruptedException, IOException {
        try {
            return (T)this.l.request(this::a);
        }
        catch (ParserBrokenException parserBrokenException) {
            throw parserBrokenException;
        }
        catch (IOException iOException) {
            a.error("", (Throwable)iOException);
            IProxifier<T> iProxifier = this.a(this.f);
            return iProxifier.query(iOLogger);
        }
    }

    private T a(ServiceBlockedException serviceBlockedException) throws IOException, InterruptedException {
        try {
            return (T)this.l.request(this::a);
        }
        catch (ParserBrokenException parserBrokenException) {
            throw parserBrokenException;
        }
        catch (IOException iOException) {
            block7: {
                a.error("", (Throwable)iOException);
                if (m || serviceBlockedException != null) break block7;
                throw new AssertionError();
            }
            throw serviceBlockedException;
        }
    }

    private T a() throws IOException, InterruptedException {
        try {
            b.acquire();
            T t2 = this.externalServiceWorker(this.k, this.g);
            return t2;
        }
        catch (ServiceBlockedByCaptchaException | ServiceBlockedByRecaptchaException serviceBlockedException) {
            b.release();
            T t3 = this.a();
            return t3;
        }
        catch (ServiceBlockedException serviceBlockedException) {
            this.j.notifyBan(this.k.getSessionId());
            this.k.startNewSession();
            b.release();
            T t4 = this.a();
            return t4;
        }
        finally {
            b.release();
        }
    }

    protected abstract T externalServiceWorker(PageReader var1, SearchEngineManager var2) throws InterruptedException, IOException;
}

