/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.pagereader;

import com.agilemind.commons.io.IOUtils;
import com.agilemind.commons.io.pagereader.ICookieManager;
import com.agilemind.commons.io.pagereader.IPageReadersSettings;
import com.agilemind.commons.io.pagereader.PageReaderConnectionInfo;
import com.agilemind.commons.io.pagereader.PageReaderContent;
import com.agilemind.commons.io.pagereader.PageReaderContentImpl;
import com.agilemind.commons.io.pagereader.ReadURLSettings;
import com.agilemind.commons.io.pagereader.ReadURLSettingsBuilder;
import com.agilemind.commons.util.HtmlUtils;
import com.agilemind.commons.util.RegPatternUtil;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PageReader {
    private static final Logger a;
    private static final Pattern b;
    private static final Pattern c;
    protected IPageReadersSettings pageReaderSettings;
    public static int d;
    private static final String[] e;

    protected PageReader(IPageReadersSettings iPageReadersSettings) {
        this.pageReaderSettings = iPageReadersSettings;
    }

    public PageReaderContent getContent(UnicodeURL unicodeURL) throws IOException, InterruptedException {
        return this.getContent(unicodeURL, new ReadURLSettingsBuilder().build());
    }

    public IPageReadersSettings getPageReaderSettings() {
        return this.pageReaderSettings;
    }

    public abstract PageReaderContent getContent(UnicodeURL var1, ReadURLSettings var2) throws IOException, InterruptedException;

    public abstract URLConnection openConnection(UnicodeURL var1, ReadURLSettings var2, boolean var3) throws IOException;

    public abstract PageReaderConnectionInfo getPageReaderConnectionInfo();

    public abstract ICookieManager getCookieManager();

    public abstract void setCookieManager(ICookieManager var1);

    public abstract void dispose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected PageReaderContent readContent(URLConnection uRLConnection, String string, @Nullable InputStream inputStream) throws InterruptedException, IOException {
        a.debug(e[6]);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        try {
            byte[] byArray;
            int n2;
            block17: {
                block16: {
                    n2 = httpURLConnection.getResponseCode();
                    if (inputStream == null || n2 >= 300 && n2 < 400) break block16;
                    if (string != null && StringUtil.split(string, ',').contains(e[7])) {
                        inputStream = new GZIPInputStream(inputStream);
                        string = null;
                    }
                    byArray = this.readBytes(inputStream);
                    if (d == 0) break block17;
                }
                byArray = new byte[]{};
            }
            try {
                if (!StringUtil.isEmpty(string)) return PageReader.createPageReaderContent(uRLConnection, string, n2, byArray);
                String string2 = uRLConnection.getContentType();
                string = HtmlUtils.getEncodingFromContentType(string2);
                return PageReader.createPageReaderContent(uRLConnection, string, n2, byArray);
            }
            catch (Exception exception) {
                a.debug(e[8], (Throwable)exception);
                return PageReader.createPageReaderContent(uRLConnection, string, n2, byArray);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    protected byte[] readBytes(InputStream inputStream) throws IOException, InterruptedException {
        return IOUtils.readBytes(inputStream, this.pageReaderSettings.getReadContentTimeout());
    }

    public static PageReaderContent createPageReaderContent(URLConnection uRLConnection, String string, int n2, byte[] byArray) throws MalformedURLException {
        PageReaderContentImpl pageReaderContentImpl;
        block5: {
            boolean bl;
            block7: {
                block6: {
                    int n3 = d;
                    long l2 = uRLConnection.getContentLength();
                    if (l2 <= 0L) {
                        l2 = byArray.length;
                    }
                    Map<String, List<String>> map = uRLConnection.getHeaderFields();
                    String string2 = uRLConnection.getHeaderField(e[4]);
                    String string3 = PageReader.extractContentType(uRLConnection.getContentType());
                    String string4 = uRLConnection.getHeaderField(e[0]);
                    String string5 = uRLConnection.getHeaderField(e[2]);
                    String string6 = HtmlUtils.getEncodingFromContentType(uRLConnection.getContentType());
                    String string7 = PageReader.a(uRLConnection.getHeaderField(e[3]));
                    String string8 = PageReader.b(uRLConnection.getHeaderField(e[5]));
                    UnicodeURL unicodeURL = UnicodeURLFactory.getInstance().createUnicodeURL(uRLConnection.getURL());
                    long l3 = uRLConnection.getLastModified();
                    a.debug(e[1], new Object[]{n2, l2, string2, string3, string4, string5, string7, string8, unicodeURL});
                    pageReaderContentImpl = new PageReaderContentImpl(string, byArray, unicodeURL, l2, map, string2, string3, string6, string4, n2, string5, new Date(uRLConnection.getDate()), string7, string8, l3);
                    if (n3 == 0) break block5;
                    if (!StringUtil.f) break block6;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            StringUtil.f = bl;
        }
        return pageReaderContentImpl;
    }

    private static String a(String string) {
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        return RegPatternUtil.getMatch(string, b, 1);
    }

    private static String b(String string) {
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        return RegPatternUtil.getMatch(string, c, 1);
    }

    protected static String extractContentType(String string) {
        int n2;
        if (!StringUtil.isEmpty(string) && (n2 = string.indexOf(59)) != -1) {
            string = string.substring(0, n2);
        }
        return string;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String string2;
        int n2;
        String[] stringArray = new String[9];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n3 = 0;
        String string3 = "\\Aa!WqZ\"\u0019SqIz4Uz";
        int n4 = -1;
        block25: while (true) {
            char[] cArray;
            block34: {
                int n5;
                int n6;
                char[] cArray2;
                block33: {
                    char[] cArray3 = string3.toCharArray();
                    n2 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n6 = n7;
                    if (n7 <= 1) break block33;
                    cArray = cArray2;
                    n5 = n6;
                    if (n6 <= n2) break block34;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n2;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n2 % 5) {
                            case 0: {
                                n9 = 31;
                                break;
                            }
                            case 1: {
                                n9 = 46;
                                break;
                            }
                            case 2: {
                                n9 = 15;
                                break;
                            }
                            case 3: {
                                n9 = 85;
                                break;
                            }
                            default: {
                                n9 = 50;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n2;
                        cArray2 = cArray5;
                        n6 = n6;
                        if (n6 != 0) break;
                        cArray5 = cArray2;
                        n5 = n6;
                        n8 = n6;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n5 = n6;
                } while (n6 > n2);
            }
            string2 = new String(cArray);
            switch (n4) {
                default: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 1;
                    string3 = "mK|%]q]juQpJjo\u0012dS#uqp@{0\\k\u000ec0\\xZgo\u0012dSm,Fz]#uJMAm:Flzn2\b?Ury\u0012|Aa!WqZ[,Bz\u0014/.O3\u000ec4\\x\u0014/.O3\u000e}0Vv\\j6F?[}9\b?Ury\u0012sGa>\u0012|Oa:\\vMn9\b?Ury\u0012mKi'WlF5uIb\u0002/'Wn[j&FJ\\co\u0012dS\u0005\u0013[qG|=8";
                    n4 = 0;
                    continue block25;
                }
                case 0: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 2;
                    string3 = "sAl4FvAa";
                    n4 = 1;
                    continue block25;
                }
                case 1: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 3;
                    string3 = "SGa>";
                    n4 = 2;
                    continue block25;
                }
                case 2: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 4;
                    string3 = "G\u0003]:PpZ|xf~I";
                    n4 = 3;
                    continue block25;
                }
                case 3: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 5;
                    string3 = "MKi'WlF";
                    n4 = 4;
                    continue block25;
                }
                case 4: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 6;
                    string3 = "LZn'F?\\j4V?m`;Fz@{";
                    n4 = 5;
                    continue block25;
                }
                case 5: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 7;
                    string3 = "xTf%";
                    n4 = 6;
                    continue block25;
                }
                case 6: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 8;
                    string3 = "ZVl0BkG`;\b?Ur";
                    n4 = 7;
                    continue block25;
                }
                case 7: 
            }
            break;
        }
        stringArray2[n3] = string2.intern();
        e = stringArray3;
        a = LoggerFactory.getLogger(PageReader.class);
        String string4 = "#\u0006T\u000b\fB\u0005&knl\u00044\tA5\\j9\u000fD\t-\b\r|Oa:\\vMn9i8\fRj";
        int n10 = -1;
        block28: while (true) {
            char[] cArray;
            block36: {
                int n11;
                int n12;
                char[] cArray6;
                block35: {
                    char[] cArray7 = string4.toCharArray();
                    n2 = 0;
                    int n13 = cArray7.length;
                    cArray6 = cArray7;
                    n12 = n13;
                    if (n13 <= 1) break block35;
                    cArray = cArray6;
                    n11 = n12;
                    if (n12 <= n2) break block36;
                }
                do {
                    char[] cArray8 = cArray6;
                    char[] cArray9 = cArray6;
                    int n14 = n2;
                    while (true) {
                        int n15;
                        char c3 = cArray8[n14];
                        switch (n2 % 5) {
                            case 0: {
                                n15 = 31;
                                break;
                            }
                            case 1: {
                                n15 = 46;
                                break;
                            }
                            case 2: {
                                n15 = 15;
                                break;
                            }
                            case 3: {
                                n15 = 85;
                                break;
                            }
                            default: {
                                n15 = 50;
                            }
                        }
                        cArray8[n14] = (char)(c3 ^ n15);
                        ++n2;
                        cArray6 = cArray9;
                        n12 = n12;
                        if (n12 != 0) break;
                        cArray9 = cArray6;
                        n11 = n12;
                        n14 = n12;
                        cArray8 = cArray6;
                    }
                    cArray = cArray6;
                    n11 = n12;
                } while (n12 > n2);
            }
            string = new String(cArray).intern();
            switch (n10) {
                default: {
                    b = Pattern.compile(string, 2);
                    string4 = "CJ$\tA5\u0015S&\u0018j\\chi8\fRj\u001a1\u0005&\u000e\u0015=s0";
                    n10 = 0;
                    continue block28;
                }
                case 0: 
            }
            break;
        }
        c = Pattern.compile(string, 2);
    }
}

