/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.pagereader.cache;

import com.agilemind.commons.io.IOUtils;
import com.agilemind.commons.io.pagereader.PageReaderContent;
import com.agilemind.commons.io.pagereader.PageReaderContentImpl;
import com.agilemind.commons.io.pagereader.cache.Cache;
import com.agilemind.commons.io.pagereader.cache.IPageCacheKey;
import com.agilemind.commons.io.pagereader.cache.MemoryCacheStorage;
import com.agilemind.commons.io.pagereader.cache.a;
import com.agilemind.commons.io.pagereader.cache.d;
import com.agilemind.commons.io.pagereader.cache.e;
import com.agilemind.commons.io.pagereader.cache.impl.CacheStorage;
import com.agilemind.commons.io.pagereader.cache.impl.LockedCache;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import com.agilemind.commons.util.Util;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagesCache
extends LockedCache<IPageCacheKey, PageReaderContent> {
    private static final String c;

    public PagesCache(CacheStorage<IPageCacheKey, PageReaderContent> cacheStorage) {
        super(cacheStorage);
    }

    static String a(UnicodeURL unicodeURL, String string) {
        if (UnicodeURLUtil.isAjaxUrl(unicodeURL)) {
            return c;
        }
        return PagesCache.b(unicodeURL, string);
    }

    private static String b(UnicodeURL unicodeURL, String string) {
        String string2;
        String string3 = unicodeURL.getPath();
        int n2 = string3.lastIndexOf(46);
        String string4 = string2 = n2 != -1 && string3.lastIndexOf(47) < n2 ? string3.substring(n2) : null;
        if (StringUtil.isEmpty(string2)) {
            if (string == null) {
                return "";
            }
            String string5 = string.toLowerCase().trim();
            if (string5.contains("/")) {
                return string.substring(string5.indexOf("/") + 1);
            }
            return "";
        }
        return string2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "\r&F/".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 101;
                            break;
                        }
                        case 1: {
                            n7 = 82;
                            break;
                        }
                        case 2: {
                            n7 = 43;
                            break;
                        }
                        case 3: {
                            n7 = 67;
                            break;
                        }
                        default: {
                            n7 = 102;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        c = new String(cArray).intern();
    }

    public static class FilePagesStorage
    extends CacheStorage<IPageCacheKey, PageReaderContent> {
        private static final Logger a;
        private File c;
        private boolean d;
        private boolean e;
        private Map<String, e> f = new HashMap<String, e>();
        private final ObjectWriter g = new ObjectMapper().writerWithDefaultPrettyPrinter();
        private BiPredicate<IPageCacheKey, PageReaderContent> h = (iPageCacheKey, pageReaderContent) -> false;
        private File i;
        private static final String[] j;

        private FilePagesStorage(boolean bl) throws IOException {
            this(new File(j[10]), bl);
        }

        private FilePagesStorage(File file, boolean bl) throws IOException {
            this.c = file;
            this.d = bl;
            if (!this.c.exists()) {
                if (!this.c.mkdirs()) {
                    a.error(j[4], (Object)file.getAbsolutePath());
                }
            }
            this.i = new File(this.c, j[3]);
            if (this.i.exists()) {
                try {
                    Map map = (Map)new ObjectMapper().readValue(this.i, (TypeReference)new a(this));
                    this.f.put((String)map.get(j[1]), new e((String)map.get(j[2]), map, null));
                }
                catch (IOException iOException) {
                    a.error(j[0], (Throwable)iOException);
                }
            }
        }

        @Override
        @Nullable
        protected PageReaderContent getFromCache(IPageCacheKey iPageCacheKey) throws IOException, InterruptedException {
            String string;
            e e2;
            if (this.d && (e2 = this.f.get(string = iPageCacheKey.getPageKey())) != null) {
                byte[] byArray;
                try {
                    byArray = IOUtils.readBytes(new File(this.c, com.agilemind.commons.io.pagereader.cache.e.access$300(e2)));
                }
                catch (IOException | InterruptedException exception) {
                    a.error(j[11], (Throwable)exception);
                    throw exception;
                }
                String string2 = (String)com.agilemind.commons.io.pagereader.cache.e.access$400(e2).get(j[12]);
                String string3 = (String)com.agilemind.commons.io.pagereader.cache.e.access$400(e2).get(j[13]);
                return new PageReaderContentImpl(string2, byArray, iPageCacheKey.getPageUrl(), string3, com.agilemind.commons.io.pagereader.cache.e.access$400(e2));
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void putToCache(IPageCacheKey iPageCacheKey, PageReaderContent pageReaderContent) throws IOException {
            File file;
            String string;
            int n2;
            block33: {
                block32: {
                    n2 = Cache.Retriever.b;
                    if (this.e && pageReaderContent.getPageBytes().length == 0) {
                        if (pageReaderContent.needRedirect()) return;
                    }
                    if (this.h.test(iPageCacheKey, pageReaderContent)) {
                        return;
                    }
                    string = iPageCacheKey.getPageKey();
                    if (!this.f.containsKey(string)) break block32;
                    file = new File(this.c, com.agilemind.commons.io.pagereader.cache.e.access$300(this.f.get(string)));
                    if (n2 == 0) break block33;
                }
                file = IOUtils.createRandomFile(this.c, PagesCache.a(iPageCacheKey.getPageUrl(), pageReaderContent.getContentType()));
            }
            String string2 = file.getName();
            try {
                IOUtils.writeBytes(file, pageReaderContent.getPageBytes());
            }
            catch (IOException iOException) {
                a.error(j[5], (Throwable)iOException);
                throw iOException;
            }
            Map<String, Object> map = pageReaderContent.getParams();
            if (!this.f.containsKey(string)) {
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.i, true));
                    Throwable throwable = null;
                    try {
                        map.put(j[9], string);
                        map.put(j[7], iPageCacheKey.getPageUrl().toIDNString());
                        map.put(j[8], string2);
                        bufferedWriter.write(this.g.writeValueAsString(map));
                        bufferedWriter.newLine();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        block31: {
                            if (bufferedWriter != null) {
                                if (throwable != null) {
                                    try {
                                        bufferedWriter.close();
                                        break block31;
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                        if (n2 == 0) break block31;
                                    }
                                }
                                bufferedWriter.close();
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    a.error(j[6], (Throwable)iOException);
                    throw iOException;
                }
            }
            if (!this.d) return;
            this.f.put(string, new e(string2, map, null));
        }

        public String getFileName(String string) {
            return Optional.ofNullable(this.f.get(string)).map(e::getFile).orElse(null);
        }

        public void setDenyToCacheFilter(BiPredicate<IPageCacheKey, PageReaderContent> biPredicate) {
            this.h = biPredicate;
        }

        public void deleteCacheFile(String string) {
            if (string != null) {
                try {
                    Files.deleteIfExists(Paths.get(this.c.getAbsolutePath(), string));
                }
                catch (IOException iOException) {
                    a.error(j[14], (Object)string);
                }
            }
        }

        public void setIgnoreStoreRedirects(boolean bl) {
            this.e = bl;
        }

        /* synthetic */ FilePagesStorage(boolean bl, d d2) throws IOException {
            this(bl);
        }

        /* synthetic */ FilePagesStorage(File file, boolean bl, d d2) throws IOException {
            this(file, bl);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[15];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "\u001f\"";
            int n3 = -1;
            block22: while (true) {
                char[] cArray;
                block27: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block26: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block26;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block27;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 100;
                                    break;
                                }
                                case 1: {
                                    n9 = 95;
                                    break;
                                }
                                case 2: {
                                    n9 = 110;
                                    break;
                                }
                                case 3: {
                                    n9 = 127;
                                    break;
                                }
                                default: {
                                    n9 = 20;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "\u0014>\t\u001aA6\u0013";
                        n3 = 0;
                        continue block22;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "\u00026\u0002\u001aD\u00058\u000b";
                        n3 = 1;
                        continue block22;
                    }
                    case 1: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 3;
                        string2 = "\u0007>\r\u0017qJ3\u0001\u0018";
                        n3 = 2;
                        continue block22;
                    }
                    case 2: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 4;
                        string2 = "'>\u0000\u0011{\u0010\u007f\r\rq\u0005+\u000b_w\u0005<\u0006\u001a4\u00020\u0002\u001bq\u0016eN\u0004i";
                        n3 = 3;
                        continue block22;
                    }
                    case 3: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 5;
                        string2 = "'>\u0000\u0011{\u0010\u007f\u0019\r}\u0010:N\u001cu\u00077\u000b_r\r3\u000bE4?\"";
                        n3 = 4;
                        continue block22;
                    }
                    case 4: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 6;
                        string2 = "'>\u0000\u0011{\u0010\u007f\u0019\r}\u0010:N\u001bu\u0010>N\u000b{D<\u000f\u001c|\u0001\u007f\u0002\u0010s^\u007f\u0015\u0002";
                        n3 = 5;
                        continue block22;
                    }
                    case 5: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 7;
                        string2 = "\u0014>\t\u001aA6\u0013";
                        n3 = 6;
                        continue block22;
                    }
                    case 6: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 8;
                        string2 = "\u00026\u0002\u001aD\u00058\u000b";
                        n3 = 7;
                        continue block22;
                    }
                    case 7: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 9;
                        string2 = "\u0007>\r\u0017q/:\u0017";
                        n3 = 8;
                        continue block22;
                    }
                    case 8: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 10;
                        string2 = "\u00026\u0002\u001aK\u0007>\r\u0017q";
                        n3 = 9;
                        continue block22;
                    }
                    case 9: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 11;
                        string2 = "'>\u0000\u0011{\u0010\u007f\u001c\u001au\u0000\u007f\b\u0016x\u0001\u007f\b\r{\t\u007f\r\u001ew\f:T_o\u0019";
                        n3 = 10;
                        continue block22;
                    }
                    case 10: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 12;
                        string2 = "\u00070\u0000\u000bq\n++\u0011w\u000b;\u0007\u0011s";
                        n3 = 11;
                        continue block22;
                    }
                    case 11: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 13;
                        string2 = "\u00077\u000f\rg\u0001+";
                        n3 = 12;
                        continue block22;
                    }
                    case 12: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 14;
                        string2 = "'>\u0000\u0011{\u0010\u007f\n\u001ax\u0001+\u000b_w\u0005<\u0006\u001a4\u00026\u0002\u001a.D$\u0013";
                        n3 = 13;
                        continue block22;
                    }
                    case 13: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            j = stringArray3;
            a = LoggerFactory.getLogger(FilePagesStorage.class);
        }
    }

    public static class FilePagesLog
    extends FilePagesStorage {
        public FilePagesLog(File file) throws IOException {
            super(file, false, null);
        }

        public FilePagesLog() throws IOException {
            super(false, null);
        }
    }

    public static class FilePagesCache
    extends FilePagesStorage {
        public FilePagesCache() throws IOException {
            super(true, null);
        }
    }

    public static class FixedPageCacheStorage
    extends MemoryCacheStorage<IPageCacheKey, PageReaderContent> {
        private String[] c;

        public FixedPageCacheStorage(String ... stringArray) {
            this.c = stringArray;
        }

        @Override
        protected PageReaderContent getFromCache(IPageCacheKey iPageCacheKey) throws IOException {
            if (Util.contains(this.c, iPageCacheKey.getPageKey())) {
                return (PageReaderContent)super.getFromCache(iPageCacheKey);
            }
            return null;
        }

        @Override
        protected void putToCache(IPageCacheKey iPageCacheKey, PageReaderContent pageReaderContent) throws IOException {
            if (Util.contains(this.c, iPageCacheKey.getPageKey())) {
                super.putToCache(iPageCacheKey, pageReaderContent);
            }
        }
    }
}

