/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.proxifier;

import com.agilemind.commons.io.pagereader.ICookieManager;
import com.agilemind.commons.io.pagereader.PageReader;
import com.agilemind.commons.io.pagereader.PageReaderFactory;
import com.agilemind.commons.io.pagereader.proxy.IProxySettings;
import com.agilemind.commons.io.proxifier.IProxifiedConnectionSettings;
import com.agilemind.commons.io.proxifier.IProxifier;
import com.agilemind.commons.io.proxifier.IProxyManager;
import com.agilemind.commons.io.proxifier.NoProxyException;
import com.agilemind.commons.io.proxifier.PageReaderChecker;
import com.agilemind.commons.io.proxifier.ServiceType;
import com.agilemind.commons.io.proxifier.cache.CachedCookieCacheStrategyFactory;
import com.agilemind.commons.io.proxifier.cache.api.CacheType;
import com.agilemind.commons.io.proxifier.cache.api.CookieCacheKey;
import com.agilemind.commons.io.proxifier.cache.api.CookieCacheStrategy;
import com.agilemind.commons.io.proxifier.cache.api.CookieCacheStrategyFactory;
import com.agilemind.commons.io.proxifier.captcha.DelegateCaptchaRequestor;
import com.agilemind.commons.io.proxifier.captcha.DelegateSearchEngineManager;
import com.agilemind.commons.io.proxifier.captcha.SilenceCaptchaRequestor;
import com.agilemind.commons.io.proxifier.j;
import com.agilemind.commons.io.proxifier.pagereader.ProxifiedPageReaderFactory;
import com.agilemind.commons.io.searchengine.CaptchaSkippedException;
import com.agilemind.commons.io.searchengine.ParserBrokenException;
import com.agilemind.commons.io.searchengine.RecaptchaSkippedException;
import com.agilemind.commons.io.searchengine.ServiceBlockedByCaptchaException;
import com.agilemind.commons.io.searchengine.ServiceBlockedByRecaptchaException;
import com.agilemind.commons.io.searchengine.ServiceBlockedException;
import com.agilemind.commons.io.searchengine.captcha.ICaptchaSettings;
import com.agilemind.commons.io.searchengine.captcha.SearchEngineManager;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngineTotallyBlockedException;
import com.agilemind.commons.io.utils.IOLogger;
import com.agilemind.commons.localization.stringkey.CommonsStringKey;
import com.agilemind.commons.util.ThreadSafeUtil;
import java.io.IOException;

public abstract class Proxifier<T>
implements IProxifier<T> {
    protected final IProxifiedConnectionSettings connectionSettings;
    protected final ServiceType serviceType;
    private final ICaptchaSettings a;
    private final SearchEngineManager b;
    private final SearchEngineManager c;
    private final CookieCacheStrategy d;
    private final boolean e;
    private int f;
    private static final String g;

    protected Proxifier(IProxifiedConnectionSettings iProxifiedConnectionSettings, ICaptchaSettings iCaptchaSettings, SearchEngineManager searchEngineManager, ServiceType serviceType, CacheType cacheType) {
        this(iProxifiedConnectionSettings, iCaptchaSettings, searchEngineManager, serviceType, new CachedCookieCacheStrategyFactory(3600000L, 60000L), cacheType);
    }

    private Proxifier(IProxifiedConnectionSettings iProxifiedConnectionSettings, ICaptchaSettings iCaptchaSettings, SearchEngineManager searchEngineManager, ServiceType serviceType, CookieCacheStrategyFactory cookieCacheStrategyFactory, CacheType cacheType) {
        this.connectionSettings = iProxifiedConnectionSettings;
        this.a = iCaptchaSettings;
        this.b = searchEngineManager;
        this.c = new DelegateSearchEngineManager(searchEngineManager, new SilenceCaptchaRequestor());
        this.serviceType = serviceType;
        this.d = cookieCacheStrategyFactory.getCookieCacheStrategy(cacheType);
        this.e = serviceType.isSupportProxyRotation();
        this.f = 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T query(IOLogger iOLogger) throws IOException, InterruptedException {
        int n2 = ServiceType.d;
        PageReader pageReader = this.a(iOLogger);
        if (this.a(pageReader)) {
            try {
                T t2 = this.worker(pageReader, this.b);
                this.d.putToCache(new CookieCacheKey(this.serviceType, pageReader), pageReader.getCookieManager());
                return t2;
            }
            catch (CaptchaSkippedException | RecaptchaSkippedException | ServiceBlockedException iOException) {
                this.d.removeFromCache(new CookieCacheKey(this.serviceType, pageReader));
                throw iOException;
            }
            catch (IOException iOException) {
                this.b(pageReader.getPageReaderSettings().getProxySettings());
                throw iOException;
            }
            catch (InterruptedException interruptedException) {
                this.d.putToCache(new CookieCacheKey(this.serviceType, pageReader), pageReader.getCookieManager());
                throw interruptedException;
            }
        }
        T t3 = null;
        IProxyManager iProxyManager = this.connectionSettings.getProxyManager();
        do {
            Object object;
            try {
                iOLogger.log(new CommonsStringKey(g).getString(this.f));
                SearchEngineManager searchEngineManager = this.a(pageReader, iProxyManager);
                t3 = this.worker(pageReader, searchEngineManager);
                iProxyManager.decreaseExecuted(pageReader.getPageReaderSettings().getProxySettings(), this.serviceType, true);
            }
            catch (ServiceBlockedException serviceBlockedException) {
                block30: {
                    block31: {
                        block29: {
                            if (!(serviceBlockedException instanceof SearchEngineTotallyBlockedException)) break block29;
                            iProxyManager.totallyBanProxy(pageReader.getPageReaderSettings().getProxySettings(), this.serviceType);
                            if (n2 == 0) break block30;
                        }
                        if (!(serviceBlockedException instanceof ServiceBlockedByCaptchaException) && !(serviceBlockedException instanceof ServiceBlockedByRecaptchaException) || !iProxyManager.isBlocked(pageReader.getPageReaderSettings().getProxySettings(), this.serviceType) || this.a.isShowCaptchaForRankChecking() || this.a.isShowCaptchaForAdvancedSearchQueries()) break block31;
                        iProxyManager.banShortProxy(pageReader.getPageReaderSettings().getProxySettings(), this.serviceType);
                        if (n2 == 0) break block30;
                    }
                    iProxyManager.banProxy(pageReader.getPageReaderSettings().getProxySettings(), this.serviceType);
                }
                this.d.removeFromCache(new CookieCacheKey(this.serviceType, pageReader));
                if (!this.e) {
                    throw serviceBlockedException;
                }
                object = pageReader;
                pageReader = this.a(iOLogger);
                this.a(pageReader, serviceBlockedException, (PageReader)object);
            }
            catch (ParserBrokenException | InterruptedException exception) {
                iProxyManager.decreaseExecuted(pageReader.getPageReaderSettings().getProxySettings(), this.serviceType, false);
                throw exception;
            }
            catch (CaptchaSkippedException | RecaptchaSkippedException iOException) {
                iProxyManager.banProxy(pageReader.getPageReaderSettings().getProxySettings(), this.serviceType);
                this.d.removeFromCache(new CookieCacheKey(this.serviceType, pageReader));
                throw iOException;
            }
            catch (IOException iOException) {
                object = pageReader.getPageReaderSettings().getProxySettings();
                try {
                    PageReaderChecker.checkPageReader(pageReader);
                    iProxyManager.banProxy(pageReader.getPageReaderSettings().getProxySettings(), this.serviceType);
                }
                catch (IOException iOException2) {
                    this.b((IProxySettings)object);
                    iProxyManager.decreaseExecuted((IProxySettings)object, this.serviceType, false);
                }
                if (!this.e) {
                    throw iOException;
                }
                PageReader pageReader2 = pageReader;
                pageReader = this.a(iOLogger);
                this.a(pageReader, iOException, pageReader2);
            }
            ++this.f;
        } while (t3 == null && this.e);
        this.d.putToCache(new CookieCacheKey(this.serviceType, pageReader), pageReader.getCookieManager());
        return t3;
    }

    protected abstract T worker(PageReader var1, SearchEngineManager var2) throws IOException, InterruptedException;

    private boolean a(PageReader pageReader) {
        return this.a(pageReader.getPageReaderSettings().getProxySettings()) || !this.connectionSettings.getProxyRotationSettings().isUseProxyRotation();
    }

    private SearchEngineManager a(PageReader pageReader, IProxyManager iProxyManager) {
        boolean bl = this.a(pageReader.getPageReaderSettings().getProxySettings());
        boolean bl2 = iProxyManager.isBlocked(pageReader.getPageReaderSettings().getProxySettings(), this.serviceType);
        if (bl || bl2) {
            if (bl) {
                return this.b;
            }
            return new DelegateSearchEngineManager(this.b, new DelegateCaptchaRequestor(this.b, new j(iProxyManager, pageReader, this.serviceType, null)));
        }
        return this.c;
    }

    private boolean a(IProxySettings iProxySettings) {
        return this.connectionSettings.getRealProxySettings() == iProxySettings;
    }

    private void a(PageReader pageReader, IOException iOException, PageReader pageReader2) throws IOException {
        block6: {
            block7: {
                if (!this.a(pageReader.getPageReaderSettings().getProxySettings()) || !this.a(pageReader2.getPageReaderSettings().getProxySettings())) break block6;
                if (this.connectionSettings.getProxyRotationSettings().isUseGlobalProxySettings()) break block7;
                throw new NoProxyException();
            }
            throw iOException;
        }
    }

    private void b(IProxySettings iProxySettings) throws InterruptedException {
        ThreadSafeUtil.invokeAndWait(iProxySettings::setDead);
    }

    private PageReader a(IOLogger iOLogger) throws NoProxyException, InterruptedException {
        PageReader pageReader;
        block11: {
            block10: {
                if (!this.e) break block10;
                pageReader = ProxifiedPageReaderFactory.getInstance(this.connectionSettings).createProxifiedPageReader(iOLogger, this.serviceType);
                if (ServiceType.d == 0) break block11;
            }
            pageReader = PageReaderFactory.getInstance(this.connectionSettings).createPageReaderForNonSearchEngine();
        }
        if (pageReader == null) {
            throw new NoProxyException();
        }
        ICookieManager iCookieManager = this.d.getFromCache(new CookieCacheKey(this.serviceType, pageReader));
        if (iCookieManager != null) {
            pageReader.setCookieManager(iCookieManager);
            this.a(this.serviceType, pageReader);
        }
        return pageReader;
    }

    private void a(ServiceType serviceType, PageReader pageReader) {
        if (this.connectionSettings.getProxyRotationSettings().isUseProxyRotation()) {
            this.connectionSettings.getProxyManager().increaseExecuted(pageReader.getPageReaderSettings().getProxySettings(), serviceType);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "{\u0002\u0019\u0012\u0007`\u001b\u0013\u000eHx\u001d\u001b\u0007\u000fz\u0015R\u0001\u0012`\u0017\u0011\u0010\u0012Z".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 20;
                            break;
                        }
                        case 1: {
                            n7 = 114;
                            break;
                        }
                        case 2: {
                            n7 = 124;
                            break;
                        }
                        case 3: {
                            n7 = 96;
                            break;
                        }
                        default: {
                            n7 = 102;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        g = new String(cArray).intern();
    }
}

