/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.searchengine.searchengines;

import com.agilemind.commons.io.pagereader.HttpResponseIOExeption;
import com.agilemind.commons.io.pagereader.PageReader;
import com.agilemind.commons.io.pagereader.PageReaderContent;
import com.agilemind.commons.io.searchengine.CaptchaSkippedException;
import com.agilemind.commons.io.searchengine.captcha.CaptchaRequestor;
import com.agilemind.commons.io.searchengine.captcha.CaptchaResponse;
import com.agilemind.commons.io.searchengine.captcha.CaptchaTerm;
import com.agilemind.commons.io.searchengine.captcha.ImageSupplierImpl;
import com.agilemind.commons.io.searchengine.searchengines.CaptchaSolution;
import com.agilemind.commons.io.searchengine.searchengines.Query;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.SearchEnginePagination;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngineQuery;
import com.agilemind.commons.io.utils.IOLogger;
import com.agilemind.commons.io.utils.IOUtilMessages;
import com.agilemind.commons.localization.stringkey.StringKey;
import com.agilemind.commons.localization.stringkey.StringKeyStorage;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCaptchaSolution
implements CaptchaSolution {
    protected SearchEngine searchEngine;
    private static final String a;

    public AbstractCaptchaSolution(SearchEngine searchEngine) {
        this.searchEngine = searchEngine;
    }

    @Override
    public boolean hasCaptcha(PageReader pageReader, PageReaderContent pageReaderContent) throws IOException, InterruptedException {
        boolean bl = this.getCaptchaUrl(pageReader, pageReaderContent) != null;
        return bl;
    }

    @Override
    public UnicodeURL getAfterCaptchaUrl(PageReader pageReader, CaptchaRequestor captchaRequestor, PageReaderContent pageReaderContent, Query query, IOLogger iOLogger) throws IOException, InterruptedException {
        CaptchaResponse captchaResponse = query.getCaptcha();
        if (captchaResponse != null) {
            captchaResponse.reportBad();
        }
        UnicodeURL unicodeURL = this.getCaptchaUrl(pageReader, pageReaderContent);
        return this.a(pageReader, captchaRequestor, query, pageReaderContent, unicodeURL, iOLogger, 0);
    }

    private UnicodeURL a(PageReader pageReader, CaptchaRequestor captchaRequestor, Query query, @NotNull PageReaderContent pageReaderContent, UnicodeURL unicodeURL, IOLogger iOLogger, int n2) throws InterruptedException, IOException {
        SearchEngineQuery searchEngineQuery = query.getSearchEngineQuery();
        CaptchaTerm captchaTerm = new CaptchaTerm(searchEngineQuery.getSearchQuery().toString(), AbstractCaptchaSolution.a(this.searchEngine, searchEngineQuery), this.isRussian());
        StringKey stringKey = IOUtilMessages.CAPTCHA_REQUEST_INFO.createExtension(new StringKeyStorage.Fixed(a, this.searchEngine.getType().getName()));
        if (!captchaRequestor.isShouldTryAgain(n2)) {
            throw new CaptchaSkippedException(captchaTerm.getQuery());
        }
        CaptchaResponse captchaResponse = captchaRequestor.requestCaptcha(new ImageSupplierImpl(pageReader, unicodeURL), captchaTerm, stringKey, iOLogger);
        query.setCaptcha(captchaResponse);
        String string = captchaResponse.getResponse();
        if (StringUtil.isEmpty(string)) {
            throw new CaptchaSkippedException(captchaTerm.getQuery());
        }
        iOLogger.log(IOUtilMessages.READING_PAGE.getString());
        try {
            return this.getCaptchaSearchQueryURL(pageReader, string, pageReaderContent.createPage(), query.getQueryUrl());
        }
        catch (HttpResponseIOExeption httpResponseIOExeption) {
            PageReaderContent pageReaderContent2 = httpResponseIOExeption.getErrorContentRaw();
            if (pageReaderContent2 == null) {
                return null;
            }
            unicodeURL = this.getCaptchaUrl(pageReader, pageReaderContent2);
            if (unicodeURL != null) {
                query.getCaptcha().reportBad();
                return this.a(pageReader, captchaRequestor, query, pageReaderContent2, unicodeURL, iOLogger, n2 + 1);
            }
            return null;
        }
    }

    static boolean a(SearchEngine searchEngine, SearchEngineQuery searchEngineQuery) {
        return searchEngineQuery.complex() || searchEngineQuery.getUrlsPerPage() == SearchEnginePagination.MAX || !searchEngine.isSupportGateway();
    }

    protected boolean isRussian() {
        return false;
    }

    protected abstract UnicodeURL getCaptchaUrl(PageReader var1, PageReaderContent var2) throws IOException, InterruptedException;

    protected abstract UnicodeURL getCaptchaSearchQueryURL(PageReader var1, String var2, String var3, UnicodeURL var4) throws IOException, InterruptedException;

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "t\u000f77+H\u0014\u00178>B\u00127".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 43;
                            break;
                        }
                        case 1: {
                            n7 = 124;
                            break;
                        }
                        case 2: {
                            n7 = 82;
                            break;
                        }
                        case 3: {
                            n7 = 86;
                            break;
                        }
                        default: {
                            n7 = 89;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        a = new String(cArray).intern();
    }
}

