/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.searchengine.searchengines;

import com.agilemind.commons.io.pagereader.HttpResponseIOExeption;
import com.agilemind.commons.io.pagereader.PageReader;
import com.agilemind.commons.io.pagereader.PageReaderContent;
import com.agilemind.commons.io.searchengine.RecaptchaSkippedException;
import com.agilemind.commons.io.searchengine.captcha.CaptchaRequestor;
import com.agilemind.commons.io.searchengine.captcha.CaptchaTerm;
import com.agilemind.commons.io.searchengine.captcha.RecaptchaResponse;
import com.agilemind.commons.io.searchengine.searchengines.AbstractCaptchaSolution;
import com.agilemind.commons.io.searchengine.searchengines.CaptchaSolution;
import com.agilemind.commons.io.searchengine.searchengines.Query;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngineQuery;
import com.agilemind.commons.io.utils.IOLogger;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import java.io.IOException;

public abstract class AbstractRecaptchaSolution
implements CaptchaSolution {
    private SearchEngine a;

    public AbstractRecaptchaSolution(SearchEngine searchEngine) {
        this.a = searchEngine;
    }

    @Override
    public boolean hasCaptcha(PageReader pageReader, PageReaderContent pageReaderContent) throws IOException, InterruptedException {
        boolean bl = this.getRecaptchaSiteKey(pageReaderContent) != null;
        return bl;
    }

    @Override
    public UnicodeURL getAfterCaptchaUrl(PageReader pageReader, CaptchaRequestor captchaRequestor, PageReaderContent pageReaderContent, Query query, IOLogger iOLogger) throws InterruptedException, IOException {
        String string = this.getRecaptchaSiteKey(pageReaderContent);
        return this.a(pageReader, captchaRequestor, pageReaderContent, string, query, iOLogger, 0);
    }

    private UnicodeURL a(PageReader pageReader, CaptchaRequestor captchaRequestor, PageReaderContent pageReaderContent, String string, Query query, IOLogger iOLogger, int n2) throws IOException, InterruptedException {
        SearchEngineQuery searchEngineQuery = query.getSearchEngineQuery();
        CaptchaTerm captchaTerm = new CaptchaTerm(searchEngineQuery.getSearchQuery().toString(), AbstractCaptchaSolution.a(this.a, searchEngineQuery));
        if (!captchaRequestor.isShouldTryAgain(n2)) {
            throw new RecaptchaSkippedException(captchaTerm.getQuery());
        }
        RecaptchaResponse recaptchaResponse = captchaRequestor.requestRecaptcha(pageReaderContent.getRequestURL(), string, captchaTerm, iOLogger);
        String string2 = recaptchaResponse.getCode();
        if (StringUtil.isEmpty(string2)) {
            throw new RecaptchaSkippedException(captchaTerm.getQuery());
        }
        try {
            return this.getRecaptchaSearchQueryUrl(pageReader, string2, pageReaderContent.createPage(), pageReaderContent.getRequestURL());
        }
        catch (HttpResponseIOExeption httpResponseIOExeption) {
            PageReaderContent pageReaderContent2 = httpResponseIOExeption.getErrorContentRaw();
            if (pageReaderContent2 == null) {
                return null;
            }
            string = this.getRecaptchaSiteKey(pageReaderContent2);
            if (string != null) {
                return this.a(pageReader, captchaRequestor, pageReaderContent2, string, query, iOLogger, n2 + 1);
            }
            return null;
        }
    }

    protected abstract String getRecaptchaSiteKey(PageReaderContent var1) throws IOException, InterruptedException;

    protected abstract UnicodeURL getRecaptchaSearchQueryUrl(PageReader var1, String var2, String var3, UnicodeURL var4) throws IOException, InterruptedException;
}

