/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.searchengine.searchengines;

import com.agilemind.commons.io.searchengine.searchengines.BackLinkSearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.CacheIndexedSearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.DirectSearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.ISearchQuery;
import com.agilemind.commons.io.searchengine.searchengines.PageIndexedSearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.SearchEnginePagination;
import com.agilemind.commons.io.searchengine.searchengines.SiteIndexedSearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.WebBasedSearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.WebBasedSearchEngineParser;
import com.agilemind.commons.util.Interval;
import com.agilemind.commons.util.UnicodeURL;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.Date;

public abstract class SearchEngineQuery<T> {
    private int a;
    private boolean b;
    private SearchEnginePagination.PerPage c;
    private Interval<Date> d;
    public static boolean e;

    SearchEngineQuery(SearchEnginePagination.PerPage perPage, int n2, boolean bl) {
        this.c = perPage;
        this.a = n2;
        this.b = bl;
    }

    public abstract SearchEngine.SearchEngineParser getSearchEngineParser(SearchEngine var1);

    public Interval<Date> getDateCustom() {
        return this.d;
    }

    public void setDateCustom(Interval<Date> interval) {
        this.d = interval;
    }

    public abstract T getSearchQuery();

    public abstract boolean complex();

    public SearchEnginePagination.PerPage getUrlsPerPage() {
        return this.c;
    }

    public int getPage() {
        return this.a;
    }

    public int getUrlsPerPage(SearchEngine searchEngine) {
        return this.c.getPerPage(this.getSearchEngineParser(searchEngine).getLinksPerPage());
    }

    public int getPreviousResults(SearchEngine searchEngine) {
        return this.a * this.getUrlsPerPage(searchEngine);
    }

    public boolean isWithOmittedResults() {
        return this.b;
    }

    public static class PageIndexed
    extends SearchEngineQuery<UnicodeURL> {
        private UnicodeURL f;

        public PageIndexed(UnicodeURL unicodeURL) {
            super(SearchEnginePagination.MIN, 0, false);
            this.f = unicodeURL;
        }

        @Override
        public SearchEngine.SearchEngineParser getSearchEngineParser(SearchEngine searchEngine) {
            PageIndexedSearchEngine pageIndexedSearchEngine = (PageIndexedSearchEngine)((Object)searchEngine);
            return pageIndexedSearchEngine.getPageIndexedParser();
        }

        @Override
        public UnicodeURL getSearchQuery() {
            return this.f;
        }

        @Override
        public boolean complex() {
            return true;
        }
    }

    public static class CacheIndexed
    extends SearchEngineQuery<UnicodeURL> {
        private UnicodeURL f;

        public CacheIndexed(UnicodeURL unicodeURL) {
            this(unicodeURL, SearchEnginePagination.MIN);
        }

        public CacheIndexed(UnicodeURL unicodeURL, SearchEnginePagination.PerPage perPage) {
            this(unicodeURL, perPage, 0);
        }

        public CacheIndexed(UnicodeURL unicodeURL, SearchEnginePagination.PerPage perPage, int n2) {
            this(unicodeURL, perPage, n2, false);
        }

        public CacheIndexed(UnicodeURL unicodeURL, SearchEnginePagination.PerPage perPage, int n2, boolean bl) {
            super(perPage, n2, bl);
            this.f = unicodeURL;
        }

        @Override
        public UnicodeURL getSearchQuery() {
            return this.f;
        }

        @Override
        public SearchEngine.SearchEngineParser getSearchEngineParser(SearchEngine searchEngine) {
            CacheIndexedSearchEngine cacheIndexedSearchEngine = (CacheIndexedSearchEngine)((Object)searchEngine);
            return cacheIndexedSearchEngine.getCacheIndexedParser();
        }

        @Override
        public boolean complex() {
            return true;
        }
    }

    public static class SiteIndexed
    extends SearchEngineQuery<UnicodeURL> {
        private UnicodeURL f;
        private boolean g;

        public SiteIndexed(UnicodeURL unicodeURL) {
            this(unicodeURL, SearchEnginePagination.MIN, true);
        }

        public SiteIndexed(UnicodeURL unicodeURL, SearchEnginePagination.PerPage perPage, boolean bl) {
            this(unicodeURL, perPage, bl, 0);
        }

        public SiteIndexed(UnicodeURL unicodeURL, SearchEnginePagination.PerPage perPage, boolean bl, int n2) {
            this(unicodeURL, perPage, bl, n2, false);
        }

        public SiteIndexed(UnicodeURL unicodeURL, SearchEnginePagination.PerPage perPage, boolean bl, int n2, boolean bl2) {
            super(perPage, n2, bl2);
            this.f = unicodeURL;
            this.g = bl;
        }

        @Override
        public UnicodeURL getSearchQuery() {
            return this.f;
        }

        public boolean isShowLinksToThisURLOnly() {
            return this.g;
        }

        @Override
        public SearchEngine.SearchEngineParser getSearchEngineParser(SearchEngine searchEngine) {
            SiteIndexedSearchEngine siteIndexedSearchEngine = (SiteIndexedSearchEngine)((Object)searchEngine);
            return siteIndexedSearchEngine.getSiteIndexedParser();
        }

        @Override
        public boolean complex() {
            return true;
        }
    }

    public static class BackLink
    extends SearchEngineQuery<UnicodeURL> {
        private UnicodeURL f;
        private boolean g;
        private boolean h;

        public BackLink(UnicodeURL unicodeURL) {
            this(unicodeURL, SearchEnginePagination.MIN, true, true);
        }

        public BackLink(UnicodeURL unicodeURL, SearchEnginePagination.PerPage perPage, boolean bl, boolean bl2) {
            this(unicodeURL, perPage, bl, bl2, 0, false);
        }

        public BackLink(UnicodeURL unicodeURL, SearchEnginePagination.PerPage perPage, boolean bl, boolean bl2, int n2, boolean bl3) {
            super(perPage, n2, bl3);
            this.f = unicodeURL;
            this.g = bl;
            this.h = bl2;
        }

        @Override
        public UnicodeURL getSearchQuery() {
            return this.f;
        }

        public boolean isShowLinksToThisURLOnly() {
            return this.g;
        }

        public boolean isExceptFromDomain() {
            return this.h;
        }

        @Override
        public SearchEngine.SearchEngineParser getSearchEngineParser(SearchEngine searchEngine) {
            BackLinkSearchEngine backLinkSearchEngine = (BackLinkSearchEngine)((Object)searchEngine);
            return backLinkSearchEngine.getBackLinksParser();
        }

        @Override
        public boolean complex() {
            return true;
        }
    }

    public static class Cached
    extends SearchEngineQuery<UnicodeURL> {
        private UnicodeURL f;

        public Cached(UnicodeURL unicodeURL) {
            super(SearchEnginePagination.MIN, 0, false);
            this.f = unicodeURL;
        }

        @Override
        public UnicodeURL getSearchQuery() {
            return this.f;
        }

        @Override
        public SearchEngine.SearchEngineParser getSearchEngineParser(SearchEngine searchEngine) {
            CacheIndexedSearchEngine cacheIndexedSearchEngine = (CacheIndexedSearchEngine)((Object)searchEngine);
            return cacheIndexedSearchEngine.getCacheIndexedParser();
        }

        @Override
        public boolean complex() {
            return true;
        }
    }

    public static class Keyword
    extends SearchEngineQuery<String> {
        private ISearchQuery f;
        private boolean g;

        public Keyword(ISearchQuery iSearchQuery) {
            this(iSearchQuery, SearchEnginePagination.MIN, false);
        }

        public Keyword(ISearchQuery iSearchQuery, SearchEnginePagination.PerPage perPage, boolean bl) {
            this(iSearchQuery, perPage, 0, bl);
        }

        public Keyword(ISearchQuery iSearchQuery, SearchEnginePagination.PerPage perPage, int n2, boolean bl) {
            this(iSearchQuery, perPage, n2, false, bl);
        }

        public Keyword(ISearchQuery iSearchQuery, SearchEnginePagination.PerPage perPage, int n2, boolean bl, boolean bl2) {
            super(perPage, n2, bl);
            this.f = iSearchQuery;
            this.g = bl2;
        }

        @Override
        public String getSearchQuery() {
            return this.f.query();
        }

        @Override
        public boolean complex() {
            return this.f.complex();
        }

        @Override
        public SearchEngine.SearchEngineParser getSearchEngineParser(SearchEngine searchEngine) {
            DirectSearchEngine directSearchEngine = (DirectSearchEngine)((Object)searchEngine);
            return directSearchEngine.getQueryParser();
        }

        public UnicodeURL getSearchQueryURL(WebBasedSearchEngine webBasedSearchEngine) throws MalformedURLException, UnsupportedEncodingException {
            WebBasedSearchEngineParser webBasedSearchEngineParser = (WebBasedSearchEngineParser)this.getSearchEngineParser(webBasedSearchEngine);
            return webBasedSearchEngineParser.getSearchQueryURL(this);
        }

        public boolean isUseUniversalSearch() {
            return this.g;
        }
    }
}

