/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.searchengine.searchengines;

import com.agilemind.commons.io.searchengine.searchengines.SearchEngineQuery;
import com.agilemind.commons.io.searchengine.searchengines.SearchRecord;
import com.agilemind.commons.io.searchengine.searchengines.data.UniversalSearchType;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchResults {
    public static final int NUMBER_RESULTS_FAILED = -1;
    public static final int NUMBER_RESULTS_NA = -3;
    private final int a;
    private int b;
    private String c;
    private int d;
    private final UnicodeURL e;
    private List<Result> f;
    private boolean g;

    protected SearchResults(UnicodeURL unicodeURL, String string, List<SearchRecord> list, int n2, int n3, int n4, boolean bl) throws MalformedURLException {
        boolean bl2 = SearchEngineQuery.e;
        this.e = unicodeURL;
        this.c = string;
        this.a = n2;
        this.b = n3;
        this.d = n4;
        this.g = bl;
        this.f = new ArrayList<Result>();
        if (list != null) {
            for (SearchRecord searchRecord : list) {
                String[] stringArray = searchRecord.getRecords();
                UniversalSearchType universalSearchType = searchRecord.getSearchResultType();
                UnicodeURL[] unicodeURLArray = new UnicodeURL[stringArray.length];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    UnicodeURL unicodeURL2;
                    UnicodeURL unicodeURL3 = stringArray[i2] != null ? UnicodeURLFactory.getInstance().createUnicodeURL(StringUtil.decode(stringArray[i2])) : null;
                    unicodeURLArray[i2] = unicodeURL2 = unicodeURL3;
                    if (!bl2) continue;
                }
                this.f.add(new Result(universalSearchType, unicodeURLArray, searchRecord.getParameters()));
                if (!bl2) continue;
            }
        }
    }

    @NotNull
    public List<Result> getFoundResults() {
        return this.f;
    }

    public SearchResults getNextPageSearch() throws IOException, InterruptedException {
        return this.getNextPageSearch(this.d + this.f.size(), this.getNextPageURL());
    }

    public SearchResults getNextPageSearch(UnicodeURL unicodeURL) throws IOException, InterruptedException {
        return this.getNextPageSearch(this.d + this.f.size(), unicodeURL);
    }

    public abstract UnicodeURL getNextPageURL() throws MalformedURLException;

    protected abstract SearchResults getNextPageSearch(int var1, UnicodeURL var2) throws IOException, InterruptedException;

    public abstract long getNumberOfResults();

    public boolean isEmpty() {
        return this.f.isEmpty();
    }

    public int getPage() {
        return this.a;
    }

    public int getUrlsPerPage() {
        return this.b;
    }

    public String getPageText() {
        return this.c;
    }

    public int getPreviousResultsCount() {
        return this.d;
    }

    public UnicodeURL getPageUrl() {
        return this.e;
    }

    public boolean isUseUniversalSearch() {
        return this.g;
    }

    public static class Result {
        private final UniversalSearchType a;
        private final UnicodeURL[] b;
        private final Map<String, Object> c;

        public Result(@Nullable UniversalSearchType universalSearchType, @Nullable UnicodeURL[] unicodeURLArray, Map<String, Object> map) {
            this.a = universalSearchType;
            this.b = unicodeURLArray;
            this.c = map;
        }

        public UnicodeURL[] getRecords() {
            return this.b;
        }

        public UnicodeURL getFoundURL() {
            return this.b != null && this.b.length > 0 ? this.b[0] : null;
        }

        public UniversalSearchType getSearchResultType() {
            return this.a;
        }

        @Nullable
        public Object getParameter(String string) {
            return this.c == null ? null : this.c.get(string);
        }

        @Nullable
        public Map<String, Object> getParameters() {
            return this.c;
        }
    }
}

