/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.searchengine.searchengines;

import com.agilemind.commons.io.pagereader.PageReader;
import com.agilemind.commons.io.pagereader.PageReaderContent;
import com.agilemind.commons.io.pagereader.ReadURLSettings;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngine;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngineKnowledgeBaseDataModel;
import com.agilemind.commons.io.searchengine.searchengines.SearchEngineParserBrokenException;
import com.agilemind.commons.io.searchengine.searchengines.data.ISearchEngineHumanEmulationStrategy;
import com.agilemind.commons.io.searchengine.searchengines.type.SearchEngineType;
import com.agilemind.commons.util.UnicodeURL;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class WebBasedSearchEngine
extends SearchEngine {
    protected ISearchEngineHumanEmulationStrategy humanEmulationStrategy;
    protected boolean supportGZip;
    private static final String e;

    protected WebBasedSearchEngine(SearchEngineType searchEngineType, ISearchEngineHumanEmulationStrategy iSearchEngineHumanEmulationStrategy) {
        this(searchEngineType, iSearchEngineHumanEmulationStrategy, true);
    }

    protected WebBasedSearchEngine(SearchEngineType searchEngineType, ISearchEngineHumanEmulationStrategy iSearchEngineHumanEmulationStrategy, boolean bl) {
        this(searchEngineType, iSearchEngineHumanEmulationStrategy, bl, true);
    }

    protected WebBasedSearchEngine(SearchEngineType searchEngineType, ISearchEngineHumanEmulationStrategy iSearchEngineHumanEmulationStrategy, boolean bl, boolean bl2) {
        super(searchEngineType, true, bl2);
        this.humanEmulationStrategy = iSearchEngineHumanEmulationStrategy;
        this.supportGZip = bl;
    }

    protected PageReaderContent readPage(PageReader pageReader, UnicodeURL unicodeURL, ReadURLSettings readURLSettings, Date date) throws IOException, InterruptedException {
        PageReaderContent pageReaderContent = pageReader.getContent(unicodeURL, readURLSettings);
        this.checkIfSearchEngineBroken(pageReaderContent, date);
        return pageReaderContent;
    }

    protected void checkIfSearchEngineBroken(PageReaderContent pageReaderContent, Date date) throws SearchEngineParserBrokenException {
        block4: {
            Date date2 = pageReaderContent.getDate();
            if (date2 == null || !SearchEngineKnowledgeBaseDataModel.isGotBrokenSearchEngine(this.getType(), null, date, date2)) break block4;
            throw new SearchEngineParserBrokenException(pageReaderContent.getRequestURL());
        }
    }

    protected String decodeURL(String string) {
        try {
            string = URLDecoder.decode(string, e);
            string = string.replaceAll(" ", "+");
        }
        catch (UnsupportedEncodingException | IllegalArgumentException exception) {
            // empty catch block
        }
        return string;
    }

    protected Map<String, String> getRequestHeaders() {
        return new HashMap<String, String>();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "\u001f6r\u0013\u000e".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 74;
                            break;
                        }
                        case 1: {
                            n7 = 98;
                            break;
                        }
                        case 2: {
                            n7 = 52;
                            break;
                        }
                        case 3: {
                            n7 = 62;
                            break;
                        }
                        default: {
                            n7 = 54;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        e = new String(cArray).intern();
    }
}

