/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.searchengine.spider;

import com.agilemind.commons.io.pagereader.PageReaderContent;
import com.agilemind.commons.io.pagereader.PageReaderUtil;
import com.agilemind.commons.io.pagereader.ReadURLSettingsBuilder;
import com.agilemind.commons.io.searchengine.robots.NoRobotClient;
import com.agilemind.commons.io.searchengine.spider.Spider;
import com.agilemind.commons.io.searchengine.spider.SpiderLimit;
import com.agilemind.commons.io.utils.URLCollector;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import java.io.IOException;
import java.util.Set;

public abstract class SpiderTask {
    private UnicodeURL a;
    protected Spider spider;
    private int b;
    private NoRobotClient c;

    protected SpiderTask(int n2, UnicodeURL unicodeURL, Spider spider) {
        this(n2, unicodeURL, spider, null);
    }

    protected SpiderTask(int n2, UnicodeURL unicodeURL, Spider spider, NoRobotClient noRobotClient) {
        this.b = n2;
        this.a = unicodeURL;
        this.spider = spider;
        this.c = noRobotClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void collectURLs() throws IOException, InterruptedException {
        int n2 = SpiderLimit.b;
        PageReaderContent pageReaderContent = PageReaderUtil.getContentFollowRedirect(this.spider.c, this.a, ReadURLSettingsBuilder.createNoFollow());
        this.proceedPage(this.a, pageReaderContent);
        URLCollector uRLCollector = new URLCollector(this.a, pageReaderContent.createPage());
        Set<UnicodeURL> set = uRLCollector.getUniqueUrls(URLCollector.URL_TYPE_LOCAL);
        for (UnicodeURL unicodeURL : set) {
            try {
                if (this.c == null || this.c.isUrlAllowed(unicodeURL)) {
                    this.spider.proceedLocalURL(UnicodeURLUtil.getPage(unicodeURL), this);
                }
            }
            catch (IOException iOException) {
                if (this.handleIOException(unicodeURL, iOException)) {
                    throw iOException;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (n2 == 0) continue;
            StringUtil.f = !StringUtil.f;
            return;
        }
    }

    protected abstract boolean handleIOException(UnicodeURL var1, IOException var2);

    protected abstract void proceedPage(UnicodeURL var1, PageReaderContent var2) throws IOException, InterruptedException;

    public int getDeep() {
        return this.b;
    }

    public UnicodeURL getUrl() {
        return this.a;
    }
}

