/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.utils;

import com.agilemind.commons.io.pagereader.IConnectionSettings;
import com.agilemind.commons.io.pagereader.PageReader;
import com.agilemind.commons.io.pagereader.PageReaderContent;
import com.agilemind.commons.io.pagereader.PageReaderFactory;
import com.agilemind.commons.io.searchengine.searchengines.data.ISearchEngineHumanEmulationStrategy;
import com.agilemind.commons.io.searchengine.searchengines.humanemulation.SearchEngineHumanEmulationBrakes;
import com.agilemind.commons.io.utils.IOLogger;
import com.agilemind.commons.io.utils.IOUtilMessages;
import com.agilemind.commons.io.utils.NoCache;
import com.agilemind.commons.io.utils.URLCollector;
import com.agilemind.commons.io.utils.WhoisUtil;
import com.agilemind.commons.localization.stringkey.CommonsStringKey;
import com.agilemind.commons.util.ICache;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.tags.BodyTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public abstract class ContactInfoCollector
implements IOLogger {
    private PageReader a;
    public static final List<String> TEXTS;
    public static final List<String> DEFAULT_EXCLUDED_EMAILS;
    private Collection<String> b;
    private Collection<String> c;
    private ICache<UnicodeURL, Set<String>> d;
    private static final String[] e;

    public ContactInfoCollector(IConnectionSettings iConnectionSettings, Collection<String> collection) {
        this(PageReaderFactory.getInstance(iConnectionSettings).createPageReaderForNonSearchEngine(), TEXTS, collection);
    }

    public ContactInfoCollector(PageReader pageReader, Collection<String> collection, Collection<String> collection2) {
        this(pageReader, new NoCache<UnicodeURL, Set<String>>(), collection, collection2);
    }

    public ContactInfoCollector(PageReader pageReader, ICache<UnicodeURL, Set<String>> iCache, Collection<String> collection, Collection<String> collection2) {
        this.a = pageReader;
        this.d = iCache;
        this.b = collection;
        this.c = StringUtil.toLowerCase(collection2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> getContactInfo(UnicodeURL unicodeURL, ISearchEngineHumanEmulationStrategy iSearchEngineHumanEmulationStrategy) throws IOException, InterruptedException {
        boolean bl = URLCollector.URLType.b;
        Set<String> set = this.getEmailsFromPage(unicodeURL, iSearchEngineHumanEmulationStrategy);
        if (set.isEmpty()) {
            try {
                WhoisUtil.getEmail(set, unicodeURL);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        set = StringUtil.toLowerCase(set);
        this.log(new CommonsStringKey(e[3]).getString());
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (!StringUtil.anyContainsIgnoreCase(string, this.c)) {
                hashSet.add(string);
            }
            if (!bl) continue;
        }
        return hashSet;
    }

    public Set<String> getEmailsFromPage(UnicodeURL unicodeURL, ISearchEngineHumanEmulationStrategy iSearchEngineHumanEmulationStrategy) throws IOException, InterruptedException {
        UnicodeURL unicodeURL2 = UnicodeURLUtil.getHomePage(unicodeURL);
        Set<String> set = this.d.get(unicodeURL2);
        if (set != null) {
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        this.a(hashSet, unicodeURL2, iSearchEngineHumanEmulationStrategy);
        if (!unicodeURL.equals(unicodeURL2)) {
            this.a(hashSet, unicodeURL, iSearchEngineHumanEmulationStrategy);
        }
        this.d.put(unicodeURL2, hashSet);
        return hashSet;
    }

    private void a(Collection<String> collection, UnicodeURL unicodeURL, ISearchEngineHumanEmulationStrategy iSearchEngineHumanEmulationStrategy) throws IOException, InterruptedException {
        boolean bl = URLCollector.URLType.b;
        this.log(IOUtilMessages.READING_KNOWN_PAGE.getString(unicodeURL));
        PageReaderContent pageReaderContent = this.a.getContent(unicodeURL);
        String string = pageReaderContent.createPage();
        this.log(new CommonsStringKey(e[1]).getString());
        ContactInfoCollector.a(collection, unicodeURL, string);
        URLCollector uRLCollector = new URLCollector(unicodeURL, string);
        if (this.b != null) {
            this.log(new CommonsStringKey(e[2]).getString());
            Set<UnicodeURL> set = uRLCollector.getUniqueUrls(URLCollector.URL_TYPE_LOCAL, this.b);
            SearchEngineHumanEmulationBrakes searchEngineHumanEmulationBrakes = new SearchEngineHumanEmulationBrakes();
            for (UnicodeURL unicodeURL2 : set) {
                try {
                    searchEngineHumanEmulationBrakes.waitQuery(iSearchEngineHumanEmulationStrategy, this);
                    this.log(IOUtilMessages.READING_KNOWN_PAGE.getString(unicodeURL2));
                    PageReaderContent pageReaderContent2 = this.a.getContent(unicodeURL2);
                    string = pageReaderContent2.createPage();
                    this.log(new CommonsStringKey(e[0]).getString());
                    ContactInfoCollector.a(collection, unicodeURL, string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!bl) continue;
            }
        }
    }

    public void getEmailsFromPage(Collection<String> collection, UnicodeURL unicodeURL) throws IOException, InterruptedException {
        boolean bl = URLCollector.URLType.b;
        PageReaderContent pageReaderContent = this.a.getContent(unicodeURL);
        String string = pageReaderContent.createPage();
        ContactInfoCollector.a(collection, unicodeURL, string);
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (StringUtil.anyContainsIgnoreCase(string2, this.c)) {
                iterator.remove();
            }
            if (!bl) continue;
        }
    }

    private static void a(Collection<String> collection, UnicodeURL unicodeURL, String string) throws IOException, InterruptedException {
        NodeList nodeList;
        Object object;
        boolean bl = URLCollector.URLType.b;
        try {
            object = new Parser(new Lexer(string));
            nodeList = object.extractAllNodesThatMatch((NodeFilter)new NodeClassFilter(BodyTag.class));
            String string2 = nodeList.asString(" ");
            Object object2 = StringUtil.find(string2, e[4]);
            collection.addAll((Collection<String>)object2);
        }
        catch (ParserException parserException) {
            // empty catch block
        }
        object = new URLCollector(unicodeURL, string);
        nodeList = ((URLCollector)object).getUniqueUrls(URLCollector.URL_TYPE_MAIL);
        for (Object object2 : nodeList) {
            block7: {
                String string3 = ((UnicodeURL)object2).getPath();
                if (StringUtil.isEmpty(string3) || !StringUtil.isValidEmail(string3)) break block7;
                collection.add(string3);
            }
            if (!bl) continue;
        }
    }

    @Override
    public abstract void log(String var1);

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "%\"@\u0006^>;J\u001a\u0011&=B\u0013V$5\u000b\u0017P$&D\u0017K9\u001eJ\u001bT?\"";
        int n3 = -1;
        block120: while (true) {
            char[] cArray;
            block125: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block124: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block124;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block125;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 74;
                                break;
                            }
                            case 1: {
                                n9 = 82;
                                break;
                            }
                            case 2: {
                                n9 = 37;
                                break;
                            }
                            case 3: {
                                n9 = 116;
                                break;
                            }
                            default: {
                                n9 = 63;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "%\"@\u0006^>;J\u001a\u0011&=B\u0013V$5\u000b\u0017P$&D\u0017K9\u001eJ\u001bT?\"";
                    n3 = 0;
                    continue block120;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "%\"@\u0006^>;J\u001a\u0011&=B\u0013V$5\u000b\u0017P&>@\u0017K#<B8V$9V";
                    n3 = 1;
                    continue block120;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "%\"@\u0006^>;J\u001a\u0011&=B\u0013V$5\u000b\u0011G)>P\u0010V$5a\u0001O&;F\u0015K/!";
                    n3 = 2;
                    continue block120;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "b\u000eR_dg|\u000eRba{\u000f(Ha\u0012\r/\u0012z\u007f\u001c\u0015\u00120\u0013\b.ba\t\u000b)\u0016a\tDYE\u000b\u007f\u007f)Dx~\u0014CB";
                    n3 = 3;
                    continue block120;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    e = stringArray3;
                    String[] stringArray4 = new String[78];
                    stringArray2 = stringArray4;
                    stringArray3 = stringArray4;
                    n2 = 0;
                    string2 = "+0J\u0001K";
                    n3 = 4;
                    continue block120;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = ")=H\u0004^$+";
                    n3 = 5;
                    continue block120;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = ")=K\u0000^)&";
                    n3 = 6;
                    continue block120;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "87T\u0001Z9&";
                    n3 = 7;
                    continue block120;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "#<C\u001b";
                    n3 = 8;
                    continue block120;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "9'U\u0004P8&";
                    n3 = 9;
                    continue block120;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "#?U\u0006Z9!P\u0019";
                    n3 = 10;
                    continue block120;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "!=K\u0000^!&";
                    n3 = 11;
                    continue block120;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u0016'\u0015@\f+\u000ePD\u000by7y\u0001\u000f~aA(Jzf\u0011Fc?b\u0011G\u000f\u0016'\u0015@\f+\u000ePD\u000b~`y\u0001\u000f~fG";
                    n3 = 12;
                    continue block120;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u0016'\u0015@\f/\u000ePD\u000bycy\u0001\u000f~f\u0015(Jzf\u0016Dc?b\u0011@\r\u0016'\u0015@\f.\u000ePD\u000byby\u0001\u000f~fCTc?b\u0011@\u000e\u0016'\u0015@\fx\u000ePD\u000b~4y\u0001\u000f~a\u0012(Jzf\u0011\u0017";
                    n3 = 13;
                    continue block120;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u00b60@\u0006";
                    n3 = 14;
                    continue block120;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u001f<Q\u0011M$7M\u0019Z$";
                    n3 = 15;
                    continue block120;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "?<V";
                    n3 = 16;
                    continue block120;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u000b<C\u0006^-7";
                    n3 = 17;
                    continue block120;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "?<Q\u0011M9&\u00d9\u0000E?<B";
                    n3 = 18;
                    continue block120;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "!=K\u0000^!&L\u0011M/<";
                    n3 = 19;
                    continue block120;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "9'W";
                    n3 = 20;
                    continue block120;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "9=F\u001d\u00d6>\u00bb";
                    n3 = 21;
                    continue block120;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "$=P\u0007";
                    n3 = 22;
                    continue block120;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = ".7H\u0015Q.7";
                    n3 = 23;
                    continue block120;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "9=P\u0000V/<";
                    n3 = 24;
                    continue block120;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "9=G\u0006Z";
                    n3 = 25;
                    continue block120;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "/?U\u0006Z93";
                    n3 = 26;
                    continue block120;
                }
                case 26: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = ")=K\u0000^)&J";
                    n3 = 27;
                    continue block120;
                }
                case 27: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "$=V\u001bK8=V";
                    n3 = 28;
                    continue block120;
                }
                case 28: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = ".7H\u0015Q.3";
                    n3 = 29;
                    continue block120;
                }
                case 29: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "+!L\u0007K/<F\u001d^";
                    n3 = 30;
                    continue block120;
                }
                case 30: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = ">\u00b3W\u0007^9\u00b3B";
                    n3 = 31;
                    continue block120;
                }
                case 31: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 28;
                    string2 = "!3U\u0017L%>D\u0000";
                    n3 = 32;
                    continue block120;
                }
                case 32: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 29;
                    string2 = "!\u00bbW\u009dL";
                    n3 = 33;
                    continue block120;
                }
                case 33: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 30;
                    string2 = ">\u00b3H\u001bX+&\u00c4\u0007";
                    n3 = 34;
                    continue block120;
                }
                case 34: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 31;
                    string2 = ")=H\u0004^-<L\u0015";
                    n3 = 35;
                    continue block120;
                }
                case 35: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 32;
                    string2 = ")=K\u0000^>&J";
                    n3 = 36;
                    continue block120;
                }
                case 36: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 33;
                    string2 = "$=L";
                    n3 = 37;
                    continue block120;
                }
                case 37: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 34;
                    string2 = "8;F\u001cV/!Q\u0015";
                    n3 = 38;
                    continue block120;
                }
                case 38: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 35;
                    string2 = "9=V\u0000Z-<J";
                    n3 = 39;
                    continue block120;
                }
                case 39: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 36;
                    string2 = ")=K\u0000^>&L";
                    n3 = 40;
                    continue block120;
                }
                case 40: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 37;
                    string2 = "\u0019\"J\u0018P\u0147<J\u0007K";
                    n3 = 41;
                    continue block120;
                }
                case 41: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 38;
                    string2 = "\u0004\u00b3V";
                    n3 = 42;
                    continue block120;
                }
                case 42: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 39;
                    string2 = "\u0137;D\u0010P9\u0137";
                    n3 = 43;
                    continue block120;
                }
                case 43: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 40;
                    string2 = ":=H\u001b\\";
                    n3 = 44;
                    continue block120;
                }
                case 44: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 41;
                    string2 = "\f;W\u0019^";
                    n3 = 45;
                    continue block120;
                }
                case 45: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 42;
                    string2 = "$3V";
                    n3 = 46;
                    continue block120;
                }
                case 46: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 43;
                    string2 = "03U\u001bK8(@\u0016P=3K\u001dZ";
                    n3 = 47;
                    continue block120;
                }
                case 47: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 44;
                    string2 = "\u001d!U\u0015M);@";
                    n3 = 48;
                    continue block120;
                }
                case 48: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 45;
                    string2 = "\u0470\u046c\u0419\u044b\u040f\u0477\u046a\u046a";
                    n3 = 49;
                    continue block120;
                }
                case 49: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 46;
                    string2 = "\u0470\u046c\u0418\u0436\u040f\u0470\u0410\u046e";
                    n3 = 50;
                    continue block120;
                }
                case 50: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 47;
                    string2 = "\u047d\u0462\u041a\u0434\u0401\u040b";
                    n3 = 51;
                    continue block120;
                }
                case 51: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 48;
                    string2 = "\u0472\u046f\u0461\u044a\u047f\u0476\u0462\u0463\u044c\u0470";
                    n3 = 52;
                    continue block120;
                }
                case 52: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 49;
                    string2 = "\u0475\u046c\u0411\u0440\u040a\u040a\u0464\u041f\u0444";
                    n3 = 53;
                    continue block120;
                }
                case 53: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 50;
                    string2 = "\u0474\u0463\u0005\u0444\u040d\u0408\u046c\u0465\u0441";
                    n3 = 54;
                    continue block120;
                }
                case 54: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 51;
                    string2 = "\u040b\u0460\u046a\u0443\u040f\u0408\u041e\u0464\u043b";
                    n3 = 55;
                    continue block120;
                }
                case 55: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 52;
                    string2 = ":=A\u001eZ>8@";
                    n3 = 56;
                    continue block120;
                }
                case 56: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 53;
                    string2 = "9&L\u001f";
                    n3 = 57;
                    continue block120;
                }
                case 57: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 54;
                    string2 = "03M\u0000Z<3";
                    n3 = 58;
                    continue block120;
                }
                case 58: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 55;
                    string2 = ":=H\u001b\u0132";
                    n3 = 59;
                    continue block120;
                }
                case 59: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 56;
                    string2 = "!=K\u0000^!&L\u0006^ &@";
                    n3 = 60;
                    continue block120;
                }
                case 60: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 57;
                    string2 = ".7V\u0004M/";
                    n3 = 61;
                    continue block120;
                }
                case 61: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 58;
                    string2 = ")=H\u0004^$;@";
                    n3 = 62;
                    continue block120;
                }
                case 62: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 59;
                    string2 = "&7B\u0177K? \u0126";
                    n3 = 63;
                    continue block120;
                }
                case 63: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 60;
                    string2 = "$=P\u0177";
                    n3 = 64;
                    continue block120;
                }
                case 64: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 61;
                    string2 = "9=I\u001d\\#&D\u0006Z";
                    n3 = 65;
                    continue block120;
                }
                case 65: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 62;
                    string2 = "9\"W\u001dU#<";
                    n3 = 66;
                    continue block120;
                }
                case 66: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 63;
                    string2 = ")=K\u0000^)&D\u0000V";
                    n3 = 67;
                    continue block120;
                }
                case 67: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 64;
                    string2 = "%<A\u0011M$7H\u001dQ-";
                    n3 = 68;
                    continue block120;
                }
                case 68: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 65;
                    string2 = "%<V";
                    n3 = 69;
                    continue block120;
                }
                case 69: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 66;
                    string2 = "<7W\u000eP/9";
                    n3 = 70;
                    continue block120;
                }
                case 70: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 67;
                    string2 = "%<A\u0011M9&@\u0001Q#<B";
                    n3 = 71;
                    continue block120;
                }
                case 71: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 68;
                    string2 = ")=K\u0000^)&\u0005\u001cZ(0@\u001a";
                    n3 = 72;
                    continue block120;
                }
                case 72: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 69;
                    string2 = "/>\u00cc\u0006W/&\u0174\u0007\u00d6-";
                    n3 = 73;
                    continue block120;
                }
                case 73: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 70;
                    string2 = "/>\u00cc\u0006W/&\u0174\u0007\u00d6-7N";
                    n3 = 74;
                    continue block120;
                }
                case 74: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 71;
                    string2 = "#<C\u0087";
                    n3 = 75;
                    continue block120;
                }
                case 75: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 72;
                    string2 = "8\u00a1I\u0001Q!r";
                    n3 = 76;
                    continue block120;
                }
                case 76: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 73;
                    string2 = "'3B\u0001Q! \u00d6\u0018";
                    n3 = 77;
                    continue block120;
                }
                case 77: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 74;
                    string2 = "(7H\u0001K+&N\u001bE\u00ab!";
                    n3 = 78;
                    continue block120;
                }
                case 78: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 75;
                    string2 = "<\u00b3I\u0018^&3Q";
                    n3 = 79;
                    continue block120;
                }
                case 79: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 76;
                    string2 = ")\u00bbB\u0088Q!";
                    n3 = 80;
                    continue block120;
                }
                case 80: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 77;
                    string2 = ")\u00bbB\u0006\u016e&";
                    n3 = 81;
                    continue block120;
                }
                case 81: {
                    stringArray2[n2] = string.intern();
                    TEXTS = Arrays.asList(stringArray3);
                    String[] stringArray5 = new String[30];
                    stringArray2 = stringArray5;
                    stringArray3 = stringArray5;
                    n2 = 0;
                    string2 = "\nb\u0015D[%?D\u001dQ9|F\u001bR";
                    n3 = 82;
                    continue block120;
                }
                case 82: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\nc\u0017G[%?D\u001dQ87B\u001dL> \\Z\\%?";
                    n3 = 83;
                    continue block120;
                }
                case 83: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\ncD\u001a[{|F\u001bR";
                    n3 = 84;
                    continue block120;
                }
                case 84: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\ncD\u001a[{\u007fU\u0006V<3Q\u0011\u001287B\u001dL> D\u0000V%<\u000b\u0017P'";
                    n3 = 85;
                    continue block120;
                }
                case 85: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\n0@\rP$6\u000b\u0017P'";
                    n3 = 86;
                    continue block120;
                }
                case 86: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\n1J\u001aK+1Q\u0004M#$D\u0017Fd1J\u0019";
                    n3 = 87;
                    continue block120;
                }
                case 87: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\n6J\u0019^#<D\u0017K#$@Z\\%?";
                    n3 = 88;
                    continue block120;
                }
                case 88: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\n6J\u0019^#<G\u0015Q!|F\u001bR";
                    n3 = 89;
                    continue block120;
                }
                case 89: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\n6J\u0019^#<A\u001dL) @\u0011Kd1J\u0019";
                    n3 = 90;
                    continue block120;
                }
                case 90: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\n6J\u0019^#<V\u0016F: J\fFd1J\u0019";
                    n3 = 91;
                    continue block120;
                }
                case 91: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\n6J\u0019^#<V\u0011M<;F\u0011\u0011)=H";
                    n3 = 92;
                    continue block120;
                }
                case 92: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\n6W\u001b^d1J\u0019";
                    n3 = 93;
                    continue block120;
                }
                case 93: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\n7K\u001bRd1J\u0019";
                    n3 = 94;
                    continue block120;
                }
                case 94: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\n5D\u001a[#|K\u0011K";
                    n3 = 95;
                    continue block120;
                }
                case 95: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\n:J\u0019Z9&@\u0015[9'U\u0004P8&\u000b\u0017P'";
                    n3 = 96;
                    continue block120;
                }
                case 96: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\n;U\u001bH/ R\u0011]d1J\u0019";
                    n3 = 97;
                    continue block120;
                }
                case 97: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "\n?\\\u0004M#$D\u0000Z87B\u001dL> D\u0000V%<\u000b\u0017P'";
                    n3 = 98;
                    continue block120;
                }
                case 98: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "\n<D\u0019Z(3W\u0013^#<\u000b\u0017P'";
                    n3 = 99;
                    continue block120;
                }
                case 99: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "\n<D\u0019Z):@\u0015Od1J\u0019";
                    n3 = 100;
                    continue block120;
                }
                case 100: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "\n<D\u0019Z9|F\u001b\u0011?9";
                    n3 = 101;
                    continue block120;
                }
                case 101: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "\n<@\u0000H% N\u0007P&'Q\u001dP$!\u000b\u0017P'";
                    n3 = 102;
                    continue block120;
                }
                case 102: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "\n<@\u0000H% N\u0007P&'Q\u001dP$!U\u0006V<3Q\u0011M/5L\u0007K83Q\u001dP$|F\u001bR";
                    n3 = 103;
                    continue block120;
                }
                case 103: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "\n\"W\u001dI+1\\\u0004P9&\u000b\u0017P'";
                    n3 = 104;
                    continue block120;
                }
                case 104: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "\n\"W\u001dI+1\\\u0004M%&@\u0017Kd=W\u0013";
                    n3 = 105;
                    continue block120;
                }
                case 105: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "\n\"W\u001bK/1Q\u0011[: L\u0002^)+\u000b\u0017P'";
                    n3 = 106;
                    continue block120;
                }
                case 106: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "\n @\u0013V9&@\u0006\u0011)=H";
                    n3 = 107;
                    continue block120;
                }
                case 107: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "\n!L\u0000Z: J\u0000Z)&\u000b\u0017P'";
                    n3 = 108;
                    continue block120;
                }
                case 108: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "\n$@\u0006V%\u007fM\u001bL>;K\u0013\u0011)=H";
                    n3 = 109;
                    continue block120;
                }
                case 109: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 28;
                    string2 = "\n%M\u001bV95P\u0015M.|F\u001bR";
                    n3 = 110;
                    continue block120;
                }
                case 110: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 29;
                    string2 = "\n%M\u001bV9\"W\u001dI+1\\\u0004M%&@\u0017Kd1J\u0019";
                    n3 = 111;
                    continue block120;
                }
                case 111: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        DEFAULT_EXCLUDED_EMAILS = Arrays.asList(stringArray3);
    }
}

