/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.io.utils;

import com.agilemind.commons.io.IOUtils;
import com.agilemind.commons.io.utils.g;
import com.agilemind.commons.io.utils.h;
import com.agilemind.commons.io.utils.i;
import com.agilemind.commons.io.utils.j;
import com.agilemind.commons.io.utils.k;
import com.agilemind.commons.io.utils.m;
import com.agilemind.commons.io.utils.n;
import com.agilemind.commons.io.utils.o;
import com.agilemind.commons.util.Charset;
import com.agilemind.commons.util.HtmlUtils;
import com.agilemind.commons.util.LinkPrototypicalNodeFactory;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLFactory;
import com.agilemind.commons.util.UnicodeURLUtil;
import com.agilemind.commons.util.UrlUtils;
import com.agilemind.commons.util.Util;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.htmlparser.Node;
import org.htmlparser.NodeFactory;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.Tag;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.tags.ImageTag;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class URLCollector {
    public static final String ANCHOR_SPLIT_REGEX;
    public static final String IMAGE_ANCHOR;
    public static final String PATH_SPLIT_REGEX;
    public static final String HTTP_PROTOCOL;
    public static final String MAILTO_PROTOCOL;
    public static final URLType URL_TYPE_ALL;
    public static final URLType URL_TYPE_IMAGE;
    public static final URLType URL_TYPE_MAIL;
    public static final URLType URL_TYPE_LOCAL;
    public static final URLType URL_TYPE_HTTP;
    public static final URLType URL_TYPE_LOCAL_HTTP;
    public static final URLType URL_TYPE_REMOTE;
    public static final URLType URL_TYPE_REMOTE_HTTP;
    public static final URLType URL_TYPE_SUBFOLDER;
    public static final URLType URL_TYPE_TEXT;
    public static final URLType URL_TYPE_LOCAL_REMOTE;
    private UnicodeURL a;
    private String b;
    private static final String[] c;

    public URLCollector(UnicodeURL unicodeURL, String string) {
        this.a = unicodeURL;
        this.b = string;
    }

    @NotNull
    public static String removeMultipleSlash(@NotNull String string) {
        String string2 = "";
        String string3 = "";
        int n2 = string.indexOf(c[7]);
        if (n2 > 0 && n2 < 6) {
            string2 = string.substring(0, n2 + 3);
            string = string.substring(n2 + 3);
        }
        if ((n2 = string.indexOf("?")) >= 0) {
            string3 = string.substring(n2);
            string = string.substring(0, n2);
        }
        return string2 + string.replaceAll(c[9], c[8]) + string3;
    }

    public static boolean isLocalURL(UnicodeURL unicodeURL, UnicodeURL unicodeURL2) {
        boolean bl;
        block3: {
            block2: {
                boolean bl2 = UnicodeURLUtil.getHostWithoutWWW(unicodeURL2).equalsIgnoreCase(UnicodeURLUtil.getHostWithoutWWW(unicodeURL));
                if (!unicodeURL.getProtocol().contains(c[0]) || !unicodeURL2.getProtocol().contains(c[1])) break block2;
                bl = true;
                if (!URLType.b) break block3;
            }
            bl = unicodeURL2.getProtocol().equals(unicodeURL.getProtocol());
        }
        return bl2 &= bl;
    }

    public Set<UnicodeURL> getUniqueUrls(URLType uRLType, Collection<String> collection) throws IOException, InterruptedException {
        return new HashSet<UnicodeURL>(this.getUrls(uRLType, collection, Charset.UTF8));
    }

    public Set<UnicodeURL> getUniqueUrls(URLType uRLType) throws IOException, InterruptedException {
        return new HashSet<UnicodeURL>(this.getUrls(uRLType, null, Charset.UTF8));
    }

    public List<UnicodeURL> getUrls(URLType uRLType) throws IOException, InterruptedException {
        return this.getUrls(uRLType, null, Charset.UTF8);
    }

    public List<UnicodeURL> getUrls(URLType uRLType, Collection<String> collection, Charset charset) throws IOException, InterruptedException {
        boolean bl = URLType.b;
        List<LinkDescription> list = this.getUrls(uRLType, collection, charset, false, null);
        ArrayList<UnicodeURL> arrayList = new ArrayList<UnicodeURL>();
        for (LinkDescription linkDescription : list) {
            arrayList.add(linkDescription.getLink());
            if (!bl) continue;
        }
        return arrayList;
    }

    public List<LinkDescription> getUrls(URLType uRLType, @Nullable Collection<String> collection, Charset charset, boolean bl, UnicodeURL unicodeURL) throws IOException, InterruptedException {
        try {
            Lexer lexer = new Lexer(this.b);
            NodeList nodeList = this.a(lexer);
            return this.a(uRLType, collection, charset, bl, unicodeURL, lexer.getPage(), nodeList);
        }
        catch (ParserException parserException) {
            throw IOUtils.throwIOException(parserException);
        }
    }

    private List<LinkDescription> a(URLType uRLType, @Nullable Collection<String> collection, Charset charset, boolean bl, UnicodeURL unicodeURL, Page page, NodeList nodeList) throws InterruptedException {
        boolean bl2 = URLType.b;
        Util.checkInterrupted();
        ArrayList<LinkDescription> arrayList = new ArrayList<LinkDescription>();
        SimpleNodeIterator simpleNodeIterator = nodeList.elements();
        while (simpleNodeIterator.hasMoreNodes()) {
            LinkTag linkTag = (LinkTag)simpleNodeIterator.nextNode();
            LinkDescription linkDescription = this.a(uRLType, collection, charset, bl, unicodeURL, page, linkTag);
            if (linkDescription != null) {
                arrayList.add(linkDescription);
            }
            if (!bl2) continue;
        }
        return arrayList;
    }

    @Nullable
    private LinkDescription a(URLType uRLType, @Nullable Collection<String> collection, Charset charset, boolean bl, UnicodeURL unicodeURL, Page page, LinkTag linkTag) {
        if (!linkTag.isJavascriptLink()) {
            String string = this.b(linkTag);
            String string2 = linkTag.getLinkText();
            try {
                UnicodeURL unicodeURL2 = this.a(charset, bl, string);
                if (uRLType.accept(this.a, unicodeURL2, (Tag)linkTag)) {
                    return this.a(collection, charset, unicodeURL, page, linkTag, string2, unicodeURL2);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private LinkDescription a(@Nullable Collection<String> collection, Charset charset, UnicodeURL unicodeURL, Page page, LinkTag linkTag, String string, UnicodeURL unicodeURL2) throws MalformedURLException {
        LinkDescription linkDescription;
        block11: {
            AnchorType anchorType;
            Object object;
            block8: {
                boolean bl;
                block10: {
                    block9: {
                        bl = URLType.b;
                        if (collection == null) break block8;
                        object = new g(string, unicodeURL2.getPath());
                        if (!((g)object).a(collection)) break block9;
                        linkDescription = new LinkDescription(unicodeURL2, unicodeURL, string, page.row(linkTag.getStartPosition()), page.column(linkTag.getStartPosition()), page.row(linkTag.getEndPosition()), page.column(linkTag.getEndPosition()));
                        if (!bl) break block10;
                    }
                    linkDescription = null;
                }
                if (!bl) break block11;
            }
            object = null;
            string = StringUtil.trimHTML(string.replaceAll(c[2], " "));
            Node node = this.a(linkTag);
            if (node != null) {
                anchorType = AnchorType.IMAGE;
                object = this.a(charset, (ImageTag)node);
                string = ((ImageTag)node).getAttribute(c[4]);
            } else {
                anchorType = AnchorType.TEXT;
                string = StringUtil.decode(string.replaceAll(c[3], ""));
            }
            linkDescription = new LinkDescription(unicodeURL2, unicodeURL, string, (UnicodeURL)object, anchorType, page.row(linkTag.getStartPosition()) + 1, page.column(linkTag.getStartPosition()), page.row(linkTag.getEndPosition()) + 1, page.column(linkTag.getEndPosition()), HtmlUtils.isNofollow((CompositeTag)linkTag));
        }
        return linkDescription;
    }

    private Node a(LinkTag linkTag) {
        boolean bl = URLType.b;
        SimpleNodeIterator simpleNodeIterator = linkTag.children();
        while (simpleNodeIterator.hasMoreNodes()) {
            Node node = simpleNodeIterator.nextNode();
            if (node instanceof ImageTag) {
                return node;
            }
            if (!bl) continue;
        }
        return null;
    }

    private UnicodeURL a(Charset charset, ImageTag imageTag) throws MalformedURLException {
        try {
            UnicodeURL unicodeURL = this.a == null ? UnicodeURLFactory.getInstance().createUnicodeURL(this.a, imageTag.getImageURL(), charset) : UnicodeURLFactory.getInstance().createUnicodeURL(UrlUtils.resolveUrl(this.a.toIDNString(), imageTag.getImageURL()));
            return unicodeURL;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @NotNull
    private String b(LinkTag linkTag) {
        String string = StringUtil.trim(linkTag.getLink());
        string = URLCollector.removeMultipleSlash(StringUtil.decode(string));
        if (linkTag.isMailLink()) {
            string = c[6] + string;
        }
        return string;
    }

    private UnicodeURL a(Charset charset, boolean bl, String string) throws MalformedURLException {
        UnicodeURL unicodeURL = this.a == null ? UnicodeURLFactory.getInstance().createUnicodeURL(this.a, string, charset) : UnicodeURLFactory.getInstance().createUnicodeURL(this.a(string), charset, bl);
        return unicodeURL;
    }

    private String a(String string) {
        if (string.startsWith(c[5])) {
            string = this.a.getProtocol() + ":" + string;
        }
        return UrlUtils.resolveUrl(this.a.toString(), string);
    }

    private NodeList a(Lexer lexer) throws ParserException {
        Parser parser = new Parser(lexer);
        parser.setNodeFactory((NodeFactory)new LinkPrototypicalNodeFactory());
        return parser.extractAllNodesThatMatch((NodeFilter)new NodeClassFilter(LinkTag.class));
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[12];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "*TFl";
        int n3 = 11;
        block24: while (true) {
            char[] cArray;
            block29: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block28: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block28;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block29;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 66;
                                break;
                            }
                            case 1: {
                                n9 = 32;
                                break;
                            }
                            case 2: {
                                n9 = 50;
                                break;
                            }
                            case 3: {
                                n9 = 28;
                                break;
                            }
                            default: {
                                n9 = 3;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 11: {
                    HTTP_PROTOCOL = string.intern();
                    string2 = "\u0019|\r6_\u001c\u000b\u000f>$~\u001eNbcm|\u001fC_n|A=_\u0019|o@-x\u001bn\\ g\b\u001bA";
                    n3 = 12;
                    continue block24;
                }
                case 12: {
                    ANCHOR_SPLIT_REGEX = string.intern();
                    string2 = "/A[pw-";
                    n3 = 13;
                    continue block24;
                }
                case 13: {
                    MAILTO_PROTOCOL = string.intern();
                    string2 = "\u0019i_}d'}";
                    n3 = 14;
                    continue block24;
                }
                case 14: {
                    IMAGE_ANCHOR = string.intern();
                    string2 = "\u0019\u000fn1\\\u001e\u000eo";
                    n3 = 15;
                    continue block24;
                }
                case 15: {
                    PATH_SPLIT_REGEX = string.intern();
                    string2 = "*TFl";
                    n3 = -1;
                    continue block24;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "*TFl";
                    n3 = 0;
                    continue block24;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u001e\u0006\\~p2\u001b";
                    n3 = 1;
                    continue block24;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "~\u000f\r@ti\u000e\u0018#=";
                    n3 = 2;
                    continue block24;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "#LF";
                    n3 = 3;
                    continue block24;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "m\u000f";
                    n3 = 4;
                    continue block24;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "/A[pw-\u001a";
                    n3 = 5;
                    continue block24;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "x\u000f\u001d";
                    n3 = 6;
                    continue block24;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "f\u0011\u001d";
                    n3 = 7;
                    continue block24;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "j\u000e\u001b3xp\fO";
                    n3 = 8;
                    continue block24;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "/A[pw-";
                    n3 = 9;
                    continue block24;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "*TFl";
                    n3 = 10;
                    continue block24;
                }
                case 10: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        c = stringArray3;
        URL_TYPE_ALL = new h();
        URL_TYPE_IMAGE = new m();
        URL_TYPE_MAIL = new o(c[10], null);
        URL_TYPE_LOCAL = new CompositeURLType(new i(), new NotURLType(URL_TYPE_MAIL));
        URL_TYPE_HTTP = new o(c[11], null);
        URL_TYPE_LOCAL_HTTP = new CompositeURLType(URL_TYPE_LOCAL, URL_TYPE_HTTP);
        URL_TYPE_REMOTE = new CompositeURLType(new j(), new NotURLType(URL_TYPE_MAIL));
        URL_TYPE_REMOTE_HTTP = new CompositeURLType(URL_TYPE_REMOTE, URL_TYPE_HTTP);
        URL_TYPE_SUBFOLDER = new k();
        URL_TYPE_TEXT = new n();
        URL_TYPE_LOCAL_REMOTE = new NotURLType(URL_TYPE_MAIL);
    }

    public static class LinkDescription {
        private UnicodeURL a;
        private UnicodeURL b;
        private String c;
        private UnicodeURL d;
        private int e;
        private int f;
        private int g;
        private int h;
        private AnchorType i;
        private boolean j;

        public LinkDescription(UnicodeURL unicodeURL, UnicodeURL unicodeURL2, String string, int n2, int n3, int n4, int n5) {
            this(unicodeURL, unicodeURL2, string, null, AnchorType.TEXT, n2, n3, n4, n5, false);
        }

        public LinkDescription(UnicodeURL unicodeURL, UnicodeURL unicodeURL2, String string, UnicodeURL unicodeURL3, AnchorType anchorType, int n2, int n3, int n4, int n5, boolean bl) {
            boolean bl2 = URLType.b;
            this.a = unicodeURL;
            this.c = string;
            this.d = unicodeURL3;
            this.e = n2;
            this.f = n3;
            this.b = unicodeURL2;
            this.i = anchorType;
            this.g = n4;
            this.h = n5;
            this.j = bl;
            if (StringUtil.f) {
                URLType.b = !bl2;
            }
        }

        public UnicodeURL getLink() {
            return this.a;
        }

        public String getAnchorText() {
            return this.c;
        }

        public int getRow() {
            return this.e;
        }

        public int getColumn() {
            return this.f;
        }

        public int getEndRow() {
            return this.g;
        }

        public int getEndColumn() {
            return this.h;
        }

        public UnicodeURL getSourceLink() {
            return this.b;
        }

        public AnchorType getAnchorType() {
            return this.i;
        }

        public UnicodeURL getImageSrc() {
            return this.d;
        }

        public boolean isNofollow() {
            return this.j;
        }
    }

    public static class CompositeURLType
    extends URLType {
        private URLType a;
        private URLType c;

        public CompositeURLType(URLType uRLType, URLType uRLType2) {
            this.a = uRLType;
            this.c = uRLType2;
        }

        @Override
        public boolean accept(UnicodeURL unicodeURL, UnicodeURL unicodeURL2, Tag tag) {
            return this.a.accept(unicodeURL, unicodeURL2, tag) && this.c.accept(unicodeURL, unicodeURL2, tag);
        }
    }

    public static class NotURLType
    extends URLType {
        private URLType a;

        public NotURLType(URLType uRLType) {
            this.a = uRLType;
        }

        @Override
        public boolean accept(UnicodeURL unicodeURL, UnicodeURL unicodeURL2, Tag tag) {
            return !this.a.accept(unicodeURL, unicodeURL2, tag);
        }
    }

    public static abstract class URLType {
        public static boolean b;

        public abstract boolean accept(UnicodeURL var1, UnicodeURL var2, Tag var3);
    }

    public static final class AnchorType
    extends Enum<AnchorType> {
        public static final /* enum */ AnchorType TEXT;
        public static final /* enum */ AnchorType IMAGE;
        private static final /* synthetic */ AnchorType[] a;
        private static final String[] b;

        public static AnchorType[] values() {
            return (AnchorType[])a.clone();
        }

        public static AnchorType valueOf(String string) {
            return Enum.valueOf(AnchorType.class, string);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "\u0019=)@9";
            int n3 = -1;
            block9: while (true) {
                char[] cArray;
                block14: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block13: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block13;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block14;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 80;
                                    break;
                                }
                                case 1: {
                                    n9 = 112;
                                    break;
                                }
                                case 2: {
                                    n9 = 104;
                                    break;
                                }
                                case 3: {
                                    n9 = 7;
                                    break;
                                }
                                default: {
                                    n9 = 124;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "\u000450S";
                        n3 = 0;
                        continue block9;
                    }
                    case 0: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            b = stringArray3;
            TEXT = new AnchorType();
            IMAGE = new AnchorType();
            a = new AnchorType[]{TEXT, IMAGE};
        }
    }
}

