/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.modules.io.autoupdate.util;

import com.agilemind.commons.io.utils.SumChecker;
import com.agilemind.commons.modules.io.autoupdate.util.CRC32SumChecker;
import com.agilemind.commons.modules.io.autoupdate.util.UpdateLoader;
import com.agilemind.commons.modules.io.autoupdate.util.UpdateSaver;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

public abstract class RepositoryEntry {
    private static final SumChecker a = new CRC32SumChecker();
    public static final int ENTRY_TYPE_FOLDER = 0;
    public static final int ENTRY_TYPE_FILE = 1;
    private RepositoryEntry b;
    private int c;
    public static boolean d;

    protected RepositoryEntry(RepositoryEntry repositoryEntry, int n2) {
        this.b = repositoryEntry;
        this.c = n2;
    }

    public void save(UpdateSaver updateSaver) throws IOException {
        updateSaver.writeInt(this.c);
        this.saveEntry(updateSaver);
    }

    protected abstract void saveEntry(UpdateSaver var1) throws IOException;

    public abstract String getName();

    public String getFullName() {
        String string = this.b != null ? this.b.getFullName() + '/' + this.getName() : "";
        return string;
    }

    public String toString() {
        return this.getFullName();
    }

    public abstract long getHash();

    public int getEntryType() {
        return this.c;
    }

    private static RepositoryEntry a(RepositoryEntry repositoryEntry, File file, FileFilter fileFilter) throws IOException {
        RepositoryEntry repositoryEntry2;
        block3: {
            block2: {
                if (!file.isDirectory()) break block2;
                repositoryEntry2 = new FolderEntry(repositoryEntry, file, fileFilter);
                if (!d) break block3;
            }
            repositoryEntry2 = new FileEntry(repositoryEntry, file);
        }
        return repositoryEntry2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RepositoryEntry a(RepositoryEntry repositoryEntry, int n2, UpdateLoader updateLoader) throws IOException {
        void var3_6;
        block5: {
            block6: {
                boolean bl;
                block4: {
                    bl = d;
                    if (n2 != 0) break block4;
                    FolderEntry folderEntry = new FolderEntry(repositoryEntry, updateLoader);
                    if (!bl) break block5;
                }
                if (n2 != 1) break block6;
                FileEntry fileEntry = new FileEntry(repositoryEntry, updateLoader);
                if (!bl) break block5;
            }
            throw new IllegalArgumentException();
        }
        return var3_6;
    }

    public static class FileEntry
    extends RepositoryEntry {
        private String e;
        private long f;

        public FileEntry(RepositoryEntry repositoryEntry, File file) throws IOException {
            super(repositoryEntry, 1);
            this.e = file.getName();
            this.f = a.getChecksumValue(file);
        }

        public FileEntry(RepositoryEntry repositoryEntry, UpdateLoader updateLoader) throws IOException {
            super(repositoryEntry, 1);
            this.e = updateLoader.readUTF();
            this.f = updateLoader.readLong();
        }

        @Override
        protected void saveEntry(UpdateSaver updateSaver) throws IOException {
            updateSaver.writeUTF(this.e);
            updateSaver.writeLong(this.f);
        }

        @Override
        public String getName() {
            return this.e;
        }

        @Override
        public long getHash() {
            return this.f;
        }
    }

    public static class FolderEntry
    extends RepositoryEntry {
        private RepositoryEntry[] e;
        private String f;
        private long g;

        public FolderEntry(RepositoryEntry repositoryEntry, File file, FileFilter fileFilter) throws IOException {
            boolean bl = d;
            super(repositoryEntry, 0);
            File[] fileArray = file.listFiles(fileFilter);
            this.e = new RepositoryEntry[fileArray.length];
            this.f = file.getName();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                this.e[i2] = RepositoryEntry.a((RepositoryEntry)this, fileArray[i2], fileFilter);
                if (!bl) continue;
            }
            this.g = FolderEntry.a(this.e, this.f);
        }

        public FolderEntry(RepositoryEntry repositoryEntry, UpdateLoader updateLoader) throws IOException {
            boolean bl = d;
            super(repositoryEntry, 0);
            this.f = updateLoader.readUTF();
            int n2 = updateLoader.readInt();
            this.e = new RepositoryEntry[n2];
            for (int i2 = 0; i2 < this.e.length; ++i2) {
                int n3 = updateLoader.readInt();
                this.e[i2] = RepositoryEntry.a((RepositoryEntry)this, n3, updateLoader);
                if (!bl) continue;
            }
            this.g = FolderEntry.a(this.e, this.f);
        }

        @Override
        protected void saveEntry(UpdateSaver updateSaver) throws IOException {
            boolean bl = d;
            updateSaver.writeUTF(this.f);
            updateSaver.writeInt(this.e.length);
            for (RepositoryEntry repositoryEntry : this.e) {
                repositoryEntry.save(updateSaver);
                if (!bl) continue;
            }
        }

        @Override
        public String getName() {
            return this.f;
        }

        @Override
        public long getHash() {
            return this.g;
        }

        private static long a(RepositoryEntry[] repositoryEntryArray, String string) {
            boolean bl = d;
            long l2 = string.hashCode();
            for (RepositoryEntry repositoryEntry : repositoryEntryArray) {
                l2 += repositoryEntry.getHash();
                if (!bl) continue;
            }
            return l2;
        }

        public RepositoryEntry[] getChildren() {
            return this.e;
        }
    }
}

