/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.util;

import com.agilemind.commons.util.UnicodeURL;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public final class DateUtil {
    public static final long DAY_LONG = 86400000L;
    private static final String a;

    private DateUtil() {
    }

    public static Date getStartDay(Date date) {
        if (date != null) {
            Calendar calendar = DateUtil.getStartCalendar(date);
            return calendar.getTime();
        }
        return null;
    }

    public static Date getUtcStartDay(Date date) {
        if (date != null) {
            Calendar calendar = DateUtil.getUtcStartCalendar(date);
            return calendar.getTime();
        }
        return null;
    }

    public static Calendar getStartCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        DateUtil.setStartDayCalendar(calendar, date);
        return calendar;
    }

    public static Calendar getUtcStartCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        DateUtil.setUtcStartDayCalendar(calendar, date);
        return calendar;
    }

    public static void setStartDayCalendar(Calendar calendar, Date date) {
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static void setUtcStartDayCalendar(Calendar calendar, Date date) {
        calendar.setTime(date);
        calendar.setTimeZone(TimeZone.getTimeZone(a));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static Date getTimezoneToday() {
        return DateUtil.getStartDay(new Date());
    }

    public static Date getPlusThreeMonthsDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.getTimezoneToday());
        calendar.add(2, 3);
        return calendar.getTime();
    }

    public static boolean theSameDay(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return calendar.get(5) == calendar2.get(5) && calendar.get(2) == calendar2.get(2) && calendar.get(1) == calendar2.get(1);
    }

    public static Date minusDays(long l2) {
        return Date.from(LocalDateTime.now().minus(l2, ChronoUnit.DAYS).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date minusHours(long l2) {
        return Date.from(LocalDateTime.now().minus(l2, ChronoUnit.HOURS).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date minusMinutes(long l2) {
        return Date.from(LocalDateTime.now().minus(l2, ChronoUnit.MINUTES).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date plusSeconds(Date date, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, n2);
        return calendar.getTime();
    }

    public static long daysAfter(Date date) {
        return -DateUtil.daysBefore(date);
    }

    public static long daysBefore(Date date) {
        return (long)Math.floor((double)(date.getTime() - System.currentTimeMillis()) / 8.64E7);
    }

    public static long getDifferenceDays(Date date) {
        return DateUtil.getDifferenceDays(date, new Date());
    }

    public static long getDifferenceDays(Date date, Date date2) {
        long l2 = date2.getTime() - date.getTime();
        return TimeUnit.DAYS.convert(l2, TimeUnit.MILLISECONDS);
    }

    public static Date min(Date date, Date date2) {
        return date.before(date2) ? date : date2;
    }

    public static Date max(Date date, Date date2) {
        return date.before(date2) ? date2 : date;
    }

    public static int compareDates(Date date, Date date2, int n2) {
        int n3 = UnicodeURL.c;
        int[] nArray = new int[]{1, 2, 5, 11, 12, 13, 14};
        int n4 = Arrays.binarySearch(nArray, n2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        if (n4 >= 0) {
            for (int i2 = n4 + 1; i2 < nArray.length; ++i2) {
                calendar.set(nArray[i2], 0);
                calendar2.set(nArray[i2], 0);
                if (n3 == 0) continue;
            }
        }
        return calendar.compareTo(calendar2);
    }

    public static Date nextDay(Date date) {
        return DateUtil.moveDay(date, 1);
    }

    public static Date prevDay(Date date) {
        return DateUtil.moveDay(date, -1);
    }

    public static Date moveDay(Date date, int n2) {
        return new Date(date.getTime() + 86400000L * (long)n2);
    }

    public static long nextDay(long l2) {
        return DateUtil.moveDay(l2, 1);
    }

    public static long prevDay(long l2) {
        return DateUtil.moveDay(l2, -1);
    }

    public static long moveDay(long l2, int n2) {
        return l2 + 86400000L * (long)n2;
    }

    public static boolean between(Date date, Date date2, Date date3) {
        return date.equals(date2) || date.equals(date3) || date.after(date2) && date.before(date3);
    }

    public static synchronized Date createDate(int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(n2, n3, n4, n5, n6, 0);
        return calendar.getTime();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "\"@B".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 119;
                            break;
                        }
                        case 1: {
                            n7 = 20;
                            break;
                        }
                        case 2: {
                            n7 = 1;
                            break;
                        }
                        case 3: {
                            n7 = 71;
                            break;
                        }
                        default: {
                            n7 = 123;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        a = new String(cArray).intern();
    }
}

