/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.util;

import com.agilemind.commons.util.Charset;
import com.agilemind.commons.util.IdnURL;
import com.agilemind.commons.util.StringURLUtil;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.idna.IDNA;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class UnicodeURL
implements Serializable,
Comparable<UnicodeURL> {
    private static final long serialVersionUID = 6277874025020440464L;
    private final IdnURL a;
    private final String b;
    public static int c;
    private static final String d;

    public UnicodeURL(String string) throws MalformedURLException {
        this(new URL(string));
    }

    public UnicodeURL(String string, Charset charset) throws MalformedURLException {
        this(string, charset, false);
    }

    public UnicodeURL(String string, Charset charset, boolean bl) throws MalformedURLException {
        this(new URL(string), charset, bl);
    }

    public UnicodeURL(File file) throws MalformedURLException {
        this(file.toURI().toURL());
    }

    public UnicodeURL(UnicodeURL unicodeURL, String string) throws MalformedURLException {
        this(unicodeURL, string, Charset.UTF8);
    }

    public UnicodeURL(UnicodeURL unicodeURL, String string, Charset charset) throws MalformedURLException {
        this(new URL(unicodeURL != null ? unicodeURL.getIDNURL() : null, string).toString(), charset, false);
    }

    public UnicodeURL(URL uRL) throws MalformedURLException {
        this(uRL, Charset.UTF8, false);
    }

    public UnicodeURL(URL uRL, Charset charset, boolean bl) throws MalformedURLException {
        this(new IdnURL(uRL, charset, bl));
    }

    public UnicodeURL(IdnURL idnURL) {
        block3: {
            block2: {
                this.a = idnURL;
                String string = UnicodeURL.a(idnURL);
                if (idnURL.getUrl().equals(string)) break block2;
                this.b = string;
                if (c == 0) break block3;
            }
            this.b = null;
        }
    }

    private static String a(IdnURL idnURL) {
        try {
            return UnicodeURL.a(new URL(idnURL.getProtocol(), IDNA.decodeDomain(idnURL.getHost()), idnURL.getPort(), idnURL.getFile()).toString(), idnURL.getCharset());
        }
        catch (Exception exception) {
            return idnURL.getUrl();
        }
    }

    private static String b(IdnURL idnURL) {
        try {
            return UnicodeURL.a(IDNA.decodeDomain(idnURL.getHost()), idnURL.getCharset());
        }
        catch (Exception exception) {
            return idnURL.getHost();
        }
    }

    private static String a(String string, Charset charset) {
        try {
            return StringURLUtil.decodeUrl(string, charset.getNioCode());
        }
        catch (Exception exception) {
            return string;
        }
    }

    public String getUnicodeHost() {
        return UnicodeURL.b(this.a);
    }

    public String toUnicodeString() {
        if (this.b == null) {
            return this.a.getUrl();
        }
        return this.b;
    }

    public String getIDNHost() {
        return this.a.getHost();
    }

    public String getProtocol() {
        return this.a.getProtocol();
    }

    public String getPath() {
        return this.a.getPath();
    }

    public int getPort() {
        return this.a.getPort();
    }

    public String getFile() {
        return this.a.getFile();
    }

    public String getQuery() {
        return this.a.getQuery();
    }

    public String getRef() {
        return this.a.getRef();
    }

    public boolean isLocal() {
        return this.getProtocol().equals(d);
    }

    public String toIDNString() {
        return this.a.getUrl();
    }

    public URL getIDNURL() throws MalformedURLException {
        return new URL(this.a.getUrl());
    }

    public Charset getCharset() {
        return this.a.getCharset();
    }

    public boolean equals(Object object) {
        if (!(object instanceof UnicodeURL)) {
            return false;
        }
        UnicodeURL unicodeURL = (UnicodeURL)object;
        if (this == object) {
            return true;
        }
        if (!this.c(unicodeURL)) {
            return false;
        }
        if (!this.b(unicodeURL)) {
            return false;
        }
        if (this.a(unicodeURL)) {
            return false;
        }
        return this.d(unicodeURL);
    }

    public boolean equals(UnicodeURL unicodeURL, boolean bl) {
        if (unicodeURL == null) {
            return false;
        }
        if (!this.getProtocol().equalsIgnoreCase(unicodeURL.getProtocol())) {
            return false;
        }
        if (this.a(unicodeURL)) {
            return false;
        }
        String string = this.getUnicodeHost();
        String string2 = unicodeURL.getUnicodeHost();
        if (bl) {
            string = StringURLUtil.removeWWW(string);
            string2 = StringURLUtil.removeWWW(string2);
        }
        if (!string.equalsIgnoreCase(string2)) {
            return false;
        }
        String string3 = this.getPath();
        String string4 = unicodeURL.getPath();
        if ("/".equals(string3)) {
            string3 = "";
        }
        if ("/".equals(string4)) {
            string4 = "";
        }
        if (!string3.equals(string4)) {
            return false;
        }
        String string5 = this.getQuery();
        String string6 = unicodeURL.getQuery();
        if (string5 == null && string6 == null) {
            return true;
        }
        return StringUtil.equals(string5, string6);
    }

    private boolean a(UnicodeURL unicodeURL) {
        return this.getPort() != unicodeURL.getPort();
    }

    private boolean b(UnicodeURL unicodeURL) {
        return this.a(this.getFile(), unicodeURL.getFile(), false);
    }

    private boolean c(UnicodeURL unicodeURL) {
        return this.a(this.getProtocol(), unicodeURL.getProtocol(), true);
    }

    private boolean d(UnicodeURL unicodeURL) {
        return this.a(this.getIDNHost(), unicodeURL.getIDNHost(), true);
    }

    private boolean a(String string, String string2, boolean bl) {
        return Objects.equals(string, string2) || string != null && (bl ? string.equalsIgnoreCase(string2) : string.equals(string2));
    }

    public int hashCode() {
        return this.toUnicodeString().hashCode();
    }

    public String toString() {
        return this.toUnicodeString();
    }

    @Override
    public int compareTo(@NotNull UnicodeURL unicodeURL) {
        return this.toUnicodeString().compareTo(unicodeURL.toUnicodeString());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "OAV\u0011".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 41;
                            break;
                        }
                        case 1: {
                            n7 = 40;
                            break;
                        }
                        case 2: {
                            n7 = 58;
                            break;
                        }
                        case 3: {
                            n7 = 116;
                            break;
                        }
                        default: {
                            n7 = 110;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        d = new String(cArray).intern();
    }
}

