/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.util;

import com.agilemind.commons.util.Charset;
import com.agilemind.commons.util.StringURLUtil;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLFactory;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnicodeURLUtil {
    public static final String[] INDEX_EXTENSIONS;
    private static final Logger a;
    private static final Set<String> b;
    private static final String[] c;

    private UnicodeURLUtil() {
    }

    public static boolean isEmpty(UnicodeURL unicodeURL) {
        return unicodeURL == null || StringUtil.isEmpty(unicodeURL.toUnicodeString()) || StringUtil.isEmpty(unicodeURL.getUnicodeHost()) && !c[9].equals(unicodeURL.getProtocol());
    }

    public static String getStringOrEmpty(UnicodeURL unicodeURL) {
        return unicodeURL != null ? StringUtil.getStringOrEmpty(unicodeURL.toUnicodeString()) : "";
    }

    public static UnicodeURL getNotEmptyURL(String string) throws MalformedURLException {
        UnicodeURL unicodeURL = UnicodeURLUtil.getURL(string);
        if (UnicodeURLUtil.isEmpty(unicodeURL)) {
            throw new MalformedURLException(c[1]);
        }
        return unicodeURL;
    }

    public static UnicodeURL getURL(String string) throws MalformedURLException {
        return UnicodeURLUtil.getURL(string, null);
    }

    public static UnicodeURL getURL(String string, @Nullable Charset charset) throws MalformedURLException {
        UnicodeURL unicodeURL;
        block5: {
            block4: {
                if (!StringUtil.isEmpty(string)) break block4;
                unicodeURL = null;
                if (UnicodeURL.c == 0) break block5;
            }
            try {
                unicodeURL = new UnicodeURL(string, charset);
            }
            catch (MalformedURLException malformedURLException) {
                unicodeURL = new UnicodeURL(c[4] + string, charset);
            }
        }
        return unicodeURL;
    }

    public static UnicodeURL getURL(UnicodeURL unicodeURL, String string) throws MalformedURLException {
        return new UnicodeURL(new URL(unicodeURL.getProtocol(), unicodeURL.getUnicodeHost(), unicodeURL.getPort(), "/" + string));
    }

    public static UnicodeURL getURLOrNullIfEmpty(String string) throws MalformedURLException {
        UnicodeURL unicodeURL = StringUtil.isEmpty(string) ? null : UnicodeURLUtil.getURL(string);
        return unicodeURL;
    }

    public static UnicodeURL getURLOrNull(String string) {
        try {
            return new UnicodeURL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String getHostWithoutWWW(UnicodeURL unicodeURL) {
        return StringURLUtil.removeWWW(unicodeURL.getUnicodeHost());
    }

    public static String getIdnHostWithoutWWW(UnicodeURL unicodeURL) {
        return StringURLUtil.removeWWW(unicodeURL.getIDNHost());
    }

    public static UnicodeURL inverseWww(UnicodeURL unicodeURL) throws MalformedURLException {
        URL uRL;
        UnicodeURL unicodeURL2;
        String string = unicodeURL.getIDNHost();
        boolean bl = string.startsWith(c[8]);
        UnicodeURL unicodeURL3 = unicodeURL2;
        UnicodeURL unicodeURL4 = unicodeURL2;
        URL uRL2 = uRL;
        URL uRL3 = uRL;
        String string2 = unicodeURL.getProtocol();
        String string3 = bl ? StringURLUtil.removeWWW(string) : c[7] + string;
        uRL2(string2, string3, unicodeURL.getPort(), unicodeURL.getFile());
        unicodeURL3(uRL3);
        return unicodeURL4;
    }

    public static UnicodeURL removeWWW(UnicodeURL unicodeURL) throws MalformedURLException {
        return new UnicodeURL(new URL(unicodeURL.getProtocol(), StringURLUtil.removeWWW(unicodeURL.getIDNHost()), unicodeURL.getPort(), unicodeURL.getFile()));
    }

    public static String removeWWWFromUnicodeHost(UnicodeURL unicodeURL) {
        String string = UnicodeURLUtil.getHostWithoutWWW(unicodeURL);
        String string2 = unicodeURL.toUnicodeString();
        if (!string.equals(unicodeURL.getUnicodeHost())) {
            string2 = string2.replace(unicodeURL.getUnicodeHost(), string);
        }
        return string2;
    }

    public static String getMailHost(UnicodeURL unicodeURL) {
        String string = UnicodeURLUtil.getHostWithoutWWW(unicodeURL);
        if (string != null) {
            string = '@' + string;
        }
        return string;
    }

    public static String removeProtocol(UnicodeURL unicodeURL) {
        return unicodeURL.toUnicodeString().substring(unicodeURL.getProtocol().length() + 3, unicodeURL.toUnicodeString().length());
    }

    @Nullable
    public static String getTld(UnicodeURL unicodeURL) {
        int n2;
        if (UnicodeURLUtil.isEmpty(unicodeURL)) {
            return null;
        }
        String string = unicodeURL.getUnicodeHost();
        int n3 = string.lastIndexOf(46);
        if (n3 != -1 && (n2 = string.substring(0, n3).lastIndexOf(46)) != -1 && b.contains(string.substring(n2))) {
            return string.substring(n2);
        }
        return n3 == -1 ? "" : string.substring(n3);
    }

    public static String toUnicodeFile(UnicodeURL unicodeURL) {
        try {
            return StringURLUtil.decodeUrl(unicodeURL.getFile(), unicodeURL.getCharset().getNioCode());
        }
        catch (Exception exception) {
            return unicodeURL.getFile();
        }
    }

    @Nullable
    public static String getTldWithoutDot(UnicodeURL unicodeURL) {
        String string = UnicodeURLUtil.getTld(unicodeURL);
        if (!StringUtil.isEmpty(string)) {
            string = string.substring(1);
        }
        return string;
    }

    public static Collection<UnicodeURL> getUniqueHomePages(@NotNull Collection<UnicodeURL> collection) {
        return UnicodeURLUtil.a(new HashSet<UnicodeURL>(collection.size()), collection);
    }

    private static Collection<UnicodeURL> a(@NotNull Collection<UnicodeURL> collection, @NotNull Collection<UnicodeURL> collection2) {
        int n2 = UnicodeURL.c;
        for (UnicodeURL unicodeURL : collection2) {
            try {
                collection.add(UnicodeURLUtil.getHomePage(unicodeURL));
            }
            catch (MalformedURLException malformedURLException) {
                a.error("", (Throwable)malformedURLException);
            }
            if (n2 == 0) continue;
        }
        return collection;
    }

    public static boolean isAjaxUrl(UnicodeURL unicodeURL) {
        return unicodeURL.getRef() != null && unicodeURL.getRef().startsWith("!");
    }

    public static UnicodeURL getDomain(@NotNull UnicodeURL unicodeURL) {
        try {
            URL uRL;
            UnicodeURL unicodeURL2;
            UnicodeURL unicodeURL3 = unicodeURL2;
            UnicodeURL unicodeURL4 = unicodeURL2;
            URL uRL2 = uRL;
            URL uRL3 = uRL;
            String string = unicodeURL.getProtocol();
            String string2 = unicodeURL.getUnicodeHost();
            int n2 = unicodeURL.getPort();
            String string3 = unicodeURL.getFile().equals("/") ? "/" : "";
            uRL2(string, string2, n2, string3);
            unicodeURL3(uRL3);
            return unicodeURL4;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return unicodeURL;
        }
    }

    public static UnicodeURL getDomainToLowerCase(@NotNull UnicodeURL unicodeURL) throws MalformedURLException {
        URL uRL;
        UnicodeURL unicodeURL2;
        UnicodeURL unicodeURL3 = unicodeURL2;
        UnicodeURL unicodeURL4 = unicodeURL2;
        URL uRL2 = uRL;
        URL uRL3 = uRL;
        String string = unicodeURL.getProtocol().toLowerCase();
        String string2 = unicodeURL.getUnicodeHost().toLowerCase();
        int n2 = unicodeURL.getPort();
        String string3 = unicodeURL.getFile().equals("/") ? "/" : "";
        uRL2(string, string2, n2, string3);
        unicodeURL3(uRL3);
        return unicodeURL4;
    }

    public static UnicodeURL getUnicodeDomainWithoutPort(@NotNull UnicodeURL unicodeURL) throws MalformedURLException {
        URL uRL;
        UnicodeURL unicodeURL2;
        UnicodeURL unicodeURL3 = unicodeURL2;
        UnicodeURL unicodeURL4 = unicodeURL2;
        URL uRL2 = uRL;
        URL uRL3 = uRL;
        String string = unicodeURL.getProtocol();
        String string2 = unicodeURL.getUnicodeHost();
        int n2 = -1;
        String string3 = unicodeURL.getFile().equals("/") ? "/" : "";
        uRL2(string, string2, n2, string3);
        unicodeURL3(uRL3);
        return unicodeURL4;
    }

    public static UnicodeURL getHomePage(@NotNull UnicodeURL unicodeURL) throws MalformedURLException {
        return new UnicodeURL(new URL(unicodeURL.getProtocol(), unicodeURL.getUnicodeHost(), unicodeURL.getPort(), ""));
    }

    public static UnicodeURL getPage(@NotNull UnicodeURL unicodeURL) throws MalformedURLException {
        return UnicodeURLFactory.getInstance().createUnicodeURL(unicodeURL.getProtocol(), unicodeURL.getUnicodeHost(), unicodeURL.getPort(), unicodeURL.getFile());
    }

    public static boolean isHomePage(@NotNull UnicodeURL unicodeURL) {
        return UnicodeURLUtil.isHomePage(null, unicodeURL);
    }

    public static boolean isHomePage(@Nullable UnicodeURL unicodeURL, @NotNull UnicodeURL unicodeURL2) {
        if (unicodeURL != null && !UnicodeURLUtil.isSameDomain(unicodeURL, unicodeURL2)) {
            return false;
        }
        String string = unicodeURL2.getFile();
        return StringUtil.isEmpty(string) || string.equals("/");
    }

    public static boolean isHomePageIncludeIndex(@NotNull UnicodeURL unicodeURL) {
        return UnicodeURLUtil.isHomePageIncludeIndex(null, unicodeURL);
    }

    public static boolean isHomePageIncludeIndex(@Nullable UnicodeURL unicodeURL, @NotNull UnicodeURL unicodeURL2) {
        int n2 = UnicodeURL.c;
        if (UnicodeURLUtil.isHomePage(unicodeURL, unicodeURL2)) {
            return true;
        }
        String string = unicodeURL2.getFile();
        for (String string2 : INDEX_EXTENSIONS) {
            if (!string.equalsIgnoreCase(c[2] + string2)) continue;
            return true;
        }
        return false;
    }

    public static UnicodeURL getURLExt(String string) throws MalformedURLException {
        UnicodeURL unicodeURL;
        if (StringUtil.isEmpty(string)) {
            throw new MalformedURLException(c[6]);
        }
        try {
            try {
                unicodeURL = new UnicodeURL(string);
            }
            catch (MalformedURLException malformedURLException) {
                unicodeURL = new UnicodeURL(c[5] + string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            unicodeURL = new UnicodeURL(new File(string).toURI().toURL());
        }
        return unicodeURL;
    }

    public static String getURLExtension(UnicodeURL unicodeURL) {
        String string = unicodeURL.getPath();
        int n2 = string.lastIndexOf(47);
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        return StringUtil.getFileExtension(string);
    }

    public static boolean isSameUrls(UnicodeURL unicodeURL, UnicodeURL unicodeURL2, boolean bl) {
        if (unicodeURL == null || unicodeURL2 == null) {
            return false;
        }
        String string = StringURLUtil.removeProtocolAndSlash(unicodeURL.toUnicodeString());
        String string2 = StringURLUtil.removeProtocolAndSlash(unicodeURL2.toUnicodeString());
        if (bl) {
            string = StringURLUtil.removeWWW(string);
            string2 = StringURLUtil.removeWWW(string2);
        }
        return string.equalsIgnoreCase(string2);
    }

    public static boolean isSameUrls(UnicodeURL unicodeURL, UnicodeURL unicodeURL2) {
        if (unicodeURL == null || unicodeURL2 == null) {
            return false;
        }
        String string = unicodeURL.toUnicodeString();
        String string2 = unicodeURL2.toUnicodeString();
        string = StringURLUtil.removeTrailingSlash(string);
        string2 = StringURLUtil.removeTrailingSlash(string2);
        return string.equalsIgnoreCase(string2);
    }

    public static boolean isSameDomain(String string, String string2) throws MalformedURLException {
        String string3 = StringURLUtil.removeProtocolAndSlash(UnicodeURLUtil.getHostWithoutWWW(UnicodeURLUtil.getURL(string)));
        String string4 = StringURLUtil.removeProtocolAndSlash(UnicodeURLUtil.getHostWithoutWWW(UnicodeURLUtil.getURL(string2)));
        return string3.equalsIgnoreCase(string4);
    }

    public static boolean isSameDomain(UnicodeURL unicodeURL, UnicodeURL unicodeURL2) {
        return StringURLUtil.removeWWW(unicodeURL.getUnicodeHost()).equalsIgnoreCase(StringURLUtil.removeWWW(unicodeURL2.getUnicodeHost()));
    }

    public static boolean isSameDomain(UnicodeURL unicodeURL, UnicodeURL unicodeURL2, boolean bl) {
        return bl ? StringURLUtil.removeWWW(unicodeURL.getUnicodeHost()).equalsIgnoreCase(StringURLUtil.removeWWW(unicodeURL2.getUnicodeHost())) : unicodeURL.getUnicodeHost().equalsIgnoreCase(unicodeURL2.getUnicodeHost());
    }

    public static boolean isSubDomain(@NotNull UnicodeURL unicodeURL, @NotNull UnicodeURL unicodeURL2) {
        String string;
        String string2 = StringURLUtil.removeWWW(unicodeURL2.getUnicodeHost()).toLowerCase();
        return string2.equals(string = StringURLUtil.removeWWW(unicodeURL.getUnicodeHost()).toLowerCase()) || string2.endsWith('.' + string);
    }

    public static UnicodeURL removeQuery(UnicodeURL unicodeURL) throws MalformedURLException {
        return new UnicodeURL(unicodeURL.getProtocol() + c[0] + unicodeURL.getIDNHost() + unicodeURL.getPath());
    }

    @Nullable
    public static UnicodeURL createEmptyUnicodeUrl() {
        try {
            return new UnicodeURL(c[3]);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block56: {
            block55: {
                v0 = new String[10];
                v1 = v0;
                v2 = v0;
                v3 = 0;
                v4 = "YTR";
                v5 = -1;
                break block55;
lbl8:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 1;
                    v4 = "&\u0016\rCbC\u0013\u0012Do";
                    v5 = 0;
                    break block55;
                    break;
                }
lbl16:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 2;
                    v4 = "L\u0012\u0013S~\u001bU";
                    v5 = 1;
                    break block55;
                    break;
                }
lbl24:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 3;
                    v4 = "\u000b\u000f\tG!LT";
                    v5 = 2;
                    break block55;
                    break;
                }
lbl32:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 4;
                    v4 = "\u000b\u000f\tG!LT";
                    v5 = 3;
                    break block55;
                    break;
                }
lbl40:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 5;
                    v4 = "\u000b\u000f\tG!LT";
                    v5 = 4;
                    break block55;
                    break;
                }
lbl48:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 6;
                    v4 = "&\u0016\rCbC\u0013\u0012Do";
                    v5 = 5;
                    break block55;
                    break;
                }
lbl56:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 7;
                    v4 = "\u0014\f\n\u0019";
                    v5 = 6;
                    break block55;
                    break;
                }
lbl64:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 8;
                    v4 = "\u0014\f\n\u0019";
                    v5 = 7;
                    break block55;
                    break;
                }
lbl72:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 9;
                    v4 = "\u0005\u0012\u0011R";
                    v5 = 8;
                    break block55;
                    break;
                }
lbl80:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    UnicodeURLUtil.c = v2;
                    ** GOTO lbl191
                    break;
                }
lbl84:
                // 3 sources

                while (true) {
                    v7 = v8.toCharArray();
                    var1 = 0;
                    v9 = v7.length;
                    v10 = v7;
                    v11 = v9;
                    if (v9 > 1) ** GOTO lbl122
                    do {
                        v12 = v10;
                        v13 = v10;
                        v14 = var1;
                        while (true) {
                            v15 = v12[v14];
                            switch (var1 % 5) {
                                case 0: {
                                    v16 = 99;
                                    break;
                                }
                                case 1: {
                                    v16 = 123;
                                    break;
                                }
                                case 2: {
                                    v16 = 125;
                                    break;
                                }
                                case 3: {
                                    v16 = 55;
                                    break;
                                }
                                default: {
                                    v16 = 27;
                                }
                            }
                            v12[v14] = (char)(v15 ^ v16);
                            ++var1;
                            v10 = v13;
                            v11 = v11;
                            if (v11 != 0) break;
                            v13 = v10;
                            v17 = v11;
                            v14 = v11;
                            v12 = v10;
                        }
lbl122:
                        // 2 sources

                        v18 = v10;
                        v17 = v11;
                    } while (v11 > var1);
                    break block56;
                    break;
                }
            }
            block52: while (true) {
                v19 = v4.toCharArray();
                var1 = 0;
                v20 = v19.length;
                v21 = v19;
                v22 = v20;
                if (v20 > 1) ** GOTO lbl165
                do {
                    v23 = v21;
                    v24 = v21;
                    v25 = var1;
                    while (true) {
                        v26 = v23[v25];
                        switch (var1 % 5) {
                            case 0: {
                                v27 = 99;
                                break;
                            }
                            case 1: {
                                v27 = 123;
                                break;
                            }
                            case 2: {
                                v27 = 125;
                                break;
                            }
                            case 3: {
                                v27 = 55;
                                break;
                            }
                            default: {
                                v27 = 27;
                            }
                        }
                        v23[v25] = (char)(v26 ^ v27);
                        ++var1;
                        v21 = v24;
                        v22 = v22;
                        if (v22 != 0) break;
                        v24 = v21;
                        v28 = v22;
                        v25 = v22;
                        v23 = v21;
                    }
lbl165:
                    // 2 sources

                    v29 = v21;
                    v28 = v22;
                } while (v22 > var1);
                v6 = new String(v29);
                switch (v5) {
                    default: {
                        ** continue;
                    }
                    case 0: {
                        ** continue;
                    }
                    case 1: {
                        ** continue;
                    }
                    case 2: {
                        ** continue;
                    }
                    case 3: {
                        ** continue;
                    }
                    case 4: {
                        ** continue;
                    }
                    case 5: {
                        ** continue;
                    }
                    case 6: {
                        ** continue;
                    }
                    case 7: {
                        ** continue;
                    }
                    case 8: {
                        ** continue;
                    }
lbl191:
                    // 1 sources

                    v30 = new String[12];
                    v1 = v30;
                    v2 = v30;
                    v3 = 0;
                    v4 = "\u000b\u000f\u0010[";
                    v5 = 9;
                    continue block52;
                    case 9: {
                        v1[v3] = v6.intern();
                        v1 = v2;
                        v2 = v2;
                        v3 = 1;
                        v4 = "\u000b\u000f\u0010";
                        v5 = 10;
                        continue block52;
                    }
                    case 10: {
                        v1[v3] = v6.intern();
                        v1 = v2;
                        v2 = v2;
                        v3 = 2;
                        v4 = "\u0013\u0013\r";
                        v5 = 11;
                        continue block52;
                    }
                    case 11: {
                        v1[v3] = v6.intern();
                        v1 = v2;
                        v2 = v2;
                        v3 = 3;
                        v4 = "\u0002\b\r";
                        v5 = 12;
                        continue block52;
                    }
                    case 12: {
                        v1[v3] = v6.intern();
                        v1 = v2;
                        v2 = v2;
                        v3 = 4;
                        v4 = "\t\b\r";
                        v5 = 13;
                        continue block52;
                    }
                    case 13: {
                        v1[v3] = v6.intern();
                        v1 = v2;
                        v2 = v2;
                        v3 = 5;
                        v4 = "\u0010\u0013\tZw";
                        v5 = 14;
                        continue block52;
                    }
                    case 14: {
                        v1[v3] = v6.intern();
                        v1 = v2;
                        v2 = v2;
                        v3 = 6;
                        v4 = "\u0002\b\rO";
                        v5 = 15;
                        continue block52;
                    }
                    case 15: {
                        v1[v3] = v6.intern();
                        v1 = v2;
                        v2 = v2;
                        v3 = 7;
                        v4 = "\u0002\b\u001c";
                        v5 = 16;
                        continue block52;
                    }
                    case 16: {
                        v1[v3] = v6.intern();
                        v1 = v2;
                        v2 = v2;
                        v3 = 8;
                        v4 = "\u0013\u0017";
                        v5 = 17;
                        continue block52;
                    }
                    case 17: {
                        v1[v3] = v6.intern();
                        v1 = v2;
                        v2 = v2;
                        v3 = 9;
                        v4 = "\u0000\u001d";
                        v5 = 18;
                        continue block52;
                    }
                    case 18: {
                        v1[v3] = v6.intern();
                        v1 = v2;
                        v2 = v2;
                        v3 = 10;
                        v4 = "\u0000\u001d\u0010[";
                        v5 = 19;
                        continue block52;
                    }
                    case 19: {
                        v1[v3] = v6.intern();
                        v1 = v2;
                        v2 = v2;
                        v3 = 11;
                        v4 = "\u0000\u001c\u0014";
                        v5 = 20;
                        continue block52;
                    }
                    case 20: 
                }
                break;
            }
            v1[v3] = v6.intern();
            UnicodeURLUtil.INDEX_EXTENSIONS = v2;
            UnicodeURLUtil.a = LoggerFactory.getLogger(UnicodeURLUtil.class);
            v31 = var0_1 = ImmutableSet.builder();
            v8 = "M\u0018\u0012Z5\u0002\u000e";
            v32 = -1;
            ** GOTO lbl84
        }
        v33 = new String(v18).intern();
        switch (v32) {
            default: {
                v31.add((Object)v33);
                v31 = var0_1;
                v8 = "M\u0018\u0012\u0019q\u0013";
                v32 = 0;
                ** GOTO lbl84
            }
            case 0: {
                v31.add((Object)v33);
                v31 = var0_1;
                v8 = "M\u0018\u0012\u0019n\b";
                v32 = 1;
                ** continue;
            }
            case 1: 
        }
        v31.add((Object)v33);
        UnicodeURLUtil.b = var0_1.build();
    }
}

