/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.util;

import com.agilemind.commons.util.MathUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.function.ConsumerEx2;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static final Comparator<Object> FAST_COMPARATOR;
    public static final Comparator<Object> FAST_REVERSE_COMPARATOR;
    private static final String[] b;

    private Util() {
    }

    public static boolean equals(Object object, Object object2) {
        block7: {
            if (object == object2) {
                return true;
            }
            if (object != null && object2 != null) break block7;
            return false;
        }
        return object.equals(object2);
    }

    public static int compare(Object object, Object object2) {
        block23: {
            if (object != null || object2 != null) break block23;
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof String) {
            return ((String)object).compareToIgnoreCase((String)object2);
        }
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            boolean bl2 = (Boolean)object2;
            if (bl == bl2) {
                return 0;
            }
            if (bl) {
                return 1;
            }
            return -1;
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        String string = object.toString();
        String string2 = object2.toString();
        return string.compareToIgnoreCase(string2);
    }

    public static <E extends Number, T extends Collection<E>> int compareCollections(T t2, T t3) {
        int n2 = UnicodeURL.c;
        Iterator<E> iterator = t2.iterator();
        Iterator<E> iterator2 = t3.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Number number;
            Number number2;
            block17: {
                number2 = (Number)iterator.next();
                number = (Number)iterator2.next();
                if (number2 != null || number != null) break block17;
                if (n2 == 0) continue;
            }
            if (number2 == null) {
                return -1;
            }
            if (number == null) {
                return 1;
            }
            int n3 = number2.intValue();
            int n4 = number.intValue();
            if (n3 > n4) {
                return 1;
            }
            if (n3 < n4) {
                return -1;
            }
            if (n2 == 0) continue;
        }
        return t2.size() - t3.size();
    }

    public static <T> Collection<T> max(Collection<T> collection, Comparator<T> comparator) {
        return Optional.ofNullable(Collections.max(collection, comparator)).map(object -> collection.stream().filter(object2 -> {
            boolean bl = comparator.compare(object, object2) == 0;
            return bl;
        }).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public static <T> Collection<T> intersection(Collection<T> collection, Collection<T> collection2) {
        return collection.stream().filter(collection2::contains).collect(Collectors.toList());
    }

    public static <T, H> void removeFirstEmptyValues(Map<T, H> map) {
        int n2 = UnicodeURL.c;
        Iterator<Map.Entry<T, H>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            block6: {
                block5: {
                    Map.Entry<T, H> entry = iterator.next();
                    if (entry.getValue() != null) break block5;
                    iterator.remove();
                    if (n2 == 0) break block6;
                }
                return;
            }
            if (n2 == 0) continue;
        }
    }

    public static int saveParseInt(String string, int n2) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public static Integer saveParseInteger(String string, Integer n2) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public static Integer saveParseIntegerOrGetNull(String string) {
        return Util.saveParseInteger(string, null);
    }

    public static boolean contains(int[] nArray, int n2) {
        boolean bl = Util.indexOf(nArray, n2) != -1;
        return bl;
    }

    public static int indexOf(int[] nArray, int n2) {
        int n3 = UnicodeURL.c;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public static <E> boolean contains(E[] EArray, E e2) {
        return Util.contains(Arrays.asList(EArray), e2);
    }

    public static <E> boolean contains(Collection<E> collection, E e2) {
        int n2 = UnicodeURL.c;
        for (E e3 : collection) {
            if (e3.equals(e2)) {
                return true;
            }
            if (n2 == 0) continue;
        }
        return false;
    }

    public static <E> boolean contains(Collection<E> collection, E e2, Comparator<E> comparator) {
        int n2 = UnicodeURL.c;
        for (E e3 : collection) {
            if (comparator.compare(e3, e2) == 0) {
                return true;
            }
            if (n2 == 0) continue;
        }
        return false;
    }

    public static <E> int indexOf(E[] EArray, E e2) {
        int n2 = UnicodeURL.c;
        for (int i2 = 0; i2 < EArray.length; ++i2) {
            if (!EArray[i2].equals(e2)) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(Iterable<?> iterable, Object object) {
        int n2 = UnicodeURL.c;
        int n3 = 0;
        for (Object obj : iterable) {
            if (obj.equals(object)) {
                return n3;
            }
            ++n3;
            if (n2 == 0) continue;
        }
        return -1;
    }

    public static void prettyPrint(Map<?, ?> map, Consumer<String> consumer) {
        Util.prettyPrint(map, 0, consumer);
    }

    public static void prettyPrint(Map<?, ?> map, int n2, Consumer<String> consumer) {
        consumer.accept(Util.prettyPrint(map, n2));
    }

    public static String prettyPrint(Map<?, ?> map, int n2) {
        int n3 = UnicodeURL.c;
        if (map == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("\n");
        String string = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + "\t";
            if (n3 == 0) continue;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            block10: {
                Object obj;
                block9: {
                    stringBuilder.append(string).append(b[2]).append(String.valueOf(entry.getKey())).append(b[1]).append(string).append(b[0]);
                    obj = entry.getValue();
                    if (!(obj instanceof Map)) break block9;
                    stringBuilder.append(Util.prettyPrint((Map)obj, n2 + 1));
                    if (n3 == 0) break block10;
                }
                stringBuilder.append(String.valueOf(obj));
            }
            stringBuilder.append("\n");
            if (n3 == 0) continue;
        }
        return stringBuilder.toString();
    }

    public static boolean isBigEndian(long l2, long l3, long l4) {
        boolean bl;
        block5: {
            block4: {
                if (l2 > l3 || l3 > l4) break block4;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> int indexedBinarySearch(List<T> list, T t2, int n2, int n3, Comparator<T> comparator) {
        int n4 = UnicodeURL.c;
        int n5 = n2;
        int n6 = n3 - 1;
        while (n5 <= n6) {
            block6: {
                int n7;
                block7: {
                    int n8;
                    block5: {
                        n7 = n5 + n6 >> 1;
                        T t3 = list.get(n7);
                        n8 = comparator.compare(t3, t2);
                        if (n8 >= 0) break block5;
                        n5 = n7 + 1;
                        if (n4 == 0) break block6;
                    }
                    if (n8 <= 0) break block7;
                    n6 = n7 - 1;
                    if (n4 == 0) break block6;
                }
                return n7;
            }
            if (n4 == 0) continue;
        }
        return -(n5 + 1);
    }

    public static int countBytes(InputStream inputStream) throws IOException {
        int n2 = UnicodeURL.c;
        int n3 = 0;
        while (inputStream.read() != -1) {
            ++n3;
            if (n2 == 0) continue;
        }
        return n3;
    }

    public static void checkInterrupted() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    public static Boolean invert(Boolean bl) {
        Boolean bl2;
        block5: {
            block4: {
                if (bl != null && bl.booleanValue()) break block4;
                bl2 = Boolean.TRUE;
                break block5;
            }
            bl2 = Boolean.FALSE;
        }
        return bl2;
    }

    public static <T> T random(T[] TArray) {
        block6: {
            block7: {
                if (a) break block6;
                if (TArray == null) break block7;
                if (TArray.length > 0) break block6;
            }
            throw new AssertionError();
        }
        return TArray[MathUtil.random(TArray.length)];
    }

    public static String getSystemProperties() {
        int n2 = UnicodeURL.c;
        StringBuilder stringBuilder = new StringBuilder();
        Properties properties = System.getProperties();
        for (Object object : properties.keySet()) {
            String string = properties.getProperty((String)object);
            stringBuilder.append(object).append('=').append(string).append('\n');
            if (n2 == 0) continue;
        }
        return stringBuilder.toString();
    }

    public static <T> T[] merge(T[] TArray, T[] TArray2) {
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length + TArray2.length);
        System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
        System.arraycopy(TArray2, 0, objectArray, TArray.length, TArray2.length);
        return objectArray;
    }

    public static Color[] copy(Color[] colorArray) {
        return Arrays.copyOf(colorArray, colorArray.length);
    }

    public static void reverse(Object[] objectArray) {
        int n2 = UnicodeURL.c;
        if (objectArray == null) {
            return;
        }
        int n3 = 0;
        for (int i2 = objectArray.length - 1; i2 > n3; --i2, ++n3) {
            Object object = objectArray[i2];
            objectArray[i2] = objectArray[n3];
            objectArray[n3] = object;
            if (n2 == 0) continue;
        }
    }

    public static <T> List<T> subList(List<T> list, int n2) {
        List<T> list2 = n2 >= 0 ? list.subList(0, Math.min(list.size(), n2)) : list;
        return list2;
    }

    public static <T> List<T> subList(List<T> list, int n2, int n3) {
        block16: {
            block17: {
                if (n2 < 0) {
                    throw new IllegalArgumentException(b[3] + n2 + "!");
                }
                if (n3 < -1) {
                    throw new IllegalArgumentException(b[4] + n3 + "!");
                }
                if (n2 <= 0) break block16;
                if (n2 < list.size()) break block17;
                return list.subList(0, 0);
            }
            if (n3 > -1) {
                return list.subList(n2, Math.min(n2 + n3, list.size()));
            }
            return list.subList(n2, list.size());
        }
        if (n3 > -1) {
            return list.subList(0, Math.min(n3, list.size()));
        }
        return list.subList(0, list.size());
    }

    public static <T> void paginate(List<T> list, int n2, Consumer<List<T>> consumer) {
        List<T> list2;
        int n3 = UnicodeURL.c;
        int n4 = 0;
        while (!(list2 = Util.subList(list, n4, n2)).isEmpty() || n3 != 0) {
            n4 += n2;
            consumer.accept(list2);
            if (n3 == 0) continue;
        }
    }

    public static <T, E1 extends Throwable, E2 extends Throwable> void paginate(List<T> list, int n2, ConsumerEx2<List<T>, E1, E2> consumerEx2) throws E1, E2 {
        List<T> list2;
        int n3 = UnicodeURL.c;
        int n4 = 0;
        while (!(list2 = Util.subList(list, n4, n2)).isEmpty() || n3 != 0) {
            n4 += n2;
            consumerEx2.accept(list2);
            if (n3 == 0) continue;
        }
    }

    @SafeVarargs
    public static <T> List<T> filter(Iterable<T> iterable, Predicate<T> ... predicateArray) {
        int n2 = UnicodeURL.c;
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t2 : iterable) {
            boolean bl = false;
            for (Predicate<T> predicate : predicateArray) {
                if (predicate.test(t2)) {
                    bl = true;
                    if (n2 == 0) continue;
                }
                bl = false;
                if (n2 == 0) break;
                if (n2 == 0) continue;
                break;
            }
            if (bl) {
                arrayList.add(t2);
            }
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    @Nullable
    public static <T> T findLast(List<T> list, Predicate<T> predicate) {
        int n2 = UnicodeURL.c;
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            T t2 = list.get(i2);
            if (!predicate.test(t2)) continue;
            return t2;
        }
        return null;
    }

    public static <F, T> List<T> transform(Iterable<F> iterable, Function<F, T> function) {
        int n2 = UnicodeURL.c;
        ArrayList<T> arrayList = new ArrayList<T>();
        for (F f2 : iterable) {
            arrayList.add(function.apply(f2));
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    public static void lockForRun(@NotNull AtomicBoolean atomicBoolean, @NotNull Runnable runnable) {
        if (!atomicBoolean.compareAndSet(false, true)) {
            try {
                runnable.run();
            }
            finally {
                atomicBoolean.set(false);
            }
        }
    }

    public static <E extends Number, T extends Collection<E>> int compareBySum(T t2, T t3) {
        block18: {
            block17: {
                block15: {
                    block16: {
                        if (!Util.isNotEmpty(t2)) break block15;
                        if (!Util.isNotEmpty(t3)) break block16;
                        return Util.compareCollectionsBySum(t2, t3);
                    }
                    return 1;
                }
                if (Util.isNotEmpty(t3)) {
                    return -1;
                }
                if (t2.isEmpty() || !t3.isEmpty()) break block17;
                return 1;
            }
            if (!t2.isEmpty() || t3.isEmpty()) break block18;
            return -1;
        }
        return 0;
    }

    public static <E extends Number, T extends Collection<E>> int compareCollectionsBySum(T t2, T t3) {
        return Double.compare(Util.getCollectionSum(t2), Util.getCollectionSum(t3));
    }

    public static <E extends Number, T extends Collection<E>> double getCollectionSum(T t2) {
        return t2.stream().filter(Objects::nonNull).mapToDouble(Number::doubleValue).sum();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        boolean bl;
        block7: {
            block6: {
                if (collection == null || collection.isEmpty()) break block6;
                if (!collection.stream().anyMatch(Objects::nonNull)) break block6;
                bl = true;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "Qp{oX=\u0011";
        int n3 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block17;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 7;
                                break;
                            }
                            case 1: {
                                n9 = 49;
                                break;
                            }
                            case 2: {
                                n9 = 55;
                                break;
                            }
                            case 3: {
                                n9 = 58;
                                break;
                            }
                            default: {
                                n9 = 29;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\r8";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "Ltn\u0000=";
                    n3 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "HWQIxs\u0011ZOns\u0011U_=9\f\u0007\u001a\u007frE\u0017M|t\u0011";
                    n3 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "KXZSi'\\BIi'SR\u001a#:\u001c\u0006\u001a\u007frE\u0017M|t\u0011";
                    n3 = 3;
                    continue block13;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        b = stringArray3;
        FAST_COMPARATOR = new FastComparator<Object>(false);
        FAST_REVERSE_COMPARATOR = new FastComparator<Object>(false);
    }

    public static class FastComparator<T>
    implements Comparator<T>,
    Serializable {
        private boolean a;

        public FastComparator(boolean bl) {
            this.a = bl;
        }

        @Override
        public int compare(T t2, T t3) {
            return this.a ? Util.compare(t3, t2) : Util.compare(t2, t3);
        }
    }
}

